#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 retrie
version:              0.1.1.1
visibility:           public
id:                   retrie-0.1.1.1-5NzdICuqkr9CGzP7TU2gR9
key:                  retrie-0.1.1.1-5NzdICuqkr9CGzP7TU2gR9
license:              MIT
copyright:            Copyright (c) Facebook, Inc. and its affiliates.
maintainer:           Andrew Farmer <anfarmer@fb.com>
author:               Andrew Farmer <anfarmer@fb.com>
homepage:             https://github.com/facebookincubator/retrie
synopsis:             A powerful, easy-to-use codemodding tool for Haskell.
description:
    Retrie is a tool for codemodding Haskell. Key goals include:

    * Speed: Efficiently rewrite in large (>1 million line) codebases.
    * Safety: Avoids large classes of codemod-related errors.
    * Ease-of-use: Haskell syntax instead of regular expressions. No hand-rolled AST traversals.

    This package provides a command-line tool (@retrie@) and a library
    ("Retrie") for making equational edits to Haskell code.

    Please see the [README](#readme) for examples and usage.

category:             Development
abi:                  3553ce5d6440f536c5fc4b9bee9b9196
exposed:              True
exposed-modules:
    Retrie Retrie.AlphaEnv Retrie.CPP Retrie.Context Retrie.Debug
    Retrie.ExactPrint Retrie.ExactPrint.Annotated Retrie.Expr
    Retrie.Fixity Retrie.FreeVars Retrie.GHC Retrie.GroundTerms
    Retrie.Monad Retrie.Options Retrie.PatternMap.Bag
    Retrie.PatternMap.Class Retrie.PatternMap.Instances Retrie.Pretty
    Retrie.Quantifiers Retrie.Query Retrie.Replace Retrie.Rewrites
    Retrie.Rewrites.Function Retrie.Rewrites.Rules
    Retrie.Rewrites.Types Retrie.Run Retrie.SYB Retrie.Subst
    Retrie.Substitution Retrie.Types Retrie.Universe Retrie.Util

import-dirs:          /usr/lib/ghc-8.10.2/site-local/retrie-0.1.1.1
library-dirs:         /usr/lib/ghc-8.10.2/site-local/retrie-0.1.1.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.2/retrie-0.1.1.1
hs-libraries:         HSretrie-0.1.1.1-5NzdICuqkr9CGzP7TU2gR9
depends:
    ansi-terminal-0.11-2SXi8ZhU18i2uWLidRUotS
    async-2.2.2-6WjYHdzpa4C5cwFlX6aJ0s base-4.14.1.0
    bytestring-0.10.10.0 containers-0.6.2.1
    data-default-0.7.1.1-KLr953AsnH0rCiCUM3wfv directory-1.3.6.0
    filepath-1.4.2.1 ghc-8.10.2
    ghc-exactprint-0.6.3.3-70RbqMe6JpFclbotAcDEV mtl-2.2.2
    optparse-applicative-0.16.1.0-JDPEASK1GJS1Nsq2qjjZCq
    process-1.6.9.0 random-shuffle-0.0.4-EgyJy9f9ItP7d1erK1Xitn
    syb-0.7.1-EJn6avnnYqseQTf54r0Yp text-1.2.3.2 transformers-0.5.6.2
    unordered-containers-0.2.13.0-HeBOjfSts31GSj9apQxnyX

haddock-interfaces:   /usr/share/doc/haskell-retrie/html/retrie.haddock
haddock-html:         /usr/share/doc/haskell-retrie/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

