#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 cborg
version:              0.2.5.0
visibility:           public
id:                   cborg-0.2.5.0-9EvLXFRKXWFK41IT7yryAK
key:                  cborg-0.2.5.0-9EvLXFRKXWFK41IT7yryAK
license:              BSD-3-Clause
copyright:
    2015-2019 Duncan Coutts,
    2015-2019 Well-Typed LLP,
    2015 IRIS Connect Ltd

maintainer:           duncan@community.haskell.org, ben@smart-cactus.org
author:               Duncan Coutts
synopsis:             Concise Binary Object Representation (CBOR)
description:
    This package provides an efficient implementation of the Concise
    Binary Object Representation (CBOR), as specified by
    [RFC 7049](https://tools.ietf.org/html/rfc7049).

    If you are looking for a library for serialisation of Haskell values,
    have a look at the [serialise](/package/serialise) package, which is
    built upon this library.

    An implementation of the standard bijection between CBOR and JSON is
    provided by the [cborg-json](/package/cborg-json) package. Also see
    [cbor-tool](/package/cbor-tool) for a convenient command-line utility
    for working with CBOR data.

    This package was formerly known as @binary-serialise-cbor@.

category:             Codec
abi:                  7993258c035ca67f8c16c067bd924afc
exposed:              True
exposed-modules:
    Codec.CBOR Codec.CBOR.ByteArray Codec.CBOR.ByteArray.Sliced
    Codec.CBOR.Decoding Codec.CBOR.Encoding Codec.CBOR.FlatTerm
    Codec.CBOR.Magic Codec.CBOR.Pretty Codec.CBOR.Read Codec.CBOR.Term
    Codec.CBOR.Write

hidden-modules:       Codec.CBOR.ByteArray.Internal
import-dirs:          /usr/lib/ghc-8.10.5/site-local/cborg-0.2.5.0
library-dirs:         /usr/lib/ghc-8.10.5/site-local/cborg-0.2.5.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/cborg-0.2.5.0
hs-libraries:         HScborg-0.2.5.0-9EvLXFRKXWFK41IT7yryAK
depends:
    array-0.5.4.0 base-4.14.2.0 bytestring-0.10.12.0 containers-0.6.4.1
    deepseq-1.4.4.0 ghc-prim-0.6.1 half-0.3.1-CkbRDGX7YGBF0y5EvDisTr
    integer-gmp-1.0.3.0 primitive-0.7.1.0-H44eQ1j8hQJ3Kj2SFx0Ivh
    text-1.2.4.1

haddock-interfaces:   /usr/share/doc/haskell-cborg/html/cborg.haddock
haddock-html:         /usr/share/doc/haskell-cborg/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

