/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.spring.core.type;

import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.spring.core.annotation.MicronautMergedAnnotations;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.MethodMetadata;

@Internal
public final class BeanDefinitionSpringMetadata
implements AnnotationMetadata {
    private final BeanDefinition<?> beanDefinition;

    public BeanDefinitionSpringMetadata(BeanDefinition<?> beanDefinition) {
        this.beanDefinition = beanDefinition;
    }

    public Set<MethodMetadata> getAnnotatedMethods(String annotationName) {
        return Collections.emptySet();
    }

    public MergedAnnotations getAnnotations() {
        return new MicronautMergedAnnotations(this.beanDefinition.getAnnotationMetadata());
    }

    public String getClassName() {
        return this.beanDefinition.getBeanType().getName();
    }

    public boolean isInterface() {
        return this.beanDefinition.getBeanType().isInterface();
    }

    public boolean isAnnotation() {
        return this.beanDefinition.getBeanType().isAnnotation();
    }

    public boolean isAbstract() {
        return this.beanDefinition.isAbstract();
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.beanDefinition.getBeanType().getModifiers());
    }

    public boolean isIndependent() {
        return this.getEnclosingClassName() == null;
    }

    public String getEnclosingClassName() {
        Class<?> ec = this.beanDefinition.getBeanType().getEnclosingClass();
        if (ec != null) {
            return ec.getName();
        }
        return null;
    }

    public String getSuperClassName() {
        Class st = this.beanDefinition.getBeanType().getSuperclass();
        if (st != null && st != Object.class) {
            return st.getName();
        }
        return null;
    }

    public String[] getInterfaceNames() {
        Class<?>[] interfaces = this.beanDefinition.getBeanType().getInterfaces();
        return (String[])Arrays.stream(interfaces).map(Class::getName).toArray(String[]::new);
    }

    public String[] getMemberClassNames() {
        Class<?>[] classes = this.beanDefinition.getBeanType().getClasses();
        return (String[])Arrays.stream(classes).map(Class::getName).toArray(String[]::new);
    }
}

