"""remove category table

Revision ID: b1ca8054f845
Revises: dc5c0f8d5e77
Create Date: 2018-08-18 20:21:55.403300

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'b1ca8054f845'
down_revision = 'dc5c0f8d5e77'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index('cat_pages', table_name='category')
    op.drop_index('cat_title', table_name='category')
    op.drop_table('category')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('category',
    sa.Column('cat_id', sa.INTEGER(), autoincrement=True, nullable=False),
    sa.Column('cat_title', sa.TEXT(), autoincrement=False, nullable=False),
    sa.Column('cat_pages', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('cat_subcats', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('cat_files', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.PrimaryKeyConstraint('cat_id', name='category_pkey')
    )
    op.create_index('cat_title', 'category', ['cat_title'], unique=True)
    op.create_index('cat_pages', 'category', ['cat_pages'], unique=False)
    # ### end Alembic commands ###
