# This file has been autogenerated by the pywayland scanner

# Copyright 2019 Sebastian Wick
# Copyright 2019 Erwin Burema
# Copyright 2020 AMD
# Copyright 2020-2024 Collabora, Ltd.
# Copyright 2024 Xaver Hugl
# Copyright 2022-2025 Red Hat, Inc.
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

import enum

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from .wp_image_description_v1 import WpImageDescriptionV1


class WpImageDescriptionCreatorIccV1(Interface):
    """Holder of image description icc information

    This type of object is used for collecting all the information required to
    create a
    :class:`~pywayland.protocol.color_management_v1.WpImageDescriptionV1`
    object from an ICC file. A complete set of required parameters consists of
    these properties: - ICC file

    Each required property must be set exactly once if the client is to create
    an image description. The set requests verify that a property was not
    already set. The create request verifies that all required properties are
    set. There may be several alternative requests for setting each property,
    and in that case the client must choose one of them.

    Once all properties have been set, the create request must be used to
    create the image description object, destroying the creator in the process.

    The link between a pixel value (a device value in ICC) and its respective
    colorimetry is defined by the details of the particular ICC profile. Those
    details also determine when colorimetry becomes undefined.
    """

    name = "wp_image_description_creator_icc_v1"
    version = 1

    class error(enum.IntEnum):
        incomplete_set = 0
        already_set = 1
        bad_fd = 2
        bad_size = 3
        out_of_file = 4


class WpImageDescriptionCreatorIccV1Proxy(Proxy[WpImageDescriptionCreatorIccV1]):
    interface = WpImageDescriptionCreatorIccV1

    @WpImageDescriptionCreatorIccV1.request(
        Argument(ArgumentType.NewId, interface=WpImageDescriptionV1),
    )
    def create(self) -> Proxy[WpImageDescriptionV1]:
        """Create the image description object from icc data

        Create an image description object based on the ICC information
        previously set on this object. A compositor must parse the ICC data in
        some undefined but finite amount of time.

        The completeness of the parameter set is verified. If the set is not
        complete, the protocol error incomplete_set is raised. For the
        definition of a complete set, see the description of this interface.

        If the particular combination of the information is not supported by
        the compositor, the resulting image description object shall
        immediately deliver the :func:`WpImageDescriptionV1.failed()
        <pywayland.protocol.color_management_v1.WpImageDescriptionV1.failed>`
        event with the 'unsupported' cause. If a valid image description was
        created from the information, the :func:`WpImageDescriptionV1.ready()
        <pywayland.protocol.color_management_v1.WpImageDescriptionV1.ready>`
        event will eventually be sent instead.

        This request destroys the :class:`WpImageDescriptionCreatorIccV1`
        object.

        The resulting image description object does not allow get_information
        request.

        :returns:
            :class:`~pywayland.protocol.color_management_v1.WpImageDescriptionV1`
        """
        image_description = self._marshal_constructor(0, WpImageDescriptionV1)
        return image_description

    @WpImageDescriptionCreatorIccV1.request(
        Argument(ArgumentType.FileDescriptor),
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
    )
    def set_icc_file(self, icc_profile: int, offset: int, length: int) -> None:
        """Set the icc profile file

        Sets the ICC profile file to be used as the basis of the image
        description.

        The data shall be found through the given fd at the given offset,
        having the given length. The fd must be seekable and readable.
        Violating these requirements raises the bad_fd protocol error.

        If reading the data fails due to an error independent of the client,
        the compositor shall send the :func:`WpImageDescriptionV1.failed()
        <pywayland.protocol.color_management_v1.WpImageDescriptionV1.failed>`
        event on the created
        :class:`~pywayland.protocol.color_management_v1.WpImageDescriptionV1`
        with the 'operating_system' cause.

        The maximum size of the ICC profile is 32 MB. If length is greater than
        that or zero, the protocol error bad_size is raised. If offset + length
        exceeds the file size, the protocol error out_of_file is raised.

        A compositor may read the file at any time starting from this request
        and only until whichever happens first: - If create request was issued,
        the
        :class:`~pywayland.protocol.color_management_v1.WpImageDescriptionV1`
        object   delivers either failed or ready event; or - if create request
        was not issued, this   :class:`WpImageDescriptionCreatorIccV1` object
        is destroyed.

        A compositor shall not modify the contents of the file, and the fd may
        be sealed for writes and size changes. The client must ensure to its
        best ability that the data does not change while the compositor is
        reading it.

        The data must represent a valid ICC profile. The ICC profile version
        must be 2 or 4, it must be a 3 channel profile and the class must be
        Display or ColorSpace. Violating these requirements will not result in
        a protocol error, but will eventually send the
        :func:`WpImageDescriptionV1.failed()
        <pywayland.protocol.color_management_v1.WpImageDescriptionV1.failed>`
        event on the created
        :class:`~pywayland.protocol.color_management_v1.WpImageDescriptionV1`
        with the 'unsupported' cause.

        See the International Color Consortium specification ICC.1:2022 for
        more details about ICC profiles.

        If ICC file has already been set on this object, the protocol error
        already_set is raised.

        :param icc_profile:
            ICC profile
        :type icc_profile:
            `ArgumentType.FileDescriptor`
        :param offset:
            byte offset in fd to start of ICC data
        :type offset:
            `ArgumentType.Uint`
        :param length:
            length of ICC data in bytes
        :type length:
            `ArgumentType.Uint`
        """
        self._marshal(1, icc_profile, offset, length)


class WpImageDescriptionCreatorIccV1Resource(Resource):
    interface = WpImageDescriptionCreatorIccV1


class WpImageDescriptionCreatorIccV1Global(Global):
    interface = WpImageDescriptionCreatorIccV1


WpImageDescriptionCreatorIccV1._gen_c()
WpImageDescriptionCreatorIccV1.proxy_class = WpImageDescriptionCreatorIccV1Proxy
WpImageDescriptionCreatorIccV1.resource_class = WpImageDescriptionCreatorIccV1Resource
WpImageDescriptionCreatorIccV1.global_class = WpImageDescriptionCreatorIccV1Global
