/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.coordination;

import java.io.IOException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;

public class PublishClusterStateStats
implements Writeable,
ToXContentObject {
    private final long fullClusterStateReceivedCount;
    private final long incompatibleClusterStateDiffReceivedCount;
    private final long compatibleClusterStateDiffReceivedCount;

    public PublishClusterStateStats(long fullClusterStateReceivedCount, long incompatibleClusterStateDiffReceivedCount, long compatibleClusterStateDiffReceivedCount) {
        this.fullClusterStateReceivedCount = fullClusterStateReceivedCount;
        this.incompatibleClusterStateDiffReceivedCount = incompatibleClusterStateDiffReceivedCount;
        this.compatibleClusterStateDiffReceivedCount = compatibleClusterStateDiffReceivedCount;
    }

    public PublishClusterStateStats(StreamInput in) throws IOException {
        this.fullClusterStateReceivedCount = in.readVLong();
        this.incompatibleClusterStateDiffReceivedCount = in.readVLong();
        this.compatibleClusterStateDiffReceivedCount = in.readVLong();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.fullClusterStateReceivedCount);
        out.writeVLong(this.incompatibleClusterStateDiffReceivedCount);
        out.writeVLong(this.compatibleClusterStateDiffReceivedCount);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("published_cluster_states");
        builder.field("full_states", this.fullClusterStateReceivedCount);
        builder.field("incompatible_diffs", this.incompatibleClusterStateDiffReceivedCount);
        builder.field("compatible_diffs", this.compatibleClusterStateDiffReceivedCount);
        builder.endObject();
        return builder;
    }

    public long getFullClusterStateReceivedCount() {
        return this.fullClusterStateReceivedCount;
    }

    public long getIncompatibleClusterStateDiffReceivedCount() {
        return this.incompatibleClusterStateDiffReceivedCount;
    }

    public long getCompatibleClusterStateDiffReceivedCount() {
        return this.compatibleClusterStateDiffReceivedCount;
    }

    public String toString() {
        return "PublishClusterStateStats(full=" + this.fullClusterStateReceivedCount + ", incompatible=" + this.incompatibleClusterStateDiffReceivedCount + ", compatible=" + this.compatibleClusterStateDiffReceivedCount + ")";
    }
}

