/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.tokenattributes;

import java.util.Objects;
import org.apache.lucene.analysis.tokenattributes.BytesTermAttribute;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.AttributeReflector;
import org.apache.lucene.util.BytesRef;

public class BytesTermAttributeImpl
extends AttributeImpl
implements BytesTermAttribute,
TermToBytesRefAttribute {
    private BytesRef bytes;

    @Override
    public BytesRef getBytesRef() {
        return this.bytes;
    }

    @Override
    public void setBytesRef(BytesRef bytes) {
        this.bytes = bytes;
    }

    @Override
    public void clear() {
        this.bytes = null;
    }

    @Override
    public void copyTo(AttributeImpl target) {
        BytesTermAttributeImpl other = (BytesTermAttributeImpl)target;
        other.bytes = this.bytes == null ? null : BytesRef.deepCopyOf(this.bytes);
    }

    @Override
    public AttributeImpl clone() {
        BytesTermAttributeImpl c = (BytesTermAttributeImpl)super.clone();
        this.copyTo(c);
        return c;
    }

    @Override
    public void reflectWith(AttributeReflector reflector) {
        reflector.reflect(TermToBytesRefAttribute.class, "bytes", this.bytes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BytesTermAttributeImpl)) {
            return false;
        }
        BytesTermAttributeImpl that = (BytesTermAttributeImpl)o;
        return Objects.equals(this.bytes, that.bytes);
    }

    public int hashCode() {
        return Objects.hash(this.bytes);
    }
}

