/*
 * Decompiled with CFR 0.152.
 */
package com.github.kokorin.jaffree.ffmpeg;

import com.github.kokorin.jaffree.ffmpeg.Filter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class FilterChain {
    private final List<Filter> filters = new ArrayList<Filter>();

    public FilterChain addFilter(Filter filter) {
        this.filters.add(filter);
        return this;
    }

    public FilterChain addFilters(List<? extends Filter> filtersToAdd) {
        this.filters.addAll(filtersToAdd);
        return this;
    }

    public String getValue() {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Filter filter : this.filters) {
            if (!first) {
                result.append(",");
            }
            result.append(filter.getValue());
            first = false;
        }
        return result.toString();
    }

    public static FilterChain of(Filter ... filters) {
        return new FilterChain().addFilters(Arrays.asList(filters));
    }
}

