/*
 * Decompiled with CFR 0.152.
 */
package org.jpl7;

import java.math.BigInteger;
import java.util.Objects;
import org.jpl7.JPLException;
import org.jpl7.Term;

public class Integer
extends Term {
    private static BigInteger BIG_MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);
    private static BigInteger BIG_MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    protected final long value;
    protected final BigInteger bigValue;

    public Integer(long l) {
        this.bigValue = null;
        this.value = l;
    }

    public Integer(BigInteger bigInteger) {
        if (bigInteger == null) {
            throw new NullPointerException();
        }
        if (bigInteger.compareTo(BIG_MIN_LONG) >= 0 && bigInteger.compareTo(BIG_MAX_LONG) <= 0) {
            this.bigValue = null;
            this.value = bigInteger.longValue();
        } else {
            this.bigValue = bigInteger;
            this.value = 0L;
        }
    }

    @Override
    public Term[] args() {
        return new Term[0];
    }

    @Override
    public final BigInteger bigValue() {
        if (this.bigValue == null) {
            return new BigInteger(Long.toString(this.value));
        }
        return this.bigValue;
    }

    @Override
    public final double doubleValue() {
        if (this.bigValue == null) {
            return this.value;
        }
        return this.bigValue.doubleValue();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof Integer)) {
            return false;
        }
        Integer integer = (Integer)object;
        if (this.bigValue == null && integer.bigValue == null) {
            return this.value == integer.value;
        }
        if (this.bigValue != null && integer.bigValue != null) {
            return this.bigValue.equals(integer.bigValue);
        }
        return false;
    }

    public int hashCode() {
        if (this.bigValue == null) {
            return Objects.hash(this.value);
        }
        return Objects.hash(this.bigValue);
    }

    @Override
    public final float floatValue() {
        if (this.bigValue == null) {
            return this.value;
        }
        return this.bigValue.floatValue();
    }

    @Override
    public final boolean hasFunctor(long l, int n) {
        return this.value == l && this.bigValue == null && n == 0;
    }

    @Override
    public final boolean hasFunctor(BigInteger bigInteger, int n) {
        return this.bigValue != null && n == 0 && this.bigValue.equals(bigInteger);
    }

    @Override
    public final int intValue() {
        if (this.bigValue != null || this.value < java.lang.Integer.MIN_VALUE || this.value > java.lang.Integer.MAX_VALUE) {
            throw new JPLException("cannot represent value as an int");
        }
        return (int)this.value;
    }

    @Override
    public final boolean isBig() {
        return this.bigValue != null;
    }

    @Override
    public final long longValue() {
        if (this.bigValue != null) {
            throw new JPLException("cannot represent value as a long");
        }
        return this.value;
    }

    public String toString() {
        if (this.bigValue == null) {
            return Long.toString(this.value);
        }
        return this.bigValue.toString(10);
    }

    @Override
    public final int type() {
        return 3;
    }

    @Override
    public String typeName() {
        return "Integer";
    }
}

