#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 tomland
version:              1.3.1.0
visibility:           public
id:                   tomland-1.3.1.0-I2IRKpaLPp12Vd14Ou1fIB
key:                  tomland-1.3.1.0-I2IRKpaLPp12Vd14Ou1fIB
license:              MPL-2.0
copyright:            2018-2020 Kowainik
maintainer:           Kowainik <xrom.xkov@gmail.com>
author:               Dmitrii Kovanikov, Veronika Romashkina
homepage:             https://github.com/kowainik/tomland
synopsis:             Bidirectional TOML serialization
description:
    Implementation of bidirectional TOML serialization. Simple codecs look like this:

    @
    __data__ User = User
    \    { userName :: Text
    \    , userAge  :: Int
    \    }
    \
    \userCodec :: TomlCodec User
    \userCodec = User
    \    \<$\> Toml.text "name" .= userName
    \    \<*\> Toml.int  "age"  .= userAge
    @

    The following blog post has more details about library design:

    * [tomland: Bidirectional TOML serialization](https://kowainik.github.io/posts/2019-01-14-tomland)

category:             TOML, Text, Configuration
abi:                  567d4b0fb74f8cf7c613496a09a6cc7a
exposed:              True
exposed-modules:
    Toml Toml.Codec Toml.Codec.BiMap Toml.Codec.BiMap.Conversion
    Toml.Codec.Code Toml.Codec.Combinator Toml.Codec.Combinator.Common
    Toml.Codec.Combinator.Custom Toml.Codec.Combinator.List
    Toml.Codec.Combinator.Map Toml.Codec.Combinator.Monoid
    Toml.Codec.Combinator.Primitive Toml.Codec.Combinator.Set
    Toml.Codec.Combinator.Table Toml.Codec.Combinator.Time
    Toml.Codec.Combinator.Tuple Toml.Codec.Di Toml.Codec.Error
    Toml.Codec.Generic Toml.Codec.Types Toml.Parser Toml.Parser.Core
    Toml.Parser.Item Toml.Parser.Key Toml.Parser.String
    Toml.Parser.Validate Toml.Parser.Value Toml.Type Toml.Type.AnyValue
    Toml.Type.Edsl Toml.Type.Key Toml.Type.PrefixTree Toml.Type.Printer
    Toml.Type.TOML Toml.Type.UValue Toml.Type.Value

import-dirs:          /usr/lib/ghc-8.10.3/site-local/tomland-1.3.1.0
library-dirs:         /usr/lib/ghc-8.10.3/site-local/tomland-1.3.1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.3/tomland-1.3.1.0
hs-libraries:         HStomland-1.3.1.0-I2IRKpaLPp12Vd14Ou1fIB
depends:
    base-4.14.1.0 bytestring-0.10.12.0 containers-0.6.2.1
    deepseq-1.4.4.0 hashable-1.3.0.0-1CyJarTczNyI67reXuzvxw
    megaparsec-9.0.1-4BAoLpa3muKAl1jICB0rZ7 mtl-2.2.2
    parser-combinators-1.2.1-BgKMLJR8mPH8EvrPvvjrd8 text-1.2.4.1
    time-1.9.3 transformers-0.5.6.2
    unordered-containers-0.2.13.0-Bg5eF3DAB5aLsMS6ltKYUU
    validation-selective-0.1.0.0-6VrI4GKYO0T3qfVEN7Ei1u

haddock-interfaces:   /usr/share/doc/haskell-tomland/html/tomland.haddock
haddock-html:         /usr/share/doc/haskell-tomland/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

