#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 mueval
version:              0.9.3
visibility:           public
id:                   mueval-0.9.3-JvjMbeHYTL3ExPB0updtJT
key:                  mueval-0.9.3-JvjMbeHYTL3ExPB0updtJT
license:              BSD-3-Clause
maintainer:           Gwern <gwern@gwern.net>
author:               Gwern
homepage:             https://github.com/gwern/mueval
synopsis:             Safely evaluate pure Haskell expressions
description:
    Mueval is a Haskell interpreter. It
    uses the GHC API to evaluate arbitrary Haskell expressions.
    Importantly, mueval takes many precautions to defang and avoid \"evil\"
    code.  It uses resource limits, whitelisted modules and Safe Haskell,
    special Show instances for IO, threads, processes, and changes of directory
    to sandbox the Haskell code.

    It is, in short, intended to be a standalone version of Lambdabot'\''s famous
    evaluation functionality. For examples and explanations, please see the README file.

    Mueval is POSIX-only.

category:             Development, Language
abi:                  5a1f9b0d41743354caa2108b76bdaa8e
exposed:              True
exposed-modules:
    Mueval.ArgsParse Mueval.Context Mueval.Interpreter Mueval.Parallel
    Mueval.Resources

import-dirs:          /usr/lib/ghc-8.10.5/site-local/mueval-0.9.3
library-dirs:         /usr/lib/ghc-8.10.5/site-local/mueval-0.9.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/mueval-0.9.3
hs-libraries:         HSmueval-0.9.3-JvjMbeHYTL3ExPB0updtJT
depends:
    Cabal-3.2.1.0 QuickCheck-2.14.2-LYkEXWaccd95SoKseYSYTk
    base-4.14.2.0 containers-0.6.4.1 directory-1.3.6.0
    extensible-exceptions-0.1.1.4-9nRdO96RVgFCedKm18TbaI
    filepath-1.4.2.1 hint-0.9.0.4-DFbrLM5upooFX1mVFmYsXE mtl-2.2.2
    process-1.6.9.0 show-0.6-Bv4jpveeRSCUTFrm5rrOi
    simple-reflect-0.3.3-C3REZ52VTBC6wXIpKK13lR unix-2.7.2.2

haddock-interfaces:   /usr/share/doc/haskell-mueval/html/mueval.haddock
haddock-html:         /usr/share/doc/haskell-mueval/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

