; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -mtriple=riscv64 -mattr=+v -passes=loop-vectorize -scalable-vectorization=off -force-vector-width=1 < %s | FileCheck %s

; Make sure we don't unroll scalar loops in the loop vectorizer.
;
define void @small_loop(ptr nocapture %inArray, i32 %size) nounwind {
; CHECK-LABEL: @small_loop(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = icmp sgt i32 [[SIZE:%.*]], 0
; CHECK-NEXT:    br i1 [[TMP0]], label [[LOOP_PREHEADER:%.*]], label [[EXIT:%.*]]
; CHECK:       loop.preheader:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ [[IV1:%.*]], [[LOOP]] ], [ 0, [[LOOP_PREHEADER]] ]
; CHECK-NEXT:    [[TMP1:%.*]] = getelementptr inbounds i32, ptr [[INARRAY:%.*]], i32 [[IV]]
; CHECK-NEXT:    [[TMP2:%.*]] = load i32, ptr [[TMP1]], align 4
; CHECK-NEXT:    [[TMP3:%.*]] = add nsw i32 [[TMP2]], 6
; CHECK-NEXT:    store i32 [[TMP3]], ptr [[TMP1]], align 4
; CHECK-NEXT:    [[IV1]] = add i32 [[IV]], 1
; CHECK-NEXT:    [[COND:%.*]] = icmp eq i32 [[IV1]], [[SIZE]]
; CHECK-NEXT:    br i1 [[COND]], label [[EXIT_LOOPEXIT:%.*]], label [[LOOP]]
; CHECK:       exit.loopexit:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %0 = icmp sgt i32 %size, 0
  br i1 %0, label %loop, label %exit

loop:                                          ; preds = %entry, %loop
  %iv = phi i32 [ %iv1, %loop ], [ 0, %entry ]
  %1 = getelementptr inbounds i32, ptr %inArray, i32 %iv
  %2 = load i32, ptr %1, align 4
  %3 = add nsw i32 %2, 6
  store i32 %3, ptr %1, align 4
  %iv1 = add i32 %iv, 1
  %cond = icmp eq i32 %iv1, %size
  br i1 %cond, label %exit, label %loop

exit:                                         ; preds = %loop, %entry
  ret void
}
