; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; Test 128-bit multiplication in vector registers on z17
;
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=z17 | FileCheck %s

; Multiplication.
define i128 @f1(i128 %a, i128 %b) {
; CHECK-LABEL: f1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r4), 3
; CHECK-NEXT:    vl %v1, 0(%r3), 3
; CHECK-NEXT:    vmlq %v0, %v1, %v0
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %res = mul i128 %a, %b
  ret i128 %res
}

; Multiply-and-add.
define i128 @f2(i128 %a, i128 %b, i128 %add) {
; CHECK-LABEL: f2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r5), 3
; CHECK-NEXT:    vl %v1, 0(%r4), 3
; CHECK-NEXT:    vl %v2, 0(%r3), 3
; CHECK-NEXT:    vmalq %v0, %v2, %v1, %v0
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %mul = mul i128 %a, %b
  %res = add i128 %mul, %add
  ret i128 %res
}
