; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc < %s -mtriple=sparc | FileCheck %s
; RUN: llc < %s -mtriple=sparcel | FileCheck %s --check-prefix=CHECK-LE
; RUN: llc < %s -mtriple=sparcv9 -mattr=+vis | FileCheck %s --check-prefix=CHECK-VIS
; RUN: llc < %s -mtriple=sparcv9 -mattr=+vis,+vis3 | FileCheck %s --check-prefix=CHECK-VIS3

;; Bitcast should not do a runtime conversion, but rather emit a
;; constant into integer registers directly.

define <2 x i32> @bitcast() nounwind {
; CHECK-LABEL: bitcast:
; CHECK:       ! %bb.0:
; CHECK-NEXT:    sethi 1049856, %o0
; CHECK-NEXT:    retl
; CHECK-NEXT:    mov %g0, %o1
;
; CHECK-LE-LABEL: bitcast:
; CHECK-LE:       ! %bb.0:
; CHECK-LE-NEXT:    sethi 1049856, %o1
; CHECK-LE-NEXT:    retl
; CHECK-LE-NEXT:    mov %g0, %o0
;
; CHECK-VIS-LABEL: bitcast:
; CHECK-VIS:       ! %bb.0:
; CHECK-VIS-NEXT:    sethi 1049856, %o0
; CHECK-VIS-NEXT:    retl
; CHECK-VIS-NEXT:    mov %g0, %o1
;
; CHECK-VIS3-LABEL: bitcast:
; CHECK-VIS3:       ! %bb.0:
; CHECK-VIS3-NEXT:    sethi 1049856, %o0
; CHECK-VIS3-NEXT:    retl
; CHECK-VIS3-NEXT:    mov %g0, %o1
  %1 = bitcast double 5.0 to <2 x i32>
  ret <2 x i32> %1
}

;; Same thing for a call using a double (which gets passed in integer
;; registers)

declare void @a(double)
define void @test_call() nounwind {
; CHECK-LABEL: test_call:
; CHECK:       ! %bb.0:
; CHECK-NEXT:    save %sp, -96, %sp
; CHECK-NEXT:    sethi 1049856, %o0
; CHECK-NEXT:    call a
; CHECK-NEXT:    mov %g0, %o1
; CHECK-NEXT:    ret
; CHECK-NEXT:    restore
;
; CHECK-LE-LABEL: test_call:
; CHECK-LE:       ! %bb.0:
; CHECK-LE-NEXT:    save %sp, -96, %sp
; CHECK-LE-NEXT:    sethi 1049856, %o1
; CHECK-LE-NEXT:    call a
; CHECK-LE-NEXT:    mov %g0, %o0
; CHECK-LE-NEXT:    ret
; CHECK-LE-NEXT:    restore
;
; CHECK-VIS-LABEL: test_call:
; CHECK-VIS:       ! %bb.0:
; CHECK-VIS-NEXT:    save %sp, -176, %sp
; CHECK-VIS-NEXT:    sethi %h44(.LCPI1_0), %i0
; CHECK-VIS-NEXT:    add %i0, %m44(.LCPI1_0), %i0
; CHECK-VIS-NEXT:    sllx %i0, 12, %i0
; CHECK-VIS-NEXT:    call a
; CHECK-VIS-NEXT:    ldd [%i0+%l44(.LCPI1_0)], %f0
; CHECK-VIS-NEXT:    ret
; CHECK-VIS-NEXT:    restore
;
; CHECK-VIS3-LABEL: test_call:
; CHECK-VIS3:       ! %bb.0:
; CHECK-VIS3-NEXT:    save %sp, -176, %sp
; CHECK-VIS3-NEXT:    sethi %h44(.LCPI1_0), %i0
; CHECK-VIS3-NEXT:    add %i0, %m44(.LCPI1_0), %i0
; CHECK-VIS3-NEXT:    sllx %i0, 12, %i0
; CHECK-VIS3-NEXT:    call a
; CHECK-VIS3-NEXT:    ldd [%i0+%l44(.LCPI1_0)], %f0
; CHECK-VIS3-NEXT:    ret
; CHECK-VIS3-NEXT:    restore
  call void @a(double 5.0)
  ret void
}

;; And for a libcall emitted from the pow intrinsic.  (libcall
;; emission happens after SelectionDAG type legalization, so is a bit
;; different than a normal function call. This was crashing before,
;; due to an earlier broken workaround for this issue.)

declare double @llvm.pow.f64(double, double)
define double @test_intrins_call() nounwind {
; CHECK-LABEL: test_intrins_call:
; CHECK:       ! %bb.0:
; CHECK-NEXT:    save %sp, -96, %sp
; CHECK-NEXT:    sethi 1048576, %o0
; CHECK-NEXT:    mov %g0, %o1
; CHECK-NEXT:    mov %o0, %o2
; CHECK-NEXT:    call pow
; CHECK-NEXT:    mov %g0, %o3
; CHECK-NEXT:    ret
; CHECK-NEXT:    restore
;
; CHECK-LE-LABEL: test_intrins_call:
; CHECK-LE:       ! %bb.0:
; CHECK-LE-NEXT:    save %sp, -96, %sp
; CHECK-LE-NEXT:    sethi 1048576, %o1
; CHECK-LE-NEXT:    mov %g0, %o0
; CHECK-LE-NEXT:    mov %g0, %o2
; CHECK-LE-NEXT:    call pow
; CHECK-LE-NEXT:    mov %o1, %o3
; CHECK-LE-NEXT:    ret
; CHECK-LE-NEXT:    restore
;
; CHECK-VIS-LABEL: test_intrins_call:
; CHECK-VIS:       ! %bb.0:
; CHECK-VIS-NEXT:    save %sp, -176, %sp
; CHECK-VIS-NEXT:    sethi %h44(.LCPI2_0), %i0
; CHECK-VIS-NEXT:    add %i0, %m44(.LCPI2_0), %i0
; CHECK-VIS-NEXT:    sllx %i0, 12, %i0
; CHECK-VIS-NEXT:    ldd [%i0+%l44(.LCPI2_0)], %f0
; CHECK-VIS-NEXT:    fmovd %f0, %f2
; CHECK-VIS-NEXT:    call pow
; CHECK-VIS-NEXT:    nop
; CHECK-VIS-NEXT:    ret
; CHECK-VIS-NEXT:    restore
;
; CHECK-VIS3-LABEL: test_intrins_call:
; CHECK-VIS3:       ! %bb.0:
; CHECK-VIS3-NEXT:    save %sp, -176, %sp
; CHECK-VIS3-NEXT:    sethi %h44(.LCPI2_0), %i0
; CHECK-VIS3-NEXT:    add %i0, %m44(.LCPI2_0), %i0
; CHECK-VIS3-NEXT:    sllx %i0, 12, %i0
; CHECK-VIS3-NEXT:    ldd [%i0+%l44(.LCPI2_0)], %f0
; CHECK-VIS3-NEXT:    fmovd %f0, %f2
; CHECK-VIS3-NEXT:    call pow
; CHECK-VIS3-NEXT:    nop
; CHECK-VIS3-NEXT:    ret
; CHECK-VIS3-NEXT:    restore
  %1 = call double @llvm.pow.f64(double 2.0, double 2.0)
  ret double %1
}

;; When we have VIS, f32/f64 zero constant should be materialized from fzero/fzeros.

define double @pos_zero_double() nounwind {
; CHECK-LABEL: pos_zero_double:
; CHECK:       ! %bb.0:
; CHECK-NEXT:    sethi %hi(.LCPI3_0), %o0
; CHECK-NEXT:    retl
; CHECK-NEXT:    ldd [%o0+%lo(.LCPI3_0)], %f0
;
; CHECK-LE-LABEL: pos_zero_double:
; CHECK-LE:       ! %bb.0:
; CHECK-LE-NEXT:    sethi %hi(.LCPI3_0), %o0
; CHECK-LE-NEXT:    retl
; CHECK-LE-NEXT:    ldd [%o0+%lo(.LCPI3_0)], %f0
;
; CHECK-VIS-LABEL: pos_zero_double:
; CHECK-VIS:       ! %bb.0:
; CHECK-VIS-NEXT:    retl
; CHECK-VIS-NEXT:    fzero %f0
;
; CHECK-VIS3-LABEL: pos_zero_double:
; CHECK-VIS3:       ! %bb.0:
; CHECK-VIS3-NEXT:    retl
; CHECK-VIS3-NEXT:    fzero %f0
  ret double +0.0
}

define double @neg_zero_double() nounwind {
; CHECK-LABEL: neg_zero_double:
; CHECK:       ! %bb.0:
; CHECK-NEXT:    sethi %hi(.LCPI4_0), %o0
; CHECK-NEXT:    retl
; CHECK-NEXT:    ldd [%o0+%lo(.LCPI4_0)], %f0
;
; CHECK-LE-LABEL: neg_zero_double:
; CHECK-LE:       ! %bb.0:
; CHECK-LE-NEXT:    sethi %hi(.LCPI4_0), %o0
; CHECK-LE-NEXT:    retl
; CHECK-LE-NEXT:    ldd [%o0+%lo(.LCPI4_0)], %f0
;
; CHECK-VIS-LABEL: neg_zero_double:
; CHECK-VIS:       ! %bb.0:
; CHECK-VIS-NEXT:    fzero %f0
; CHECK-VIS-NEXT:    retl
; CHECK-VIS-NEXT:    fnegd %f0, %f0
;
; CHECK-VIS3-LABEL: neg_zero_double:
; CHECK-VIS3:       ! %bb.0:
; CHECK-VIS3-NEXT:    fzero %f0
; CHECK-VIS3-NEXT:    retl
; CHECK-VIS3-NEXT:    fnegd %f0, %f0
  ret double -0.0
}

define float @pos_zero_float() nounwind {
; CHECK-LABEL: pos_zero_float:
; CHECK:       ! %bb.0:
; CHECK-NEXT:    sethi %hi(.LCPI5_0), %o0
; CHECK-NEXT:    retl
; CHECK-NEXT:    ld [%o0+%lo(.LCPI5_0)], %f0
;
; CHECK-LE-LABEL: pos_zero_float:
; CHECK-LE:       ! %bb.0:
; CHECK-LE-NEXT:    sethi %hi(.LCPI5_0), %o0
; CHECK-LE-NEXT:    retl
; CHECK-LE-NEXT:    ld [%o0+%lo(.LCPI5_0)], %f0
;
; CHECK-VIS-LABEL: pos_zero_float:
; CHECK-VIS:       ! %bb.0:
; CHECK-VIS-NEXT:    retl
; CHECK-VIS-NEXT:    fzeros %f0
;
; CHECK-VIS3-LABEL: pos_zero_float:
; CHECK-VIS3:       ! %bb.0:
; CHECK-VIS3-NEXT:    retl
; CHECK-VIS3-NEXT:    fzeros %f0
  ret float +0.0
}

define float @neg_zero_float() nounwind {
; CHECK-LABEL: neg_zero_float:
; CHECK:       ! %bb.0:
; CHECK-NEXT:    sethi %hi(.LCPI6_0), %o0
; CHECK-NEXT:    retl
; CHECK-NEXT:    ld [%o0+%lo(.LCPI6_0)], %f0
;
; CHECK-LE-LABEL: neg_zero_float:
; CHECK-LE:       ! %bb.0:
; CHECK-LE-NEXT:    sethi %hi(.LCPI6_0), %o0
; CHECK-LE-NEXT:    retl
; CHECK-LE-NEXT:    ld [%o0+%lo(.LCPI6_0)], %f0
;
; CHECK-VIS-LABEL: neg_zero_float:
; CHECK-VIS:       ! %bb.0:
; CHECK-VIS-NEXT:    fzeros %f0
; CHECK-VIS-NEXT:    retl
; CHECK-VIS-NEXT:    fnegs %f0, %f0
;
; CHECK-VIS3-LABEL: neg_zero_float:
; CHECK-VIS3:       ! %bb.0:
; CHECK-VIS3-NEXT:    fzeros %f0
; CHECK-VIS3-NEXT:    retl
; CHECK-VIS3-NEXT:    fnegs %f0, %f0
  ret float -0.0
}

;; When we have VIS3, f32/f64 +/-0.5 constant should be materialized from sethi.

define double @pos_half_double() nounwind {
; CHECK-LABEL: pos_half_double:
; CHECK:       ! %bb.0:
; CHECK-NEXT:    sethi %hi(.LCPI7_0), %o0
; CHECK-NEXT:    retl
; CHECK-NEXT:    ldd [%o0+%lo(.LCPI7_0)], %f0
;
; CHECK-LE-LABEL: pos_half_double:
; CHECK-LE:       ! %bb.0:
; CHECK-LE-NEXT:    sethi %hi(.LCPI7_0), %o0
; CHECK-LE-NEXT:    retl
; CHECK-LE-NEXT:    ldd [%o0+%lo(.LCPI7_0)], %f0
;
; CHECK-VIS-LABEL: pos_half_double:
; CHECK-VIS:       ! %bb.0:
; CHECK-VIS-NEXT:    sethi %h44(.LCPI7_0), %o0
; CHECK-VIS-NEXT:    add %o0, %m44(.LCPI7_0), %o0
; CHECK-VIS-NEXT:    sllx %o0, 12, %o0
; CHECK-VIS-NEXT:    retl
; CHECK-VIS-NEXT:    ldd [%o0+%l44(.LCPI7_0)], %f0
;
; CHECK-VIS3-LABEL: pos_half_double:
; CHECK-VIS3:       ! %bb.0:
; CHECK-VIS3-NEXT:    sethi 1046528, %o0
; CHECK-VIS3-NEXT:    sllx %o0, 32, %o0
; CHECK-VIS3-NEXT:    retl
; CHECK-VIS3-NEXT:    movxtod %o0, %f0
  ret double +0.5
}

define double @neg_half_double() nounwind {
; CHECK-LABEL: neg_half_double:
; CHECK:       ! %bb.0:
; CHECK-NEXT:    sethi %hi(.LCPI8_0), %o0
; CHECK-NEXT:    retl
; CHECK-NEXT:    ldd [%o0+%lo(.LCPI8_0)], %f0
;
; CHECK-LE-LABEL: neg_half_double:
; CHECK-LE:       ! %bb.0:
; CHECK-LE-NEXT:    sethi %hi(.LCPI8_0), %o0
; CHECK-LE-NEXT:    retl
; CHECK-LE-NEXT:    ldd [%o0+%lo(.LCPI8_0)], %f0
;
; CHECK-VIS-LABEL: neg_half_double:
; CHECK-VIS:       ! %bb.0:
; CHECK-VIS-NEXT:    sethi %h44(.LCPI8_0), %o0
; CHECK-VIS-NEXT:    add %o0, %m44(.LCPI8_0), %o0
; CHECK-VIS-NEXT:    sllx %o0, 12, %o0
; CHECK-VIS-NEXT:    retl
; CHECK-VIS-NEXT:    ldd [%o0+%l44(.LCPI8_0)], %f0
;
; CHECK-VIS3-LABEL: neg_half_double:
; CHECK-VIS3:       ! %bb.0:
; CHECK-VIS3-NEXT:    sethi 3143680, %o0
; CHECK-VIS3-NEXT:    sllx %o0, 32, %o0
; CHECK-VIS3-NEXT:    retl
; CHECK-VIS3-NEXT:    movxtod %o0, %f0
  ret double -0.5
}

define float @pos_half_float() nounwind {
; CHECK-LABEL: pos_half_float:
; CHECK:       ! %bb.0:
; CHECK-NEXT:    sethi %hi(.LCPI9_0), %o0
; CHECK-NEXT:    retl
; CHECK-NEXT:    ld [%o0+%lo(.LCPI9_0)], %f0
;
; CHECK-LE-LABEL: pos_half_float:
; CHECK-LE:       ! %bb.0:
; CHECK-LE-NEXT:    sethi %hi(.LCPI9_0), %o0
; CHECK-LE-NEXT:    retl
; CHECK-LE-NEXT:    ld [%o0+%lo(.LCPI9_0)], %f0
;
; CHECK-VIS-LABEL: pos_half_float:
; CHECK-VIS:       ! %bb.0:
; CHECK-VIS-NEXT:    sethi %h44(.LCPI9_0), %o0
; CHECK-VIS-NEXT:    add %o0, %m44(.LCPI9_0), %o0
; CHECK-VIS-NEXT:    sllx %o0, 12, %o0
; CHECK-VIS-NEXT:    retl
; CHECK-VIS-NEXT:    ld [%o0+%l44(.LCPI9_0)], %f0
;
; CHECK-VIS3-LABEL: pos_half_float:
; CHECK-VIS3:       ! %bb.0:
; CHECK-VIS3-NEXT:    sethi 1032192, %o0
; CHECK-VIS3-NEXT:    retl
; CHECK-VIS3-NEXT:    movwtos %o0, %f0
  ret float +0.5
}

define float @neg_half_float() nounwind {
; CHECK-LABEL: neg_half_float:
; CHECK:       ! %bb.0:
; CHECK-NEXT:    sethi %hi(.LCPI10_0), %o0
; CHECK-NEXT:    retl
; CHECK-NEXT:    ld [%o0+%lo(.LCPI10_0)], %f0
;
; CHECK-LE-LABEL: neg_half_float:
; CHECK-LE:       ! %bb.0:
; CHECK-LE-NEXT:    sethi %hi(.LCPI10_0), %o0
; CHECK-LE-NEXT:    retl
; CHECK-LE-NEXT:    ld [%o0+%lo(.LCPI10_0)], %f0
;
; CHECK-VIS-LABEL: neg_half_float:
; CHECK-VIS:       ! %bb.0:
; CHECK-VIS-NEXT:    sethi %h44(.LCPI10_0), %o0
; CHECK-VIS-NEXT:    add %o0, %m44(.LCPI10_0), %o0
; CHECK-VIS-NEXT:    sllx %o0, 12, %o0
; CHECK-VIS-NEXT:    retl
; CHECK-VIS-NEXT:    ld [%o0+%l44(.LCPI10_0)], %f0
;
; CHECK-VIS3-LABEL: neg_half_float:
; CHECK-VIS3:       ! %bb.0:
; CHECK-VIS3-NEXT:    sethi 3129344, %o0
; CHECK-VIS3-NEXT:    retl
; CHECK-VIS3-NEXT:    movwtos %o0, %f0
  ret float -0.5
}
