; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --include-generated-funcs --version 2
; RUN: llc -mtriple=riscv64 -riscv-enable-copy-propagation -enable-machine-outliner -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV64I

; The outlined function produced by this test case contains a register to
; register copy, which is at risk of being removed by MachineCopyPropagation
; if it can't see that the copy is used. At the time of writing this test
; case, MCP will remove the copy if it is run after the machine outliner.

define signext i32 @nge(i32 signext %a, i32 signext %b) nounwind {
entry:
  %cmp = icmp sge i32 %a, %b
  %conv.neg = sext i1 %cmp to i32
  ret i32 %conv.neg
}

define signext i32 @ngt(i32 signext %a, i32 signext %b) nounwind {
entry:
  %cmp = icmp sgt i32 %a, %b
  %conv.neg = sext i1 %cmp to i32
  ret i32 %conv.neg
}

define signext i32 @nle(i32 signext %a, i32 signext %b) nounwind {
entry:
  %cmp = icmp sle i32 %a, %b
  %conv.neg = sext i1 %cmp to i32
  ret i32 %conv.neg
}

define signext i32 @nlt(i32 signext %a, i32 signext %b) nounwind {
entry:
  %cmp = icmp slt i32 %a, %b
  %conv.neg = sext i1 %cmp to i32
  ret i32 %conv.neg
}

define signext i32 @main() nounwind {
entry:
  %call = tail call signext i32 @nge(i32 signext -2147483648, i32 signext 2147483647)
  %cmp.not = icmp eq i32 %call, 0
  br i1 %cmp.not, label %if.end, label %if.then

if.then:
  tail call void @abort()
  unreachable

if.end:
  %call1 = tail call signext i32 @nge(i32 signext 2147483647, i32 signext -2147483648)
  %cmp2.not = icmp eq i32 %call1, -1
  br i1 %cmp2.not, label %if.end4, label %if.then3

if.then3:
  tail call void @abort()
  unreachable

if.end4:
  %call5 = tail call signext i32 @ngt(i32 signext -2147483648, i32 signext 2147483647)
  %cmp6.not = icmp eq i32 %call5, 0
  br i1 %cmp6.not, label %if.end8, label %if.then7

if.then7:
  tail call void @abort()
  unreachable

if.end8:
  %call9 = tail call signext i32 @ngt(i32 signext 2147483647, i32 signext -2147483648)
  %cmp10.not = icmp eq i32 %call9, -1
  br i1 %cmp10.not, label %if.end12, label %if.then11

if.then11:
  tail call void @abort()
  unreachable

if.end12:
  %call13 = tail call signext i32 @nle(i32 signext -2147483648, i32 signext 2147483647)
  %cmp14.not = icmp eq i32 %call13, -1
  br i1 %cmp14.not, label %if.end16, label %if.then15

if.then15:
  tail call void @abort()
  unreachable

if.end16:
  %call17 = tail call signext i32 @nle(i32 signext 2147483647, i32 signext -2147483648)
  %cmp18.not = icmp eq i32 %call17, 0
  br i1 %cmp18.not, label %if.end20, label %if.then19

if.then19:
  tail call void @abort()
  unreachable

if.end20:
  %call21 = tail call signext i32 @nlt(i32 signext -2147483648, i32 signext 2147483647)
  %cmp22.not = icmp eq i32 %call21, -1
  br i1 %cmp22.not, label %if.end24, label %if.then23

if.then23:
  tail call void @abort()
  unreachable

if.end24:
  %call25 = tail call signext i32 @nlt(i32 signext 2147483647, i32 signext -2147483648)
  %cmp26.not = icmp eq i32 %call25, 0
  br i1 %cmp26.not, label %if.end28, label %if.then27

if.then27:
  tail call void @abort()
  unreachable

if.end28:
  tail call void @exit(i32 signext 0)
  unreachable
}

declare void @abort() noreturn
declare void @exit(i32 signext) noreturn

; RV64I-LABEL: nge:
; RV64I:       # %bb.0: # %entry
; RV64I-NEXT:    slt a0, a0, a1
; RV64I-NEXT:    addi a0, a0, -1
; RV64I-NEXT:    ret
;
; RV64I-LABEL: ngt:
; RV64I:       # %bb.0: # %entry
; RV64I-NEXT:    slt a0, a1, a0
; RV64I-NEXT:    neg a0, a0
; RV64I-NEXT:    ret
;
; RV64I-LABEL: nle:
; RV64I:       # %bb.0: # %entry
; RV64I-NEXT:    slt a0, a1, a0
; RV64I-NEXT:    addi a0, a0, -1
; RV64I-NEXT:    ret
;
; RV64I-LABEL: nlt:
; RV64I:       # %bb.0: # %entry
; RV64I-NEXT:    slt a0, a0, a1
; RV64I-NEXT:    neg a0, a0
; RV64I-NEXT:    ret
;
; RV64I-LABEL: main:
; RV64I:       # %bb.0: # %entry
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call t0, OUTLINED_FUNCTION_0
; RV64I-NEXT:    call nge
; RV64I-NEXT:    bnez a0, .LBB4_9
; RV64I-NEXT:  # %bb.1: # %if.end
; RV64I-NEXT:    lui a1, 524288
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call nge
; RV64I-NEXT:    li a1, -1
; RV64I-NEXT:    bne a0, a1, .LBB4_9
; RV64I-NEXT:  # %bb.2: # %if.end4
; RV64I-NEXT:    call t0, OUTLINED_FUNCTION_0
; RV64I-NEXT:    call ngt
; RV64I-NEXT:    bnez a0, .LBB4_9
; RV64I-NEXT:  # %bb.3: # %if.end8
; RV64I-NEXT:    lui a1, 524288
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call ngt
; RV64I-NEXT:    li s1, -1
; RV64I-NEXT:    bne a0, s1, .LBB4_9
; RV64I-NEXT:  # %bb.4: # %if.end12
; RV64I-NEXT:    call t0, OUTLINED_FUNCTION_0
; RV64I-NEXT:    call nle
; RV64I-NEXT:    bne a0, s1, .LBB4_9
; RV64I-NEXT:  # %bb.5: # %if.end16
; RV64I-NEXT:    lui a1, 524288
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call nle
; RV64I-NEXT:    bnez a0, .LBB4_9
; RV64I-NEXT:  # %bb.6: # %if.end20
; RV64I-NEXT:    call t0, OUTLINED_FUNCTION_0
; RV64I-NEXT:    call nlt
; RV64I-NEXT:    li a1, -1
; RV64I-NEXT:    bne a0, a1, .LBB4_9
; RV64I-NEXT:  # %bb.7: # %if.end24
; RV64I-NEXT:    lui a1, 524288
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call nlt
; RV64I-NEXT:    bnez a0, .LBB4_9
; RV64I-NEXT:  # %bb.8: # %if.end28
; RV64I-NEXT:    call exit
; RV64I-NEXT:  .LBB4_9: # %if.then
; RV64I-NEXT:    call abort
;
; RV64I-LABEL: OUTLINED_FUNCTION_0:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui s0, 524288
; RV64I-NEXT:    addiw s0, s0, -1
; RV64I-NEXT:    lui a0, 524288
; RV64I-NEXT:    mv a1, s0
; RV64I-NEXT:    jr t0
