import { z, ZodTypeAny } from 'zod';
import { AuthInfo } from './server/auth/types.js';
export declare const LATEST_PROTOCOL_VERSION = "2025-06-18";
export declare const DEFAULT_NEGOTIATED_PROTOCOL_VERSION = "2025-03-26";
export declare const SUPPORTED_PROTOCOL_VERSIONS: string[];
export declare const JSONRPC_VERSION = "2.0";
/**
 * A progress token, used to associate progress notifications with the original request.
 */
export declare const ProgressTokenSchema: z.ZodUnion<[z.ZodString, z.ZodNumber]>;
/**
 * An opaque token used to represent a cursor for pagination.
 */
export declare const CursorSchema: z.ZodString;
declare const RequestMetaSchema: z.ZodObject<{
    /**
     * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
     */
    progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    /**
     * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
     */
    progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    /**
     * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
     */
    progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
}, z.ZodTypeAny, "passthrough">>;
export declare const RequestSchema: z.ZodObject<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, "strip", z.ZodTypeAny, {
    method: string;
    params?: z.objectOutputType<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}, {
    method: string;
    params?: z.objectInputType<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}>;
export declare const NotificationSchema: z.ZodObject<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, "strip", z.ZodTypeAny, {
    method: string;
    params?: z.objectOutputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}, {
    method: string;
    params?: z.objectInputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}>;
export declare const ResultSchema: z.ZodObject<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, z.ZodTypeAny, "passthrough">>;
/**
 * A uniquely identifying ID for a request in JSON-RPC.
 */
export declare const RequestIdSchema: z.ZodUnion<[z.ZodString, z.ZodNumber]>;
/**
 * A request that expects a response.
 */
export declare const JSONRPCRequestSchema: z.ZodObject<z.objectUtil.extendShape<{
    jsonrpc: z.ZodLiteral<"2.0">;
    id: z.ZodUnion<[z.ZodString, z.ZodNumber]>;
}, {
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}>, "strict", z.ZodTypeAny, {
    method: string;
    jsonrpc: "2.0";
    id: string | number;
    params?: z.objectOutputType<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}, {
    method: string;
    jsonrpc: "2.0";
    id: string | number;
    params?: z.objectInputType<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}>;
export declare const isJSONRPCRequest: (value: unknown) => value is JSONRPCRequest;
/**
 * A notification which does not expect a response.
 */
export declare const JSONRPCNotificationSchema: z.ZodObject<z.objectUtil.extendShape<{
    jsonrpc: z.ZodLiteral<"2.0">;
}, {
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}>, "strict", z.ZodTypeAny, {
    method: string;
    jsonrpc: "2.0";
    params?: z.objectOutputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}, {
    method: string;
    jsonrpc: "2.0";
    params?: z.objectInputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}>;
export declare const isJSONRPCNotification: (value: unknown) => value is JSONRPCNotification;
/**
 * A successful (non-error) response to a request.
 */
export declare const JSONRPCResponseSchema: z.ZodObject<{
    jsonrpc: z.ZodLiteral<"2.0">;
    id: z.ZodUnion<[z.ZodString, z.ZodNumber]>;
    result: z.ZodObject<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>;
}, "strict", z.ZodTypeAny, {
    jsonrpc: "2.0";
    id: string | number;
    result: {
        _meta?: z.objectOutputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
    } & {
        [k: string]: unknown;
    };
}, {
    jsonrpc: "2.0";
    id: string | number;
    result: {
        _meta?: z.objectInputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
    } & {
        [k: string]: unknown;
    };
}>;
export declare const isJSONRPCResponse: (value: unknown) => value is JSONRPCResponse;
/**
 * Error codes defined by the JSON-RPC specification.
 */
export declare enum ErrorCode {
    ConnectionClosed = -32000,
    RequestTimeout = -32001,
    ParseError = -32700,
    InvalidRequest = -32600,
    MethodNotFound = -32601,
    InvalidParams = -32602,
    InternalError = -32603
}
/**
 * A response to a request that indicates an error occurred.
 */
export declare const JSONRPCErrorSchema: z.ZodObject<{
    jsonrpc: z.ZodLiteral<"2.0">;
    id: z.ZodUnion<[z.ZodString, z.ZodNumber]>;
    error: z.ZodObject<{
        /**
         * The error type that occurred.
         */
        code: z.ZodNumber;
        /**
         * A short description of the error. The message SHOULD be limited to a concise single sentence.
         */
        message: z.ZodString;
        /**
         * Additional information about the error. The value of this member is defined by the sender (e.g. detailed error information, nested errors etc.).
         */
        data: z.ZodOptional<z.ZodUnknown>;
    }, "strip", z.ZodTypeAny, {
        code: number;
        message: string;
        data?: unknown;
    }, {
        code: number;
        message: string;
        data?: unknown;
    }>;
}, "strict", z.ZodTypeAny, {
    jsonrpc: "2.0";
    id: string | number;
    error: {
        code: number;
        message: string;
        data?: unknown;
    };
}, {
    jsonrpc: "2.0";
    id: string | number;
    error: {
        code: number;
        message: string;
        data?: unknown;
    };
}>;
export declare const isJSONRPCError: (value: unknown) => value is JSONRPCError;
export declare const JSONRPCMessageSchema: z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
    jsonrpc: z.ZodLiteral<"2.0">;
    id: z.ZodUnion<[z.ZodString, z.ZodNumber]>;
}, {
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}>, "strict", z.ZodTypeAny, {
    method: string;
    jsonrpc: "2.0";
    id: string | number;
    params?: z.objectOutputType<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}, {
    method: string;
    jsonrpc: "2.0";
    id: string | number;
    params?: z.objectInputType<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}>, z.ZodObject<z.objectUtil.extendShape<{
    jsonrpc: z.ZodLiteral<"2.0">;
}, {
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}>, "strict", z.ZodTypeAny, {
    method: string;
    jsonrpc: "2.0";
    params?: z.objectOutputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}, {
    method: string;
    jsonrpc: "2.0";
    params?: z.objectInputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}>, z.ZodObject<{
    jsonrpc: z.ZodLiteral<"2.0">;
    id: z.ZodUnion<[z.ZodString, z.ZodNumber]>;
    result: z.ZodObject<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>;
}, "strict", z.ZodTypeAny, {
    jsonrpc: "2.0";
    id: string | number;
    result: {
        _meta?: z.objectOutputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
    } & {
        [k: string]: unknown;
    };
}, {
    jsonrpc: "2.0";
    id: string | number;
    result: {
        _meta?: z.objectInputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
    } & {
        [k: string]: unknown;
    };
}>, z.ZodObject<{
    jsonrpc: z.ZodLiteral<"2.0">;
    id: z.ZodUnion<[z.ZodString, z.ZodNumber]>;
    error: z.ZodObject<{
        /**
         * The error type that occurred.
         */
        code: z.ZodNumber;
        /**
         * A short description of the error. The message SHOULD be limited to a concise single sentence.
         */
        message: z.ZodString;
        /**
         * Additional information about the error. The value of this member is defined by the sender (e.g. detailed error information, nested errors etc.).
         */
        data: z.ZodOptional<z.ZodUnknown>;
    }, "strip", z.ZodTypeAny, {
        code: number;
        message: string;
        data?: unknown;
    }, {
        code: number;
        message: string;
        data?: unknown;
    }>;
}, "strict", z.ZodTypeAny, {
    jsonrpc: "2.0";
    id: string | number;
    error: {
        code: number;
        message: string;
        data?: unknown;
    };
}, {
    jsonrpc: "2.0";
    id: string | number;
    error: {
        code: number;
        message: string;
        data?: unknown;
    };
}>]>;
/**
 * A response that indicates success but carries no data.
 */
export declare const EmptyResultSchema: z.ZodObject<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, "strict", z.ZodTypeAny, {
    _meta?: z.objectOutputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
}, {
    _meta?: z.objectInputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
}>;
/**
 * This notification can be sent by either side to indicate that it is cancelling a previously-issued request.
 *
 * The request SHOULD still be in-flight, but due to communication latency, it is always possible that this notification MAY arrive after the request has already finished.
 *
 * This notification indicates that the result will be unused, so any associated processing SHOULD cease.
 *
 * A client MUST NOT attempt to cancel its `initialize` request.
 */
export declare const CancelledNotificationSchema: z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"notifications/cancelled">;
    params: z.ZodObject<z.objectUtil.extendShape<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The ID of the request to cancel.
         *
         * This MUST correspond to the ID of a request previously issued in the same direction.
         */
        requestId: z.ZodUnion<[z.ZodString, z.ZodNumber]>;
        /**
         * An optional string describing the reason for the cancellation. This MAY be logged or presented to the user.
         */
        reason: z.ZodOptional<z.ZodString>;
    }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The ID of the request to cancel.
         *
         * This MUST correspond to the ID of a request previously issued in the same direction.
         */
        requestId: z.ZodUnion<[z.ZodString, z.ZodNumber]>;
        /**
         * An optional string describing the reason for the cancellation. This MAY be logged or presented to the user.
         */
        reason: z.ZodOptional<z.ZodString>;
    }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The ID of the request to cancel.
         *
         * This MUST correspond to the ID of a request previously issued in the same direction.
         */
        requestId: z.ZodUnion<[z.ZodString, z.ZodNumber]>;
        /**
         * An optional string describing the reason for the cancellation. This MAY be logged or presented to the user.
         */
        reason: z.ZodOptional<z.ZodString>;
    }>, z.ZodTypeAny, "passthrough">>;
}>, "strip", z.ZodTypeAny, {
    params: {
        requestId: string | number;
        _meta?: z.objectOutputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
        reason?: string | undefined;
    } & {
        [k: string]: unknown;
    };
    method: "notifications/cancelled";
}, {
    params: {
        requestId: string | number;
        _meta?: z.objectInputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
        reason?: string | undefined;
    } & {
        [k: string]: unknown;
    };
    method: "notifications/cancelled";
}>;
/**
 * Icon schema for use in tools, prompts, resources, and implementations.
 */
export declare const IconSchema: z.ZodObject<{
    /**
     * URL or data URI for the icon.
     */
    src: z.ZodString;
    /**
     * Optional MIME type for the icon.
     */
    mimeType: z.ZodOptional<z.ZodString>;
    /**
     * Optional array of strings that specify sizes at which the icon can be used.
     * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
     *
     * If not provided, the client should assume that the icon can be used at any size.
     */
    sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    /**
     * URL or data URI for the icon.
     */
    src: z.ZodString;
    /**
     * Optional MIME type for the icon.
     */
    mimeType: z.ZodOptional<z.ZodString>;
    /**
     * Optional array of strings that specify sizes at which the icon can be used.
     * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
     *
     * If not provided, the client should assume that the icon can be used at any size.
     */
    sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    /**
     * URL or data URI for the icon.
     */
    src: z.ZodString;
    /**
     * Optional MIME type for the icon.
     */
    mimeType: z.ZodOptional<z.ZodString>;
    /**
     * Optional array of strings that specify sizes at which the icon can be used.
     * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
     *
     * If not provided, the client should assume that the icon can be used at any size.
     */
    sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
}, z.ZodTypeAny, "passthrough">>;
/**
 * Base schema to add `icons` property.
 *
 */
export declare const IconsSchema: z.ZodObject<{
    /**
     * Optional set of sized icons that the client can display in a user interface.
     *
     * Clients that support rendering icons MUST support at least the following MIME types:
     * - `image/png` - PNG images (safe, universal compatibility)
     * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
     *
     * Clients that support rendering icons SHOULD also support:
     * - `image/svg+xml` - SVG images (scalable but requires security precautions)
     * - `image/webp` - WebP images (modern, efficient format)
     */
    icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, z.ZodTypeAny, "passthrough">>, "many">>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    /**
     * Optional set of sized icons that the client can display in a user interface.
     *
     * Clients that support rendering icons MUST support at least the following MIME types:
     * - `image/png` - PNG images (safe, universal compatibility)
     * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
     *
     * Clients that support rendering icons SHOULD also support:
     * - `image/svg+xml` - SVG images (scalable but requires security precautions)
     * - `image/webp` - WebP images (modern, efficient format)
     */
    icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, z.ZodTypeAny, "passthrough">>, "many">>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    /**
     * Optional set of sized icons that the client can display in a user interface.
     *
     * Clients that support rendering icons MUST support at least the following MIME types:
     * - `image/png` - PNG images (safe, universal compatibility)
     * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
     *
     * Clients that support rendering icons SHOULD also support:
     * - `image/svg+xml` - SVG images (scalable but requires security precautions)
     * - `image/webp` - WebP images (modern, efficient format)
     */
    icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, z.ZodTypeAny, "passthrough">>, "many">>;
}, z.ZodTypeAny, "passthrough">>;
/**
 * Base metadata interface for common properties across resources, tools, prompts, and implementations.
 */
export declare const BaseMetadataSchema: z.ZodObject<{
    /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
    name: z.ZodString;
    /**
     * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
     * even by those unfamiliar with domain-specific terminology.
     *
     * If not provided, the name should be used for display (except for Tool,
     * where `annotations.title` should be given precedence over using `name`,
     * if present).
     */
    title: z.ZodOptional<z.ZodString>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
    name: z.ZodString;
    /**
     * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
     * even by those unfamiliar with domain-specific terminology.
     *
     * If not provided, the name should be used for display (except for Tool,
     * where `annotations.title` should be given precedence over using `name`,
     * if present).
     */
    title: z.ZodOptional<z.ZodString>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
    name: z.ZodString;
    /**
     * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
     * even by those unfamiliar with domain-specific terminology.
     *
     * If not provided, the name should be used for display (except for Tool,
     * where `annotations.title` should be given precedence over using `name`,
     * if present).
     */
    title: z.ZodOptional<z.ZodString>;
}, z.ZodTypeAny, "passthrough">>;
/**
 * Describes the name and version of an MCP implementation.
 */
export declare const ImplementationSchema: z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
    name: z.ZodString;
    /**
     * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
     * even by those unfamiliar with domain-specific terminology.
     *
     * If not provided, the name should be used for display (except for Tool,
     * where `annotations.title` should be given precedence over using `name`,
     * if present).
     */
    title: z.ZodOptional<z.ZodString>;
}, {
    version: z.ZodString;
    /**
     * An optional URL of the website for this implementation.
     */
    websiteUrl: z.ZodOptional<z.ZodString>;
}>, {
    /**
     * Optional set of sized icons that the client can display in a user interface.
     *
     * Clients that support rendering icons MUST support at least the following MIME types:
     * - `image/png` - PNG images (safe, universal compatibility)
     * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
     *
     * Clients that support rendering icons SHOULD also support:
     * - `image/svg+xml` - SVG images (scalable but requires security precautions)
     * - `image/webp` - WebP images (modern, efficient format)
     */
    icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, z.ZodTypeAny, "passthrough">>, "many">>;
}>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
    name: z.ZodString;
    /**
     * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
     * even by those unfamiliar with domain-specific terminology.
     *
     * If not provided, the name should be used for display (except for Tool,
     * where `annotations.title` should be given precedence over using `name`,
     * if present).
     */
    title: z.ZodOptional<z.ZodString>;
}, {
    version: z.ZodString;
    /**
     * An optional URL of the website for this implementation.
     */
    websiteUrl: z.ZodOptional<z.ZodString>;
}>, {
    /**
     * Optional set of sized icons that the client can display in a user interface.
     *
     * Clients that support rendering icons MUST support at least the following MIME types:
     * - `image/png` - PNG images (safe, universal compatibility)
     * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
     *
     * Clients that support rendering icons SHOULD also support:
     * - `image/svg+xml` - SVG images (scalable but requires security precautions)
     * - `image/webp` - WebP images (modern, efficient format)
     */
    icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, z.ZodTypeAny, "passthrough">>, "many">>;
}>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
    name: z.ZodString;
    /**
     * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
     * even by those unfamiliar with domain-specific terminology.
     *
     * If not provided, the name should be used for display (except for Tool,
     * where `annotations.title` should be given precedence over using `name`,
     * if present).
     */
    title: z.ZodOptional<z.ZodString>;
}, {
    version: z.ZodString;
    /**
     * An optional URL of the website for this implementation.
     */
    websiteUrl: z.ZodOptional<z.ZodString>;
}>, {
    /**
     * Optional set of sized icons that the client can display in a user interface.
     *
     * Clients that support rendering icons MUST support at least the following MIME types:
     * - `image/png` - PNG images (safe, universal compatibility)
     * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
     *
     * Clients that support rendering icons SHOULD also support:
     * - `image/svg+xml` - SVG images (scalable but requires security precautions)
     * - `image/webp` - WebP images (modern, efficient format)
     */
    icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, z.ZodTypeAny, "passthrough">>, "many">>;
}>, z.ZodTypeAny, "passthrough">>;
/**
 * Capabilities a client may support. Known capabilities are defined here, in this schema, but this is not a closed set: any client can define its own, additional capabilities.
 */
export declare const ClientCapabilitiesSchema: z.ZodObject<{
    /**
     * Experimental, non-standard capabilities that the client supports.
     */
    experimental: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    /**
     * Present if the client supports sampling from an LLM.
     */
    sampling: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    /**
     * Present if the client supports eliciting user input.
     */
    elicitation: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    /**
     * Present if the client supports listing roots.
     */
    roots: z.ZodOptional<z.ZodObject<{
        /**
         * Whether the client supports issuing notifications for changes to the roots list.
         */
        listChanged: z.ZodOptional<z.ZodBoolean>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * Whether the client supports issuing notifications for changes to the roots list.
         */
        listChanged: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * Whether the client supports issuing notifications for changes to the roots list.
         */
        listChanged: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">>>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    /**
     * Experimental, non-standard capabilities that the client supports.
     */
    experimental: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    /**
     * Present if the client supports sampling from an LLM.
     */
    sampling: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    /**
     * Present if the client supports eliciting user input.
     */
    elicitation: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    /**
     * Present if the client supports listing roots.
     */
    roots: z.ZodOptional<z.ZodObject<{
        /**
         * Whether the client supports issuing notifications for changes to the roots list.
         */
        listChanged: z.ZodOptional<z.ZodBoolean>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * Whether the client supports issuing notifications for changes to the roots list.
         */
        listChanged: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * Whether the client supports issuing notifications for changes to the roots list.
         */
        listChanged: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">>>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    /**
     * Experimental, non-standard capabilities that the client supports.
     */
    experimental: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    /**
     * Present if the client supports sampling from an LLM.
     */
    sampling: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    /**
     * Present if the client supports eliciting user input.
     */
    elicitation: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    /**
     * Present if the client supports listing roots.
     */
    roots: z.ZodOptional<z.ZodObject<{
        /**
         * Whether the client supports issuing notifications for changes to the roots list.
         */
        listChanged: z.ZodOptional<z.ZodBoolean>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * Whether the client supports issuing notifications for changes to the roots list.
         */
        listChanged: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * Whether the client supports issuing notifications for changes to the roots list.
         */
        listChanged: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">>>;
}, z.ZodTypeAny, "passthrough">>;
/**
 * This request is sent from the client to the server when it first connects, asking it to begin initialization.
 */
export declare const InitializeRequestSchema: z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"initialize">;
    params: z.ZodObject<z.objectUtil.extendShape<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The latest version of the Model Context Protocol that the client supports. The client MAY decide to support older versions as well.
         */
        protocolVersion: z.ZodString;
        capabilities: z.ZodObject<{
            /**
             * Experimental, non-standard capabilities that the client supports.
             */
            experimental: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            /**
             * Present if the client supports sampling from an LLM.
             */
            sampling: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            /**
             * Present if the client supports eliciting user input.
             */
            elicitation: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            /**
             * Present if the client supports listing roots.
             */
            roots: z.ZodOptional<z.ZodObject<{
                /**
                 * Whether the client supports issuing notifications for changes to the roots list.
                 */
                listChanged: z.ZodOptional<z.ZodBoolean>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                /**
                 * Whether the client supports issuing notifications for changes to the roots list.
                 */
                listChanged: z.ZodOptional<z.ZodBoolean>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                /**
                 * Whether the client supports issuing notifications for changes to the roots list.
                 */
                listChanged: z.ZodOptional<z.ZodBoolean>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * Experimental, non-standard capabilities that the client supports.
             */
            experimental: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            /**
             * Present if the client supports sampling from an LLM.
             */
            sampling: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            /**
             * Present if the client supports eliciting user input.
             */
            elicitation: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            /**
             * Present if the client supports listing roots.
             */
            roots: z.ZodOptional<z.ZodObject<{
                /**
                 * Whether the client supports issuing notifications for changes to the roots list.
                 */
                listChanged: z.ZodOptional<z.ZodBoolean>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                /**
                 * Whether the client supports issuing notifications for changes to the roots list.
                 */
                listChanged: z.ZodOptional<z.ZodBoolean>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                /**
                 * Whether the client supports issuing notifications for changes to the roots list.
                 */
                listChanged: z.ZodOptional<z.ZodBoolean>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * Experimental, non-standard capabilities that the client supports.
             */
            experimental: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            /**
             * Present if the client supports sampling from an LLM.
             */
            sampling: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            /**
             * Present if the client supports eliciting user input.
             */
            elicitation: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            /**
             * Present if the client supports listing roots.
             */
            roots: z.ZodOptional<z.ZodObject<{
                /**
                 * Whether the client supports issuing notifications for changes to the roots list.
                 */
                listChanged: z.ZodOptional<z.ZodBoolean>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                /**
                 * Whether the client supports issuing notifications for changes to the roots list.
                 */
                listChanged: z.ZodOptional<z.ZodBoolean>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                /**
                 * Whether the client supports issuing notifications for changes to the roots list.
                 */
                listChanged: z.ZodOptional<z.ZodBoolean>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">>;
        clientInfo: z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
            /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
            name: z.ZodString;
            /**
             * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
             * even by those unfamiliar with domain-specific terminology.
             *
             * If not provided, the name should be used for display (except for Tool,
             * where `annotations.title` should be given precedence over using `name`,
             * if present).
             */
            title: z.ZodOptional<z.ZodString>;
        }, {
            version: z.ZodString;
            /**
             * An optional URL of the website for this implementation.
             */
            websiteUrl: z.ZodOptional<z.ZodString>;
        }>, {
            /**
             * Optional set of sized icons that the client can display in a user interface.
             *
             * Clients that support rendering icons MUST support at least the following MIME types:
             * - `image/png` - PNG images (safe, universal compatibility)
             * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
             *
             * Clients that support rendering icons SHOULD also support:
             * - `image/svg+xml` - SVG images (scalable but requires security precautions)
             * - `image/webp` - WebP images (modern, efficient format)
             */
            icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">>, "many">>;
        }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<z.objectUtil.extendShape<{
            /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
            name: z.ZodString;
            /**
             * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
             * even by those unfamiliar with domain-specific terminology.
             *
             * If not provided, the name should be used for display (except for Tool,
             * where `annotations.title` should be given precedence over using `name`,
             * if present).
             */
            title: z.ZodOptional<z.ZodString>;
        }, {
            version: z.ZodString;
            /**
             * An optional URL of the website for this implementation.
             */
            websiteUrl: z.ZodOptional<z.ZodString>;
        }>, {
            /**
             * Optional set of sized icons that the client can display in a user interface.
             *
             * Clients that support rendering icons MUST support at least the following MIME types:
             * - `image/png` - PNG images (safe, universal compatibility)
             * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
             *
             * Clients that support rendering icons SHOULD also support:
             * - `image/svg+xml` - SVG images (scalable but requires security precautions)
             * - `image/webp` - WebP images (modern, efficient format)
             */
            icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">>, "many">>;
        }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<z.objectUtil.extendShape<{
            /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
            name: z.ZodString;
            /**
             * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
             * even by those unfamiliar with domain-specific terminology.
             *
             * If not provided, the name should be used for display (except for Tool,
             * where `annotations.title` should be given precedence over using `name`,
             * if present).
             */
            title: z.ZodOptional<z.ZodString>;
        }, {
            version: z.ZodString;
            /**
             * An optional URL of the website for this implementation.
             */
            websiteUrl: z.ZodOptional<z.ZodString>;
        }>, {
            /**
             * Optional set of sized icons that the client can display in a user interface.
             *
             * Clients that support rendering icons MUST support at least the following MIME types:
             * - `image/png` - PNG images (safe, universal compatibility)
             * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
             *
             * Clients that support rendering icons SHOULD also support:
             * - `image/svg+xml` - SVG images (scalable but requires security precautions)
             * - `image/webp` - WebP images (modern, efficient format)
             */
            icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">>, "many">>;
        }>, z.ZodTypeAny, "passthrough">>;
    }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The latest version of the Model Context Protocol that the client supports. The client MAY decide to support older versions as well.
         */
        protocolVersion: z.ZodString;
        capabilities: z.ZodObject<{
            /**
             * Experimental, non-standard capabilities that the client supports.
             */
            experimental: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            /**
             * Present if the client supports sampling from an LLM.
             */
            sampling: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            /**
             * Present if the client supports eliciting user input.
             */
            elicitation: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            /**
             * Present if the client supports listing roots.
             */
            roots: z.ZodOptional<z.ZodObject<{
                /**
                 * Whether the client supports issuing notifications for changes to the roots list.
                 */
                listChanged: z.ZodOptional<z.ZodBoolean>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                /**
                 * Whether the client supports issuing notifications for changes to the roots list.
                 */
                listChanged: z.ZodOptional<z.ZodBoolean>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                /**
                 * Whether the client supports issuing notifications for changes to the roots list.
                 */
                listChanged: z.ZodOptional<z.ZodBoolean>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * Experimental, non-standard capabilities that the client supports.
             */
            experimental: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            /**
             * Present if the client supports sampling from an LLM.
             */
            sampling: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            /**
             * Present if the client supports eliciting user input.
             */
            elicitation: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            /**
             * Present if the client supports listing roots.
             */
            roots: z.ZodOptional<z.ZodObject<{
                /**
                 * Whether the client supports issuing notifications for changes to the roots list.
                 */
                listChanged: z.ZodOptional<z.ZodBoolean>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                /**
                 * Whether the client supports issuing notifications for changes to the roots list.
                 */
                listChanged: z.ZodOptional<z.ZodBoolean>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                /**
                 * Whether the client supports issuing notifications for changes to the roots list.
                 */
                listChanged: z.ZodOptional<z.ZodBoolean>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * Experimental, non-standard capabilities that the client supports.
             */
            experimental: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            /**
             * Present if the client supports sampling from an LLM.
             */
            sampling: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            /**
             * Present if the client supports eliciting user input.
             */
            elicitation: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            /**
             * Present if the client supports listing roots.
             */
            roots: z.ZodOptional<z.ZodObject<{
                /**
                 * Whether the client supports issuing notifications for changes to the roots list.
                 */
                listChanged: z.ZodOptional<z.ZodBoolean>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                /**
                 * Whether the client supports issuing notifications for changes to the roots list.
                 */
                listChanged: z.ZodOptional<z.ZodBoolean>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                /**
                 * Whether the client supports issuing notifications for changes to the roots list.
                 */
                listChanged: z.ZodOptional<z.ZodBoolean>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">>;
        clientInfo: z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
            /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
            name: z.ZodString;
            /**
             * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
             * even by those unfamiliar with domain-specific terminology.
             *
             * If not provided, the name should be used for display (except for Tool,
             * where `annotations.title` should be given precedence over using `name`,
             * if present).
             */
            title: z.ZodOptional<z.ZodString>;
        }, {
            version: z.ZodString;
            /**
             * An optional URL of the website for this implementation.
             */
            websiteUrl: z.ZodOptional<z.ZodString>;
        }>, {
            /**
             * Optional set of sized icons that the client can display in a user interface.
             *
             * Clients that support rendering icons MUST support at least the following MIME types:
             * - `image/png` - PNG images (safe, universal compatibility)
             * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
             *
             * Clients that support rendering icons SHOULD also support:
             * - `image/svg+xml` - SVG images (scalable but requires security precautions)
             * - `image/webp` - WebP images (modern, efficient format)
             */
            icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">>, "many">>;
        }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<z.objectUtil.extendShape<{
            /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
            name: z.ZodString;
            /**
             * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
             * even by those unfamiliar with domain-specific terminology.
             *
             * If not provided, the name should be used for display (except for Tool,
             * where `annotations.title` should be given precedence over using `name`,
             * if present).
             */
            title: z.ZodOptional<z.ZodString>;
        }, {
            version: z.ZodString;
            /**
             * An optional URL of the website for this implementation.
             */
            websiteUrl: z.ZodOptional<z.ZodString>;
        }>, {
            /**
             * Optional set of sized icons that the client can display in a user interface.
             *
             * Clients that support rendering icons MUST support at least the following MIME types:
             * - `image/png` - PNG images (safe, universal compatibility)
             * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
             *
             * Clients that support rendering icons SHOULD also support:
             * - `image/svg+xml` - SVG images (scalable but requires security precautions)
             * - `image/webp` - WebP images (modern, efficient format)
             */
            icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">>, "many">>;
        }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<z.objectUtil.extendShape<{
            /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
            name: z.ZodString;
            /**
             * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
             * even by those unfamiliar with domain-specific terminology.
             *
             * If not provided, the name should be used for display (except for Tool,
             * where `annotations.title` should be given precedence over using `name`,
             * if present).
             */
            title: z.ZodOptional<z.ZodString>;
        }, {
            version: z.ZodString;
            /**
             * An optional URL of the website for this implementation.
             */
            websiteUrl: z.ZodOptional<z.ZodString>;
        }>, {
            /**
             * Optional set of sized icons that the client can display in a user interface.
             *
             * Clients that support rendering icons MUST support at least the following MIME types:
             * - `image/png` - PNG images (safe, universal compatibility)
             * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
             *
             * Clients that support rendering icons SHOULD also support:
             * - `image/svg+xml` - SVG images (scalable but requires security precautions)
             * - `image/webp` - WebP images (modern, efficient format)
             */
            icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">>, "many">>;
        }>, z.ZodTypeAny, "passthrough">>;
    }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The latest version of the Model Context Protocol that the client supports. The client MAY decide to support older versions as well.
         */
        protocolVersion: z.ZodString;
        capabilities: z.ZodObject<{
            /**
             * Experimental, non-standard capabilities that the client supports.
             */
            experimental: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            /**
             * Present if the client supports sampling from an LLM.
             */
            sampling: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            /**
             * Present if the client supports eliciting user input.
             */
            elicitation: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            /**
             * Present if the client supports listing roots.
             */
            roots: z.ZodOptional<z.ZodObject<{
                /**
                 * Whether the client supports issuing notifications for changes to the roots list.
                 */
                listChanged: z.ZodOptional<z.ZodBoolean>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                /**
                 * Whether the client supports issuing notifications for changes to the roots list.
                 */
                listChanged: z.ZodOptional<z.ZodBoolean>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                /**
                 * Whether the client supports issuing notifications for changes to the roots list.
                 */
                listChanged: z.ZodOptional<z.ZodBoolean>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * Experimental, non-standard capabilities that the client supports.
             */
            experimental: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            /**
             * Present if the client supports sampling from an LLM.
             */
            sampling: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            /**
             * Present if the client supports eliciting user input.
             */
            elicitation: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            /**
             * Present if the client supports listing roots.
             */
            roots: z.ZodOptional<z.ZodObject<{
                /**
                 * Whether the client supports issuing notifications for changes to the roots list.
                 */
                listChanged: z.ZodOptional<z.ZodBoolean>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                /**
                 * Whether the client supports issuing notifications for changes to the roots list.
                 */
                listChanged: z.ZodOptional<z.ZodBoolean>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                /**
                 * Whether the client supports issuing notifications for changes to the roots list.
                 */
                listChanged: z.ZodOptional<z.ZodBoolean>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * Experimental, non-standard capabilities that the client supports.
             */
            experimental: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            /**
             * Present if the client supports sampling from an LLM.
             */
            sampling: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            /**
             * Present if the client supports eliciting user input.
             */
            elicitation: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            /**
             * Present if the client supports listing roots.
             */
            roots: z.ZodOptional<z.ZodObject<{
                /**
                 * Whether the client supports issuing notifications for changes to the roots list.
                 */
                listChanged: z.ZodOptional<z.ZodBoolean>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                /**
                 * Whether the client supports issuing notifications for changes to the roots list.
                 */
                listChanged: z.ZodOptional<z.ZodBoolean>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                /**
                 * Whether the client supports issuing notifications for changes to the roots list.
                 */
                listChanged: z.ZodOptional<z.ZodBoolean>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">>;
        clientInfo: z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
            /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
            name: z.ZodString;
            /**
             * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
             * even by those unfamiliar with domain-specific terminology.
             *
             * If not provided, the name should be used for display (except for Tool,
             * where `annotations.title` should be given precedence over using `name`,
             * if present).
             */
            title: z.ZodOptional<z.ZodString>;
        }, {
            version: z.ZodString;
            /**
             * An optional URL of the website for this implementation.
             */
            websiteUrl: z.ZodOptional<z.ZodString>;
        }>, {
            /**
             * Optional set of sized icons that the client can display in a user interface.
             *
             * Clients that support rendering icons MUST support at least the following MIME types:
             * - `image/png` - PNG images (safe, universal compatibility)
             * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
             *
             * Clients that support rendering icons SHOULD also support:
             * - `image/svg+xml` - SVG images (scalable but requires security precautions)
             * - `image/webp` - WebP images (modern, efficient format)
             */
            icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">>, "many">>;
        }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<z.objectUtil.extendShape<{
            /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
            name: z.ZodString;
            /**
             * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
             * even by those unfamiliar with domain-specific terminology.
             *
             * If not provided, the name should be used for display (except for Tool,
             * where `annotations.title` should be given precedence over using `name`,
             * if present).
             */
            title: z.ZodOptional<z.ZodString>;
        }, {
            version: z.ZodString;
            /**
             * An optional URL of the website for this implementation.
             */
            websiteUrl: z.ZodOptional<z.ZodString>;
        }>, {
            /**
             * Optional set of sized icons that the client can display in a user interface.
             *
             * Clients that support rendering icons MUST support at least the following MIME types:
             * - `image/png` - PNG images (safe, universal compatibility)
             * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
             *
             * Clients that support rendering icons SHOULD also support:
             * - `image/svg+xml` - SVG images (scalable but requires security precautions)
             * - `image/webp` - WebP images (modern, efficient format)
             */
            icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">>, "many">>;
        }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<z.objectUtil.extendShape<{
            /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
            name: z.ZodString;
            /**
             * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
             * even by those unfamiliar with domain-specific terminology.
             *
             * If not provided, the name should be used for display (except for Tool,
             * where `annotations.title` should be given precedence over using `name`,
             * if present).
             */
            title: z.ZodOptional<z.ZodString>;
        }, {
            version: z.ZodString;
            /**
             * An optional URL of the website for this implementation.
             */
            websiteUrl: z.ZodOptional<z.ZodString>;
        }>, {
            /**
             * Optional set of sized icons that the client can display in a user interface.
             *
             * Clients that support rendering icons MUST support at least the following MIME types:
             * - `image/png` - PNG images (safe, universal compatibility)
             * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
             *
             * Clients that support rendering icons SHOULD also support:
             * - `image/svg+xml` - SVG images (scalable but requires security precautions)
             * - `image/webp` - WebP images (modern, efficient format)
             */
            icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">>, "many">>;
        }>, z.ZodTypeAny, "passthrough">>;
    }>, z.ZodTypeAny, "passthrough">>;
}>, "strip", z.ZodTypeAny, {
    params: {
        protocolVersion: string;
        capabilities: {
            experimental?: z.objectOutputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
            sampling?: z.objectOutputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
            elicitation?: z.objectOutputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
            roots?: z.objectOutputType<{
                /**
                 * Whether the client supports issuing notifications for changes to the roots list.
                 */
                listChanged: z.ZodOptional<z.ZodBoolean>;
            }, z.ZodTypeAny, "passthrough"> | undefined;
        } & {
            [k: string]: unknown;
        };
        clientInfo: {
            name: string;
            version: string;
            icons?: z.objectOutputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">[] | undefined;
            title?: string | undefined;
            websiteUrl?: string | undefined;
        } & {
            [k: string]: unknown;
        };
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    } & {
        [k: string]: unknown;
    };
    method: "initialize";
}, {
    params: {
        protocolVersion: string;
        capabilities: {
            experimental?: z.objectInputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
            sampling?: z.objectInputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
            elicitation?: z.objectInputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
            roots?: z.objectInputType<{
                /**
                 * Whether the client supports issuing notifications for changes to the roots list.
                 */
                listChanged: z.ZodOptional<z.ZodBoolean>;
            }, z.ZodTypeAny, "passthrough"> | undefined;
        } & {
            [k: string]: unknown;
        };
        clientInfo: {
            name: string;
            version: string;
            icons?: z.objectInputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">[] | undefined;
            title?: string | undefined;
            websiteUrl?: string | undefined;
        } & {
            [k: string]: unknown;
        };
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    } & {
        [k: string]: unknown;
    };
    method: "initialize";
}>;
export declare const isInitializeRequest: (value: unknown) => value is InitializeRequest;
/**
 * Capabilities that a server may support. Known capabilities are defined here, in this schema, but this is not a closed set: any server can define its own, additional capabilities.
 */
export declare const ServerCapabilitiesSchema: z.ZodObject<{
    /**
     * Experimental, non-standard capabilities that the server supports.
     */
    experimental: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    /**
     * Present if the server supports sending log messages to the client.
     */
    logging: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    /**
     * Present if the server supports sending completions to the client.
     */
    completions: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    /**
     * Present if the server offers any prompt templates.
     */
    prompts: z.ZodOptional<z.ZodObject<{
        /**
         * Whether this server supports issuing notifications for changes to the prompt list.
         */
        listChanged: z.ZodOptional<z.ZodBoolean>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * Whether this server supports issuing notifications for changes to the prompt list.
         */
        listChanged: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * Whether this server supports issuing notifications for changes to the prompt list.
         */
        listChanged: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">>>;
    /**
     * Present if the server offers any resources to read.
     */
    resources: z.ZodOptional<z.ZodObject<{
        /**
         * Whether this server supports clients subscribing to resource updates.
         */
        subscribe: z.ZodOptional<z.ZodBoolean>;
        /**
         * Whether this server supports issuing notifications for changes to the resource list.
         */
        listChanged: z.ZodOptional<z.ZodBoolean>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * Whether this server supports clients subscribing to resource updates.
         */
        subscribe: z.ZodOptional<z.ZodBoolean>;
        /**
         * Whether this server supports issuing notifications for changes to the resource list.
         */
        listChanged: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * Whether this server supports clients subscribing to resource updates.
         */
        subscribe: z.ZodOptional<z.ZodBoolean>;
        /**
         * Whether this server supports issuing notifications for changes to the resource list.
         */
        listChanged: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">>>;
    /**
     * Present if the server offers any tools to call.
     */
    tools: z.ZodOptional<z.ZodObject<{
        /**
         * Whether this server supports issuing notifications for changes to the tool list.
         */
        listChanged: z.ZodOptional<z.ZodBoolean>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * Whether this server supports issuing notifications for changes to the tool list.
         */
        listChanged: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * Whether this server supports issuing notifications for changes to the tool list.
         */
        listChanged: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">>>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    /**
     * Experimental, non-standard capabilities that the server supports.
     */
    experimental: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    /**
     * Present if the server supports sending log messages to the client.
     */
    logging: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    /**
     * Present if the server supports sending completions to the client.
     */
    completions: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    /**
     * Present if the server offers any prompt templates.
     */
    prompts: z.ZodOptional<z.ZodObject<{
        /**
         * Whether this server supports issuing notifications for changes to the prompt list.
         */
        listChanged: z.ZodOptional<z.ZodBoolean>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * Whether this server supports issuing notifications for changes to the prompt list.
         */
        listChanged: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * Whether this server supports issuing notifications for changes to the prompt list.
         */
        listChanged: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">>>;
    /**
     * Present if the server offers any resources to read.
     */
    resources: z.ZodOptional<z.ZodObject<{
        /**
         * Whether this server supports clients subscribing to resource updates.
         */
        subscribe: z.ZodOptional<z.ZodBoolean>;
        /**
         * Whether this server supports issuing notifications for changes to the resource list.
         */
        listChanged: z.ZodOptional<z.ZodBoolean>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * Whether this server supports clients subscribing to resource updates.
         */
        subscribe: z.ZodOptional<z.ZodBoolean>;
        /**
         * Whether this server supports issuing notifications for changes to the resource list.
         */
        listChanged: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * Whether this server supports clients subscribing to resource updates.
         */
        subscribe: z.ZodOptional<z.ZodBoolean>;
        /**
         * Whether this server supports issuing notifications for changes to the resource list.
         */
        listChanged: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">>>;
    /**
     * Present if the server offers any tools to call.
     */
    tools: z.ZodOptional<z.ZodObject<{
        /**
         * Whether this server supports issuing notifications for changes to the tool list.
         */
        listChanged: z.ZodOptional<z.ZodBoolean>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * Whether this server supports issuing notifications for changes to the tool list.
         */
        listChanged: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * Whether this server supports issuing notifications for changes to the tool list.
         */
        listChanged: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">>>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    /**
     * Experimental, non-standard capabilities that the server supports.
     */
    experimental: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    /**
     * Present if the server supports sending log messages to the client.
     */
    logging: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    /**
     * Present if the server supports sending completions to the client.
     */
    completions: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    /**
     * Present if the server offers any prompt templates.
     */
    prompts: z.ZodOptional<z.ZodObject<{
        /**
         * Whether this server supports issuing notifications for changes to the prompt list.
         */
        listChanged: z.ZodOptional<z.ZodBoolean>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * Whether this server supports issuing notifications for changes to the prompt list.
         */
        listChanged: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * Whether this server supports issuing notifications for changes to the prompt list.
         */
        listChanged: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">>>;
    /**
     * Present if the server offers any resources to read.
     */
    resources: z.ZodOptional<z.ZodObject<{
        /**
         * Whether this server supports clients subscribing to resource updates.
         */
        subscribe: z.ZodOptional<z.ZodBoolean>;
        /**
         * Whether this server supports issuing notifications for changes to the resource list.
         */
        listChanged: z.ZodOptional<z.ZodBoolean>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * Whether this server supports clients subscribing to resource updates.
         */
        subscribe: z.ZodOptional<z.ZodBoolean>;
        /**
         * Whether this server supports issuing notifications for changes to the resource list.
         */
        listChanged: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * Whether this server supports clients subscribing to resource updates.
         */
        subscribe: z.ZodOptional<z.ZodBoolean>;
        /**
         * Whether this server supports issuing notifications for changes to the resource list.
         */
        listChanged: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">>>;
    /**
     * Present if the server offers any tools to call.
     */
    tools: z.ZodOptional<z.ZodObject<{
        /**
         * Whether this server supports issuing notifications for changes to the tool list.
         */
        listChanged: z.ZodOptional<z.ZodBoolean>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * Whether this server supports issuing notifications for changes to the tool list.
         */
        listChanged: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * Whether this server supports issuing notifications for changes to the tool list.
         */
        listChanged: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">>>;
}, z.ZodTypeAny, "passthrough">>;
/**
 * After receiving an initialize request from the client, the server sends this response.
 */
export declare const InitializeResultSchema: z.ZodObject<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, {
    /**
     * The version of the Model Context Protocol that the server wants to use. This may not match the version that the client requested. If the client cannot support this version, it MUST disconnect.
     */
    protocolVersion: z.ZodString;
    capabilities: z.ZodObject<{
        /**
         * Experimental, non-standard capabilities that the server supports.
         */
        experimental: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        /**
         * Present if the server supports sending log messages to the client.
         */
        logging: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        /**
         * Present if the server supports sending completions to the client.
         */
        completions: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        /**
         * Present if the server offers any prompt templates.
         */
        prompts: z.ZodOptional<z.ZodObject<{
            /**
             * Whether this server supports issuing notifications for changes to the prompt list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * Whether this server supports issuing notifications for changes to the prompt list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * Whether this server supports issuing notifications for changes to the prompt list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">>>;
        /**
         * Present if the server offers any resources to read.
         */
        resources: z.ZodOptional<z.ZodObject<{
            /**
             * Whether this server supports clients subscribing to resource updates.
             */
            subscribe: z.ZodOptional<z.ZodBoolean>;
            /**
             * Whether this server supports issuing notifications for changes to the resource list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * Whether this server supports clients subscribing to resource updates.
             */
            subscribe: z.ZodOptional<z.ZodBoolean>;
            /**
             * Whether this server supports issuing notifications for changes to the resource list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * Whether this server supports clients subscribing to resource updates.
             */
            subscribe: z.ZodOptional<z.ZodBoolean>;
            /**
             * Whether this server supports issuing notifications for changes to the resource list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">>>;
        /**
         * Present if the server offers any tools to call.
         */
        tools: z.ZodOptional<z.ZodObject<{
            /**
             * Whether this server supports issuing notifications for changes to the tool list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * Whether this server supports issuing notifications for changes to the tool list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * Whether this server supports issuing notifications for changes to the tool list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * Experimental, non-standard capabilities that the server supports.
         */
        experimental: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        /**
         * Present if the server supports sending log messages to the client.
         */
        logging: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        /**
         * Present if the server supports sending completions to the client.
         */
        completions: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        /**
         * Present if the server offers any prompt templates.
         */
        prompts: z.ZodOptional<z.ZodObject<{
            /**
             * Whether this server supports issuing notifications for changes to the prompt list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * Whether this server supports issuing notifications for changes to the prompt list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * Whether this server supports issuing notifications for changes to the prompt list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">>>;
        /**
         * Present if the server offers any resources to read.
         */
        resources: z.ZodOptional<z.ZodObject<{
            /**
             * Whether this server supports clients subscribing to resource updates.
             */
            subscribe: z.ZodOptional<z.ZodBoolean>;
            /**
             * Whether this server supports issuing notifications for changes to the resource list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * Whether this server supports clients subscribing to resource updates.
             */
            subscribe: z.ZodOptional<z.ZodBoolean>;
            /**
             * Whether this server supports issuing notifications for changes to the resource list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * Whether this server supports clients subscribing to resource updates.
             */
            subscribe: z.ZodOptional<z.ZodBoolean>;
            /**
             * Whether this server supports issuing notifications for changes to the resource list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">>>;
        /**
         * Present if the server offers any tools to call.
         */
        tools: z.ZodOptional<z.ZodObject<{
            /**
             * Whether this server supports issuing notifications for changes to the tool list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * Whether this server supports issuing notifications for changes to the tool list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * Whether this server supports issuing notifications for changes to the tool list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * Experimental, non-standard capabilities that the server supports.
         */
        experimental: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        /**
         * Present if the server supports sending log messages to the client.
         */
        logging: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        /**
         * Present if the server supports sending completions to the client.
         */
        completions: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        /**
         * Present if the server offers any prompt templates.
         */
        prompts: z.ZodOptional<z.ZodObject<{
            /**
             * Whether this server supports issuing notifications for changes to the prompt list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * Whether this server supports issuing notifications for changes to the prompt list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * Whether this server supports issuing notifications for changes to the prompt list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">>>;
        /**
         * Present if the server offers any resources to read.
         */
        resources: z.ZodOptional<z.ZodObject<{
            /**
             * Whether this server supports clients subscribing to resource updates.
             */
            subscribe: z.ZodOptional<z.ZodBoolean>;
            /**
             * Whether this server supports issuing notifications for changes to the resource list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * Whether this server supports clients subscribing to resource updates.
             */
            subscribe: z.ZodOptional<z.ZodBoolean>;
            /**
             * Whether this server supports issuing notifications for changes to the resource list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * Whether this server supports clients subscribing to resource updates.
             */
            subscribe: z.ZodOptional<z.ZodBoolean>;
            /**
             * Whether this server supports issuing notifications for changes to the resource list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">>>;
        /**
         * Present if the server offers any tools to call.
         */
        tools: z.ZodOptional<z.ZodObject<{
            /**
             * Whether this server supports issuing notifications for changes to the tool list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * Whether this server supports issuing notifications for changes to the tool list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * Whether this server supports issuing notifications for changes to the tool list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>;
    serverInfo: z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        version: z.ZodString;
        /**
         * An optional URL of the website for this implementation.
         */
        websiteUrl: z.ZodOptional<z.ZodString>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">>, "many">>;
    }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        version: z.ZodString;
        /**
         * An optional URL of the website for this implementation.
         */
        websiteUrl: z.ZodOptional<z.ZodString>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">>, "many">>;
    }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        version: z.ZodString;
        /**
         * An optional URL of the website for this implementation.
         */
        websiteUrl: z.ZodOptional<z.ZodString>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">>, "many">>;
    }>, z.ZodTypeAny, "passthrough">>;
    /**
     * Instructions describing how to use the server and its features.
     *
     * This can be used by clients to improve the LLM's understanding of available tools, resources, etc. It can be thought of like a "hint" to the model. For example, this information MAY be added to the system prompt.
     */
    instructions: z.ZodOptional<z.ZodString>;
}>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, {
    /**
     * The version of the Model Context Protocol that the server wants to use. This may not match the version that the client requested. If the client cannot support this version, it MUST disconnect.
     */
    protocolVersion: z.ZodString;
    capabilities: z.ZodObject<{
        /**
         * Experimental, non-standard capabilities that the server supports.
         */
        experimental: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        /**
         * Present if the server supports sending log messages to the client.
         */
        logging: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        /**
         * Present if the server supports sending completions to the client.
         */
        completions: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        /**
         * Present if the server offers any prompt templates.
         */
        prompts: z.ZodOptional<z.ZodObject<{
            /**
             * Whether this server supports issuing notifications for changes to the prompt list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * Whether this server supports issuing notifications for changes to the prompt list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * Whether this server supports issuing notifications for changes to the prompt list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">>>;
        /**
         * Present if the server offers any resources to read.
         */
        resources: z.ZodOptional<z.ZodObject<{
            /**
             * Whether this server supports clients subscribing to resource updates.
             */
            subscribe: z.ZodOptional<z.ZodBoolean>;
            /**
             * Whether this server supports issuing notifications for changes to the resource list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * Whether this server supports clients subscribing to resource updates.
             */
            subscribe: z.ZodOptional<z.ZodBoolean>;
            /**
             * Whether this server supports issuing notifications for changes to the resource list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * Whether this server supports clients subscribing to resource updates.
             */
            subscribe: z.ZodOptional<z.ZodBoolean>;
            /**
             * Whether this server supports issuing notifications for changes to the resource list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">>>;
        /**
         * Present if the server offers any tools to call.
         */
        tools: z.ZodOptional<z.ZodObject<{
            /**
             * Whether this server supports issuing notifications for changes to the tool list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * Whether this server supports issuing notifications for changes to the tool list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * Whether this server supports issuing notifications for changes to the tool list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * Experimental, non-standard capabilities that the server supports.
         */
        experimental: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        /**
         * Present if the server supports sending log messages to the client.
         */
        logging: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        /**
         * Present if the server supports sending completions to the client.
         */
        completions: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        /**
         * Present if the server offers any prompt templates.
         */
        prompts: z.ZodOptional<z.ZodObject<{
            /**
             * Whether this server supports issuing notifications for changes to the prompt list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * Whether this server supports issuing notifications for changes to the prompt list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * Whether this server supports issuing notifications for changes to the prompt list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">>>;
        /**
         * Present if the server offers any resources to read.
         */
        resources: z.ZodOptional<z.ZodObject<{
            /**
             * Whether this server supports clients subscribing to resource updates.
             */
            subscribe: z.ZodOptional<z.ZodBoolean>;
            /**
             * Whether this server supports issuing notifications for changes to the resource list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * Whether this server supports clients subscribing to resource updates.
             */
            subscribe: z.ZodOptional<z.ZodBoolean>;
            /**
             * Whether this server supports issuing notifications for changes to the resource list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * Whether this server supports clients subscribing to resource updates.
             */
            subscribe: z.ZodOptional<z.ZodBoolean>;
            /**
             * Whether this server supports issuing notifications for changes to the resource list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">>>;
        /**
         * Present if the server offers any tools to call.
         */
        tools: z.ZodOptional<z.ZodObject<{
            /**
             * Whether this server supports issuing notifications for changes to the tool list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * Whether this server supports issuing notifications for changes to the tool list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * Whether this server supports issuing notifications for changes to the tool list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * Experimental, non-standard capabilities that the server supports.
         */
        experimental: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        /**
         * Present if the server supports sending log messages to the client.
         */
        logging: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        /**
         * Present if the server supports sending completions to the client.
         */
        completions: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        /**
         * Present if the server offers any prompt templates.
         */
        prompts: z.ZodOptional<z.ZodObject<{
            /**
             * Whether this server supports issuing notifications for changes to the prompt list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * Whether this server supports issuing notifications for changes to the prompt list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * Whether this server supports issuing notifications for changes to the prompt list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">>>;
        /**
         * Present if the server offers any resources to read.
         */
        resources: z.ZodOptional<z.ZodObject<{
            /**
             * Whether this server supports clients subscribing to resource updates.
             */
            subscribe: z.ZodOptional<z.ZodBoolean>;
            /**
             * Whether this server supports issuing notifications for changes to the resource list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * Whether this server supports clients subscribing to resource updates.
             */
            subscribe: z.ZodOptional<z.ZodBoolean>;
            /**
             * Whether this server supports issuing notifications for changes to the resource list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * Whether this server supports clients subscribing to resource updates.
             */
            subscribe: z.ZodOptional<z.ZodBoolean>;
            /**
             * Whether this server supports issuing notifications for changes to the resource list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">>>;
        /**
         * Present if the server offers any tools to call.
         */
        tools: z.ZodOptional<z.ZodObject<{
            /**
             * Whether this server supports issuing notifications for changes to the tool list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * Whether this server supports issuing notifications for changes to the tool list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * Whether this server supports issuing notifications for changes to the tool list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>;
    serverInfo: z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        version: z.ZodString;
        /**
         * An optional URL of the website for this implementation.
         */
        websiteUrl: z.ZodOptional<z.ZodString>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">>, "many">>;
    }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        version: z.ZodString;
        /**
         * An optional URL of the website for this implementation.
         */
        websiteUrl: z.ZodOptional<z.ZodString>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">>, "many">>;
    }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        version: z.ZodString;
        /**
         * An optional URL of the website for this implementation.
         */
        websiteUrl: z.ZodOptional<z.ZodString>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">>, "many">>;
    }>, z.ZodTypeAny, "passthrough">>;
    /**
     * Instructions describing how to use the server and its features.
     *
     * This can be used by clients to improve the LLM's understanding of available tools, resources, etc. It can be thought of like a "hint" to the model. For example, this information MAY be added to the system prompt.
     */
    instructions: z.ZodOptional<z.ZodString>;
}>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, {
    /**
     * The version of the Model Context Protocol that the server wants to use. This may not match the version that the client requested. If the client cannot support this version, it MUST disconnect.
     */
    protocolVersion: z.ZodString;
    capabilities: z.ZodObject<{
        /**
         * Experimental, non-standard capabilities that the server supports.
         */
        experimental: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        /**
         * Present if the server supports sending log messages to the client.
         */
        logging: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        /**
         * Present if the server supports sending completions to the client.
         */
        completions: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        /**
         * Present if the server offers any prompt templates.
         */
        prompts: z.ZodOptional<z.ZodObject<{
            /**
             * Whether this server supports issuing notifications for changes to the prompt list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * Whether this server supports issuing notifications for changes to the prompt list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * Whether this server supports issuing notifications for changes to the prompt list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">>>;
        /**
         * Present if the server offers any resources to read.
         */
        resources: z.ZodOptional<z.ZodObject<{
            /**
             * Whether this server supports clients subscribing to resource updates.
             */
            subscribe: z.ZodOptional<z.ZodBoolean>;
            /**
             * Whether this server supports issuing notifications for changes to the resource list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * Whether this server supports clients subscribing to resource updates.
             */
            subscribe: z.ZodOptional<z.ZodBoolean>;
            /**
             * Whether this server supports issuing notifications for changes to the resource list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * Whether this server supports clients subscribing to resource updates.
             */
            subscribe: z.ZodOptional<z.ZodBoolean>;
            /**
             * Whether this server supports issuing notifications for changes to the resource list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">>>;
        /**
         * Present if the server offers any tools to call.
         */
        tools: z.ZodOptional<z.ZodObject<{
            /**
             * Whether this server supports issuing notifications for changes to the tool list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * Whether this server supports issuing notifications for changes to the tool list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * Whether this server supports issuing notifications for changes to the tool list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * Experimental, non-standard capabilities that the server supports.
         */
        experimental: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        /**
         * Present if the server supports sending log messages to the client.
         */
        logging: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        /**
         * Present if the server supports sending completions to the client.
         */
        completions: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        /**
         * Present if the server offers any prompt templates.
         */
        prompts: z.ZodOptional<z.ZodObject<{
            /**
             * Whether this server supports issuing notifications for changes to the prompt list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * Whether this server supports issuing notifications for changes to the prompt list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * Whether this server supports issuing notifications for changes to the prompt list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">>>;
        /**
         * Present if the server offers any resources to read.
         */
        resources: z.ZodOptional<z.ZodObject<{
            /**
             * Whether this server supports clients subscribing to resource updates.
             */
            subscribe: z.ZodOptional<z.ZodBoolean>;
            /**
             * Whether this server supports issuing notifications for changes to the resource list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * Whether this server supports clients subscribing to resource updates.
             */
            subscribe: z.ZodOptional<z.ZodBoolean>;
            /**
             * Whether this server supports issuing notifications for changes to the resource list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * Whether this server supports clients subscribing to resource updates.
             */
            subscribe: z.ZodOptional<z.ZodBoolean>;
            /**
             * Whether this server supports issuing notifications for changes to the resource list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">>>;
        /**
         * Present if the server offers any tools to call.
         */
        tools: z.ZodOptional<z.ZodObject<{
            /**
             * Whether this server supports issuing notifications for changes to the tool list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * Whether this server supports issuing notifications for changes to the tool list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * Whether this server supports issuing notifications for changes to the tool list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * Experimental, non-standard capabilities that the server supports.
         */
        experimental: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        /**
         * Present if the server supports sending log messages to the client.
         */
        logging: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        /**
         * Present if the server supports sending completions to the client.
         */
        completions: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        /**
         * Present if the server offers any prompt templates.
         */
        prompts: z.ZodOptional<z.ZodObject<{
            /**
             * Whether this server supports issuing notifications for changes to the prompt list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * Whether this server supports issuing notifications for changes to the prompt list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * Whether this server supports issuing notifications for changes to the prompt list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">>>;
        /**
         * Present if the server offers any resources to read.
         */
        resources: z.ZodOptional<z.ZodObject<{
            /**
             * Whether this server supports clients subscribing to resource updates.
             */
            subscribe: z.ZodOptional<z.ZodBoolean>;
            /**
             * Whether this server supports issuing notifications for changes to the resource list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * Whether this server supports clients subscribing to resource updates.
             */
            subscribe: z.ZodOptional<z.ZodBoolean>;
            /**
             * Whether this server supports issuing notifications for changes to the resource list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * Whether this server supports clients subscribing to resource updates.
             */
            subscribe: z.ZodOptional<z.ZodBoolean>;
            /**
             * Whether this server supports issuing notifications for changes to the resource list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">>>;
        /**
         * Present if the server offers any tools to call.
         */
        tools: z.ZodOptional<z.ZodObject<{
            /**
             * Whether this server supports issuing notifications for changes to the tool list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * Whether this server supports issuing notifications for changes to the tool list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * Whether this server supports issuing notifications for changes to the tool list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>;
    serverInfo: z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        version: z.ZodString;
        /**
         * An optional URL of the website for this implementation.
         */
        websiteUrl: z.ZodOptional<z.ZodString>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">>, "many">>;
    }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        version: z.ZodString;
        /**
         * An optional URL of the website for this implementation.
         */
        websiteUrl: z.ZodOptional<z.ZodString>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">>, "many">>;
    }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        version: z.ZodString;
        /**
         * An optional URL of the website for this implementation.
         */
        websiteUrl: z.ZodOptional<z.ZodString>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">>, "many">>;
    }>, z.ZodTypeAny, "passthrough">>;
    /**
     * Instructions describing how to use the server and its features.
     *
     * This can be used by clients to improve the LLM's understanding of available tools, resources, etc. It can be thought of like a "hint" to the model. For example, this information MAY be added to the system prompt.
     */
    instructions: z.ZodOptional<z.ZodString>;
}>, z.ZodTypeAny, "passthrough">>;
/**
 * This notification is sent from the client to the server after initialization has finished.
 */
export declare const InitializedNotificationSchema: z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"notifications/initialized">;
}>, "strip", z.ZodTypeAny, {
    method: "notifications/initialized";
    params?: z.objectOutputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}, {
    method: "notifications/initialized";
    params?: z.objectInputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}>;
export declare const isInitializedNotification: (value: unknown) => value is InitializedNotification;
/**
 * A ping, issued by either the server or the client, to check that the other party is still alive. The receiver must promptly respond, or else may be disconnected.
 */
export declare const PingRequestSchema: z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"ping">;
}>, "strip", z.ZodTypeAny, {
    method: "ping";
    params?: z.objectOutputType<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}, {
    method: "ping";
    params?: z.objectInputType<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}>;
export declare const ProgressSchema: z.ZodObject<{
    /**
     * The progress thus far. This should increase every time progress is made, even if the total is unknown.
     */
    progress: z.ZodNumber;
    /**
     * Total number of items to process (or total progress required), if known.
     */
    total: z.ZodOptional<z.ZodNumber>;
    /**
     * An optional message describing the current progress.
     */
    message: z.ZodOptional<z.ZodString>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    /**
     * The progress thus far. This should increase every time progress is made, even if the total is unknown.
     */
    progress: z.ZodNumber;
    /**
     * Total number of items to process (or total progress required), if known.
     */
    total: z.ZodOptional<z.ZodNumber>;
    /**
     * An optional message describing the current progress.
     */
    message: z.ZodOptional<z.ZodString>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    /**
     * The progress thus far. This should increase every time progress is made, even if the total is unknown.
     */
    progress: z.ZodNumber;
    /**
     * Total number of items to process (or total progress required), if known.
     */
    total: z.ZodOptional<z.ZodNumber>;
    /**
     * An optional message describing the current progress.
     */
    message: z.ZodOptional<z.ZodString>;
}, z.ZodTypeAny, "passthrough">>;
/**
 * An out-of-band notification used to inform the receiver of a progress update for a long-running request.
 */
export declare const ProgressNotificationSchema: z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"notifications/progress">;
    params: z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The progress thus far. This should increase every time progress is made, even if the total is unknown.
         */
        progress: z.ZodNumber;
        /**
         * Total number of items to process (or total progress required), if known.
         */
        total: z.ZodOptional<z.ZodNumber>;
        /**
         * An optional message describing the current progress.
         */
        message: z.ZodOptional<z.ZodString>;
    }>, {
        /**
         * The progress token which was given in the initial request, used to associate this notification with the request that is proceeding.
         */
        progressToken: z.ZodUnion<[z.ZodString, z.ZodNumber]>;
    }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The progress thus far. This should increase every time progress is made, even if the total is unknown.
         */
        progress: z.ZodNumber;
        /**
         * Total number of items to process (or total progress required), if known.
         */
        total: z.ZodOptional<z.ZodNumber>;
        /**
         * An optional message describing the current progress.
         */
        message: z.ZodOptional<z.ZodString>;
    }>, {
        /**
         * The progress token which was given in the initial request, used to associate this notification with the request that is proceeding.
         */
        progressToken: z.ZodUnion<[z.ZodString, z.ZodNumber]>;
    }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The progress thus far. This should increase every time progress is made, even if the total is unknown.
         */
        progress: z.ZodNumber;
        /**
         * Total number of items to process (or total progress required), if known.
         */
        total: z.ZodOptional<z.ZodNumber>;
        /**
         * An optional message describing the current progress.
         */
        message: z.ZodOptional<z.ZodString>;
    }>, {
        /**
         * The progress token which was given in the initial request, used to associate this notification with the request that is proceeding.
         */
        progressToken: z.ZodUnion<[z.ZodString, z.ZodNumber]>;
    }>, z.ZodTypeAny, "passthrough">>;
}>, "strip", z.ZodTypeAny, {
    params: {
        progressToken: string | number;
        progress: number;
        message?: string | undefined;
        _meta?: z.objectOutputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
        total?: number | undefined;
    } & {
        [k: string]: unknown;
    };
    method: "notifications/progress";
}, {
    params: {
        progressToken: string | number;
        progress: number;
        message?: string | undefined;
        _meta?: z.objectInputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
        total?: number | undefined;
    } & {
        [k: string]: unknown;
    };
    method: "notifications/progress";
}>;
export declare const PaginatedRequestSchema: z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    params: z.ZodOptional<z.ZodObject<z.objectUtil.extendShape<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * An opaque token representing the current pagination position.
         * If provided, the server should return results starting after this cursor.
         */
        cursor: z.ZodOptional<z.ZodString>;
    }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * An opaque token representing the current pagination position.
         * If provided, the server should return results starting after this cursor.
         */
        cursor: z.ZodOptional<z.ZodString>;
    }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * An opaque token representing the current pagination position.
         * If provided, the server should return results starting after this cursor.
         */
        cursor: z.ZodOptional<z.ZodString>;
    }>, z.ZodTypeAny, "passthrough">>>;
}>, "strip", z.ZodTypeAny, {
    method: string;
    params?: z.objectOutputType<z.objectUtil.extendShape<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * An opaque token representing the current pagination position.
         * If provided, the server should return results starting after this cursor.
         */
        cursor: z.ZodOptional<z.ZodString>;
    }>, z.ZodTypeAny, "passthrough"> | undefined;
}, {
    method: string;
    params?: z.objectInputType<z.objectUtil.extendShape<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * An opaque token representing the current pagination position.
         * If provided, the server should return results starting after this cursor.
         */
        cursor: z.ZodOptional<z.ZodString>;
    }>, z.ZodTypeAny, "passthrough"> | undefined;
}>;
export declare const PaginatedResultSchema: z.ZodObject<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, {
    /**
     * An opaque token representing the pagination position after the last returned result.
     * If present, there may be more results available.
     */
    nextCursor: z.ZodOptional<z.ZodString>;
}>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, {
    /**
     * An opaque token representing the pagination position after the last returned result.
     * If present, there may be more results available.
     */
    nextCursor: z.ZodOptional<z.ZodString>;
}>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, {
    /**
     * An opaque token representing the pagination position after the last returned result.
     * If present, there may be more results available.
     */
    nextCursor: z.ZodOptional<z.ZodString>;
}>, z.ZodTypeAny, "passthrough">>;
/**
 * The contents of a specific resource or sub-resource.
 */
export declare const ResourceContentsSchema: z.ZodObject<{
    /**
     * The URI of this resource.
     */
    uri: z.ZodString;
    /**
     * The MIME type of this resource, if known.
     */
    mimeType: z.ZodOptional<z.ZodString>;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    /**
     * The URI of this resource.
     */
    uri: z.ZodString;
    /**
     * The MIME type of this resource, if known.
     */
    mimeType: z.ZodOptional<z.ZodString>;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    /**
     * The URI of this resource.
     */
    uri: z.ZodString;
    /**
     * The MIME type of this resource, if known.
     */
    mimeType: z.ZodOptional<z.ZodString>;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, z.ZodTypeAny, "passthrough">>;
export declare const TextResourceContentsSchema: z.ZodObject<z.objectUtil.extendShape<{
    /**
     * The URI of this resource.
     */
    uri: z.ZodString;
    /**
     * The MIME type of this resource, if known.
     */
    mimeType: z.ZodOptional<z.ZodString>;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, {
    /**
     * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
     */
    text: z.ZodString;
}>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
    /**
     * The URI of this resource.
     */
    uri: z.ZodString;
    /**
     * The MIME type of this resource, if known.
     */
    mimeType: z.ZodOptional<z.ZodString>;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, {
    /**
     * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
     */
    text: z.ZodString;
}>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
    /**
     * The URI of this resource.
     */
    uri: z.ZodString;
    /**
     * The MIME type of this resource, if known.
     */
    mimeType: z.ZodOptional<z.ZodString>;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, {
    /**
     * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
     */
    text: z.ZodString;
}>, z.ZodTypeAny, "passthrough">>;
export declare const BlobResourceContentsSchema: z.ZodObject<z.objectUtil.extendShape<{
    /**
     * The URI of this resource.
     */
    uri: z.ZodString;
    /**
     * The MIME type of this resource, if known.
     */
    mimeType: z.ZodOptional<z.ZodString>;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, {
    /**
     * A base64-encoded string representing the binary data of the item.
     */
    blob: z.ZodEffects<z.ZodString, string, string>;
}>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
    /**
     * The URI of this resource.
     */
    uri: z.ZodString;
    /**
     * The MIME type of this resource, if known.
     */
    mimeType: z.ZodOptional<z.ZodString>;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, {
    /**
     * A base64-encoded string representing the binary data of the item.
     */
    blob: z.ZodEffects<z.ZodString, string, string>;
}>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
    /**
     * The URI of this resource.
     */
    uri: z.ZodString;
    /**
     * The MIME type of this resource, if known.
     */
    mimeType: z.ZodOptional<z.ZodString>;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, {
    /**
     * A base64-encoded string representing the binary data of the item.
     */
    blob: z.ZodEffects<z.ZodString, string, string>;
}>, z.ZodTypeAny, "passthrough">>;
/**
 * A known resource that the server is capable of reading.
 */
export declare const ResourceSchema: z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
    name: z.ZodString;
    /**
     * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
     * even by those unfamiliar with domain-specific terminology.
     *
     * If not provided, the name should be used for display (except for Tool,
     * where `annotations.title` should be given precedence over using `name`,
     * if present).
     */
    title: z.ZodOptional<z.ZodString>;
}, {
    /**
     * The URI of this resource.
     */
    uri: z.ZodString;
    /**
     * A description of what this resource represents.
     *
     * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
     */
    description: z.ZodOptional<z.ZodString>;
    /**
     * The MIME type of this resource, if known.
     */
    mimeType: z.ZodOptional<z.ZodString>;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}>, {
    /**
     * Optional set of sized icons that the client can display in a user interface.
     *
     * Clients that support rendering icons MUST support at least the following MIME types:
     * - `image/png` - PNG images (safe, universal compatibility)
     * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
     *
     * Clients that support rendering icons SHOULD also support:
     * - `image/svg+xml` - SVG images (scalable but requires security precautions)
     * - `image/webp` - WebP images (modern, efficient format)
     */
    icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, z.ZodTypeAny, "passthrough">>, "many">>;
}>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
    name: z.ZodString;
    /**
     * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
     * even by those unfamiliar with domain-specific terminology.
     *
     * If not provided, the name should be used for display (except for Tool,
     * where `annotations.title` should be given precedence over using `name`,
     * if present).
     */
    title: z.ZodOptional<z.ZodString>;
}, {
    /**
     * The URI of this resource.
     */
    uri: z.ZodString;
    /**
     * A description of what this resource represents.
     *
     * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
     */
    description: z.ZodOptional<z.ZodString>;
    /**
     * The MIME type of this resource, if known.
     */
    mimeType: z.ZodOptional<z.ZodString>;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}>, {
    /**
     * Optional set of sized icons that the client can display in a user interface.
     *
     * Clients that support rendering icons MUST support at least the following MIME types:
     * - `image/png` - PNG images (safe, universal compatibility)
     * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
     *
     * Clients that support rendering icons SHOULD also support:
     * - `image/svg+xml` - SVG images (scalable but requires security precautions)
     * - `image/webp` - WebP images (modern, efficient format)
     */
    icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, z.ZodTypeAny, "passthrough">>, "many">>;
}>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
    name: z.ZodString;
    /**
     * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
     * even by those unfamiliar with domain-specific terminology.
     *
     * If not provided, the name should be used for display (except for Tool,
     * where `annotations.title` should be given precedence over using `name`,
     * if present).
     */
    title: z.ZodOptional<z.ZodString>;
}, {
    /**
     * The URI of this resource.
     */
    uri: z.ZodString;
    /**
     * A description of what this resource represents.
     *
     * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
     */
    description: z.ZodOptional<z.ZodString>;
    /**
     * The MIME type of this resource, if known.
     */
    mimeType: z.ZodOptional<z.ZodString>;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}>, {
    /**
     * Optional set of sized icons that the client can display in a user interface.
     *
     * Clients that support rendering icons MUST support at least the following MIME types:
     * - `image/png` - PNG images (safe, universal compatibility)
     * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
     *
     * Clients that support rendering icons SHOULD also support:
     * - `image/svg+xml` - SVG images (scalable but requires security precautions)
     * - `image/webp` - WebP images (modern, efficient format)
     */
    icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, z.ZodTypeAny, "passthrough">>, "many">>;
}>, z.ZodTypeAny, "passthrough">>;
/**
 * A template description for resources available on the server.
 */
export declare const ResourceTemplateSchema: z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
    name: z.ZodString;
    /**
     * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
     * even by those unfamiliar with domain-specific terminology.
     *
     * If not provided, the name should be used for display (except for Tool,
     * where `annotations.title` should be given precedence over using `name`,
     * if present).
     */
    title: z.ZodOptional<z.ZodString>;
}, {
    /**
     * A URI template (according to RFC 6570) that can be used to construct resource URIs.
     */
    uriTemplate: z.ZodString;
    /**
     * A description of what this template is for.
     *
     * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
     */
    description: z.ZodOptional<z.ZodString>;
    /**
     * The MIME type for all resources that match this template. This should only be included if all resources matching this template have the same type.
     */
    mimeType: z.ZodOptional<z.ZodString>;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}>, {
    /**
     * Optional set of sized icons that the client can display in a user interface.
     *
     * Clients that support rendering icons MUST support at least the following MIME types:
     * - `image/png` - PNG images (safe, universal compatibility)
     * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
     *
     * Clients that support rendering icons SHOULD also support:
     * - `image/svg+xml` - SVG images (scalable but requires security precautions)
     * - `image/webp` - WebP images (modern, efficient format)
     */
    icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, z.ZodTypeAny, "passthrough">>, "many">>;
}>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
    name: z.ZodString;
    /**
     * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
     * even by those unfamiliar with domain-specific terminology.
     *
     * If not provided, the name should be used for display (except for Tool,
     * where `annotations.title` should be given precedence over using `name`,
     * if present).
     */
    title: z.ZodOptional<z.ZodString>;
}, {
    /**
     * A URI template (according to RFC 6570) that can be used to construct resource URIs.
     */
    uriTemplate: z.ZodString;
    /**
     * A description of what this template is for.
     *
     * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
     */
    description: z.ZodOptional<z.ZodString>;
    /**
     * The MIME type for all resources that match this template. This should only be included if all resources matching this template have the same type.
     */
    mimeType: z.ZodOptional<z.ZodString>;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}>, {
    /**
     * Optional set of sized icons that the client can display in a user interface.
     *
     * Clients that support rendering icons MUST support at least the following MIME types:
     * - `image/png` - PNG images (safe, universal compatibility)
     * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
     *
     * Clients that support rendering icons SHOULD also support:
     * - `image/svg+xml` - SVG images (scalable but requires security precautions)
     * - `image/webp` - WebP images (modern, efficient format)
     */
    icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, z.ZodTypeAny, "passthrough">>, "many">>;
}>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
    name: z.ZodString;
    /**
     * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
     * even by those unfamiliar with domain-specific terminology.
     *
     * If not provided, the name should be used for display (except for Tool,
     * where `annotations.title` should be given precedence over using `name`,
     * if present).
     */
    title: z.ZodOptional<z.ZodString>;
}, {
    /**
     * A URI template (according to RFC 6570) that can be used to construct resource URIs.
     */
    uriTemplate: z.ZodString;
    /**
     * A description of what this template is for.
     *
     * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
     */
    description: z.ZodOptional<z.ZodString>;
    /**
     * The MIME type for all resources that match this template. This should only be included if all resources matching this template have the same type.
     */
    mimeType: z.ZodOptional<z.ZodString>;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}>, {
    /**
     * Optional set of sized icons that the client can display in a user interface.
     *
     * Clients that support rendering icons MUST support at least the following MIME types:
     * - `image/png` - PNG images (safe, universal compatibility)
     * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
     *
     * Clients that support rendering icons SHOULD also support:
     * - `image/svg+xml` - SVG images (scalable but requires security precautions)
     * - `image/webp` - WebP images (modern, efficient format)
     */
    icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, z.ZodTypeAny, "passthrough">>, "many">>;
}>, z.ZodTypeAny, "passthrough">>;
/**
 * Sent from the client to request a list of resources the server has.
 */
export declare const ListResourcesRequestSchema: z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    params: z.ZodOptional<z.ZodObject<z.objectUtil.extendShape<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * An opaque token representing the current pagination position.
         * If provided, the server should return results starting after this cursor.
         */
        cursor: z.ZodOptional<z.ZodString>;
    }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * An opaque token representing the current pagination position.
         * If provided, the server should return results starting after this cursor.
         */
        cursor: z.ZodOptional<z.ZodString>;
    }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * An opaque token representing the current pagination position.
         * If provided, the server should return results starting after this cursor.
         */
        cursor: z.ZodOptional<z.ZodString>;
    }>, z.ZodTypeAny, "passthrough">>>;
}>, {
    method: z.ZodLiteral<"resources/list">;
}>, "strip", z.ZodTypeAny, {
    method: "resources/list";
    params?: z.objectOutputType<z.objectUtil.extendShape<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * An opaque token representing the current pagination position.
         * If provided, the server should return results starting after this cursor.
         */
        cursor: z.ZodOptional<z.ZodString>;
    }>, z.ZodTypeAny, "passthrough"> | undefined;
}, {
    method: "resources/list";
    params?: z.objectInputType<z.objectUtil.extendShape<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * An opaque token representing the current pagination position.
         * If provided, the server should return results starting after this cursor.
         */
        cursor: z.ZodOptional<z.ZodString>;
    }>, z.ZodTypeAny, "passthrough"> | undefined;
}>;
/**
 * The server's response to a resources/list request from the client.
 */
export declare const ListResourcesResultSchema: z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, {
    /**
     * An opaque token representing the pagination position after the last returned result.
     * If present, there may be more results available.
     */
    nextCursor: z.ZodOptional<z.ZodString>;
}>, {
    resources: z.ZodArray<z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * A description of what this resource represents.
         *
         * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">>, "many">>;
    }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * A description of what this resource represents.
         *
         * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">>, "many">>;
    }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * A description of what this resource represents.
         *
         * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">>, "many">>;
    }>, z.ZodTypeAny, "passthrough">>, "many">;
}>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, {
    /**
     * An opaque token representing the pagination position after the last returned result.
     * If present, there may be more results available.
     */
    nextCursor: z.ZodOptional<z.ZodString>;
}>, {
    resources: z.ZodArray<z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * A description of what this resource represents.
         *
         * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">>, "many">>;
    }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * A description of what this resource represents.
         *
         * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">>, "many">>;
    }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * A description of what this resource represents.
         *
         * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">>, "many">>;
    }>, z.ZodTypeAny, "passthrough">>, "many">;
}>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, {
    /**
     * An opaque token representing the pagination position after the last returned result.
     * If present, there may be more results available.
     */
    nextCursor: z.ZodOptional<z.ZodString>;
}>, {
    resources: z.ZodArray<z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * A description of what this resource represents.
         *
         * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">>, "many">>;
    }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * A description of what this resource represents.
         *
         * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">>, "many">>;
    }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * A description of what this resource represents.
         *
         * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">>, "many">>;
    }>, z.ZodTypeAny, "passthrough">>, "many">;
}>, z.ZodTypeAny, "passthrough">>;
/**
 * Sent from the client to request a list of resource templates the server has.
 */
export declare const ListResourceTemplatesRequestSchema: z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    params: z.ZodOptional<z.ZodObject<z.objectUtil.extendShape<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * An opaque token representing the current pagination position.
         * If provided, the server should return results starting after this cursor.
         */
        cursor: z.ZodOptional<z.ZodString>;
    }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * An opaque token representing the current pagination position.
         * If provided, the server should return results starting after this cursor.
         */
        cursor: z.ZodOptional<z.ZodString>;
    }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * An opaque token representing the current pagination position.
         * If provided, the server should return results starting after this cursor.
         */
        cursor: z.ZodOptional<z.ZodString>;
    }>, z.ZodTypeAny, "passthrough">>>;
}>, {
    method: z.ZodLiteral<"resources/templates/list">;
}>, "strip", z.ZodTypeAny, {
    method: "resources/templates/list";
    params?: z.objectOutputType<z.objectUtil.extendShape<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * An opaque token representing the current pagination position.
         * If provided, the server should return results starting after this cursor.
         */
        cursor: z.ZodOptional<z.ZodString>;
    }>, z.ZodTypeAny, "passthrough"> | undefined;
}, {
    method: "resources/templates/list";
    params?: z.objectInputType<z.objectUtil.extendShape<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * An opaque token representing the current pagination position.
         * If provided, the server should return results starting after this cursor.
         */
        cursor: z.ZodOptional<z.ZodString>;
    }>, z.ZodTypeAny, "passthrough"> | undefined;
}>;
/**
 * The server's response to a resources/templates/list request from the client.
 */
export declare const ListResourceTemplatesResultSchema: z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, {
    /**
     * An opaque token representing the pagination position after the last returned result.
     * If present, there may be more results available.
     */
    nextCursor: z.ZodOptional<z.ZodString>;
}>, {
    resourceTemplates: z.ZodArray<z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * A URI template (according to RFC 6570) that can be used to construct resource URIs.
         */
        uriTemplate: z.ZodString;
        /**
         * A description of what this template is for.
         *
         * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * The MIME type for all resources that match this template. This should only be included if all resources matching this template have the same type.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">>, "many">>;
    }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * A URI template (according to RFC 6570) that can be used to construct resource URIs.
         */
        uriTemplate: z.ZodString;
        /**
         * A description of what this template is for.
         *
         * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * The MIME type for all resources that match this template. This should only be included if all resources matching this template have the same type.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">>, "many">>;
    }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * A URI template (according to RFC 6570) that can be used to construct resource URIs.
         */
        uriTemplate: z.ZodString;
        /**
         * A description of what this template is for.
         *
         * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * The MIME type for all resources that match this template. This should only be included if all resources matching this template have the same type.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">>, "many">>;
    }>, z.ZodTypeAny, "passthrough">>, "many">;
}>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, {
    /**
     * An opaque token representing the pagination position after the last returned result.
     * If present, there may be more results available.
     */
    nextCursor: z.ZodOptional<z.ZodString>;
}>, {
    resourceTemplates: z.ZodArray<z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * A URI template (according to RFC 6570) that can be used to construct resource URIs.
         */
        uriTemplate: z.ZodString;
        /**
         * A description of what this template is for.
         *
         * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * The MIME type for all resources that match this template. This should only be included if all resources matching this template have the same type.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">>, "many">>;
    }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * A URI template (according to RFC 6570) that can be used to construct resource URIs.
         */
        uriTemplate: z.ZodString;
        /**
         * A description of what this template is for.
         *
         * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * The MIME type for all resources that match this template. This should only be included if all resources matching this template have the same type.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">>, "many">>;
    }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * A URI template (according to RFC 6570) that can be used to construct resource URIs.
         */
        uriTemplate: z.ZodString;
        /**
         * A description of what this template is for.
         *
         * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * The MIME type for all resources that match this template. This should only be included if all resources matching this template have the same type.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">>, "many">>;
    }>, z.ZodTypeAny, "passthrough">>, "many">;
}>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, {
    /**
     * An opaque token representing the pagination position after the last returned result.
     * If present, there may be more results available.
     */
    nextCursor: z.ZodOptional<z.ZodString>;
}>, {
    resourceTemplates: z.ZodArray<z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * A URI template (according to RFC 6570) that can be used to construct resource URIs.
         */
        uriTemplate: z.ZodString;
        /**
         * A description of what this template is for.
         *
         * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * The MIME type for all resources that match this template. This should only be included if all resources matching this template have the same type.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">>, "many">>;
    }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * A URI template (according to RFC 6570) that can be used to construct resource URIs.
         */
        uriTemplate: z.ZodString;
        /**
         * A description of what this template is for.
         *
         * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * The MIME type for all resources that match this template. This should only be included if all resources matching this template have the same type.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">>, "many">>;
    }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * A URI template (according to RFC 6570) that can be used to construct resource URIs.
         */
        uriTemplate: z.ZodString;
        /**
         * A description of what this template is for.
         *
         * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * The MIME type for all resources that match this template. This should only be included if all resources matching this template have the same type.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">>, "many">>;
    }>, z.ZodTypeAny, "passthrough">>, "many">;
}>, z.ZodTypeAny, "passthrough">>;
/**
 * Sent from the client to the server, to read a specific resource URI.
 */
export declare const ReadResourceRequestSchema: z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"resources/read">;
    params: z.ZodObject<z.objectUtil.extendShape<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The URI of the resource to read. The URI can use any protocol; it is up to the server how to interpret it.
         */
        uri: z.ZodString;
    }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The URI of the resource to read. The URI can use any protocol; it is up to the server how to interpret it.
         */
        uri: z.ZodString;
    }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The URI of the resource to read. The URI can use any protocol; it is up to the server how to interpret it.
         */
        uri: z.ZodString;
    }>, z.ZodTypeAny, "passthrough">>;
}>, "strip", z.ZodTypeAny, {
    params: {
        uri: string;
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    } & {
        [k: string]: unknown;
    };
    method: "resources/read";
}, {
    params: {
        uri: string;
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    } & {
        [k: string]: unknown;
    };
    method: "resources/read";
}>;
/**
 * The server's response to a resources/read request from the client.
 */
export declare const ReadResourceResultSchema: z.ZodObject<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, {
    contents: z.ZodArray<z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
         */
        text: z.ZodString;
    }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
         */
        text: z.ZodString;
    }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
         */
        text: z.ZodString;
    }>, z.ZodTypeAny, "passthrough">>, z.ZodObject<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * A base64-encoded string representing the binary data of the item.
         */
        blob: z.ZodEffects<z.ZodString, string, string>;
    }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * A base64-encoded string representing the binary data of the item.
         */
        blob: z.ZodEffects<z.ZodString, string, string>;
    }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * A base64-encoded string representing the binary data of the item.
         */
        blob: z.ZodEffects<z.ZodString, string, string>;
    }>, z.ZodTypeAny, "passthrough">>]>, "many">;
}>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, {
    contents: z.ZodArray<z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
         */
        text: z.ZodString;
    }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
         */
        text: z.ZodString;
    }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
         */
        text: z.ZodString;
    }>, z.ZodTypeAny, "passthrough">>, z.ZodObject<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * A base64-encoded string representing the binary data of the item.
         */
        blob: z.ZodEffects<z.ZodString, string, string>;
    }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * A base64-encoded string representing the binary data of the item.
         */
        blob: z.ZodEffects<z.ZodString, string, string>;
    }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * A base64-encoded string representing the binary data of the item.
         */
        blob: z.ZodEffects<z.ZodString, string, string>;
    }>, z.ZodTypeAny, "passthrough">>]>, "many">;
}>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, {
    contents: z.ZodArray<z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
         */
        text: z.ZodString;
    }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
         */
        text: z.ZodString;
    }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
         */
        text: z.ZodString;
    }>, z.ZodTypeAny, "passthrough">>, z.ZodObject<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * A base64-encoded string representing the binary data of the item.
         */
        blob: z.ZodEffects<z.ZodString, string, string>;
    }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * A base64-encoded string representing the binary data of the item.
         */
        blob: z.ZodEffects<z.ZodString, string, string>;
    }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * A base64-encoded string representing the binary data of the item.
         */
        blob: z.ZodEffects<z.ZodString, string, string>;
    }>, z.ZodTypeAny, "passthrough">>]>, "many">;
}>, z.ZodTypeAny, "passthrough">>;
/**
 * An optional notification from the server to the client, informing it that the list of resources it can read from has changed. This may be issued by servers without any previous subscription from the client.
 */
export declare const ResourceListChangedNotificationSchema: z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"notifications/resources/list_changed">;
}>, "strip", z.ZodTypeAny, {
    method: "notifications/resources/list_changed";
    params?: z.objectOutputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}, {
    method: "notifications/resources/list_changed";
    params?: z.objectInputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}>;
/**
 * Sent from the client to request resources/updated notifications from the server whenever a particular resource changes.
 */
export declare const SubscribeRequestSchema: z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"resources/subscribe">;
    params: z.ZodObject<z.objectUtil.extendShape<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The URI of the resource to subscribe to. The URI can use any protocol; it is up to the server how to interpret it.
         */
        uri: z.ZodString;
    }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The URI of the resource to subscribe to. The URI can use any protocol; it is up to the server how to interpret it.
         */
        uri: z.ZodString;
    }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The URI of the resource to subscribe to. The URI can use any protocol; it is up to the server how to interpret it.
         */
        uri: z.ZodString;
    }>, z.ZodTypeAny, "passthrough">>;
}>, "strip", z.ZodTypeAny, {
    params: {
        uri: string;
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    } & {
        [k: string]: unknown;
    };
    method: "resources/subscribe";
}, {
    params: {
        uri: string;
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    } & {
        [k: string]: unknown;
    };
    method: "resources/subscribe";
}>;
/**
 * Sent from the client to request cancellation of resources/updated notifications from the server. This should follow a previous resources/subscribe request.
 */
export declare const UnsubscribeRequestSchema: z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"resources/unsubscribe">;
    params: z.ZodObject<z.objectUtil.extendShape<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The URI of the resource to unsubscribe from.
         */
        uri: z.ZodString;
    }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The URI of the resource to unsubscribe from.
         */
        uri: z.ZodString;
    }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The URI of the resource to unsubscribe from.
         */
        uri: z.ZodString;
    }>, z.ZodTypeAny, "passthrough">>;
}>, "strip", z.ZodTypeAny, {
    params: {
        uri: string;
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    } & {
        [k: string]: unknown;
    };
    method: "resources/unsubscribe";
}, {
    params: {
        uri: string;
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    } & {
        [k: string]: unknown;
    };
    method: "resources/unsubscribe";
}>;
/**
 * A notification from the server to the client, informing it that a resource has changed and may need to be read again. This should only be sent if the client previously sent a resources/subscribe request.
 */
export declare const ResourceUpdatedNotificationSchema: z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"notifications/resources/updated">;
    params: z.ZodObject<z.objectUtil.extendShape<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The URI of the resource that has been updated. This might be a sub-resource of the one that the client actually subscribed to.
         */
        uri: z.ZodString;
    }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The URI of the resource that has been updated. This might be a sub-resource of the one that the client actually subscribed to.
         */
        uri: z.ZodString;
    }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The URI of the resource that has been updated. This might be a sub-resource of the one that the client actually subscribed to.
         */
        uri: z.ZodString;
    }>, z.ZodTypeAny, "passthrough">>;
}>, "strip", z.ZodTypeAny, {
    params: {
        uri: string;
        _meta?: z.objectOutputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
    } & {
        [k: string]: unknown;
    };
    method: "notifications/resources/updated";
}, {
    params: {
        uri: string;
        _meta?: z.objectInputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
    } & {
        [k: string]: unknown;
    };
    method: "notifications/resources/updated";
}>;
/**
 * Describes an argument that a prompt can accept.
 */
export declare const PromptArgumentSchema: z.ZodObject<{
    /**
     * The name of the argument.
     */
    name: z.ZodString;
    /**
     * A human-readable description of the argument.
     */
    description: z.ZodOptional<z.ZodString>;
    /**
     * Whether this argument must be provided.
     */
    required: z.ZodOptional<z.ZodBoolean>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    /**
     * The name of the argument.
     */
    name: z.ZodString;
    /**
     * A human-readable description of the argument.
     */
    description: z.ZodOptional<z.ZodString>;
    /**
     * Whether this argument must be provided.
     */
    required: z.ZodOptional<z.ZodBoolean>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    /**
     * The name of the argument.
     */
    name: z.ZodString;
    /**
     * A human-readable description of the argument.
     */
    description: z.ZodOptional<z.ZodString>;
    /**
     * Whether this argument must be provided.
     */
    required: z.ZodOptional<z.ZodBoolean>;
}, z.ZodTypeAny, "passthrough">>;
/**
 * A prompt or prompt template that the server offers.
 */
export declare const PromptSchema: z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
    name: z.ZodString;
    /**
     * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
     * even by those unfamiliar with domain-specific terminology.
     *
     * If not provided, the name should be used for display (except for Tool,
     * where `annotations.title` should be given precedence over using `name`,
     * if present).
     */
    title: z.ZodOptional<z.ZodString>;
}, {
    /**
     * An optional description of what this prompt provides
     */
    description: z.ZodOptional<z.ZodString>;
    /**
     * A list of arguments to use for templating the prompt.
     */
    arguments: z.ZodOptional<z.ZodArray<z.ZodObject<{
        /**
         * The name of the argument.
         */
        name: z.ZodString;
        /**
         * A human-readable description of the argument.
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * Whether this argument must be provided.
         */
        required: z.ZodOptional<z.ZodBoolean>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * The name of the argument.
         */
        name: z.ZodString;
        /**
         * A human-readable description of the argument.
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * Whether this argument must be provided.
         */
        required: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * The name of the argument.
         */
        name: z.ZodString;
        /**
         * A human-readable description of the argument.
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * Whether this argument must be provided.
         */
        required: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">>, "many">>;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}>, {
    /**
     * Optional set of sized icons that the client can display in a user interface.
     *
     * Clients that support rendering icons MUST support at least the following MIME types:
     * - `image/png` - PNG images (safe, universal compatibility)
     * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
     *
     * Clients that support rendering icons SHOULD also support:
     * - `image/svg+xml` - SVG images (scalable but requires security precautions)
     * - `image/webp` - WebP images (modern, efficient format)
     */
    icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, z.ZodTypeAny, "passthrough">>, "many">>;
}>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
    name: z.ZodString;
    /**
     * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
     * even by those unfamiliar with domain-specific terminology.
     *
     * If not provided, the name should be used for display (except for Tool,
     * where `annotations.title` should be given precedence over using `name`,
     * if present).
     */
    title: z.ZodOptional<z.ZodString>;
}, {
    /**
     * An optional description of what this prompt provides
     */
    description: z.ZodOptional<z.ZodString>;
    /**
     * A list of arguments to use for templating the prompt.
     */
    arguments: z.ZodOptional<z.ZodArray<z.ZodObject<{
        /**
         * The name of the argument.
         */
        name: z.ZodString;
        /**
         * A human-readable description of the argument.
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * Whether this argument must be provided.
         */
        required: z.ZodOptional<z.ZodBoolean>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * The name of the argument.
         */
        name: z.ZodString;
        /**
         * A human-readable description of the argument.
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * Whether this argument must be provided.
         */
        required: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * The name of the argument.
         */
        name: z.ZodString;
        /**
         * A human-readable description of the argument.
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * Whether this argument must be provided.
         */
        required: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">>, "many">>;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}>, {
    /**
     * Optional set of sized icons that the client can display in a user interface.
     *
     * Clients that support rendering icons MUST support at least the following MIME types:
     * - `image/png` - PNG images (safe, universal compatibility)
     * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
     *
     * Clients that support rendering icons SHOULD also support:
     * - `image/svg+xml` - SVG images (scalable but requires security precautions)
     * - `image/webp` - WebP images (modern, efficient format)
     */
    icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, z.ZodTypeAny, "passthrough">>, "many">>;
}>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
    name: z.ZodString;
    /**
     * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
     * even by those unfamiliar with domain-specific terminology.
     *
     * If not provided, the name should be used for display (except for Tool,
     * where `annotations.title` should be given precedence over using `name`,
     * if present).
     */
    title: z.ZodOptional<z.ZodString>;
}, {
    /**
     * An optional description of what this prompt provides
     */
    description: z.ZodOptional<z.ZodString>;
    /**
     * A list of arguments to use for templating the prompt.
     */
    arguments: z.ZodOptional<z.ZodArray<z.ZodObject<{
        /**
         * The name of the argument.
         */
        name: z.ZodString;
        /**
         * A human-readable description of the argument.
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * Whether this argument must be provided.
         */
        required: z.ZodOptional<z.ZodBoolean>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * The name of the argument.
         */
        name: z.ZodString;
        /**
         * A human-readable description of the argument.
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * Whether this argument must be provided.
         */
        required: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * The name of the argument.
         */
        name: z.ZodString;
        /**
         * A human-readable description of the argument.
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * Whether this argument must be provided.
         */
        required: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">>, "many">>;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}>, {
    /**
     * Optional set of sized icons that the client can display in a user interface.
     *
     * Clients that support rendering icons MUST support at least the following MIME types:
     * - `image/png` - PNG images (safe, universal compatibility)
     * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
     *
     * Clients that support rendering icons SHOULD also support:
     * - `image/svg+xml` - SVG images (scalable but requires security precautions)
     * - `image/webp` - WebP images (modern, efficient format)
     */
    icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, z.ZodTypeAny, "passthrough">>, "many">>;
}>, z.ZodTypeAny, "passthrough">>;
/**
 * Sent from the client to request a list of prompts and prompt templates the server has.
 */
export declare const ListPromptsRequestSchema: z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    params: z.ZodOptional<z.ZodObject<z.objectUtil.extendShape<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * An opaque token representing the current pagination position.
         * If provided, the server should return results starting after this cursor.
         */
        cursor: z.ZodOptional<z.ZodString>;
    }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * An opaque token representing the current pagination position.
         * If provided, the server should return results starting after this cursor.
         */
        cursor: z.ZodOptional<z.ZodString>;
    }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * An opaque token representing the current pagination position.
         * If provided, the server should return results starting after this cursor.
         */
        cursor: z.ZodOptional<z.ZodString>;
    }>, z.ZodTypeAny, "passthrough">>>;
}>, {
    method: z.ZodLiteral<"prompts/list">;
}>, "strip", z.ZodTypeAny, {
    method: "prompts/list";
    params?: z.objectOutputType<z.objectUtil.extendShape<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * An opaque token representing the current pagination position.
         * If provided, the server should return results starting after this cursor.
         */
        cursor: z.ZodOptional<z.ZodString>;
    }>, z.ZodTypeAny, "passthrough"> | undefined;
}, {
    method: "prompts/list";
    params?: z.objectInputType<z.objectUtil.extendShape<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * An opaque token representing the current pagination position.
         * If provided, the server should return results starting after this cursor.
         */
        cursor: z.ZodOptional<z.ZodString>;
    }>, z.ZodTypeAny, "passthrough"> | undefined;
}>;
/**
 * The server's response to a prompts/list request from the client.
 */
export declare const ListPromptsResultSchema: z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, {
    /**
     * An opaque token representing the pagination position after the last returned result.
     * If present, there may be more results available.
     */
    nextCursor: z.ZodOptional<z.ZodString>;
}>, {
    prompts: z.ZodArray<z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * An optional description of what this prompt provides
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * A list of arguments to use for templating the prompt.
         */
        arguments: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * The name of the argument.
             */
            name: z.ZodString;
            /**
             * A human-readable description of the argument.
             */
            description: z.ZodOptional<z.ZodString>;
            /**
             * Whether this argument must be provided.
             */
            required: z.ZodOptional<z.ZodBoolean>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * The name of the argument.
             */
            name: z.ZodString;
            /**
             * A human-readable description of the argument.
             */
            description: z.ZodOptional<z.ZodString>;
            /**
             * Whether this argument must be provided.
             */
            required: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * The name of the argument.
             */
            name: z.ZodString;
            /**
             * A human-readable description of the argument.
             */
            description: z.ZodOptional<z.ZodString>;
            /**
             * Whether this argument must be provided.
             */
            required: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">>, "many">>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">>, "many">>;
    }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * An optional description of what this prompt provides
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * A list of arguments to use for templating the prompt.
         */
        arguments: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * The name of the argument.
             */
            name: z.ZodString;
            /**
             * A human-readable description of the argument.
             */
            description: z.ZodOptional<z.ZodString>;
            /**
             * Whether this argument must be provided.
             */
            required: z.ZodOptional<z.ZodBoolean>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * The name of the argument.
             */
            name: z.ZodString;
            /**
             * A human-readable description of the argument.
             */
            description: z.ZodOptional<z.ZodString>;
            /**
             * Whether this argument must be provided.
             */
            required: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * The name of the argument.
             */
            name: z.ZodString;
            /**
             * A human-readable description of the argument.
             */
            description: z.ZodOptional<z.ZodString>;
            /**
             * Whether this argument must be provided.
             */
            required: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">>, "many">>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">>, "many">>;
    }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * An optional description of what this prompt provides
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * A list of arguments to use for templating the prompt.
         */
        arguments: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * The name of the argument.
             */
            name: z.ZodString;
            /**
             * A human-readable description of the argument.
             */
            description: z.ZodOptional<z.ZodString>;
            /**
             * Whether this argument must be provided.
             */
            required: z.ZodOptional<z.ZodBoolean>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * The name of the argument.
             */
            name: z.ZodString;
            /**
             * A human-readable description of the argument.
             */
            description: z.ZodOptional<z.ZodString>;
            /**
             * Whether this argument must be provided.
             */
            required: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * The name of the argument.
             */
            name: z.ZodString;
            /**
             * A human-readable description of the argument.
             */
            description: z.ZodOptional<z.ZodString>;
            /**
             * Whether this argument must be provided.
             */
            required: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">>, "many">>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">>, "many">>;
    }>, z.ZodTypeAny, "passthrough">>, "many">;
}>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, {
    /**
     * An opaque token representing the pagination position after the last returned result.
     * If present, there may be more results available.
     */
    nextCursor: z.ZodOptional<z.ZodString>;
}>, {
    prompts: z.ZodArray<z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * An optional description of what this prompt provides
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * A list of arguments to use for templating the prompt.
         */
        arguments: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * The name of the argument.
             */
            name: z.ZodString;
            /**
             * A human-readable description of the argument.
             */
            description: z.ZodOptional<z.ZodString>;
            /**
             * Whether this argument must be provided.
             */
            required: z.ZodOptional<z.ZodBoolean>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * The name of the argument.
             */
            name: z.ZodString;
            /**
             * A human-readable description of the argument.
             */
            description: z.ZodOptional<z.ZodString>;
            /**
             * Whether this argument must be provided.
             */
            required: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * The name of the argument.
             */
            name: z.ZodString;
            /**
             * A human-readable description of the argument.
             */
            description: z.ZodOptional<z.ZodString>;
            /**
             * Whether this argument must be provided.
             */
            required: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">>, "many">>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">>, "many">>;
    }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * An optional description of what this prompt provides
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * A list of arguments to use for templating the prompt.
         */
        arguments: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * The name of the argument.
             */
            name: z.ZodString;
            /**
             * A human-readable description of the argument.
             */
            description: z.ZodOptional<z.ZodString>;
            /**
             * Whether this argument must be provided.
             */
            required: z.ZodOptional<z.ZodBoolean>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * The name of the argument.
             */
            name: z.ZodString;
            /**
             * A human-readable description of the argument.
             */
            description: z.ZodOptional<z.ZodString>;
            /**
             * Whether this argument must be provided.
             */
            required: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * The name of the argument.
             */
            name: z.ZodString;
            /**
             * A human-readable description of the argument.
             */
            description: z.ZodOptional<z.ZodString>;
            /**
             * Whether this argument must be provided.
             */
            required: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">>, "many">>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">>, "many">>;
    }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * An optional description of what this prompt provides
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * A list of arguments to use for templating the prompt.
         */
        arguments: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * The name of the argument.
             */
            name: z.ZodString;
            /**
             * A human-readable description of the argument.
             */
            description: z.ZodOptional<z.ZodString>;
            /**
             * Whether this argument must be provided.
             */
            required: z.ZodOptional<z.ZodBoolean>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * The name of the argument.
             */
            name: z.ZodString;
            /**
             * A human-readable description of the argument.
             */
            description: z.ZodOptional<z.ZodString>;
            /**
             * Whether this argument must be provided.
             */
            required: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * The name of the argument.
             */
            name: z.ZodString;
            /**
             * A human-readable description of the argument.
             */
            description: z.ZodOptional<z.ZodString>;
            /**
             * Whether this argument must be provided.
             */
            required: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">>, "many">>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">>, "many">>;
    }>, z.ZodTypeAny, "passthrough">>, "many">;
}>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, {
    /**
     * An opaque token representing the pagination position after the last returned result.
     * If present, there may be more results available.
     */
    nextCursor: z.ZodOptional<z.ZodString>;
}>, {
    prompts: z.ZodArray<z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * An optional description of what this prompt provides
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * A list of arguments to use for templating the prompt.
         */
        arguments: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * The name of the argument.
             */
            name: z.ZodString;
            /**
             * A human-readable description of the argument.
             */
            description: z.ZodOptional<z.ZodString>;
            /**
             * Whether this argument must be provided.
             */
            required: z.ZodOptional<z.ZodBoolean>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * The name of the argument.
             */
            name: z.ZodString;
            /**
             * A human-readable description of the argument.
             */
            description: z.ZodOptional<z.ZodString>;
            /**
             * Whether this argument must be provided.
             */
            required: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * The name of the argument.
             */
            name: z.ZodString;
            /**
             * A human-readable description of the argument.
             */
            description: z.ZodOptional<z.ZodString>;
            /**
             * Whether this argument must be provided.
             */
            required: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">>, "many">>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">>, "many">>;
    }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * An optional description of what this prompt provides
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * A list of arguments to use for templating the prompt.
         */
        arguments: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * The name of the argument.
             */
            name: z.ZodString;
            /**
             * A human-readable description of the argument.
             */
            description: z.ZodOptional<z.ZodString>;
            /**
             * Whether this argument must be provided.
             */
            required: z.ZodOptional<z.ZodBoolean>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * The name of the argument.
             */
            name: z.ZodString;
            /**
             * A human-readable description of the argument.
             */
            description: z.ZodOptional<z.ZodString>;
            /**
             * Whether this argument must be provided.
             */
            required: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * The name of the argument.
             */
            name: z.ZodString;
            /**
             * A human-readable description of the argument.
             */
            description: z.ZodOptional<z.ZodString>;
            /**
             * Whether this argument must be provided.
             */
            required: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">>, "many">>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">>, "many">>;
    }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * An optional description of what this prompt provides
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * A list of arguments to use for templating the prompt.
         */
        arguments: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * The name of the argument.
             */
            name: z.ZodString;
            /**
             * A human-readable description of the argument.
             */
            description: z.ZodOptional<z.ZodString>;
            /**
             * Whether this argument must be provided.
             */
            required: z.ZodOptional<z.ZodBoolean>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * The name of the argument.
             */
            name: z.ZodString;
            /**
             * A human-readable description of the argument.
             */
            description: z.ZodOptional<z.ZodString>;
            /**
             * Whether this argument must be provided.
             */
            required: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * The name of the argument.
             */
            name: z.ZodString;
            /**
             * A human-readable description of the argument.
             */
            description: z.ZodOptional<z.ZodString>;
            /**
             * Whether this argument must be provided.
             */
            required: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">>, "many">>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">>, "many">>;
    }>, z.ZodTypeAny, "passthrough">>, "many">;
}>, z.ZodTypeAny, "passthrough">>;
/**
 * Used by the client to get a prompt provided by the server.
 */
export declare const GetPromptRequestSchema: z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"prompts/get">;
    params: z.ZodObject<z.objectUtil.extendShape<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The name of the prompt or prompt template.
         */
        name: z.ZodString;
        /**
         * Arguments to use for templating the prompt.
         */
        arguments: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
    }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The name of the prompt or prompt template.
         */
        name: z.ZodString;
        /**
         * Arguments to use for templating the prompt.
         */
        arguments: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
    }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The name of the prompt or prompt template.
         */
        name: z.ZodString;
        /**
         * Arguments to use for templating the prompt.
         */
        arguments: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
    }>, z.ZodTypeAny, "passthrough">>;
}>, "strip", z.ZodTypeAny, {
    params: {
        name: string;
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        arguments?: Record<string, string> | undefined;
    } & {
        [k: string]: unknown;
    };
    method: "prompts/get";
}, {
    params: {
        name: string;
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        arguments?: Record<string, string> | undefined;
    } & {
        [k: string]: unknown;
    };
    method: "prompts/get";
}>;
/**
 * Text provided to or from an LLM.
 */
export declare const TextContentSchema: z.ZodObject<{
    type: z.ZodLiteral<"text">;
    /**
     * The text content of the message.
     */
    text: z.ZodString;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    type: z.ZodLiteral<"text">;
    /**
     * The text content of the message.
     */
    text: z.ZodString;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    type: z.ZodLiteral<"text">;
    /**
     * The text content of the message.
     */
    text: z.ZodString;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, z.ZodTypeAny, "passthrough">>;
/**
 * An image provided to or from an LLM.
 */
export declare const ImageContentSchema: z.ZodObject<{
    type: z.ZodLiteral<"image">;
    /**
     * The base64-encoded image data.
     */
    data: z.ZodEffects<z.ZodString, string, string>;
    /**
     * The MIME type of the image. Different providers may support different image types.
     */
    mimeType: z.ZodString;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    type: z.ZodLiteral<"image">;
    /**
     * The base64-encoded image data.
     */
    data: z.ZodEffects<z.ZodString, string, string>;
    /**
     * The MIME type of the image. Different providers may support different image types.
     */
    mimeType: z.ZodString;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    type: z.ZodLiteral<"image">;
    /**
     * The base64-encoded image data.
     */
    data: z.ZodEffects<z.ZodString, string, string>;
    /**
     * The MIME type of the image. Different providers may support different image types.
     */
    mimeType: z.ZodString;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, z.ZodTypeAny, "passthrough">>;
/**
 * An Audio provided to or from an LLM.
 */
export declare const AudioContentSchema: z.ZodObject<{
    type: z.ZodLiteral<"audio">;
    /**
     * The base64-encoded audio data.
     */
    data: z.ZodEffects<z.ZodString, string, string>;
    /**
     * The MIME type of the audio. Different providers may support different audio types.
     */
    mimeType: z.ZodString;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    type: z.ZodLiteral<"audio">;
    /**
     * The base64-encoded audio data.
     */
    data: z.ZodEffects<z.ZodString, string, string>;
    /**
     * The MIME type of the audio. Different providers may support different audio types.
     */
    mimeType: z.ZodString;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    type: z.ZodLiteral<"audio">;
    /**
     * The base64-encoded audio data.
     */
    data: z.ZodEffects<z.ZodString, string, string>;
    /**
     * The MIME type of the audio. Different providers may support different audio types.
     */
    mimeType: z.ZodString;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, z.ZodTypeAny, "passthrough">>;
/**
 * The contents of a resource, embedded into a prompt or tool call result.
 */
export declare const EmbeddedResourceSchema: z.ZodObject<{
    type: z.ZodLiteral<"resource">;
    resource: z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
         */
        text: z.ZodString;
    }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
         */
        text: z.ZodString;
    }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
         */
        text: z.ZodString;
    }>, z.ZodTypeAny, "passthrough">>, z.ZodObject<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * A base64-encoded string representing the binary data of the item.
         */
        blob: z.ZodEffects<z.ZodString, string, string>;
    }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * A base64-encoded string representing the binary data of the item.
         */
        blob: z.ZodEffects<z.ZodString, string, string>;
    }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * A base64-encoded string representing the binary data of the item.
         */
        blob: z.ZodEffects<z.ZodString, string, string>;
    }>, z.ZodTypeAny, "passthrough">>]>;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    type: z.ZodLiteral<"resource">;
    resource: z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
         */
        text: z.ZodString;
    }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
         */
        text: z.ZodString;
    }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
         */
        text: z.ZodString;
    }>, z.ZodTypeAny, "passthrough">>, z.ZodObject<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * A base64-encoded string representing the binary data of the item.
         */
        blob: z.ZodEffects<z.ZodString, string, string>;
    }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * A base64-encoded string representing the binary data of the item.
         */
        blob: z.ZodEffects<z.ZodString, string, string>;
    }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * A base64-encoded string representing the binary data of the item.
         */
        blob: z.ZodEffects<z.ZodString, string, string>;
    }>, z.ZodTypeAny, "passthrough">>]>;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    type: z.ZodLiteral<"resource">;
    resource: z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
         */
        text: z.ZodString;
    }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
         */
        text: z.ZodString;
    }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
         */
        text: z.ZodString;
    }>, z.ZodTypeAny, "passthrough">>, z.ZodObject<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * A base64-encoded string representing the binary data of the item.
         */
        blob: z.ZodEffects<z.ZodString, string, string>;
    }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * A base64-encoded string representing the binary data of the item.
         */
        blob: z.ZodEffects<z.ZodString, string, string>;
    }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * A base64-encoded string representing the binary data of the item.
         */
        blob: z.ZodEffects<z.ZodString, string, string>;
    }>, z.ZodTypeAny, "passthrough">>]>;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, z.ZodTypeAny, "passthrough">>;
/**
 * A resource that the server is capable of reading, included in a prompt or tool call result.
 *
 * Note: resource links returned by tools are not guaranteed to appear in the results of `resources/list` requests.
 */
export declare const ResourceLinkSchema: z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
    name: z.ZodString;
    /**
     * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
     * even by those unfamiliar with domain-specific terminology.
     *
     * If not provided, the name should be used for display (except for Tool,
     * where `annotations.title` should be given precedence over using `name`,
     * if present).
     */
    title: z.ZodOptional<z.ZodString>;
}, {
    /**
     * The URI of this resource.
     */
    uri: z.ZodString;
    /**
     * A description of what this resource represents.
     *
     * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
     */
    description: z.ZodOptional<z.ZodString>;
    /**
     * The MIME type of this resource, if known.
     */
    mimeType: z.ZodOptional<z.ZodString>;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}>, {
    /**
     * Optional set of sized icons that the client can display in a user interface.
     *
     * Clients that support rendering icons MUST support at least the following MIME types:
     * - `image/png` - PNG images (safe, universal compatibility)
     * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
     *
     * Clients that support rendering icons SHOULD also support:
     * - `image/svg+xml` - SVG images (scalable but requires security precautions)
     * - `image/webp` - WebP images (modern, efficient format)
     */
    icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, z.ZodTypeAny, "passthrough">>, "many">>;
}>, {
    type: z.ZodLiteral<"resource_link">;
}>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
    name: z.ZodString;
    /**
     * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
     * even by those unfamiliar with domain-specific terminology.
     *
     * If not provided, the name should be used for display (except for Tool,
     * where `annotations.title` should be given precedence over using `name`,
     * if present).
     */
    title: z.ZodOptional<z.ZodString>;
}, {
    /**
     * The URI of this resource.
     */
    uri: z.ZodString;
    /**
     * A description of what this resource represents.
     *
     * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
     */
    description: z.ZodOptional<z.ZodString>;
    /**
     * The MIME type of this resource, if known.
     */
    mimeType: z.ZodOptional<z.ZodString>;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}>, {
    /**
     * Optional set of sized icons that the client can display in a user interface.
     *
     * Clients that support rendering icons MUST support at least the following MIME types:
     * - `image/png` - PNG images (safe, universal compatibility)
     * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
     *
     * Clients that support rendering icons SHOULD also support:
     * - `image/svg+xml` - SVG images (scalable but requires security precautions)
     * - `image/webp` - WebP images (modern, efficient format)
     */
    icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, z.ZodTypeAny, "passthrough">>, "many">>;
}>, {
    type: z.ZodLiteral<"resource_link">;
}>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
    name: z.ZodString;
    /**
     * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
     * even by those unfamiliar with domain-specific terminology.
     *
     * If not provided, the name should be used for display (except for Tool,
     * where `annotations.title` should be given precedence over using `name`,
     * if present).
     */
    title: z.ZodOptional<z.ZodString>;
}, {
    /**
     * The URI of this resource.
     */
    uri: z.ZodString;
    /**
     * A description of what this resource represents.
     *
     * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
     */
    description: z.ZodOptional<z.ZodString>;
    /**
     * The MIME type of this resource, if known.
     */
    mimeType: z.ZodOptional<z.ZodString>;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}>, {
    /**
     * Optional set of sized icons that the client can display in a user interface.
     *
     * Clients that support rendering icons MUST support at least the following MIME types:
     * - `image/png` - PNG images (safe, universal compatibility)
     * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
     *
     * Clients that support rendering icons SHOULD also support:
     * - `image/svg+xml` - SVG images (scalable but requires security precautions)
     * - `image/webp` - WebP images (modern, efficient format)
     */
    icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, z.ZodTypeAny, "passthrough">>, "many">>;
}>, {
    type: z.ZodLiteral<"resource_link">;
}>, z.ZodTypeAny, "passthrough">>;
/**
 * A content block that can be used in prompts and tool results.
 */
export declare const ContentBlockSchema: z.ZodUnion<[z.ZodObject<{
    type: z.ZodLiteral<"text">;
    /**
     * The text content of the message.
     */
    text: z.ZodString;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    type: z.ZodLiteral<"text">;
    /**
     * The text content of the message.
     */
    text: z.ZodString;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    type: z.ZodLiteral<"text">;
    /**
     * The text content of the message.
     */
    text: z.ZodString;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, z.ZodTypeAny, "passthrough">>, z.ZodObject<{
    type: z.ZodLiteral<"image">;
    /**
     * The base64-encoded image data.
     */
    data: z.ZodEffects<z.ZodString, string, string>;
    /**
     * The MIME type of the image. Different providers may support different image types.
     */
    mimeType: z.ZodString;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    type: z.ZodLiteral<"image">;
    /**
     * The base64-encoded image data.
     */
    data: z.ZodEffects<z.ZodString, string, string>;
    /**
     * The MIME type of the image. Different providers may support different image types.
     */
    mimeType: z.ZodString;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    type: z.ZodLiteral<"image">;
    /**
     * The base64-encoded image data.
     */
    data: z.ZodEffects<z.ZodString, string, string>;
    /**
     * The MIME type of the image. Different providers may support different image types.
     */
    mimeType: z.ZodString;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, z.ZodTypeAny, "passthrough">>, z.ZodObject<{
    type: z.ZodLiteral<"audio">;
    /**
     * The base64-encoded audio data.
     */
    data: z.ZodEffects<z.ZodString, string, string>;
    /**
     * The MIME type of the audio. Different providers may support different audio types.
     */
    mimeType: z.ZodString;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    type: z.ZodLiteral<"audio">;
    /**
     * The base64-encoded audio data.
     */
    data: z.ZodEffects<z.ZodString, string, string>;
    /**
     * The MIME type of the audio. Different providers may support different audio types.
     */
    mimeType: z.ZodString;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    type: z.ZodLiteral<"audio">;
    /**
     * The base64-encoded audio data.
     */
    data: z.ZodEffects<z.ZodString, string, string>;
    /**
     * The MIME type of the audio. Different providers may support different audio types.
     */
    mimeType: z.ZodString;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, z.ZodTypeAny, "passthrough">>, z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
    name: z.ZodString;
    /**
     * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
     * even by those unfamiliar with domain-specific terminology.
     *
     * If not provided, the name should be used for display (except for Tool,
     * where `annotations.title` should be given precedence over using `name`,
     * if present).
     */
    title: z.ZodOptional<z.ZodString>;
}, {
    /**
     * The URI of this resource.
     */
    uri: z.ZodString;
    /**
     * A description of what this resource represents.
     *
     * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
     */
    description: z.ZodOptional<z.ZodString>;
    /**
     * The MIME type of this resource, if known.
     */
    mimeType: z.ZodOptional<z.ZodString>;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}>, {
    /**
     * Optional set of sized icons that the client can display in a user interface.
     *
     * Clients that support rendering icons MUST support at least the following MIME types:
     * - `image/png` - PNG images (safe, universal compatibility)
     * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
     *
     * Clients that support rendering icons SHOULD also support:
     * - `image/svg+xml` - SVG images (scalable but requires security precautions)
     * - `image/webp` - WebP images (modern, efficient format)
     */
    icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, z.ZodTypeAny, "passthrough">>, "many">>;
}>, {
    type: z.ZodLiteral<"resource_link">;
}>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
    name: z.ZodString;
    /**
     * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
     * even by those unfamiliar with domain-specific terminology.
     *
     * If not provided, the name should be used for display (except for Tool,
     * where `annotations.title` should be given precedence over using `name`,
     * if present).
     */
    title: z.ZodOptional<z.ZodString>;
}, {
    /**
     * The URI of this resource.
     */
    uri: z.ZodString;
    /**
     * A description of what this resource represents.
     *
     * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
     */
    description: z.ZodOptional<z.ZodString>;
    /**
     * The MIME type of this resource, if known.
     */
    mimeType: z.ZodOptional<z.ZodString>;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}>, {
    /**
     * Optional set of sized icons that the client can display in a user interface.
     *
     * Clients that support rendering icons MUST support at least the following MIME types:
     * - `image/png` - PNG images (safe, universal compatibility)
     * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
     *
     * Clients that support rendering icons SHOULD also support:
     * - `image/svg+xml` - SVG images (scalable but requires security precautions)
     * - `image/webp` - WebP images (modern, efficient format)
     */
    icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, z.ZodTypeAny, "passthrough">>, "many">>;
}>, {
    type: z.ZodLiteral<"resource_link">;
}>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
    name: z.ZodString;
    /**
     * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
     * even by those unfamiliar with domain-specific terminology.
     *
     * If not provided, the name should be used for display (except for Tool,
     * where `annotations.title` should be given precedence over using `name`,
     * if present).
     */
    title: z.ZodOptional<z.ZodString>;
}, {
    /**
     * The URI of this resource.
     */
    uri: z.ZodString;
    /**
     * A description of what this resource represents.
     *
     * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
     */
    description: z.ZodOptional<z.ZodString>;
    /**
     * The MIME type of this resource, if known.
     */
    mimeType: z.ZodOptional<z.ZodString>;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}>, {
    /**
     * Optional set of sized icons that the client can display in a user interface.
     *
     * Clients that support rendering icons MUST support at least the following MIME types:
     * - `image/png` - PNG images (safe, universal compatibility)
     * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
     *
     * Clients that support rendering icons SHOULD also support:
     * - `image/svg+xml` - SVG images (scalable but requires security precautions)
     * - `image/webp` - WebP images (modern, efficient format)
     */
    icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, z.ZodTypeAny, "passthrough">>, "many">>;
}>, {
    type: z.ZodLiteral<"resource_link">;
}>, z.ZodTypeAny, "passthrough">>, z.ZodObject<{
    type: z.ZodLiteral<"resource">;
    resource: z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
         */
        text: z.ZodString;
    }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
         */
        text: z.ZodString;
    }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
         */
        text: z.ZodString;
    }>, z.ZodTypeAny, "passthrough">>, z.ZodObject<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * A base64-encoded string representing the binary data of the item.
         */
        blob: z.ZodEffects<z.ZodString, string, string>;
    }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * A base64-encoded string representing the binary data of the item.
         */
        blob: z.ZodEffects<z.ZodString, string, string>;
    }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * A base64-encoded string representing the binary data of the item.
         */
        blob: z.ZodEffects<z.ZodString, string, string>;
    }>, z.ZodTypeAny, "passthrough">>]>;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    type: z.ZodLiteral<"resource">;
    resource: z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
         */
        text: z.ZodString;
    }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
         */
        text: z.ZodString;
    }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
         */
        text: z.ZodString;
    }>, z.ZodTypeAny, "passthrough">>, z.ZodObject<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * A base64-encoded string representing the binary data of the item.
         */
        blob: z.ZodEffects<z.ZodString, string, string>;
    }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * A base64-encoded string representing the binary data of the item.
         */
        blob: z.ZodEffects<z.ZodString, string, string>;
    }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * A base64-encoded string representing the binary data of the item.
         */
        blob: z.ZodEffects<z.ZodString, string, string>;
    }>, z.ZodTypeAny, "passthrough">>]>;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    type: z.ZodLiteral<"resource">;
    resource: z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
         */
        text: z.ZodString;
    }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
         */
        text: z.ZodString;
    }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
         */
        text: z.ZodString;
    }>, z.ZodTypeAny, "passthrough">>, z.ZodObject<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * A base64-encoded string representing the binary data of the item.
         */
        blob: z.ZodEffects<z.ZodString, string, string>;
    }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * A base64-encoded string representing the binary data of the item.
         */
        blob: z.ZodEffects<z.ZodString, string, string>;
    }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * A base64-encoded string representing the binary data of the item.
         */
        blob: z.ZodEffects<z.ZodString, string, string>;
    }>, z.ZodTypeAny, "passthrough">>]>;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, z.ZodTypeAny, "passthrough">>]>;
/**
 * Describes a message returned as part of a prompt.
 */
export declare const PromptMessageSchema: z.ZodObject<{
    role: z.ZodEnum<["user", "assistant"]>;
    content: z.ZodUnion<[z.ZodObject<{
        type: z.ZodLiteral<"text">;
        /**
         * The text content of the message.
         */
        text: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        type: z.ZodLiteral<"text">;
        /**
         * The text content of the message.
         */
        text: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        type: z.ZodLiteral<"text">;
        /**
         * The text content of the message.
         */
        text: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>, z.ZodObject<{
        type: z.ZodLiteral<"image">;
        /**
         * The base64-encoded image data.
         */
        data: z.ZodEffects<z.ZodString, string, string>;
        /**
         * The MIME type of the image. Different providers may support different image types.
         */
        mimeType: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        type: z.ZodLiteral<"image">;
        /**
         * The base64-encoded image data.
         */
        data: z.ZodEffects<z.ZodString, string, string>;
        /**
         * The MIME type of the image. Different providers may support different image types.
         */
        mimeType: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        type: z.ZodLiteral<"image">;
        /**
         * The base64-encoded image data.
         */
        data: z.ZodEffects<z.ZodString, string, string>;
        /**
         * The MIME type of the image. Different providers may support different image types.
         */
        mimeType: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>, z.ZodObject<{
        type: z.ZodLiteral<"audio">;
        /**
         * The base64-encoded audio data.
         */
        data: z.ZodEffects<z.ZodString, string, string>;
        /**
         * The MIME type of the audio. Different providers may support different audio types.
         */
        mimeType: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        type: z.ZodLiteral<"audio">;
        /**
         * The base64-encoded audio data.
         */
        data: z.ZodEffects<z.ZodString, string, string>;
        /**
         * The MIME type of the audio. Different providers may support different audio types.
         */
        mimeType: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        type: z.ZodLiteral<"audio">;
        /**
         * The base64-encoded audio data.
         */
        data: z.ZodEffects<z.ZodString, string, string>;
        /**
         * The MIME type of the audio. Different providers may support different audio types.
         */
        mimeType: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>, z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * A description of what this resource represents.
         *
         * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">>, "many">>;
    }>, {
        type: z.ZodLiteral<"resource_link">;
    }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * A description of what this resource represents.
         *
         * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">>, "many">>;
    }>, {
        type: z.ZodLiteral<"resource_link">;
    }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * A description of what this resource represents.
         *
         * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">>, "many">>;
    }>, {
        type: z.ZodLiteral<"resource_link">;
    }>, z.ZodTypeAny, "passthrough">>, z.ZodObject<{
        type: z.ZodLiteral<"resource">;
        resource: z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, {
            /**
             * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
             */
            text: z.ZodString;
        }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, {
            /**
             * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
             */
            text: z.ZodString;
        }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, {
            /**
             * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
             */
            text: z.ZodString;
        }>, z.ZodTypeAny, "passthrough">>, z.ZodObject<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, {
            /**
             * A base64-encoded string representing the binary data of the item.
             */
            blob: z.ZodEffects<z.ZodString, string, string>;
        }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, {
            /**
             * A base64-encoded string representing the binary data of the item.
             */
            blob: z.ZodEffects<z.ZodString, string, string>;
        }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, {
            /**
             * A base64-encoded string representing the binary data of the item.
             */
            blob: z.ZodEffects<z.ZodString, string, string>;
        }>, z.ZodTypeAny, "passthrough">>]>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        type: z.ZodLiteral<"resource">;
        resource: z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, {
            /**
             * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
             */
            text: z.ZodString;
        }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, {
            /**
             * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
             */
            text: z.ZodString;
        }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, {
            /**
             * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
             */
            text: z.ZodString;
        }>, z.ZodTypeAny, "passthrough">>, z.ZodObject<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, {
            /**
             * A base64-encoded string representing the binary data of the item.
             */
            blob: z.ZodEffects<z.ZodString, string, string>;
        }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, {
            /**
             * A base64-encoded string representing the binary data of the item.
             */
            blob: z.ZodEffects<z.ZodString, string, string>;
        }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, {
            /**
             * A base64-encoded string representing the binary data of the item.
             */
            blob: z.ZodEffects<z.ZodString, string, string>;
        }>, z.ZodTypeAny, "passthrough">>]>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        type: z.ZodLiteral<"resource">;
        resource: z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, {
            /**
             * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
             */
            text: z.ZodString;
        }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, {
            /**
             * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
             */
            text: z.ZodString;
        }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, {
            /**
             * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
             */
            text: z.ZodString;
        }>, z.ZodTypeAny, "passthrough">>, z.ZodObject<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, {
            /**
             * A base64-encoded string representing the binary data of the item.
             */
            blob: z.ZodEffects<z.ZodString, string, string>;
        }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, {
            /**
             * A base64-encoded string representing the binary data of the item.
             */
            blob: z.ZodEffects<z.ZodString, string, string>;
        }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, {
            /**
             * A base64-encoded string representing the binary data of the item.
             */
            blob: z.ZodEffects<z.ZodString, string, string>;
        }>, z.ZodTypeAny, "passthrough">>]>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>]>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    role: z.ZodEnum<["user", "assistant"]>;
    content: z.ZodUnion<[z.ZodObject<{
        type: z.ZodLiteral<"text">;
        /**
         * The text content of the message.
         */
        text: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        type: z.ZodLiteral<"text">;
        /**
         * The text content of the message.
         */
        text: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        type: z.ZodLiteral<"text">;
        /**
         * The text content of the message.
         */
        text: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>, z.ZodObject<{
        type: z.ZodLiteral<"image">;
        /**
         * The base64-encoded image data.
         */
        data: z.ZodEffects<z.ZodString, string, string>;
        /**
         * The MIME type of the image. Different providers may support different image types.
         */
        mimeType: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        type: z.ZodLiteral<"image">;
        /**
         * The base64-encoded image data.
         */
        data: z.ZodEffects<z.ZodString, string, string>;
        /**
         * The MIME type of the image. Different providers may support different image types.
         */
        mimeType: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        type: z.ZodLiteral<"image">;
        /**
         * The base64-encoded image data.
         */
        data: z.ZodEffects<z.ZodString, string, string>;
        /**
         * The MIME type of the image. Different providers may support different image types.
         */
        mimeType: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>, z.ZodObject<{
        type: z.ZodLiteral<"audio">;
        /**
         * The base64-encoded audio data.
         */
        data: z.ZodEffects<z.ZodString, string, string>;
        /**
         * The MIME type of the audio. Different providers may support different audio types.
         */
        mimeType: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        type: z.ZodLiteral<"audio">;
        /**
         * The base64-encoded audio data.
         */
        data: z.ZodEffects<z.ZodString, string, string>;
        /**
         * The MIME type of the audio. Different providers may support different audio types.
         */
        mimeType: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        type: z.ZodLiteral<"audio">;
        /**
         * The base64-encoded audio data.
         */
        data: z.ZodEffects<z.ZodString, string, string>;
        /**
         * The MIME type of the audio. Different providers may support different audio types.
         */
        mimeType: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>, z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * A description of what this resource represents.
         *
         * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">>, "many">>;
    }>, {
        type: z.ZodLiteral<"resource_link">;
    }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * A description of what this resource represents.
         *
         * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">>, "many">>;
    }>, {
        type: z.ZodLiteral<"resource_link">;
    }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * A description of what this resource represents.
         *
         * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">>, "many">>;
    }>, {
        type: z.ZodLiteral<"resource_link">;
    }>, z.ZodTypeAny, "passthrough">>, z.ZodObject<{
        type: z.ZodLiteral<"resource">;
        resource: z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, {
            /**
             * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
             */
            text: z.ZodString;
        }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, {
            /**
             * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
             */
            text: z.ZodString;
        }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, {
            /**
             * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
             */
            text: z.ZodString;
        }>, z.ZodTypeAny, "passthrough">>, z.ZodObject<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, {
            /**
             * A base64-encoded string representing the binary data of the item.
             */
            blob: z.ZodEffects<z.ZodString, string, string>;
        }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, {
            /**
             * A base64-encoded string representing the binary data of the item.
             */
            blob: z.ZodEffects<z.ZodString, string, string>;
        }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, {
            /**
             * A base64-encoded string representing the binary data of the item.
             */
            blob: z.ZodEffects<z.ZodString, string, string>;
        }>, z.ZodTypeAny, "passthrough">>]>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        type: z.ZodLiteral<"resource">;
        resource: z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, {
            /**
             * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
             */
            text: z.ZodString;
        }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, {
            /**
             * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
             */
            text: z.ZodString;
        }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, {
            /**
             * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
             */
            text: z.ZodString;
        }>, z.ZodTypeAny, "passthrough">>, z.ZodObject<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, {
            /**
             * A base64-encoded string representing the binary data of the item.
             */
            blob: z.ZodEffects<z.ZodString, string, string>;
        }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, {
            /**
             * A base64-encoded string representing the binary data of the item.
             */
            blob: z.ZodEffects<z.ZodString, string, string>;
        }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, {
            /**
             * A base64-encoded string representing the binary data of the item.
             */
            blob: z.ZodEffects<z.ZodString, string, string>;
        }>, z.ZodTypeAny, "passthrough">>]>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        type: z.ZodLiteral<"resource">;
        resource: z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, {
            /**
             * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
             */
            text: z.ZodString;
        }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, {
            /**
             * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
             */
            text: z.ZodString;
        }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, {
            /**
             * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
             */
            text: z.ZodString;
        }>, z.ZodTypeAny, "passthrough">>, z.ZodObject<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, {
            /**
             * A base64-encoded string representing the binary data of the item.
             */
            blob: z.ZodEffects<z.ZodString, string, string>;
        }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, {
            /**
             * A base64-encoded string representing the binary data of the item.
             */
            blob: z.ZodEffects<z.ZodString, string, string>;
        }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, {
            /**
             * A base64-encoded string representing the binary data of the item.
             */
            blob: z.ZodEffects<z.ZodString, string, string>;
        }>, z.ZodTypeAny, "passthrough">>]>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>]>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    role: z.ZodEnum<["user", "assistant"]>;
    content: z.ZodUnion<[z.ZodObject<{
        type: z.ZodLiteral<"text">;
        /**
         * The text content of the message.
         */
        text: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        type: z.ZodLiteral<"text">;
        /**
         * The text content of the message.
         */
        text: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        type: z.ZodLiteral<"text">;
        /**
         * The text content of the message.
         */
        text: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>, z.ZodObject<{
        type: z.ZodLiteral<"image">;
        /**
         * The base64-encoded image data.
         */
        data: z.ZodEffects<z.ZodString, string, string>;
        /**
         * The MIME type of the image. Different providers may support different image types.
         */
        mimeType: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        type: z.ZodLiteral<"image">;
        /**
         * The base64-encoded image data.
         */
        data: z.ZodEffects<z.ZodString, string, string>;
        /**
         * The MIME type of the image. Different providers may support different image types.
         */
        mimeType: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        type: z.ZodLiteral<"image">;
        /**
         * The base64-encoded image data.
         */
        data: z.ZodEffects<z.ZodString, string, string>;
        /**
         * The MIME type of the image. Different providers may support different image types.
         */
        mimeType: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>, z.ZodObject<{
        type: z.ZodLiteral<"audio">;
        /**
         * The base64-encoded audio data.
         */
        data: z.ZodEffects<z.ZodString, string, string>;
        /**
         * The MIME type of the audio. Different providers may support different audio types.
         */
        mimeType: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        type: z.ZodLiteral<"audio">;
        /**
         * The base64-encoded audio data.
         */
        data: z.ZodEffects<z.ZodString, string, string>;
        /**
         * The MIME type of the audio. Different providers may support different audio types.
         */
        mimeType: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        type: z.ZodLiteral<"audio">;
        /**
         * The base64-encoded audio data.
         */
        data: z.ZodEffects<z.ZodString, string, string>;
        /**
         * The MIME type of the audio. Different providers may support different audio types.
         */
        mimeType: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>, z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * A description of what this resource represents.
         *
         * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">>, "many">>;
    }>, {
        type: z.ZodLiteral<"resource_link">;
    }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * A description of what this resource represents.
         *
         * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">>, "many">>;
    }>, {
        type: z.ZodLiteral<"resource_link">;
    }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * A description of what this resource represents.
         *
         * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, z.ZodTypeAny, "passthrough">>, "many">>;
    }>, {
        type: z.ZodLiteral<"resource_link">;
    }>, z.ZodTypeAny, "passthrough">>, z.ZodObject<{
        type: z.ZodLiteral<"resource">;
        resource: z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, {
            /**
             * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
             */
            text: z.ZodString;
        }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, {
            /**
             * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
             */
            text: z.ZodString;
        }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, {
            /**
             * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
             */
            text: z.ZodString;
        }>, z.ZodTypeAny, "passthrough">>, z.ZodObject<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, {
            /**
             * A base64-encoded string representing the binary data of the item.
             */
            blob: z.ZodEffects<z.ZodString, string, string>;
        }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, {
            /**
             * A base64-encoded string representing the binary data of the item.
             */
            blob: z.ZodEffects<z.ZodString, string, string>;
        }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, {
            /**
             * A base64-encoded string representing the binary data of the item.
             */
            blob: z.ZodEffects<z.ZodString, string, string>;
        }>, z.ZodTypeAny, "passthrough">>]>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        type: z.ZodLiteral<"resource">;
        resource: z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, {
            /**
             * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
             */
            text: z.ZodString;
        }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, {
            /**
             * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
             */
            text: z.ZodString;
        }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, {
            /**
             * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
             */
            text: z.ZodString;
        }>, z.ZodTypeAny, "passthrough">>, z.ZodObject<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, {
            /**
             * A base64-encoded string representing the binary data of the item.
             */
            blob: z.ZodEffects<z.ZodString, string, string>;
        }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, {
            /**
             * A base64-encoded string representing the binary data of the item.
             */
            blob: z.ZodEffects<z.ZodString, string, string>;
        }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, {
            /**
             * A base64-encoded string representing the binary data of the item.
             */
            blob: z.ZodEffects<z.ZodString, string, string>;
        }>, z.ZodTypeAny, "passthrough">>]>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        type: z.ZodLiteral<"resource">;
        resource: z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, {
            /**
             * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
             */
            text: z.ZodString;
        }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, {
            /**
             * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
             */
            text: z.ZodString;
        }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, {
            /**
             * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
             */
            text: z.ZodString;
        }>, z.ZodTypeAny, "passthrough">>, z.ZodObject<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, {
            /**
             * A base64-encoded string representing the binary data of the item.
             */
            blob: z.ZodEffects<z.ZodString, string, string>;
        }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, {
            /**
             * A base64-encoded string representing the binary data of the item.
             */
            blob: z.ZodEffects<z.ZodString, string, string>;
        }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, {
            /**
             * A base64-encoded string representing the binary data of the item.
             */
            blob: z.ZodEffects<z.ZodString, string, string>;
        }>, z.ZodTypeAny, "passthrough">>]>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>]>;
}, z.ZodTypeAny, "passthrough">>;
/**
 * The server's response to a prompts/get request from the client.
 */
export declare const GetPromptResultSchema: z.ZodObject<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, {
    /**
     * An optional description for the prompt.
     */
    description: z.ZodOptional<z.ZodString>;
    messages: z.ZodArray<z.ZodObject<{
        role: z.ZodEnum<["user", "assistant"]>;
        content: z.ZodUnion<[z.ZodObject<{
            type: z.ZodLiteral<"text">;
            /**
             * The text content of the message.
             */
            text: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            type: z.ZodLiteral<"text">;
            /**
             * The text content of the message.
             */
            text: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            type: z.ZodLiteral<"text">;
            /**
             * The text content of the message.
             */
            text: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">>, z.ZodObject<{
            type: z.ZodLiteral<"image">;
            /**
             * The base64-encoded image data.
             */
            data: z.ZodEffects<z.ZodString, string, string>;
            /**
             * The MIME type of the image. Different providers may support different image types.
             */
            mimeType: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            type: z.ZodLiteral<"image">;
            /**
             * The base64-encoded image data.
             */
            data: z.ZodEffects<z.ZodString, string, string>;
            /**
             * The MIME type of the image. Different providers may support different image types.
             */
            mimeType: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            type: z.ZodLiteral<"image">;
            /**
             * The base64-encoded image data.
             */
            data: z.ZodEffects<z.ZodString, string, string>;
            /**
             * The MIME type of the image. Different providers may support different image types.
             */
            mimeType: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">>, z.ZodObject<{
            type: z.ZodLiteral<"audio">;
            /**
             * The base64-encoded audio data.
             */
            data: z.ZodEffects<z.ZodString, string, string>;
            /**
             * The MIME type of the audio. Different providers may support different audio types.
             */
            mimeType: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            type: z.ZodLiteral<"audio">;
            /**
             * The base64-encoded audio data.
             */
            data: z.ZodEffects<z.ZodString, string, string>;
            /**
             * The MIME type of the audio. Different providers may support different audio types.
             */
            mimeType: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            type: z.ZodLiteral<"audio">;
            /**
             * The base64-encoded audio data.
             */
            data: z.ZodEffects<z.ZodString, string, string>;
            /**
             * The MIME type of the audio. Different providers may support different audio types.
             */
            mimeType: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">>, z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<z.objectUtil.extendShape<{
            /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
            name: z.ZodString;
            /**
             * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
             * even by those unfamiliar with domain-specific terminology.
             *
             * If not provided, the name should be used for display (except for Tool,
             * where `annotations.title` should be given precedence over using `name`,
             * if present).
             */
            title: z.ZodOptional<z.ZodString>;
        }, {
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * A description of what this resource represents.
             *
             * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
             */
            description: z.ZodOptional<z.ZodString>;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }>, {
            /**
             * Optional set of sized icons that the client can display in a user interface.
             *
             * Clients that support rendering icons MUST support at least the following MIME types:
             * - `image/png` - PNG images (safe, universal compatibility)
             * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
             *
             * Clients that support rendering icons SHOULD also support:
             * - `image/svg+xml` - SVG images (scalable but requires security precautions)
             * - `image/webp` - WebP images (modern, efficient format)
             */
            icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">>, "many">>;
        }>, {
            type: z.ZodLiteral<"resource_link">;
        }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<z.objectUtil.extendShape<z.objectUtil.extendShape<{
            /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
            name: z.ZodString;
            /**
             * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
             * even by those unfamiliar with domain-specific terminology.
             *
             * If not provided, the name should be used for display (except for Tool,
             * where `annotations.title` should be given precedence over using `name`,
             * if present).
             */
            title: z.ZodOptional<z.ZodString>;
        }, {
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * A description of what this resource represents.
             *
             * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
             */
            description: z.ZodOptional<z.ZodString>;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }>, {
            /**
             * Optional set of sized icons that the client can display in a user interface.
             *
             * Clients that support rendering icons MUST support at least the following MIME types:
             * - `image/png` - PNG images (safe, universal compatibility)
             * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
             *
             * Clients that support rendering icons SHOULD also support:
             * - `image/svg+xml` - SVG images (scalable but requires security precautions)
             * - `image/webp` - WebP images (modern, efficient format)
             */
            icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">>, "many">>;
        }>, {
            type: z.ZodLiteral<"resource_link">;
        }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<z.objectUtil.extendShape<z.objectUtil.extendShape<{
            /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
            name: z.ZodString;
            /**
             * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
             * even by those unfamiliar with domain-specific terminology.
             *
             * If not provided, the name should be used for display (except for Tool,
             * where `annotations.title` should be given precedence over using `name`,
             * if present).
             */
            title: z.ZodOptional<z.ZodString>;
        }, {
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * A description of what this resource represents.
             *
             * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
             */
            description: z.ZodOptional<z.ZodString>;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }>, {
            /**
             * Optional set of sized icons that the client can display in a user interface.
             *
             * Clients that support rendering icons MUST support at least the following MIME types:
             * - `image/png` - PNG images (safe, universal compatibility)
             * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
             *
             * Clients that support rendering icons SHOULD also support:
             * - `image/svg+xml` - SVG images (scalable but requires security precautions)
             * - `image/webp` - WebP images (modern, efficient format)
             */
            icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">>, "many">>;
        }>, {
            type: z.ZodLiteral<"resource_link">;
        }>, z.ZodTypeAny, "passthrough">>, z.ZodObject<{
            type: z.ZodLiteral<"resource">;
            resource: z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
                 */
                text: z.ZodString;
            }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
                 */
                text: z.ZodString;
            }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
                 */
                text: z.ZodString;
            }>, z.ZodTypeAny, "passthrough">>, z.ZodObject<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * A base64-encoded string representing the binary data of the item.
                 */
                blob: z.ZodEffects<z.ZodString, string, string>;
            }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * A base64-encoded string representing the binary data of the item.
                 */
                blob: z.ZodEffects<z.ZodString, string, string>;
            }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * A base64-encoded string representing the binary data of the item.
                 */
                blob: z.ZodEffects<z.ZodString, string, string>;
            }>, z.ZodTypeAny, "passthrough">>]>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            type: z.ZodLiteral<"resource">;
            resource: z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
                 */
                text: z.ZodString;
            }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
                 */
                text: z.ZodString;
            }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
                 */
                text: z.ZodString;
            }>, z.ZodTypeAny, "passthrough">>, z.ZodObject<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * A base64-encoded string representing the binary data of the item.
                 */
                blob: z.ZodEffects<z.ZodString, string, string>;
            }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * A base64-encoded string representing the binary data of the item.
                 */
                blob: z.ZodEffects<z.ZodString, string, string>;
            }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * A base64-encoded string representing the binary data of the item.
                 */
                blob: z.ZodEffects<z.ZodString, string, string>;
            }>, z.ZodTypeAny, "passthrough">>]>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            type: z.ZodLiteral<"resource">;
            resource: z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
                 */
                text: z.ZodString;
            }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
                 */
                text: z.ZodString;
            }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
                 */
                text: z.ZodString;
            }>, z.ZodTypeAny, "passthrough">>, z.ZodObject<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * A base64-encoded string representing the binary data of the item.
                 */
                blob: z.ZodEffects<z.ZodString, string, string>;
            }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * A base64-encoded string representing the binary data of the item.
                 */
                blob: z.ZodEffects<z.ZodString, string, string>;
            }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * A base64-encoded string representing the binary data of the item.
                 */
                blob: z.ZodEffects<z.ZodString, string, string>;
            }>, z.ZodTypeAny, "passthrough">>]>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">>]>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        role: z.ZodEnum<["user", "assistant"]>;
        content: z.ZodUnion<[z.ZodObject<{
            type: z.ZodLiteral<"text">;
            /**
             * The text content of the message.
             */
            text: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            type: z.ZodLiteral<"text">;
            /**
             * The text content of the message.
             */
            text: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            type: z.ZodLiteral<"text">;
            /**
             * The text content of the message.
             */
            text: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">>, z.ZodObject<{
            type: z.ZodLiteral<"image">;
            /**
             * The base64-encoded image data.
             */
            data: z.ZodEffects<z.ZodString, string, string>;
            /**
             * The MIME type of the image. Different providers may support different image types.
             */
            mimeType: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            type: z.ZodLiteral<"image">;
            /**
             * The base64-encoded image data.
             */
            data: z.ZodEffects<z.ZodString, string, string>;
            /**
             * The MIME type of the image. Different providers may support different image types.
             */
            mimeType: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            type: z.ZodLiteral<"image">;
            /**
             * The base64-encoded image data.
             */
            data: z.ZodEffects<z.ZodString, string, string>;
            /**
             * The MIME type of the image. Different providers may support different image types.
             */
            mimeType: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">>, z.ZodObject<{
            type: z.ZodLiteral<"audio">;
            /**
             * The base64-encoded audio data.
             */
            data: z.ZodEffects<z.ZodString, string, string>;
            /**
             * The MIME type of the audio. Different providers may support different audio types.
             */
            mimeType: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            type: z.ZodLiteral<"audio">;
            /**
             * The base64-encoded audio data.
             */
            data: z.ZodEffects<z.ZodString, string, string>;
            /**
             * The MIME type of the audio. Different providers may support different audio types.
             */
            mimeType: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            type: z.ZodLiteral<"audio">;
            /**
             * The base64-encoded audio data.
             */
            data: z.ZodEffects<z.ZodString, string, string>;
            /**
             * The MIME type of the audio. Different providers may support different audio types.
             */
            mimeType: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">>, z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<z.objectUtil.extendShape<{
            /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
            name: z.ZodString;
            /**
             * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
             * even by those unfamiliar with domain-specific terminology.
             *
             * If not provided, the name should be used for display (except for Tool,
             * where `annotations.title` should be given precedence over using `name`,
             * if present).
             */
            title: z.ZodOptional<z.ZodString>;
        }, {
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * A description of what this resource represents.
             *
             * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
             */
            description: z.ZodOptional<z.ZodString>;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }>, {
            /**
             * Optional set of sized icons that the client can display in a user interface.
             *
             * Clients that support rendering icons MUST support at least the following MIME types:
             * - `image/png` - PNG images (safe, universal compatibility)
             * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
             *
             * Clients that support rendering icons SHOULD also support:
             * - `image/svg+xml` - SVG images (scalable but requires security precautions)
             * - `image/webp` - WebP images (modern, efficient format)
             */
            icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">>, "many">>;
        }>, {
            type: z.ZodLiteral<"resource_link">;
        }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<z.objectUtil.extendShape<z.objectUtil.extendShape<{
            /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
            name: z.ZodString;
            /**
             * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
             * even by those unfamiliar with domain-specific terminology.
             *
             * If not provided, the name should be used for display (except for Tool,
             * where `annotations.title` should be given precedence over using `name`,
             * if present).
             */
            title: z.ZodOptional<z.ZodString>;
        }, {
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * A description of what this resource represents.
             *
             * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
             */
            description: z.ZodOptional<z.ZodString>;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }>, {
            /**
             * Optional set of sized icons that the client can display in a user interface.
             *
             * Clients that support rendering icons MUST support at least the following MIME types:
             * - `image/png` - PNG images (safe, universal compatibility)
             * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
             *
             * Clients that support rendering icons SHOULD also support:
             * - `image/svg+xml` - SVG images (scalable but requires security precautions)
             * - `image/webp` - WebP images (modern, efficient format)
             */
            icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">>, "many">>;
        }>, {
            type: z.ZodLiteral<"resource_link">;
        }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<z.objectUtil.extendShape<z.objectUtil.extendShape<{
            /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
            name: z.ZodString;
            /**
             * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
             * even by those unfamiliar with domain-specific terminology.
             *
             * If not provided, the name should be used for display (except for Tool,
             * where `annotations.title` should be given precedence over using `name`,
             * if present).
             */
            title: z.ZodOptional<z.ZodString>;
        }, {
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * A description of what this resource represents.
             *
             * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
             */
            description: z.ZodOptional<z.ZodString>;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }>, {
            /**
             * Optional set of sized icons that the client can display in a user interface.
             *
             * Clients that support rendering icons MUST support at least the following MIME types:
             * - `image/png` - PNG images (safe, universal compatibility)
             * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
             *
             * Clients that support rendering icons SHOULD also support:
             * - `image/svg+xml` - SVG images (scalable but requires security precautions)
             * - `image/webp` - WebP images (modern, efficient format)
             */
            icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">>, "many">>;
        }>, {
            type: z.ZodLiteral<"resource_link">;
        }>, z.ZodTypeAny, "passthrough">>, z.ZodObject<{
            type: z.ZodLiteral<"resource">;
            resource: z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
                 */
                text: z.ZodString;
            }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
                 */
                text: z.ZodString;
            }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
                 */
                text: z.ZodString;
            }>, z.ZodTypeAny, "passthrough">>, z.ZodObject<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * A base64-encoded string representing the binary data of the item.
                 */
                blob: z.ZodEffects<z.ZodString, string, string>;
            }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * A base64-encoded string representing the binary data of the item.
                 */
                blob: z.ZodEffects<z.ZodString, string, string>;
            }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * A base64-encoded string representing the binary data of the item.
                 */
                blob: z.ZodEffects<z.ZodString, string, string>;
            }>, z.ZodTypeAny, "passthrough">>]>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            type: z.ZodLiteral<"resource">;
            resource: z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
                 */
                text: z.ZodString;
            }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
                 */
                text: z.ZodString;
            }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
                 */
                text: z.ZodString;
            }>, z.ZodTypeAny, "passthrough">>, z.ZodObject<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * A base64-encoded string representing the binary data of the item.
                 */
                blob: z.ZodEffects<z.ZodString, string, string>;
            }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * A base64-encoded string representing the binary data of the item.
                 */
                blob: z.ZodEffects<z.ZodString, string, string>;
            }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * A base64-encoded string representing the binary data of the item.
                 */
                blob: z.ZodEffects<z.ZodString, string, string>;
            }>, z.ZodTypeAny, "passthrough">>]>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            type: z.ZodLiteral<"resource">;
            resource: z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
                 */
                text: z.ZodString;
            }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
                 */
                text: z.ZodString;
            }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
                 */
                text: z.ZodString;
            }>, z.ZodTypeAny, "passthrough">>, z.ZodObject<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * A base64-encoded string representing the binary data of the item.
                 */
                blob: z.ZodEffects<z.ZodString, string, string>;
            }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * A base64-encoded string representing the binary data of the item.
                 */
                blob: z.ZodEffects<z.ZodString, string, string>;
            }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * A base64-encoded string representing the binary data of the item.
                 */
                blob: z.ZodEffects<z.ZodString, string, string>;
            }>, z.ZodTypeAny, "passthrough">>]>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">>]>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        role: z.ZodEnum<["user", "assistant"]>;
        content: z.ZodUnion<[z.ZodObject<{
            type: z.ZodLiteral<"text">;
            /**
             * The text content of the message.
             */
            text: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            type: z.ZodLiteral<"text">;
            /**
             * The text content of the message.
             */
            text: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            type: z.ZodLiteral<"text">;
            /**
             * The text content of the message.
             */
            text: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">>, z.ZodObject<{
            type: z.ZodLiteral<"image">;
            /**
             * The base64-encoded image data.
             */
            data: z.ZodEffects<z.ZodString, string, string>;
            /**
             * The MIME type of the image. Different providers may support different image types.
             */
            mimeType: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            type: z.ZodLiteral<"image">;
            /**
             * The base64-encoded image data.
             */
            data: z.ZodEffects<z.ZodString, string, string>;
            /**
             * The MIME type of the image. Different providers may support different image types.
             */
            mimeType: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            type: z.ZodLiteral<"image">;
            /**
             * The base64-encoded image data.
             */
            data: z.ZodEffects<z.ZodString, string, string>;
            /**
             * The MIME type of the image. Different providers may support different image types.
             */
            mimeType: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">>, z.ZodObject<{
            type: z.ZodLiteral<"audio">;
            /**
             * The base64-encoded audio data.
             */
            data: z.ZodEffects<z.ZodString, string, string>;
            /**
             * The MIME type of the audio. Different providers may support different audio types.
             */
            mimeType: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            type: z.ZodLiteral<"audio">;
            /**
             * The base64-encoded audio data.
             */
            data: z.ZodEffects<z.ZodString, string, string>;
            /**
             * The MIME type of the audio. Different providers may support different audio types.
             */
            mimeType: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            type: z.ZodLiteral<"audio">;
            /**
             * The base64-encoded audio data.
             */
            data: z.ZodEffects<z.ZodString, string, string>;
            /**
             * The MIME type of the audio. Different providers may support different audio types.
             */
            mimeType: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">>, z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<z.objectUtil.extendShape<{
            /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
            name: z.ZodString;
            /**
             * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
             * even by those unfamiliar with domain-specific terminology.
             *
             * If not provided, the name should be used for display (except for Tool,
             * where `annotations.title` should be given precedence over using `name`,
             * if present).
             */
            title: z.ZodOptional<z.ZodString>;
        }, {
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * A description of what this resource represents.
             *
             * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
             */
            description: z.ZodOptional<z.ZodString>;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }>, {
            /**
             * Optional set of sized icons that the client can display in a user interface.
             *
             * Clients that support rendering icons MUST support at least the following MIME types:
             * - `image/png` - PNG images (safe, universal compatibility)
             * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
             *
             * Clients that support rendering icons SHOULD also support:
             * - `image/svg+xml` - SVG images (scalable but requires security precautions)
             * - `image/webp` - WebP images (modern, efficient format)
             */
            icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">>, "many">>;
        }>, {
            type: z.ZodLiteral<"resource_link">;
        }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<z.objectUtil.extendShape<z.objectUtil.extendShape<{
            /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
            name: z.ZodString;
            /**
             * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
             * even by those unfamiliar with domain-specific terminology.
             *
             * If not provided, the name should be used for display (except for Tool,
             * where `annotations.title` should be given precedence over using `name`,
             * if present).
             */
            title: z.ZodOptional<z.ZodString>;
        }, {
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * A description of what this resource represents.
             *
             * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
             */
            description: z.ZodOptional<z.ZodString>;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }>, {
            /**
             * Optional set of sized icons that the client can display in a user interface.
             *
             * Clients that support rendering icons MUST support at least the following MIME types:
             * - `image/png` - PNG images (safe, universal compatibility)
             * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
             *
             * Clients that support rendering icons SHOULD also support:
             * - `image/svg+xml` - SVG images (scalable but requires security precautions)
             * - `image/webp` - WebP images (modern, efficient format)
             */
            icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">>, "many">>;
        }>, {
            type: z.ZodLiteral<"resource_link">;
        }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<z.objectUtil.extendShape<z.objectUtil.extendShape<{
            /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
            name: z.ZodString;
            /**
             * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
             * even by those unfamiliar with domain-specific terminology.
             *
             * If not provided, the name should be used for display (except for Tool,
             * where `annotations.title` should be given precedence over using `name`,
             * if present).
             */
            title: z.ZodOptional<z.ZodString>;
        }, {
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * A description of what this resource represents.
             *
             * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
             */
            description: z.ZodOptional<z.ZodString>;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }>, {
            /**
             * Optional set of sized icons that the client can display in a user interface.
             *
             * Clients that support rendering icons MUST support at least the following MIME types:
             * - `image/png` - PNG images (safe, universal compatibility)
             * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
             *
             * Clients that support rendering icons SHOULD also support:
             * - `image/svg+xml` - SVG images (scalable but requires security precautions)
             * - `image/webp` - WebP images (modern, efficient format)
             */
            icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">>, "many">>;
        }>, {
            type: z.ZodLiteral<"resource_link">;
        }>, z.ZodTypeAny, "passthrough">>, z.ZodObject<{
            type: z.ZodLiteral<"resource">;
            resource: z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
                 */
                text: z.ZodString;
            }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
                 */
                text: z.ZodString;
            }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
                 */
                text: z.ZodString;
            }>, z.ZodTypeAny, "passthrough">>, z.ZodObject<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * A base64-encoded string representing the binary data of the item.
                 */
                blob: z.ZodEffects<z.ZodString, string, string>;
            }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * A base64-encoded string representing the binary data of the item.
                 */
                blob: z.ZodEffects<z.ZodString, string, string>;
            }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * A base64-encoded string representing the binary data of the item.
                 */
                blob: z.ZodEffects<z.ZodString, string, string>;
            }>, z.ZodTypeAny, "passthrough">>]>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            type: z.ZodLiteral<"resource">;
            resource: z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
                 */
                text: z.ZodString;
            }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
                 */
                text: z.ZodString;
            }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
                 */
                text: z.ZodString;
            }>, z.ZodTypeAny, "passthrough">>, z.ZodObject<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * A base64-encoded string representing the binary data of the item.
                 */
                blob: z.ZodEffects<z.ZodString, string, string>;
            }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * A base64-encoded string representing the binary data of the item.
                 */
                blob: z.ZodEffects<z.ZodString, string, string>;
            }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * A base64-encoded string representing the binary data of the item.
                 */
                blob: z.ZodEffects<z.ZodString, string, string>;
            }>, z.ZodTypeAny, "passthrough">>]>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            type: z.ZodLiteral<"resource">;
            resource: z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
                 */
                text: z.ZodString;
            }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
                 */
                text: z.ZodString;
            }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
                 */
                text: z.ZodString;
            }>, z.ZodTypeAny, "passthrough">>, z.ZodObject<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * A base64-encoded string representing the binary data of the item.
                 */
                blob: z.ZodEffects<z.ZodString, string, string>;
            }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * A base64-encoded string representing the binary data of the item.
                 */
                blob: z.ZodEffects<z.ZodString, string, string>;
            }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * A base64-encoded string representing the binary data of the item.
                 */
                blob: z.ZodEffects<z.ZodString, string, string>;
            }>, z.ZodTypeAny, "passthrough">>]>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">>]>;
    }, z.ZodTypeAny, "passthrough">>, "many">;
}>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}, {
    /**
     * An optional description for the prompt.
     */
    description: z.ZodOptional<z.ZodString>;
    messages: z.ZodArray<z.ZodObject<{
        role: z.ZodEnum<["user", "assistant"]>;
        content: z.ZodUnion<[z.ZodObject<{
            type: z.ZodLiteral<"text">;
            /**
             * The text content of the message.
             */
            text: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            type: z.ZodLiteral<"text">;
            /**
             * The text content of the message.
             */
            text: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            type: z.ZodLiteral<"text">;
            /**
             * The text content of the message.
             */
            text: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">>, z.ZodObject<{
            type: z.ZodLiteral<"image">;
            /**
             * The base64-encoded image data.
             */
            data: z.ZodEffects<z.ZodString, string, string>;
            /**
             * The MIME type of the image. Different providers may support different image types.
             */
            mimeType: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            type: z.ZodLiteral<"image">;
            /**
             * The base64-encoded image data.
             */
            data: z.ZodEffects<z.ZodString, string, string>;
            /**
             * The MIME type of the image. Different providers may support different image types.
             */
            mimeType: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            type: z.ZodLiteral<"image">;
            /**
             * The base64-encoded image data.
             */
            data: z.ZodEffects<z.ZodString, string, string>;
            /**
             * The MIME type of the image. Different providers may support different image types.
             */
            mimeType: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">>, z.ZodObject<{
            type: z.ZodLiteral<"audio">;
            /**
             * The base64-encoded audio data.
             */
            data: z.ZodEffects<z.ZodString, string, string>;
            /**
             * The MIME type of the audio. Different providers may support different audio types.
             */
            mimeType: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            type: z.ZodLiteral<"audio">;
            /**
             * The base64-encoded audio data.
             */
            data: z.ZodEffects<z.ZodString, string, string>;
            /**
             * The MIME type of the audio. Different providers may support different audio types.
             */
            mimeType: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            type: z.ZodLiteral<"audio">;
            /**
             * The base64-encoded audio data.
             */
            data: z.ZodEffects<z.ZodString, string, string>;
            /**
             * The MIME type of the audio. Different providers may support different audio types.
             */
            mimeType: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">>, z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<z.objectUtil.extendShape<{
            /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
            name: z.ZodString;
            /**
             * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
             * even by those unfamiliar with domain-specific terminology.
             *
             * If not provided, the name should be used for display (except for Tool,
             * where `annotations.title` should be given precedence over using `name`,
             * if present).
             */
            title: z.ZodOptional<z.ZodString>;
        }, {
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * A description of what this resource represents.
             *
             * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
             */
            description: z.ZodOptional<z.ZodString>;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }>, {
            /**
             * Optional set of sized icons that the client can display in a user interface.
             *
             * Clients that support rendering icons MUST support at least the following MIME types:
             * - `image/png` - PNG images (safe, universal compatibility)
             * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
             *
             * Clients that support rendering icons SHOULD also support:
             * - `image/svg+xml` - SVG images (scalable but requires security precautions)
             * - `image/webp` - WebP images (modern, efficient format)
             */
            icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">>, "many">>;
        }>, {
            type: z.ZodLiteral<"resource_link">;
        }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<z.objectUtil.extendShape<z.objectUtil.extendShape<{
            /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
            name: z.ZodString;
            /**
             * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
             * even by those unfamiliar with domain-specific terminology.
             *
             * If not provided, the name should be used for display (except for Tool,
             * where `annotations.title` should be given precedence over using `name`,
             * if present).
             */
            title: z.ZodOptional<z.ZodString>;
        }, {
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * A description of what this resource represents.
             *
             * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
             */
            description: z.ZodOptional<z.ZodString>;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }>, {
            /**
             * Optional set of sized icons that the client can display in a user interface.
             *
             * Clients that support rendering icons MUST support at least the following MIME types:
             * - `image/png` - PNG images (safe, universal compatibility)
             * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
             *
             * Clients that support rendering icons SHOULD also support:
             * - `image/svg+xml` - SVG images (scalable but requires security precautions)
             * - `image/webp` - WebP images (modern, efficient format)
             */
            icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">>, "many">>;
        }>, {
            type: z.ZodLiteral<"resource_link">;
        }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<z.objectUtil.extendShape<z.objectUtil.extendShape<{
            /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
            name: z.ZodString;
            /**
             * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
             * even by those unfamiliar with domain-specific terminology.
             *
             * If not provided, the name should be used for display (except for Tool,
             * where `annotations.title` should be given precedence over using `name`,
             * if present).
             */
            title: z.ZodOptional<z.ZodString>;
        }, {
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * A description of what this resource represents.
             *
             * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
             */
            description: z.ZodOptional<z.ZodString>;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }>, {
            /**
             * Optional set of sized icons that the client can display in a user interface.
             *
             * Clients that support rendering icons MUST support at least the following MIME types:
             * - `image/png` - PNG images (safe, universal compatibility)
             * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
             *
             * Clients that support rendering icons SHOULD also support:
             * - `image/svg+xml` - SVG images (scalable but requires security precautions)
             * - `image/webp` - WebP images (modern, efficient format)
             */
            icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">>, "many">>;
        }>, {
            type: z.ZodLiteral<"resource_link">;
        }>, z.ZodTypeAny, "passthrough">>, z.ZodObject<{
            type: z.ZodLiteral<"resource">;
            resource: z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
                 */
                text: z.ZodString;
            }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
                 */
                text: z.ZodString;
            }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
                 */
                text: z.ZodString;
            }>, z.ZodTypeAny, "passthrough">>, z.ZodObject<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * A base64-encoded string representing the binary data of the item.
                 */
                blob: z.ZodEffects<z.ZodString, string, string>;
            }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * A base64-encoded string representing the binary data of the item.
                 */
                blob: z.ZodEffects<z.ZodString, string, string>;
            }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * A base64-encoded string representing the binary data of the item.
                 */
                blob: z.ZodEffects<z.ZodString, string, string>;
            }>, z.ZodTypeAny, "passthrough">>]>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            type: z.ZodLiteral<"resource">;
            resource: z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
                 */
                text: z.ZodString;
            }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
                 */
                text: z.ZodString;
            }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
                 */
                text: z.ZodString;
            }>, z.ZodTypeAny, "passthrough">>, z.ZodObject<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * A base64-encoded string representing the binary data of the item.
                 */
                blob: z.ZodEffects<z.ZodString, string, string>;
            }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * A base64-encoded string representing the binary data of the item.
                 */
                blob: z.ZodEffects<z.ZodString, string, string>;
            }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * A base64-encoded string representing the binary data of the item.
                 */
                blob: z.ZodEffects<z.ZodString, string, string>;
            }>, z.ZodTypeAny, "passthrough">>]>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            type: z.ZodLiteral<"resource">;
            resource: z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
                 */
                text: z.ZodString;
            }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
                 */
                text: z.ZodString;
            }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
                 */
                text: z.ZodString;
            }>, z.ZodTypeAny, "passthrough">>, z.ZodObject<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * A base64-encoded string representing the binary data of the item.
                 */
                blob: z.ZodEffects<z.ZodString, string, string>;
            }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * A base64-encoded string representing the binary data of the item.
                 */
                blob: z.ZodEffects<z.ZodString, string, string>;
            }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * A base64-encoded string representing the binary data of the item.
                 */
                blob: z.ZodEffects<z.ZodString, string, string>;
            }>, z.ZodTypeAny, "passthrough">>]>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">>]>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        role: z.ZodEnum<["user", "assistant"]>;
        content: z.ZodUnion<[z.ZodObject<{
            type: z.ZodLiteral<"text">;
            /**
             * The text content of the message.
             */
            text: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            type: z.ZodLiteral<"text">;
            /**
             * The text content of the message.
             */
            text: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            type: z.ZodLiteral<"text">;
            /**
             * The text content of the message.
             */
            text: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">>, z.ZodObject<{
            type: z.ZodLiteral<"image">;
            /**
             * The base64-encoded image data.
             */
            data: z.ZodEffects<z.ZodString, string, string>;
            /**
             * The MIME type of the image. Different providers may support different image types.
             */
            mimeType: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            type: z.ZodLiteral<"image">;
            /**
             * The base64-encoded image data.
             */
            data: z.ZodEffects<z.ZodString, string, string>;
            /**
             * The MIME type of the image. Different providers may support different image types.
             */
            mimeType: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            type: z.ZodLiteral<"image">;
            /**
             * The base64-encoded image data.
             */
            data: z.ZodEffects<z.ZodString, string, string>;
            /**
             * The MIME type of the image. Different providers may support different image types.
             */
            mimeType: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">>, z.ZodObject<{
            type: z.ZodLiteral<"audio">;
            /**
             * The base64-encoded audio data.
             */
            data: z.ZodEffects<z.ZodString, string, string>;
            /**
             * The MIME type of the audio. Different providers may support different audio types.
             */
            mimeType: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            type: z.ZodLiteral<"audio">;
            /**
             * The base64-encoded audio data.
             */
            data: z.ZodEffects<z.ZodString, string, string>;
            /**
             * The MIME type of the audio. Different providers may support different audio types.
             */
            mimeType: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            type: z.ZodLiteral<"audio">;
            /**
             * The base64-encoded audio data.
             */
            data: z.ZodEffects<z.ZodString, string, string>;
            /**
             * The MIME type of the audio. Different providers may support different audio types.
             */
            mimeType: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">>, z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<z.objectUtil.extendShape<{
            /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
            name: z.ZodString;
            /**
             * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
             * even by those unfamiliar with domain-specific terminology.
             *
             * If not provided, the name should be used for display (except for Tool,
             * where `annotations.title` should be given precedence over using `name`,
             * if present).
             */
            title: z.ZodOptional<z.ZodString>;
        }, {
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * A description of what this resource represents.
             *
             * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
             */
            description: z.ZodOptional<z.ZodString>;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }>, {
            /**
             * Optional set of sized icons that the client can display in a user interface.
             *
             * Clients that support rendering icons MUST support at least the following MIME types:
             * - `image/png` - PNG images (safe, universal compatibility)
             * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
             *
             * Clients that support rendering icons SHOULD also support:
             * - `image/svg+xml` - SVG images (scalable but requires security precautions)
             * - `image/webp` - WebP images (modern, efficient format)
             */
            icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">>, "many">>;
        }>, {
            type: z.ZodLiteral<"resource_link">;
        }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<z.objectUtil.extendShape<z.objectUtil.extendShape<{
            /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
            name: z.ZodString;
            /**
             * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
             * even by those unfamiliar with domain-specific terminology.
             *
             * If not provided, the name should be used for display (except for Tool,
             * where `annotations.title` should be given precedence over using `name`,
             * if present).
             */
            title: z.ZodOptional<z.ZodString>;
        }, {
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * A description of what this resource represents.
             *
             * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
             */
            description: z.ZodOptional<z.ZodString>;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }>, {
            /**
             * Optional set of sized icons that the client can display in a user interface.
             *
             * Clients that support rendering icons MUST support at least the following MIME types:
             * - `image/png` - PNG images (safe, universal compatibility)
             * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
             *
             * Clients that support rendering icons SHOULD also support:
             * - `image/svg+xml` - SVG images (scalable but requires security precautions)
             * - `image/webp` - WebP images (modern, efficient format)
             */
            icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">>, "many">>;
        }>, {
            type: z.ZodLiteral<"resource_link">;
        }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<z.objectUtil.extendShape<z.objectUtil.extendShape<{
            /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
            name: z.ZodString;
            /**
             * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
             * even by those unfamiliar with domain-specific terminology.
             *
             * If not provided, the name should be used for display (except for Tool,
             * where `annotations.title` should be given precedence over using `name`,
             * if present).
             */
            title: z.ZodOptional<z.ZodString>;
        }, {
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * A description of what this resource represents.
             *
             * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
             */
            description: z.ZodOptional<z.ZodString>;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }>, {
            /**
             * Optional set of sized icons that the client can display in a user interface.
             *
             * Clients that support rendering icons MUST support at least the following MIME types:
             * - `image/png` - PNG images (safe, universal compatibility)
             * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
             *
             * Clients that support rendering icons SHOULD also support:
             * - `image/svg+xml` - SVG images (scalable but requires security precautions)
             * - `image/webp` - WebP images (modern, efficient format)
             */
            icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">>, "many">>;
        }>, {
            type: z.ZodLiteral<"resource_link">;
        }>, z.ZodTypeAny, "passthrough">>, z.ZodObject<{
            type: z.ZodLiteral<"resource">;
            resource: z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
                 */
                text: z.ZodString;
            }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
                 */
                text: z.ZodString;
            }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
                 */
                text: z.ZodString;
            }>, z.ZodTypeAny, "passthrough">>, z.ZodObject<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * A base64-encoded string representing the binary data of the item.
                 */
                blob: z.ZodEffects<z.ZodString, string, string>;
            }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * A base64-encoded string representing the binary data of the item.
                 */
                blob: z.ZodEffects<z.ZodString, string, string>;
            }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * A base64-encoded string representing the binary data of the item.
                 */
                blob: z.ZodEffects<z.ZodString, string, string>;
            }>, z.ZodTypeAny, "passthrough">>]>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            type: z.ZodLiteral<"resource">;
            resource: z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
                 */
                text: z.ZodString;
            }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
                 */
                text: z.ZodString;
            }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
                 */
                text: z.ZodString;
            }>, z.ZodTypeAny, "passthrough">>, z.ZodObject<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * A base64-encoded string representing the binary data of the item.
                 */
                blob: z.ZodEffects<z.ZodString, string, string>;
            }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * A base64-encoded string representing the binary data of the item.
                 */
                blob: z.ZodEffects<z.ZodString, string, string>;
            }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * A base64-encoded string representing the binary data of the item.
                 */
                blob: z.ZodEffects<z.ZodString, string, string>;
            }>, z.ZodTypeAny, "passthrough">>]>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            type: z.ZodLiteral<"resource">;
            resource: z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
                 */
                text: z.ZodString;
            }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
                 */
                text: z.ZodString;
            }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
                 */
                text: z.ZodString;
            }>, z.ZodTypeAny, "passthrough">>, z.ZodObject<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * A base64-encoded string representing the binary data of the item.
                 */
                blob: z.ZodEffects<z.ZodString, string, string>;
            }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * A base64-encoded string representing the binary data of the item.
                 */
                blob: z.ZodEffects<z.ZodString, string, string>;
            }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * A base64-encoded string representing the binary data of the item.
                 */
                blob: z.ZodEffects<z.ZodString, string, string>;
            }>, z.ZodTypeAny, "passthrough">>]>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">>]>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        role: z.ZodEnum<["user", "assistant"]>;
        content: z.ZodUnion<[z.ZodObject<{
            type: z.ZodLiteral<"text">;
            /**
             * The text content of the message.
             */
            text: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            type: z.ZodLiteral<"text">;
            /**
             * The text content of the message.
             */
            text: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            type: z.ZodLiteral<"text">;
            /**
             * The text content of the message.
             */
            text: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">>, z.ZodObject<{
            type: z.ZodLiteral<"image">;
            /**
             * The base64-encoded image data.
             */
            data: z.ZodEffects<z.ZodString, string, string>;
            /**
             * The MIME type of the image. Different providers may support different image types.
             */
            mimeType: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            type: z.ZodLiteral<"image">;
            /**
             * The base64-encoded image data.
             */
            data: z.ZodEffects<z.ZodString, string, string>;
            /**
             * The MIME type of the image. Different providers may support different image types.
             */
            mimeType: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            type: z.ZodLiteral<"image">;
            /**
             * The base64-encoded image data.
             */
            data: z.ZodEffects<z.ZodString, string, string>;
            /**
             * The MIME type of the image. Different providers may support different image types.
             */
            mimeType: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">>, z.ZodObject<{
            type: z.ZodLiteral<"audio">;
            /**
             * The base64-encoded audio data.
             */
            data: z.ZodEffects<z.ZodString, string, string>;
            /**
             * The MIME type of the audio. Different providers may support different audio types.
             */
            mimeType: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            type: z.ZodLiteral<"audio">;
            /**
             * The base64-encoded audio data.
             */
            data: z.ZodEffects<z.ZodString, string, string>;
            /**
             * The MIME type of the audio. Different providers may support different audio types.
             */
            mimeType: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            type: z.ZodLiteral<"audio">;
            /**
             * The base64-encoded audio data.
             */
            data: z.ZodEffects<z.ZodString, string, string>;
            /**
             * The MIME type of the audio. Different providers may support different audio types.
             */
            mimeType: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">>, z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<z.objectUtil.extendShape<{
            /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
            name: z.ZodString;
            /**
             * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
             * even by those unfamiliar with domain-specific terminology.
             *
             * If not provided, the name should be used for display (except for Tool,
             * where `annotations.title` should be given precedence over using `name`,
             * if present).
             */
            title: z.ZodOptional<z.ZodString>;
        }, {
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * A description of what this resource represents.
             *
             * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
             */
            description: z.ZodOptional<z.ZodString>;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }>, {
            /**
             * Optional set of sized icons that the client can display in a user interface.
             *
             * Clients that support rendering icons MUST support at least the following MIME types:
             * - `image/png` - PNG images (safe, universal compatibility)
             * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
             *
             * Clients that support rendering icons SHOULD also support:
             * - `image/svg+xml` - SVG images (scalable but requires security precautions)
             * - `image/webp` - WebP images (modern, efficient format)
             */
            icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">>, "many">>;
        }>, {
            type: z.ZodLiteral<"resource_link">;
        }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<z.objectUtil.extendShape<z.objectUtil.extendShape<{
            /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
            name: z.ZodString;
            /**
             * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
             * even by those unfamiliar with domain-specific terminology.
             *
             * If not provided, the name should be used for display (except for Tool,
             * where `annotations.title` should be given precedence over using `name`,
             * if present).
             */
            title: z.ZodOptional<z.ZodString>;
        }, {
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * A description of what this resource represents.
             *
             * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
             */
            description: z.ZodOptional<z.ZodString>;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }>, {
            /**
             * Optional set of sized icons that the client can display in a user interface.
             *
             * Clients that support rendering icons MUST support at least the following MIME types:
             * - `image/png` - PNG images (safe, universal compatibility)
             * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
             *
             * Clients that support rendering icons SHOULD also support:
             * - `image/svg+xml` - SVG images (scalable but requires security precautions)
             * - `image/webp` - WebP images (modern, efficient format)
             */
            icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">>, "many">>;
        }>, {
            type: z.ZodLiteral<"resource_link">;
        }>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<z.objectUtil.extendShape<z.objectUtil.extendShape<{
            /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
            name: z.ZodString;
            /**
             * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
             * even by those unfamiliar with domain-specific terminology.
             *
             * If not provided, the name should be used for display (except for Tool,
             * where `annotations.title` should be given precedence over using `name`,
             * if present).
             */
            title: z.ZodOptional<z.ZodString>;
        }, {
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * A description of what this resource represents.
             *
             * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
             */
            description: z.ZodOptional<z.ZodString>;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }>, {
            /**
             * Optional set of sized icons that the client can display in a user interface.
             *
             * Clients that support rendering icons MUST support at least the following MIME types:
             * - `image/png` - PNG images (safe, universal compatibility)
             * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
             *
             * Clients that support rendering icons SHOULD also support:
             * - `image/svg+xml` - SVG images (scalable but requires security precautions)
             * - `image/webp` - WebP images (modern, efficient format)
             */
            icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough">>, "many">>;
        }>, {
            type: z.ZodLiteral<"resource_link">;
        }>, z.ZodTypeAny, "passthrough">>, z.ZodObject<{
            type: z.ZodLiteral<"resource">;
            resource: z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
            }, {
                /**
                 * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
                 */
                text: z.ZodString;
            }>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
             