pragma Ada_2012;

pragma Style_Checks (Off);
pragma Warnings (Off, "-gnatwu");

with Interfaces.C; use Interfaces.C;
limited with sys_timeb_h;
with pthread_compat_h;

package pthread_time_h is

   TIMER_ABSTIME : constant := 1;  --  D:/M/msys64/ucrt64/include/pthread_time.h:50

   CLOCK_REALTIME : constant := 0;  --  D:/M/msys64/ucrt64/include/pthread_time.h:54

   CLOCK_MONOTONIC : constant := 1;  --  D:/M/msys64/ucrt64/include/pthread_time.h:58

   CLOCK_PROCESS_CPUTIME_ID : constant := 2;  --  D:/M/msys64/ucrt64/include/pthread_time.h:62

   CLOCK_THREAD_CPUTIME_ID : constant := 3;  --  D:/M/msys64/ucrt64/include/pthread_time.h:66

   CLOCK_REALTIME_COARSE : constant := 4;  --  D:/M/msys64/ucrt64/include/pthread_time.h:70

  --   Copyright (c) 2011-2016  mingw-w64 project
  --   Permission is hereby granted, free of charge, to any person obtaining a
  --   copy of this software and associated documentation files (the "Software"),
  --   to deal in the Software without restriction, including without limitation
  --   the rights to use, copy, modify, merge, publish, distribute, sublicense,
  --   and/or sell copies of the Software, and to permit persons to whom the
  --   Software is furnished to do so, subject to the following conditions:
  --   The above copyright notice and this permission notice shall be included in
  --   all copies or substantial portions of the Software.
  --   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  --   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  --   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  --   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  --   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
  --   FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
  --   DEALINGS IN THE SOFTWARE.
  -- 

  -- Posix timers are supported  
  -- Monotonic clocks are available.   
  -- CPU-time clocks are available.   
  -- Clock support in threads are available.   
   function nanosleep32 (request : access constant sys_timeb_h.u_timespec32; remain : access sys_timeb_h.u_timespec32) return int  -- D:/M/msys64/ucrt64/include/pthread_time.h:77
   with Import => True, 
        Convention => C, 
        External_Name => "nanosleep32";

   function nanosleep64 (request : access constant sys_timeb_h.u_timespec64; remain : access sys_timeb_h.u_timespec64) return int  -- D:/M/msys64/ucrt64/include/pthread_time.h:78
   with Import => True, 
        Convention => C, 
        External_Name => "nanosleep64";

   function nanosleep (request : access constant sys_timeb_h.timespec; remain : access sys_timeb_h.timespec) return int  -- D:/M/msys64/ucrt64/include/pthread_time.h:79
   with Import => True, 
        Convention => C, 
        External_Name => "nanosleep";

   function clock_nanosleep32
     (clock_id : pthread_compat_h.clockid_t;
      flags : int;
      request : access constant sys_timeb_h.u_timespec32;
      remain : access sys_timeb_h.u_timespec32) return int  -- D:/M/msys64/ucrt64/include/pthread_time.h:88
   with Import => True, 
        Convention => C, 
        External_Name => "clock_nanosleep32";

   function clock_nanosleep64
     (clock_id : pthread_compat_h.clockid_t;
      flags : int;
      request : access constant sys_timeb_h.u_timespec64;
      remain : access sys_timeb_h.u_timespec64) return int  -- D:/M/msys64/ucrt64/include/pthread_time.h:89
   with Import => True, 
        Convention => C, 
        External_Name => "clock_nanosleep64";

   function clock_nanosleep
     (clock_id : pthread_compat_h.clockid_t;
      flags : int;
      request : access constant sys_timeb_h.timespec;
      remain : access sys_timeb_h.timespec) return int  -- D:/M/msys64/ucrt64/include/pthread_time.h:90
   with Import => True, 
        Convention => C, 
        External_Name => "clock_nanosleep";

   function clock_getres32 (clock_id : pthread_compat_h.clockid_t; res : access sys_timeb_h.u_timespec32) return int  -- D:/M/msys64/ucrt64/include/pthread_time.h:99
   with Import => True, 
        Convention => C, 
        External_Name => "clock_getres32";

   function clock_getres64 (clock_id : pthread_compat_h.clockid_t; res : access sys_timeb_h.u_timespec64) return int  -- D:/M/msys64/ucrt64/include/pthread_time.h:100
   with Import => True, 
        Convention => C, 
        External_Name => "clock_getres64";

   function clock_getres (clock_id : pthread_compat_h.clockid_t; res : access sys_timeb_h.timespec) return int  -- D:/M/msys64/ucrt64/include/pthread_time.h:101
   with Import => True, 
        Convention => C, 
        External_Name => "clock_getres";

   function clock_gettime32 (clock_id : pthread_compat_h.clockid_t; tp : access sys_timeb_h.u_timespec32) return int  -- D:/M/msys64/ucrt64/include/pthread_time.h:110
   with Import => True, 
        Convention => C, 
        External_Name => "clock_gettime32";

   function clock_gettime64 (clock_id : pthread_compat_h.clockid_t; tp : access sys_timeb_h.u_timespec64) return int  -- D:/M/msys64/ucrt64/include/pthread_time.h:111
   with Import => True, 
        Convention => C, 
        External_Name => "clock_gettime64";

   function clock_gettime (clock_id : pthread_compat_h.clockid_t; tp : access sys_timeb_h.timespec) return int  -- D:/M/msys64/ucrt64/include/pthread_time.h:112
   with Import => True, 
        Convention => C, 
        External_Name => "clock_gettime";

   function clock_settime32 (clock_id : pthread_compat_h.clockid_t; tp : access constant sys_timeb_h.u_timespec32) return int  -- D:/M/msys64/ucrt64/include/pthread_time.h:121
   with Import => True, 
        Convention => C, 
        External_Name => "clock_settime32";

   function clock_settime64 (clock_id : pthread_compat_h.clockid_t; tp : access constant sys_timeb_h.u_timespec64) return int  -- D:/M/msys64/ucrt64/include/pthread_time.h:122
   with Import => True, 
        Convention => C, 
        External_Name => "clock_settime64";

   function clock_settime (clock_id : pthread_compat_h.clockid_t; tp : access constant sys_timeb_h.timespec) return int  -- D:/M/msys64/ucrt64/include/pthread_time.h:123
   with Import => True, 
        Convention => C, 
        External_Name => "clock_settime";

end pthread_time_h;

pragma Style_Checks (On);
pragma Warnings (On, "-gnatwu");
