# aws s3 cp

> 로컬 파일 또는 S3 객체를 로컬로 또는 S3의 다른 위치로 복사.
> 더 많은 정보: <https://docs.aws.amazon.com/cli/latest/reference/s3/cp.html>.

- 로컬에서 특정 버킷으로 파일 복사:

`aws s3 cp {{경로/대상/파일}} s3://{{버킷_이름}}/{{경로/대상/원격_파일}}`

- 특정 S3 객체를 다른 버킷에 복사:

`aws s3 cp s3://{{버킷_이름}}/{{경로/대상/파일}} s3://{{버킷_이름2}}/{{경로/대상/목표}}`

- 특정 S3 객체를 원래 이름을 유지하면서, 다른 버킷에 복사:

`aws s3 cp s3://{{버킷_이름1}}/{{경로/대상/파일}} s3://{{버킷_이름2}}`

- S3 객체를 로컬 디렉터리에 재귀적으로 복사:

`aws s3 cp s3://{{버킷_이름}} . --recursive`

- 도움말 표시:

`aws s3 cp help`
