import React from "react";
import PropTypes from "prop-types";

function UnsupportedField(_ref) {
  var schema = _ref.schema,
      idSchema = _ref.idSchema,
      reason = _ref.reason;
  return React.createElement("div", {
    className: "unsupported-field"
  }, React.createElement("p", null, "Unsupported field schema", idSchema && idSchema.$id && React.createElement("span", null, " for", " field ", React.createElement("code", null, idSchema.$id)), reason && React.createElement("em", null, ": ", reason), "."), schema && React.createElement("pre", null, JSON.stringify(schema, null, 2)));
}

if (process.env.NODE_ENV !== "production") {
  UnsupportedField.propTypes = {
    schema: PropTypes.object.isRequired,
    idSchema: PropTypes.object,
    reason: PropTypes.string
  };
}

export default UnsupportedField;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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