# 協助 FastAPI - 取得協助 { #help-fastapi-get-help }

你喜歡 **FastAPI** 嗎？

你願意協助 FastAPI、其他使用者，以及作者嗎？

或是你想獲得 **FastAPI** 的協助？

有一些非常簡單的方式可以幫忙（有些只需要點一兩下）。

而且也有多種方式可以取得協助。

## 訂閱電子報 { #subscribe-to-the-newsletter }

你可以訂閱（不常發送的）[**FastAPI 與夥伴**電子報](newsletter.md){.internal-link target=_blank}，隨時掌握：

* 關於 FastAPI 與夥伴的最新消息 🚀
* 教學指南 📝
* 新功能 ✨
* 破壞性變更 🚨
* 小技巧與祕訣 ✅

## 在 X（Twitter）關注 FastAPI { #follow-fastapi-on-x-twitter }

<a href="https://x.com/fastapi" class="external-link" target="_blank">在 **X（Twitter）** 關注 @fastapi</a>，獲取 **FastAPI** 的最新消息。🐦

## 在 GitHub 為 **FastAPI** 加星 { #star-fastapi-in-github }

你可以在 GitHub 為 FastAPI「加星」（點擊右上角的 star 星號按鈕）：<a href="https://github.com/fastapi/fastapi" class="external-link" target="_blank">https://github.com/fastapi/fastapi</a>。⭐️

加上星標後，其他使用者會更容易發現它，並看到它已經對許多人很有幫助。

## 追蹤 GitHub 儲存庫的發行版 { #watch-the-github-repository-for-releases }

你可以在 GitHub「watch」FastAPI（點擊右上角的「watch」按鈕）：<a href="https://github.com/fastapi/fastapi" class="external-link" target="_blank">https://github.com/fastapi/fastapi</a>。👀

在那裡你可以選擇「Releases only」。

這樣每當 **FastAPI** 有新的發行（新版本）包含錯誤修復與新功能時，你就會收到通知（寄到你的電子郵件）。

## 與作者連結 { #connect-with-the-author }

你可以與作者 <a href="https://tiangolo.com" class="external-link" target="_blank">我（Sebastián Ramírez / `tiangolo`）</a> 建立連結。

你可以：

* <a href="https://github.com/tiangolo" class="external-link" target="_blank">在 **GitHub** 關注我</a>。
    * 看看我建立的其他開源專案，可能對你有幫助。
    * 關注我以便知道我何時建立新的開源專案。
* <a href="https://x.com/tiangolo" class="external-link" target="_blank">在 **X（Twitter）**</a> 或 <a href="https://fosstodon.org/@tiangolo" class="external-link" target="_blank">Mastodon</a> 關注我。
    * 告訴我你如何使用 FastAPI（我很愛聽這些）。
    * 接收我發布公告或釋出新工具時的消息。
    * 你也可以<a href="https://x.com/fastapi" class="external-link" target="_blank">在 X（Twitter）關注 @fastapi</a>（另外的帳號）。
* <a href="https://www.linkedin.com/in/tiangolo/" class="external-link" target="_blank">在 **LinkedIn** 關注我</a>。
    * 接收我發布公告或釋出新工具時的消息（不過我更常用 X（Twitter）🤷‍♂）。
* 在 <a href="https://dev.to/tiangolo" class="external-link" target="_blank">**Dev.to**</a> 或 <a href="https://medium.com/@tiangolo" class="external-link" target="_blank">**Medium**</a> 閱讀我寫的內容（或關注我）。
    * 閱讀我的想法、文章，以及我建立的工具。
    * 關注我以便在我發佈新內容時能第一時間看到。

## 在 X（Twitter）發文談談 **FastAPI** { #tweet-about-fastapi }

<a href="https://x.com/compose/tweet?text=I'm loving @fastapi because... https://github.com/fastapi/fastapi" class="external-link" target="_blank">發一則關於 **FastAPI** 的推文</a>，讓我與其他人知道你為什麼喜歡它。🎉

我很樂於聽到 **FastAPI** 是如何被使用、你喜歡它的哪些地方、在哪個專案／公司使用它等等。

## 為 FastAPI 投票 { #vote-for-fastapi }

* <a href="https://www.slant.co/options/34241/~fastapi-review" class="external-link" target="_blank">在 Slant 為 **FastAPI** 投票</a>。
* <a href="https://alternativeto.net/software/fastapi/about/" class="external-link" target="_blank">在 AlternativeTo 為 **FastAPI** 投票</a>。
* <a href="https://stackshare.io/pypi-fastapi" class="external-link" target="_blank">在 StackShare 表示你使用 **FastAPI**</a>。

## 在 GitHub 幫助他人解答問題 { #help-others-with-questions-in-github }

你可以嘗試幫助他人回答以下地方的問題：

* <a href="https://github.com/fastapi/fastapi/discussions/categories/questions?discussions_q=category%3AQuestions+is%3Aunanswered" class="external-link" target="_blank">GitHub Discussions</a>
* <a href="https://github.com/fastapi/fastapi/issues?q=is%3Aissue+is%3Aopen+sort%3Aupdated-desc+label%3Aquestion+-label%3Aanswered+" class="external-link" target="_blank">GitHub Issues</a>

很多時候你可能已經知道這些問題的解答。🤓

如果你經常幫大家解決問題，你會成為官方的 [FastAPI 專家](fastapi-people.md#fastapi-experts){.internal-link target=_blank}。🎉

請記得，最重要的是：盡量友善。大家可能帶著挫折而來，很多時候提問方式不夠理想，但請盡你所能保持友善。🤗

**FastAPI** 社群的理念是友善且歡迎大家。同時，也不要接受霸凌或對他人不尊重的行為。我們要彼此照顧。

---

以下是在（Discussions 或 Issues）中幫助他人解決問題的方式：

### 先理解問題 { #understand-the-question }

* 先確認你是否能理解提問者的**目的**與使用情境。

* 接著看看問題（絕大多數是提問）是否**清楚**。

* 很多時候，提問是基於使用者自己想像中的解法，但可能有**更好**的方法。如果你能更理解他們的問題與使用情境，你也許能提出更好的**替代解法**。

* 如果你無法理解問題，請要求提供更多**細節**。

### 重現問題 { #reproduce-the-problem }

在大多數情況與問題中，都會與對方的**原始程式碼**有關。

很多時候他們只會貼出一小段程式碼，但那不足以**重現問題**。

* 你可以請他們提供一個<a href="https://stackoverflow.com/help/minimal-reproducible-example" class="external-link" target="_blank">最小可重現範例</a>，讓你可以**複製貼上**並在本機執行，看到與他們相同的錯誤或行為，或更好地理解他們的使用情境。

* 如果你有心力，你也可以嘗試自己**建立一個範例**，僅依據問題描述來還原。不過請記得這可能很耗時，或許更好的是先請他們把問題說清楚。

### 提出解法建議 { #suggest-solutions }

* 在能夠理解問題後，你可以給出可能的**答案**。

* 很多時候，最好能理解他們的**底層問題或使用情境**，因為可能有比他們嘗試的方法更好的解決之道。

### 請求關閉議題 { #ask-to-close }

如果他們回覆了，你很可能已經解決了他們的問題，恭喜，**你是英雄**！🦸

* 現在，如果問題已解決，你可以請他們：
    * 在 GitHub Discussions：把某則留言標記為**答案**。
    * 在 GitHub Issues：**關閉**該 issue。

## 追蹤 GitHub 儲存庫 { #watch-the-github-repository }

你可以在 GitHub「watch」FastAPI（點擊右上角的「watch」按鈕）：<a href="https://github.com/fastapi/fastapi" class="external-link" target="_blank">https://github.com/fastapi/fastapi</a>。👀

如果你選擇「Watching」而不是「Releases only」，當有人建立新的 issue 或問題時你會收到通知。你也可以指定只想被通知新的 issues、discussions、PR 等等。

接著你就可以嘗試幫忙解決那些問題。

## 提問 { #ask-questions }

你可以在 GitHub 儲存庫<a href="https://github.com/fastapi/fastapi/discussions/new?category=questions" class="external-link" target="_blank">建立一個新的問題（Question）</a>，例如用來：

* 提出**問題**或詢問某個**疑難**。
* 建議一個新的**功能**。

**注意**：如果你這麼做，那我也會請你去幫助其他人。😉

## 審核 Pull Request { #review-pull-requests }

你可以幫我審查他人的 Pull Request。

再強調一次，請盡量保持友善。🤗

---

以下是審查 Pull Request 時需要注意與如何進行：

### 先理解要解的問題 { #understand-the-problem }

* 首先，確認你**理解了該 Pull Request 想解決的問題**。可能在 GitHub Discussion 或 issue 中有更長的討論。

* 也很有可能這個 Pull Request 其實不需要，因為問題可以用**不同的方法**解決。那你就可以提出或詢問那個方向。

### 不用太在意風格 { #dont-worry-about-style }

* 不要太擔心像是提交訊息（commit message）的風格，我會用 squash and merge 並手動調整提交內容。

* 也不用太在意程式碼風格規範，已經有自動化工具在檢查。

如果還有其他風格或一致性的需求，我會直接提出請求，或是在上面再補上需要的修改提交。

### 檢查程式碼 { #check-the-code }

* 檢查並閱讀程式碼，看看是否合理，**在本機執行**並確認它是否真的解決了問題。

* 然後**留言**說你做了這些，這樣我才知道你真的檢查過了。

/// info

很遺憾，我不能僅因為一個 PR 有好幾個核可就直接信任它。

發生過好幾次，PR 有 3、5 個甚至更多核可，可能是因為描述很吸引人，但當我實際檢查時，它其實是壞的、有 bug，或是根本沒有解決它宣稱要解決的問題。😅

所以，真的很重要的是你要實際閱讀並執行程式碼，並在留言中讓我知道你做過了。🤓

///

* 如果 PR 有機會再被簡化，你可以提出要求，但沒必要太過挑剔，很多事情是主觀的（我自己也會有主觀看法 🙈），所以最好聚焦在關鍵的事情上。

### 測試 { #tests }

* 幫我確認 PR 有**測試**。

* 檢查在 PR 之前，測試會**失敗**。🚨

* 然後檢查在 PR 之後，測試會**通過**。✅

* 很多 PR 並沒有測試，你可以**提醒**他們加上測試，或甚至**建議**一些測試。這是最花時間的事之一，而你可以在這方面幫上很大的忙。

* 接著也請留言你嘗試了什麼，這樣我就知道你有檢查過。🤓

## 建立 Pull Request { #create-a-pull-request }

你可以透過 Pull Request 來[貢獻](contributing.md){.internal-link target=_blank}原始碼，例如：

* 修正文檔中你發現的錯字。
* 分享你建立或發現的 FastAPI 相關文章、影片或 podcast，方法是<a href="https://github.com/fastapi/fastapi/edit/master/docs/en/data/external_links.yml" class="external-link" target="_blank">編輯這個檔案</a>。
    * 請確保把你的連結加到對應章節的開頭。
* 協助把[文件翻譯](contributing.md#translations){.internal-link target=_blank}成你的語言。
    * 你也可以幫忙審查他人提交的翻譯。
* 提議新的文件章節。
* 修復既有的 issue／bug。
    * 記得要加上測試。
* 新增一個功能。
    * 記得要加上測試。
    * 若相關，請記得補上文件。

## 協助維護 FastAPI { #help-maintain-fastapi }

幫我一起維護 **FastAPI**！🤓

有很多事情要做，而其中大多數其實**你**就能完成。

你現在就能做的主要任務有：

* [在 GitHub 幫助他人解答問題](#help-others-with-questions-in-github){.internal-link target=_blank}（見上方章節）。
* [審核 Pull Request](#review-pull-requests){.internal-link target=_blank}（見上方章節）。

這兩件事是**最耗時**的。這也是維護 FastAPI 的主要工作。

如果你能在這方面幫我，**你就是在幫我維護 FastAPI**，並確保它能**更快更好地前進**。🚀

## 加入聊天室 { #join-the-chat }

加入 👥 <a href="https://discord.gg/VQjSZaeJmf" class="external-link" target="_blank">Discord 聊天伺服器</a> 👥，與 FastAPI 社群的其他人一起交流。

/// tip

若要提問，請到 <a href="https://github.com/fastapi/fastapi/discussions/new?category=questions" class="external-link" target="_blank">GitHub Discussions</a>，在那裡更有機會獲得[FastAPI 專家](fastapi-people.md#fastapi-experts){.internal-link target=_blank}的協助。

聊天室請僅用於其他一般性的交流。

///

### 不要在聊天室提問 { #dont-use-the-chat-for-questions }

請記得，由於聊天室允許較「自由的對話」，很容易提出過於籠統、較難回答的問題，因此你可能不會得到答案。

在 GitHub 上，模板會引導你寫出合適的提問，讓你更容易得到好的解答，甚至在提問前就自己解決問題。而且在 GitHub 上，我能確保最終都會回覆（即使需要一些時間）。我個人無法在聊天系統做到這一點。😅

聊天系統中的對話也不像 GitHub 那樣容易被搜尋，因此問題與答案可能在對話中淹沒。而且只有 GitHub 上的問題與回答才會被計入成為[FastAPI 專家](fastapi-people.md#fastapi-experts){.internal-link target=_blank}，因此你在 GitHub 上更有機會獲得關注。

另一方面，聊天室裡有成千上萬的使用者，所以幾乎隨時都有很大的機會能找到人聊天。😄

## 贊助作者 { #sponsor-the-author }

如果你的**產品／公司**依賴或與 **FastAPI** 相關，且你想觸及它的使用者，你可以透過 <a href="https://github.com/sponsors/tiangolo" class="external-link" target="_blank">GitHub sponsors</a> 贊助作者（我）。依據不同級別，你可能會得到一些額外福利，例如在文件中顯示徽章。🎁

---

感謝！🚀
