# 依存関係のオーバーライドによるテスト { #testing-dependencies-with-overrides }

## テスト時の依存関係のオーバーライド { #overriding-dependencies-during-testing }

テスト中に依存関係をオーバーライドしたい場面がいくつかあります。

元の依存関係（およびそれにぶら下がるサブ依存関係）を実行したくない場合です。

代わりに、テストの間だけ（特定のテストだけでも）使われる別の依存関係を提供し、元の依存関係の値が使われていた箇所で利用できる値を返したいのです。

### ユースケース: 外部サービス { #use-cases-external-service }

例として、呼び出す必要がある外部の認証プロバイダがあるとします。

トークンを送ると、認証済みユーザーが返ってきます。

このプロバイダはリクエストごとに課金されるかもしれず、テスト用に固定のモックユーザーを使う場合に比べて呼び出しに余分な時間がかかるかもしれません。

外部プロバイダ自体の動作は一度はテストしたいでしょうが、実行されるすべてのテストで毎回呼び出す必要はありません。

この場合、そのプロバイダを呼び出す依存関係をオーバーライドし、テストのときだけモックユーザーを返すカスタムの依存関係を使えます。

### app.dependency_overrides 属性を使う { #use-the-app-dependency-overrides-attribute }

このような場合のために、**FastAPI** アプリケーションには `app.dependency_overrides` という属性があり、これは単純な `dict` です。

テスト用に依存関係をオーバーライドするには、キーに元の依存関係（関数）を、値にオーバーライドする依存関係（別の関数）を設定します。

すると **FastAPI** は元の依存関係の代わりにそのオーバーライドを呼び出します。

{* ../../docs_src/dependency_testing/tutorial001_an_py310.py hl[26:27,30] *}

/// tip | 豆知識

アプリケーション内のどこで使われている依存関係に対しても、依存関係のオーバーライドを設定できます。

元の依存関係は、*path operation 関数*、*path operation デコレータ*（戻り値を使わない場合）、`.include_router()` の呼び出しなど、さまざまな場所で使われていてもかまいません。

FastAPI はそれでもオーバーライドできます。

///

その後、`app.dependency_overrides` を空の `dict` に設定することで、オーバーライドをリセット（削除）できます:

```Python
app.dependency_overrides = {}
```

/// tip | 豆知識

一部のテストの間だけ依存関係をオーバーライドしたい場合は、テストの開始時（テスト関数内）にオーバーライドを設定し、終了時（テスト関数の末尾）にリセットするとよいです。

///
