# 帮助 FastAPI - 获取帮助 { #help-fastapi-get-help }

你喜欢 **FastAPI** 吗？

想帮助 FastAPI、其他用户和作者吗？

或者你想获取 **FastAPI** 的帮助？

有很多非常简单的方式可以帮忙（有些只需点一两下）。

同样，也有多种途径可以获得帮助。

## 订阅新闻邮件 { #subscribe-to-the-newsletter }

你可以订阅（不频繁的）[**FastAPI and friends** 新闻邮件](newsletter.md){.internal-link target=_blank}，获取如下更新：

* FastAPI 及其小伙伴的新闻 🚀
* 指南 📝
* 功能 ✨
* 破坏性更改 🚨
* 使用技巧 ✅

## 在 X (Twitter) 上关注 FastAPI { #follow-fastapi-on-x-twitter }

<a href="https://x.com/fastapi" class="external-link" target="_blank">在 **X (Twitter)** 上关注 @fastapi</a> 获取 **FastAPI** 的最新动态。🐦

## 在 GitHub 上为 **FastAPI** 加星 { #star-fastapi-in-github }

你可以在 GitHub 上为 FastAPI 点亮「星标」（点击右上角的星形按钮）：<a href="https://github.com/fastapi/fastapi" class="external-link" target="_blank">https://github.com/fastapi/fastapi</a>。⭐️

点亮星标后，其他用户更容易发现它，并看到它已经对许多人有帮助。

## 关注 GitHub 资源库的版本发布 { #watch-the-github-repository-for-releases }

你可以在 GitHub 上「关注」FastAPI（点击右上角的「watch」按钮）：<a href="https://github.com/fastapi/fastapi" class="external-link" target="_blank">https://github.com/fastapi/fastapi</a>。👀

在那里你可以选择「Releases only」。

这样做之后，每当 **FastAPI** 发布新版本（包含修复和新功能），你都会收到通知（邮件）。

## 联系作者 { #connect-with-the-author }

你可以联系<a href="https://tiangolo.com" class="external-link" target="_blank">我（Sebastián Ramírez / `tiangolo`）</a>，作者本人。

你可以：

* <a href="https://github.com/tiangolo" class="external-link" target="_blank">在 **GitHub** 上关注我</a>。
    * 了解我创建的其他开源项目，也许对你有帮助。
    * 关注我何时创建新的开源项目。
* 关注我在 <a href="https://x.com/tiangolo" class="external-link" target="_blank">**X (Twitter)**</a> 或 <a href="https://fosstodon.org/@tiangolo" class="external-link" target="_blank">Mastodon</a>。
    * 告诉我你如何使用 FastAPI（我很喜欢听这些）。
    * 获取我发布公告或新工具的消息。
    * 你也可以<a href="https://x.com/fastapi" class="external-link" target="_blank">关注 @fastapi on X (Twitter)</a>（独立账号）。
* <a href="https://www.linkedin.com/in/tiangolo/" class="external-link" target="_blank">在 **LinkedIn** 上关注我</a>。
    * 获取我发布公告或新工具的消息（不过我更常用 X (Twitter) 🤷‍♂）。
* 阅读我在 <a href="https://dev.to/tiangolo" class="external-link" target="_blank">**Dev.to**</a> 或 <a href="https://medium.com/@tiangolo" class="external-link" target="_blank">**Medium**</a> 上的文章（或关注我）。
    * 阅读我的其他想法、文章，以及我创建的工具。
    * 关注我，这样当我发布新文章时你会第一时间看到。

## 发推谈谈 **FastAPI** { #tweet-about-fastapi }

<a href="https://x.com/compose/tweet?text=I'm loving @fastapi because... https://github.com/fastapi/fastapi" class="external-link" target="_blank">Tweet about **FastAPI**</a>，告诉我和大家你为什么喜欢它。🎉

我很高兴听到 **FastAPI** 的使用情况、你喜欢它的哪些点、你在哪个项目/公司使用它，等等。

## 为 FastAPI 投票 { #vote-for-fastapi }

* <a href="https://www.slant.co/options/34241/~fastapi-review" class="external-link" target="_blank">在 Slant 上为 **FastAPI** 投票</a>。
* <a href="https://alternativeto.net/software/fastapi/about/" class="external-link" target="_blank">在 AlternativeTo 上为 **FastAPI** 投票</a>。
* <a href="https://stackshare.io/pypi-fastapi" class="external-link" target="_blank">在 StackShare 上标注你在用 **FastAPI**</a>。

## 在 GitHub 上帮别人解答问题 { #help-others-with-questions-in-github }

你可以尝试在以下地方帮助他人解答问题：

* <a href="https://github.com/fastapi/fastapi/discussions/categories/questions?discussions_q=category%3AQuestions+is%3Aunanswered" class="external-link" target="_blank">GitHub Discussions</a>
* <a href="https://github.com/fastapi/fastapi/issues?q=is%3Aissue+is%3Aopen+sort%3Aupdated-desc+label%3Aquestion+-label%3Aanswered+" class="external-link" target="_blank">GitHub Issues</a>

很多情况下，你也许已经知道这些问题的答案了。🤓

如果你帮助了很多人解答问题，你会成为官方的 [FastAPI 专家](fastapi-people.md#fastapi-experts){.internal-link target=_blank}。🎉

只要记住，最重要的一点是：尽量友善。人们带着挫败感而来，很多时候他们的提问方式并不理想，但请尽你所能地友好对待。🤗

我们的目标是让 **FastAPI** 社区友好且包容。同时，也不要接受对他人的霸凌或不尊重。我们需要彼此照顾。

---

以下是如何帮助他人解答问题（在 Discussions 或 Issues 中）：

### 理解问题 { #understand-the-question }

* 看看你是否能理解提问者的**目的**和使用场景。

* 然后检查问题（绝大多数是提问）是否**清晰**。

* 很多时候，问题是围绕提问者想象中的解决方案，但可能有**更好的**方案。如果你更好地理解了问题和使用场景，你就可能提出更**合适的替代方案**。

* 如果你没能理解问题，请请求更多**细节**。

### 复现问题 { #reproduce-the-problem }

在大多数情况下与问题相关的都是提问者的**原始代码**。

很多时候他们只会粘贴一小段代码，但这不足以**复现问题**。

* 你可以请他们提供一个<a href="https://stackoverflow.com/help/minimal-reproducible-example" class="external-link" target="_blank">可最小复现的示例</a>，你可以**复制粘贴**并在本地运行，看到与他们相同的错误或行为，或者更好地理解他们的用例。

* 如果你非常热心，你也可以尝试仅根据问题描述自己**构造一个示例**。不过要记住，这可能会花很多时间，通常先请他们澄清问题会更好。

### 提出解决方案 { #suggest-solutions }

* 在能够理解问题之后，你可以给出一个可能的**答案**。

* 很多情况下，更好的是去理解他们**底层的问题或场景**，因为可能存在比他们尝试的方法更好的解决方式。

### 请求关闭问题 { #ask-to-close }

如果他们回复了，很有可能你已经解决了他们的问题，恭喜，**你是英雄**！🦸

* 现在，如果问题已解决，你可以请他们：
    * 在 GitHub Discussions 中：将你的评论标记为**答案**。
    * 在 GitHub Issues 中：**关闭**该 issue。

## 关注 GitHub 资源库 { #watch-the-github-repository }

你可以在 GitHub 上「关注」FastAPI（点击右上角的「watch」按钮）：<a href="https://github.com/fastapi/fastapi" class="external-link" target="_blank">https://github.com/fastapi/fastapi</a>。👀

如果你选择「Watching」而非「Releases only」，当有人创建新的 issue 或问题时你会收到通知。你也可以指定只通知新 issues、discussions、PR 等。

然后你就可以尝试帮助他们解决这些问题。

## 提问 { #ask-questions }

你可以在 GitHub 资源库中<a href="https://github.com/fastapi/fastapi/discussions/new?category=questions" class="external-link" target="_blank">创建一个新问题（Question）</a>，例如：

* 提出一个**问题**或关于某个**问题**的求助。
* 建议一个新的**功能**。

**注意**：如果你这么做了，我也会请你去帮助其他人。😉

## 审阅 Pull Request { #review-pull-requests }

你可以帮我审阅他人的 Pull Request。

再次提醒，请尽力保持友善。🤗

---

下面是需要注意的点，以及如何审阅一个 Pull Request：

### 理解问题 { #understand-the-problem }

* 首先，确保你**理解这个 PR 要解决的问题**。它可能在 GitHub Discussion 或 issue 中有更长的讨论。

* 也有很大可能这个 PR 实际上并不需要，因为问题可以用**不同方式**解决。这种情况下你可以提出或询问该方案。

### 不用过分担心风格 { #dont-worry-about-style }

* 不用太在意提交信息风格等，我会在合并时 squash 并手动调整提交信息。

* 也不用过分担心代码风格规则，已经有自动化工具在检查。

如果还有其他风格或一致性需求，我会直接提出，或者我会在其上追加提交做必要修改。

### 检查代码 { #check-the-code }

* 检查并阅读代码，看看是否说得通，**在本地运行**并确认它确实解决了问题。

* 然后**评论**说明你已经这样做了，这样我就知道你确实检查过。

/// info | 信息

不幸的是，我不能仅仅信任那些有很多人批准的 PR。

多次发生过这样的情况：PR 有 3、5 个甚至更多的批准，可能是因为描述很吸引人，但当我检查时，它们实际上是坏的、有 bug，或者并没有解决它声称要解决的问题。😅

所以，真正重要的是你确实读过并运行过代码，并在评论里告诉我你做过这些。🤓

///

* 如果 PR 可以在某些方面简化，你可以提出建议，但没必要过分挑剔，很多东西比较主观（我也会有我自己的看法 🙈），因此尽量关注关键点更好。

### 测试 { #tests }

* 帮我检查 PR 是否包含**测试**。

* 确认在合并 PR 之前，测试**会失败**。🚨

* 然后确认合并 PR 之后，测试**能通过**。✅

* 很多 PR 没有测试，你可以**提醒**他们添加测试，或者你甚至可以自己**建议**一些测试。这是最耗时的部分之一，你能在这方面帮上大忙。

* 然后也请评论你做了哪些验证，这样我就知道你检查过。🤓

## 创建 Pull Request { #create-a-pull-request }

你可以通过 Pull Request 为源代码[做贡献](contributing.md){.internal-link target=_blank}，例如：

* 修正文档中的一个错别字。
* 通过<a href="https://github.com/fastapi/fastapi/edit/master/docs/en/data/external_links.yml" class="external-link" target="_blank">编辑这个文件</a>分享你创建或发现的关于 FastAPI 的文章、视频或播客。
    * 请确保把你的链接添加到相应区块的开头。
* 帮助把[文档翻译](contributing.md#translations){.internal-link target=_blank}成你的语言。
    * 你也可以审阅他人创建的翻译。
* 提议新增文档章节。
* 修复现有 issue/bug。
    * 记得添加测试。
* 添加新功能。
    * 记得添加测试。
    * 如果相关，记得补充文档。

## 帮忙维护 FastAPI { #help-maintain-fastapi }

帮我一起维护 **FastAPI** 吧！🤓

有很多工作要做，其中大部分其实**你**都能做。

你现在就能做的主要事情有：

* [在 GitHub 上帮别人解答问题](#help-others-with-questions-in-github){.internal-link target=_blank}（见上面的章节）。
* [审阅 Pull Request](#review-pull-requests){.internal-link target=_blank}（见上面的章节）。

这两项工作是**最耗时**的。这也是维护 FastAPI 的主要工作。

如果你能在这方面帮我，**你就是在帮我维护 FastAPI**，并确保它**更快更好地前进**。🚀

## 加入聊天 { #join-the-chat }

加入 👥 <a href="https://discord.gg/VQjSZaeJmf" class="external-link" target="_blank">Discord 聊天服务器</a> 👥，和 FastAPI 社区的小伙伴们一起交流。

/// tip | 提示

关于提问，请在 <a href="https://github.com/fastapi/fastapi/discussions/new?category=questions" class="external-link" target="_blank">GitHub Discussions</a> 中发布，这样更有机会得到 [FastAPI 专家](fastapi-people.md#fastapi-experts){.internal-link target=_blank} 的帮助。

聊天仅用于其他日常交流。

///

### 别在聊天里提问 { #dont-use-the-chat-for-questions }

请记住，聊天更偏向“自由交流”，很容易提出过于笼统、难以回答的问题，因此你可能收不到解答。

在 GitHub 中，模板会引导你写出恰当的问题，从而更容易获得好的回答，甚至在提问之前就能自己解决。而且在 GitHub 里，我能尽量确保最终回复每个问题，即使这需要一些时间。对聊天系统来说，我个人做不到这一点。😅

聊天系统中的对话也不像 GitHub 那样容易搜索，因此问答可能在聊天中淹没。而且只有在 GitHub 中的问答才会计入成为 [FastAPI 专家](fastapi-people.md#fastapi-experts){.internal-link target=_blank} 的贡献，所以你在 GitHub 上更可能获得关注。

另一方面，聊天系统里有成千上万的用户，你几乎随时都能在那里找到聊得来的人。😄

## 赞助作者 { #sponsor-the-author }

如果你的**产品/公司**依赖或与 **FastAPI** 相关，并且你想触达它的用户，你可以通过 <a href="https://github.com/sponsors/tiangolo" class="external-link" target="_blank">GitHub sponsors</a> 赞助作者（我）。根据赞助层级，你还可能获得一些额外福利，比如在文档中展示徽章。🎁

---

谢谢！🚀
