/*
 * Copyright (c) 2008-2026 Jonathan Schleifer <js@nil.im>
 *
 * All rights reserved.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3.0 only,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3.0 along with this program. If not, see
 * <https://www.gnu.org/licenses/>.
 */

#include "config.h"

#import "unicode.h"

static const OFUnichar emptyPage[0x100] = { 0 };

static const OFUnichar uppercasePage0[0x100] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 65, 66, 67, 68, 69, 70, 71,
	72, 73, 74, 75, 76, 77, 78, 79,
	80, 81, 82, 83, 84, 85, 86, 87,
	88, 89, 90, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 924, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	192, 193, 194, 195, 196, 197, 198, 199,
	200, 201, 202, 203, 204, 205, 206, 207,
	208, 209, 210, 211, 212, 213, 214, 0,
	216, 217, 218, 219, 220, 221, 222, 376,
};

static const OFUnichar uppercasePage1[0x100] = {
	0, 256, 0, 258, 0, 260, 0, 262,
	0, 264, 0, 266, 0, 268, 0, 270,
	0, 272, 0, 274, 0, 276, 0, 278,
	0, 280, 0, 282, 0, 284, 0, 286,
	0, 288, 0, 290, 0, 292, 0, 294,
	0, 296, 0, 298, 0, 300, 0, 302,
	0, 73, 0, 306, 0, 308, 0, 310,
	0, 0, 313, 0, 315, 0, 317, 0,
	319, 0, 321, 0, 323, 0, 325, 0,
	327, 0, 0, 330, 0, 332, 0, 334,
	0, 336, 0, 338, 0, 340, 0, 342,
	0, 344, 0, 346, 0, 348, 0, 350,
	0, 352, 0, 354, 0, 356, 0, 358,
	0, 360, 0, 362, 0, 364, 0, 366,
	0, 368, 0, 370, 0, 372, 0, 374,
	0, 0, 377, 0, 379, 0, 381, 83,
	579, 0, 0, 386, 0, 388, 0, 0,
	391, 0, 0, 0, 395, 0, 0, 0,
	0, 0, 401, 0, 0, 502, 0, 0,
	0, 408, 573, 42972, 0, 0, 544, 0,
	0, 416, 0, 418, 0, 420, 0, 0,
	423, 0, 0, 0, 0, 428, 0, 0,
	431, 0, 0, 0, 435, 0, 437, 0,
	0, 440, 0, 0, 0, 444, 0, 503,
	0, 0, 0, 0, 0, 452, 452, 0,
	455, 455, 0, 458, 458, 0, 461, 0,
	463, 0, 465, 0, 467, 0, 469, 0,
	471, 0, 473, 0, 475, 398, 0, 478,
	0, 480, 0, 482, 0, 484, 0, 486,
	0, 488, 0, 490, 0, 492, 0, 494,
	0, 0, 497, 497, 0, 500, 0, 0,
	0, 504, 0, 506, 0, 508, 0, 510,
};

static const OFUnichar uppercasePage2[0x100] = {
	0, 512, 0, 514, 0, 516, 0, 518,
	0, 520, 0, 522, 0, 524, 0, 526,
	0, 528, 0, 530, 0, 532, 0, 534,
	0, 536, 0, 538, 0, 540, 0, 542,
	0, 0, 0, 546, 0, 548, 0, 550,
	0, 552, 0, 554, 0, 556, 0, 558,
	0, 560, 0, 562, 0, 0, 0, 0,
	0, 0, 0, 0, 571, 0, 0, 11390,
	11391, 0, 577, 0, 0, 0, 0, 582,
	0, 584, 0, 586, 0, 588, 0, 590,
	11375, 11373, 11376, 385, 390, 0, 393, 394,
	0, 399, 0, 400, 42923, 0, 0, 0,
	403, 42924, 0, 404, 42955, 42893, 42922, 0,
	407, 406, 42926, 11362, 42925, 0, 0, 412,
	0, 11374, 413, 0, 0, 415, 0, 0,
	0, 0, 0, 0, 0, 11364, 0, 0,
	422, 0, 42949, 425, 0, 0, 0, 42929,
	430, 580, 433, 434, 581, 0, 0, 0,
	0, 0, 439, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 42930, 42928, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
};

static const OFUnichar uppercasePage3[0x100] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 921, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 880, 0, 882, 0, 0, 0, 886,
	0, 0, 0, 1021, 1022, 1023, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 902, 904, 905, 906,
	0, 913, 914, 915, 916, 917, 918, 919,
	920, 921, 922, 923, 924, 925, 926, 927,
	928, 929, 931, 931, 932, 933, 934, 935,
	936, 937, 938, 939, 908, 910, 911, 0,
	914, 920, 0, 0, 0, 934, 928, 975,
	0, 984, 0, 986, 0, 988, 0, 990,
	0, 992, 0, 994, 0, 996, 0, 998,
	0, 1000, 0, 1002, 0, 1004, 0, 1006,
	922, 929, 1017, 895, 0, 917, 0, 0,
	1015, 0, 0, 1018, 0, 0, 0, 0,
};

static const OFUnichar uppercasePage4[0x100] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	1040, 1041, 1042, 1043, 1044, 1045, 1046, 1047,
	1048, 1049, 1050, 1051, 1052, 1053, 1054, 1055,
	1056, 1057, 1058, 1059, 1060, 1061, 1062, 1063,
	1064, 1065, 1066, 1067, 1068, 1069, 1070, 1071,
	1024, 1025, 1026, 1027, 1028, 1029, 1030, 1031,
	1032, 1033, 1034, 1035, 1036, 1037, 1038, 1039,
	0, 1120, 0, 1122, 0, 1124, 0, 1126,
	0, 1128, 0, 1130, 0, 1132, 0, 1134,
	0, 1136, 0, 1138, 0, 1140, 0, 1142,
	0, 1144, 0, 1146, 0, 1148, 0, 1150,
	0, 1152, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 1162, 0, 1164, 0, 1166,
	0, 1168, 0, 1170, 0, 1172, 0, 1174,
	0, 1176, 0, 1178, 0, 1180, 0, 1182,
	0, 1184, 0, 1186, 0, 1188, 0, 1190,
	0, 1192, 0, 1194, 0, 1196, 0, 1198,
	0, 1200, 0, 1202, 0, 1204, 0, 1206,
	0, 1208, 0, 1210, 0, 1212, 0, 1214,
	0, 0, 1217, 0, 1219, 0, 1221, 0,
	1223, 0, 1225, 0, 1227, 0, 1229, 1216,
	0, 1232, 0, 1234, 0, 1236, 0, 1238,
	0, 1240, 0, 1242, 0, 1244, 0, 1246,
	0, 1248, 0, 1250, 0, 1252, 0, 1254,
	0, 1256, 0, 1258, 0, 1260, 0, 1262,
	0, 1264, 0, 1266, 0, 1268, 0, 1270,
	0, 1272, 0, 1274, 0, 1276, 0, 1278,
};

static const OFUnichar uppercasePage5[0x100] = {
	0, 1280, 0, 1282, 0, 1284, 0, 1286,
	0, 1288, 0, 1290, 0, 1292, 0, 1294,
	0, 1296, 0, 1298, 0, 1300, 0, 1302,
	0, 1304, 0, 1306, 0, 1308, 0, 1310,
	0, 1312, 0, 1314, 0, 1316, 0, 1318,
	0, 1320, 0, 1322, 0, 1324, 0, 1326,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 1329, 1330, 1331, 1332, 1333, 1334, 1335,
	1336, 1337, 1338, 1339, 1340, 1341, 1342, 1343,
	1344, 1345, 1346, 1347, 1348, 1349, 1350, 1351,
	1352, 1353, 1354, 1355, 1356, 1357, 1358, 1359,
	1360, 1361, 1362, 1363, 1364, 1365, 1366, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
};

static const OFUnichar uppercasePage16[0x100] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	7312, 7313, 7314, 7315, 7316, 7317, 7318, 7319,
	7320, 7321, 7322, 7323, 7324, 7325, 7326, 7327,
	7328, 7329, 7330, 7331, 7332, 7333, 7334, 7335,
	7336, 7337, 7338, 7339, 7340, 7341, 7342, 7343,
	7344, 7345, 7346, 7347, 7348, 7349, 7350, 7351,
	7352, 7353, 7354, 0, 0, 7357, 7358, 7359,
};

static const OFUnichar uppercasePage19[0x100] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	5104, 5105, 5106, 5107, 5108, 5109, 0, 0,
};

static const OFUnichar uppercasePage28[0x100] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	1042, 1044, 1054, 1057, 1058, 1058, 1066, 1122,
	42570, 0, 7305, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
};

static const OFUnichar uppercasePage29[0x100] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 42877, 0, 0, 0, 11363, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 42950, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
};

static const OFUnichar uppercasePage30[0x100] = {
	0, 7680, 0, 7682, 0, 7684, 0, 7686,
	0, 7688, 0, 7690, 0, 7692, 0, 7694,
	0, 7696, 0, 7698, 0, 7700, 0, 7702,
	0, 7704, 0, 7706, 0, 7708, 0, 7710,
	0, 7712, 0, 7714, 0, 7716, 0, 7718,
	0, 7720, 0, 7722, 0, 7724, 0, 7726,
	0, 7728, 0, 7730, 0, 7732, 0, 7734,
	0, 7736, 0, 7738, 0, 7740, 0, 7742,
	0, 7744, 0, 7746, 0, 7748, 0, 7750,
	0, 7752, 0, 7754, 0, 7756, 0, 7758,
	0, 7760, 0, 7762, 0, 7764, 0, 7766,
	0, 7768, 0, 7770, 0, 7772, 0, 7774,
	0, 7776, 0, 7778, 0, 7780, 0, 7782,
	0, 7784, 0, 7786, 0, 7788, 0, 7790,
	0, 7792, 0, 7794, 0, 7796, 0, 7798,
	0, 7800, 0, 7802, 0, 7804, 0, 7806,
	0, 7808, 0, 7810, 0, 7812, 0, 7814,
	0, 7816, 0, 7818, 0, 7820, 0, 7822,
	0, 7824, 0, 7826, 0, 7828, 0, 0,
	0, 0, 0, 7776, 0, 0, 0, 0,
	0, 7840, 0, 7842, 0, 7844, 0, 7846,
	0, 7848, 0, 7850, 0, 7852, 0, 7854,
	0, 7856, 0, 7858, 0, 7860, 0, 7862,
	0, 7864, 0, 7866, 0, 7868, 0, 7870,
	0, 7872, 0, 7874, 0, 7876, 0, 7878,
	0, 7880, 0, 7882, 0, 7884, 0, 7886,
	0, 7888, 0, 7890, 0, 7892, 0, 7894,
	0, 7896, 0, 7898, 0, 7900, 0, 7902,
	0, 7904, 0, 7906, 0, 7908, 0, 7910,
	0, 7912, 0, 7914, 0, 7916, 0, 7918,
	0, 7920, 0, 7922, 0, 7924, 0, 7926,
	0, 7928, 0, 7930, 0, 7932, 0, 7934,
};

static const OFUnichar uppercasePage31[0x100] = {
	7944, 7945, 7946, 7947, 7948, 7949, 7950, 7951,
	0, 0, 0, 0, 0, 0, 0, 0,
	7960, 7961, 7962, 7963, 7964, 7965, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	7976, 7977, 7978, 7979, 7980, 7981, 7982, 7983,
	0, 0, 0, 0, 0, 0, 0, 0,
	7992, 7993, 7994, 7995, 7996, 7997, 7998, 7999,
	0, 0, 0, 0, 0, 0, 0, 0,
	8008, 8009, 8010, 8011, 8012, 8013, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 8025, 0, 8027, 0, 8029, 0, 8031,
	0, 0, 0, 0, 0, 0, 0, 0,
	8040, 8041, 8042, 8043, 8044, 8045, 8046, 8047,
	0, 0, 0, 0, 0, 0, 0, 0,
	8122, 8123, 8136, 8137, 8138, 8139, 8154, 8155,
	8184, 8185, 8170, 8171, 8186, 8187, 0, 0,
	8072, 8073, 8074, 8075, 8076, 8077, 8078, 8079,
	0, 0, 0, 0, 0, 0, 0, 0,
	8088, 8089, 8090, 8091, 8092, 8093, 8094, 8095,
	0, 0, 0, 0, 0, 0, 0, 0,
	8104, 8105, 8106, 8107, 8108, 8109, 8110, 8111,
	0, 0, 0, 0, 0, 0, 0, 0,
	8120, 8121, 0, 8124, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 921, 0,
	0, 0, 0, 8140, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	8152, 8153, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	8168, 8169, 0, 0, 0, 8172, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 8188, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
};

static const OFUnichar uppercasePage33[0x100] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 8498, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	8544, 8545, 8546, 8547, 8548, 8549, 8550, 8551,
	8552, 8553, 8554, 8555, 8556, 8557, 8558, 8559,
	0, 0, 0, 0, 8579, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
};

static const OFUnichar uppercasePage36[0x100] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	9398, 9399, 9400, 9401, 9402, 9403, 9404, 9405,
	9406, 9407, 9408, 9409, 9410, 9411, 9412, 9413,
	9414, 9415, 9416, 9417, 9418, 9419, 9420, 9421,
	9422, 9423, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
};

static const OFUnichar uppercasePage44[0x100] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	11264, 11265, 11266, 11267, 11268, 11269, 11270, 11271,
	11272, 11273, 11274, 11275, 11276, 11277, 11278, 11279,
	11280, 11281, 11282, 11283, 11284, 11285, 11286, 11287,
	11288, 11289, 11290, 11291, 11292, 11293, 11294, 11295,
	11296, 11297, 11298, 11299, 11300, 11301, 11302, 11303,
	11304, 11305, 11306, 11307, 11308, 11309, 11310, 11311,
	0, 11360, 0, 0, 0, 570, 574, 0,
	11367, 0, 11369, 0, 11371, 0, 0, 0,
	0, 0, 0, 11378, 0, 0, 11381, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 11392, 0, 11394, 0, 11396, 0, 11398,
	0, 11400, 0, 11402, 0, 11404, 0, 11406,
	0, 11408, 0, 11410, 0, 11412, 0, 11414,
	0, 11416, 0, 11418, 0, 11420, 0, 11422,
	0, 11424, 0, 11426, 0, 11428, 0, 11430,
	0, 11432, 0, 11434, 0, 11436, 0, 11438,
	0, 11440, 0, 11442, 0, 11444, 0, 11446,
	0, 11448, 0, 11450, 0, 11452, 0, 11454,
	0, 11456, 0, 11458, 0, 11460, 0, 11462,
	0, 11464, 0, 11466, 0, 11468, 0, 11470,
	0, 11472, 0, 11474, 0, 11476, 0, 11478,
	0, 11480, 0, 11482, 0, 11484, 0, 11486,
	0, 11488, 0, 11490, 0, 0, 0, 0,
	0, 0, 0, 0, 11499, 0, 11501, 0,
	0, 0, 0, 11506, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
};

static const OFUnichar uppercasePage45[0x100] = {
	4256, 4257, 4258, 4259, 4260, 4261, 4262, 4263,
	4264, 4265, 4266, 4267, 4268, 4269, 4270, 4271,
	4272, 4273, 4274, 4275, 4276, 4277, 4278, 4279,
	4280, 4281, 4282, 4283, 4284, 4285, 4286, 4287,
	4288, 4289, 4290, 4291, 4292, 4293, 0, 4295,
	0, 0, 0, 0, 0, 4301, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
};

static const OFUnichar uppercasePage166[0x100] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 42560, 0, 42562, 0, 42564, 0, 42566,
	0, 42568, 0, 42570, 0, 42572, 0, 42574,
	0, 42576, 0, 42578, 0, 42580, 0, 42582,
	0, 42584, 0, 42586, 0, 42588, 0, 42590,
	0, 42592, 0, 42594, 0, 42596, 0, 42598,
	0, 42600, 0, 42602, 0, 42604, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 42624, 0, 42626, 0, 42628, 0, 42630,
	0, 42632, 0, 42634, 0, 42636, 0, 42638,
	0, 42640, 0, 42642, 0, 42644, 0, 42646,
	0, 42648, 0, 42650, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
};

static const OFUnichar uppercasePage167[0x100] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 42786, 0, 42788, 0, 42790,
	0, 42792, 0, 42794, 0, 42796, 0, 42798,
	0, 0, 0, 42802, 0, 42804, 0, 42806,
	0, 42808, 0, 42810, 0, 42812, 0, 42814,
	0, 42816, 0, 42818, 0, 42820, 0, 42822,
	0, 42824, 0, 42826, 0, 42828, 0, 42830,
	0, 42832, 0, 42834, 0, 42836, 0, 42838,
	0, 42840, 0, 42842, 0, 42844, 0, 42846,
	0, 42848, 0, 42850, 0, 42852, 0, 42854,
	0, 42856, 0, 42858, 0, 42860, 0, 42862,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 42873, 0, 42875, 0, 0, 42878,
	0, 42880, 0, 42882, 0, 42884, 0, 42886,
	0, 0, 0, 0, 42891, 0, 0, 0,
	0, 42896, 0, 42898, 42948, 0, 0, 42902,
	0, 42904, 0, 42906, 0, 42908, 0, 42910,
	0, 42912, 0, 42914, 0, 42916, 0, 42918,
	0, 42920, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 42932, 0, 42934,
	0, 42936, 0, 42938, 0, 42940, 0, 42942,
	0, 42944, 0, 42946, 0, 0, 0, 0,
	42951, 0, 42953, 0, 0, 42956, 0, 42958,
	0, 42960, 0, 42962, 0, 42964, 0, 42966,
	0, 42968, 0, 42970, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 42997, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
};

static const OFUnichar uppercasePage171[0x100] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 42931, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	5024, 5025, 5026, 5027, 5028, 5029, 5030, 5031,
	5032, 5033, 5034, 5035, 5036, 5037, 5038, 5039,
	5040, 5041, 5042, 5043, 5044, 5045, 5046, 5047,
	5048, 5049, 5050, 5051, 5052, 5053, 5054, 5055,
	5056, 5057, 5058, 5059, 5060, 5061, 5062, 5063,
	5064, 5065, 5066, 5067, 5068, 5069, 5070, 5071,
	5072, 5073, 5074, 5075, 5076, 5077, 5078, 5079,
	5080, 5081, 5082, 5083, 5084, 5085, 5086, 5087,
	5088, 5089, 5090, 5091, 5092, 5093, 5094, 5095,
	5096, 5097, 5098, 5099, 5100, 5101, 5102, 5103,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
};

static const OFUnichar uppercasePage255[0x100] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 65313, 65314, 65315, 65316, 65317, 65318, 65319,
	65320, 65321, 65322, 65323, 65324, 65325, 65326, 65327,
	65328, 65329, 65330, 65331, 65332, 65333, 65334, 65335,
	65336, 65337, 65338, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
};

static const OFUnichar uppercasePage260[0x100] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	66560, 66561, 66562, 66563, 66564, 66565, 66566, 66567,
	66568, 66569, 66570, 66571, 66572, 66573, 66574, 66575,
	66576, 66577, 66578, 66579, 66580, 66581, 66582, 66583,
	66584, 66585, 66586, 66587, 66588, 66589, 66590, 66591,
	66592, 66593, 66594, 66595, 66596, 66597, 66598, 66599,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	66736, 66737, 66738, 66739, 66740, 66741, 66742, 66743,
	66744, 66745, 66746, 66747, 66748, 66749, 66750, 66751,
	66752, 66753, 66754, 66755, 66756, 66757, 66758, 66759,
	66760, 66761, 66762, 66763, 66764, 66765, 66766, 66767,
	66768, 66769, 66770, 66771, 0, 0, 0, 0,
};

static const OFUnichar uppercasePage261[0x100] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 66928,
	66929, 66930, 66931, 66932, 66933, 66934, 66935, 66936,
	66937, 66938, 0, 66940, 66941, 66942, 66943, 66944,
	66945, 66946, 66947, 66948, 66949, 66950, 66951, 66952,
	66953, 66954, 0, 66956, 66957, 66958, 66959, 66960,
	66961, 66962, 0, 66964, 66965, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
};

static const OFUnichar uppercasePage268[0x100] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	68736, 68737, 68738, 68739, 68740, 68741, 68742, 68743,
	68744, 68745, 68746, 68747, 68748, 68749, 68750, 68751,
	68752, 68753, 68754, 68755, 68756, 68757, 68758, 68759,
	68760, 68761, 68762, 68763, 68764, 68765, 68766, 68767,
	68768, 68769, 68770, 68771, 68772, 68773, 68774, 68775,
	68776, 68777, 68778, 68779, 68780, 68781, 68782, 68783,
	68784, 68785, 68786, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
};

static const OFUnichar uppercasePage269[0x100] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	68944, 68945, 68946, 68947, 68948, 68949, 68950, 68951,
	68952, 68953, 68954, 68955, 68956, 68957, 68958, 68959,
	68960, 68961, 68962, 68963, 68964, 68965, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
};

static const OFUnichar uppercasePage280[0x100] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	71840, 71841, 71842, 71843, 71844, 71845, 71846, 71847,
	71848, 71849, 71850, 71851, 71852, 71853, 71854, 71855,
	71856, 71857, 71858, 71859, 71860, 71861, 71862, 71863,
	71864, 71865, 71866, 71867, 71868, 71869, 71870, 71871,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
};

static const OFUnichar uppercasePage366[0x100] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	93760, 93761, 93762, 93763, 93764, 93765, 93766, 93767,
	93768, 93769, 93770, 93771, 93772, 93773, 93774, 93775,
	93776, 93777, 93778, 93779, 93780, 93781, 93782, 93783,
	93784, 93785, 93786, 93787, 93788, 93789, 93790, 93791,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 93856, 93857, 93858, 93859, 93860,
	93861, 93862, 93863, 93864, 93865, 93866, 93867, 93868,
	93869, 93870, 93871, 93872, 93873, 93874, 93875, 93876,
	93877, 93878, 93879, 93880, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
};

static const OFUnichar uppercasePage489[0x100] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 125184, 125185, 125186, 125187, 125188, 125189,
	125190, 125191, 125192, 125193, 125194, 125195, 125196, 125197,
	125198, 125199, 125200, 125201, 125202, 125203, 125204, 125205,
	125206, 125207, 125208, 125209, 125210, 125211, 125212, 125213,
	125214, 125215, 125216, 125217, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
};

static const OFUnichar lowercasePage0[0x100] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 97, 98, 99, 100, 101, 102, 103,
	104, 105, 106, 107, 108, 109, 110, 111,
	112, 113, 114, 115, 116, 117, 118, 119,
	120, 121, 122, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	224, 225, 226, 227, 228, 229, 230, 231,
	232, 233, 234, 235, 236, 237, 238, 239,
	240, 241, 242, 243, 244, 245, 246, 0,
	248, 249, 250, 251, 252, 253, 254, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
};

static const OFUnichar lowercasePage1[0x100] = {
	257, 0, 259, 0, 261, 0, 263, 0,
	265, 0, 267, 0, 269, 0, 271, 0,
	273, 0, 275, 0, 277, 0, 279, 0,
	281, 0, 283, 0, 285, 0, 287, 0,
	289, 0, 291, 0, 293, 0, 295, 0,
	297, 0, 299, 0, 301, 0, 303, 0,
	105, 0, 307, 0, 309, 0, 311, 0,
	0, 314, 0, 316, 0, 318, 0, 320,
	0, 322, 0, 324, 0, 326, 0, 328,
	0, 0, 331, 0, 333, 0, 335, 0,
	337, 0, 339, 0, 341, 0, 343, 0,
	345, 0, 347, 0, 349, 0, 351, 0,
	353, 0, 355, 0, 357, 0, 359, 0,
	361, 0, 363, 0, 365, 0, 367, 0,
	369, 0, 371, 0, 373, 0, 375, 0,
	255, 378, 0, 380, 0, 382, 0, 0,
	0, 595, 387, 0, 389, 0, 596, 392,
	0, 598, 599, 396, 0, 0, 477, 601,
	603, 402, 0, 608, 611, 0, 617, 616,
	409, 0, 0, 0, 623, 626, 0, 629,
	417, 0, 419, 0, 421, 0, 640, 424,
	0, 643, 0, 0, 429, 0, 648, 432,
	0, 650, 651, 436, 0, 438, 0, 658,
	441, 0, 0, 0, 445, 0, 0, 0,
	0, 0, 0, 0, 454, 454, 0, 457,
	457, 0, 460, 460, 0, 462, 0, 464,
	0, 466, 0, 468, 0, 470, 0, 472,
	0, 474, 0, 476, 0, 0, 479, 0,
	481, 0, 483, 0, 485, 0, 487, 0,
	489, 0, 491, 0, 493, 0, 495, 0,
	0, 499, 499, 0, 501, 0, 405, 447,
	505, 0, 507, 0, 509, 0, 511, 0,
};

static const OFUnichar lowercasePage2[0x100] = {
	513, 0, 515, 0, 517, 0, 519, 0,
	521, 0, 523, 0, 525, 0, 527, 0,
	529, 0, 531, 0, 533, 0, 535, 0,
	537, 0, 539, 0, 541, 0, 543, 0,
	414, 0, 547, 0, 549, 0, 551, 0,
	553, 0, 555, 0, 557, 0, 559, 0,
	561, 0, 563, 0, 0, 0, 0, 0,
	0, 0, 11365, 572, 0, 410, 11366, 0,
	0, 578, 0, 384, 649, 652, 583, 0,
	585, 0, 587, 0, 589, 0, 591, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
};

static const OFUnichar lowercasePage3[0x100] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	881, 0, 883, 0, 0, 0, 887, 0,
	0, 0, 0, 0, 0, 0, 0, 1011,
	0, 0, 0, 0, 0, 0, 940, 0,
	941, 942, 943, 0, 972, 0, 973, 974,
	0, 945, 946, 947, 948, 949, 950, 951,
	952, 953, 954, 955, 956, 957, 958, 959,
	960, 961, 0, 963, 964, 965, 966, 967,
	968, 969, 970, 971, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 983,
	0, 0, 0, 0, 0, 0, 0, 0,
	985, 0, 987, 0, 989, 0, 991, 0,
	993, 0, 995, 0, 997, 0, 999, 0,
	1001, 0, 1003, 0, 1005, 0, 1007, 0,
	0, 0, 0, 0, 952, 0, 0, 1016,
	0, 1010, 1019, 0, 0, 891, 892, 893,
};

static const OFUnichar lowercasePage4[0x100] = {
	1104, 1105, 1106, 1107, 1108, 1109, 1110, 1111,
	1112, 1113, 1114, 1115, 1116, 1117, 1118, 1119,
	1072, 1073, 1074, 1075, 1076, 1077, 1078, 1079,
	1080, 1081, 1082, 1083, 1084, 1085, 1086, 1087,
	1088, 1089, 1090, 1091, 1092, 1093, 1094, 1095,
	1096, 1097, 1098, 1099, 1100, 1101, 1102, 1103,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	1121, 0, 1123, 0, 1125, 0, 1127, 0,
	1129, 0, 1131, 0, 1133, 0, 1135, 0,
	1137, 0, 1139, 0, 1141, 0, 1143, 0,
	1145, 0, 1147, 0, 1149, 0, 1151, 0,
	1153, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 1163, 0, 1165, 0, 1167, 0,
	1169, 0, 1171, 0, 1173, 0, 1175, 0,
	1177, 0, 1179, 0, 1181, 0, 1183, 0,
	1185, 0, 1187, 0, 1189, 0, 1191, 0,
	1193, 0, 1195, 0, 1197, 0, 1199, 0,
	1201, 0, 1203, 0, 1205, 0, 1207, 0,
	1209, 0, 1211, 0, 1213, 0, 1215, 0,
	1231, 1218, 0, 1220, 0, 1222, 0, 1224,
	0, 1226, 0, 1228, 0, 1230, 0, 0,
	1233, 0, 1235, 0, 1237, 0, 1239, 0,
	1241, 0, 1243, 0, 1245, 0, 1247, 0,
	1249, 0, 1251, 0, 1253, 0, 1255, 0,
	1257, 0, 1259, 0, 1261, 0, 1263, 0,
	1265, 0, 1267, 0, 1269, 0, 1271, 0,
	1273, 0, 1275, 0, 1277, 0, 1279, 0,
};

static const OFUnichar lowercasePage5[0x100] = {
	1281, 0, 1283, 0, 1285, 0, 1287, 0,
	1289, 0, 1291, 0, 1293, 0, 1295, 0,
	1297, 0, 1299, 0, 1301, 0, 1303, 0,
	1305, 0, 1307, 0, 1309, 0, 1311, 0,
	1313, 0, 1315, 0, 1317, 0, 1319, 0,
	1321, 0, 1323, 0, 1325, 0, 1327, 0,
	0, 1377, 1378, 1379, 1380, 1381, 1382, 1383,
	1384, 1385, 1386, 1387, 1388, 1389, 1390, 1391,
	1392, 1393, 1394, 1395, 1396, 1397, 1398, 1399,
	1400, 1401, 1402, 1403, 1404, 1405, 1406, 1407,
	1408, 1409, 1410, 1411, 1412, 1413, 1414, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
};

static const OFUnichar lowercasePage16[0x100] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	11520, 11521, 11522, 11523, 11524, 11525, 11526, 11527,
	11528, 11529, 11530, 11531, 11532, 11533, 11534, 11535,
	11536, 11537, 11538, 11539, 11540, 11541, 11542, 11543,
	11544, 11545, 11546, 11547, 11548, 11549, 11550, 11551,
	11552, 11553, 11554, 11555, 11556, 11557, 0, 11559,
	0, 0, 0, 0, 0, 11565, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
};

static const OFUnichar lowercasePage19[0x100] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	43888, 43889, 43890, 43891, 43892, 43893, 43894, 43895,
	43896, 43897, 43898, 43899, 43900, 43901, 43902, 43903,
	43904, 43905, 43906, 43907, 43908, 43909, 43910, 43911,
	43912, 43913, 43914, 43915, 43916, 43917, 43918, 43919,
	43920, 43921, 43922, 43923, 43924, 43925, 43926, 43927,
	43928, 43929, 43930, 43931, 43932, 43933, 43934, 43935,
	43936, 43937, 43938, 43939, 43940, 43941, 43942, 43943,
	43944, 43945, 43946, 43947, 43948, 43949, 43950, 43951,
	43952, 43953, 43954, 43955, 43956, 43957, 43958, 43959,
	43960, 43961, 43962, 43963, 43964, 43965, 43966, 43967,
	5112, 5113, 5114, 5115, 5116, 5117, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
};

static const OFUnichar lowercasePage28[0x100] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 7306, 0, 0, 0, 0, 0, 0,
	4304, 4305, 4306, 4307, 4308, 4309, 4310, 4311,
	4312, 4313, 4314, 4315, 4316, 4317, 4318, 4319,
	4320, 4321, 4322, 4323, 4324, 4325, 4326, 4327,
	4328, 4329, 4330, 4331, 4332, 4333, 4334, 4335,
	4336, 4337, 4338, 4339, 4340, 4341, 4342, 4343,
	4344, 4345, 4346, 0, 0, 4349, 4350, 4351,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
};

static const OFUnichar lowercasePage30[0x100] = {
	7681, 0, 7683, 0, 7685, 0, 7687, 0,
	7689, 0, 7691, 0, 7693, 0, 7695, 0,
	7697, 0, 7699, 0, 7701, 0, 7703, 0,
	7705, 0, 7707, 0, 7709, 0, 7711, 0,
	7713, 0, 7715, 0, 7717, 0, 7719, 0,
	7721, 0, 7723, 0, 7725, 0, 7727, 0,
	7729, 0, 7731, 0, 7733, 0, 7735, 0,
	7737, 0, 7739, 0, 7741, 0, 7743, 0,
	7745, 0, 7747, 0, 7749, 0, 7751, 0,
	7753, 0, 7755, 0, 7757, 0, 7759, 0,
	7761, 0, 7763, 0, 7765, 0, 7767, 0,
	7769, 0, 7771, 0, 7773, 0, 7775, 0,
	7777, 0, 7779, 0, 7781, 0, 7783, 0,
	7785, 0, 7787, 0, 7789, 0, 7791, 0,
	7793, 0, 7795, 0, 7797, 0, 7799, 0,
	7801, 0, 7803, 0, 7805, 0, 7807, 0,
	7809, 0, 7811, 0, 7813, 0, 7815, 0,
	7817, 0, 7819, 0, 7821, 0, 7823, 0,
	7825, 0, 7827, 0, 7829, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 223, 0,
	7841, 0, 7843, 0, 7845, 0, 7847, 0,
	7849, 0, 7851, 0, 7853, 0, 7855, 0,
	7857, 0, 7859, 0, 7861, 0, 7863, 0,
	7865, 0, 7867, 0, 7869, 0, 7871, 0,
	7873, 0, 7875, 0, 7877, 0, 7879, 0,
	7881, 0, 7883, 0, 7885, 0, 7887, 0,
	7889, 0, 7891, 0, 7893, 0, 7895, 0,
	7897, 0, 7899, 0, 7901, 0, 7903, 0,
	7905, 0, 7907, 0, 7909, 0, 7911, 0,
	7913, 0, 7915, 0, 7917, 0, 7919, 0,
	7921, 0, 7923, 0, 7925, 0, 7927, 0,
	7929, 0, 7931, 0, 7933, 0, 7935, 0,
};

static const OFUnichar lowercasePage31[0x100] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	7936, 7937, 7938, 7939, 7940, 7941, 7942, 7943,
	0, 0, 0, 0, 0, 0, 0, 0,
	7952, 7953, 7954, 7955, 7956, 7957, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	7968, 7969, 7970, 7971, 7972, 7973, 7974, 7975,
	0, 0, 0, 0, 0, 0, 0, 0,
	7984, 7985, 7986, 7987, 7988, 7989, 7990, 7991,
	0, 0, 0, 0, 0, 0, 0, 0,
	8000, 8001, 8002, 8003, 8004, 8005, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 8017, 0, 8019, 0, 8021, 0, 8023,
	0, 0, 0, 0, 0, 0, 0, 0,
	8032, 8033, 8034, 8035, 8036, 8037, 8038, 8039,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	8064, 8065, 8066, 8067, 8068, 8069, 8070, 8071,
	0, 0, 0, 0, 0, 0, 0, 0,
	8080, 8081, 8082, 8083, 8084, 8085, 8086, 8087,
	0, 0, 0, 0, 0, 0, 0, 0,
	8096, 8097, 8098, 8099, 8100, 8101, 8102, 8103,
	0, 0, 0, 0, 0, 0, 0, 0,
	8112, 8113, 8048, 8049, 8115, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	8050, 8051, 8052, 8053, 8131, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	8144, 8145, 8054, 8055, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	8160, 8161, 8058, 8059, 8165, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	8056, 8057, 8060, 8061, 8179, 0, 0, 0,
};

static const OFUnichar lowercasePage33[0x100] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 969, 0,
	0, 0, 107, 229, 0, 0, 0, 0,
	0, 0, 8526, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	8560, 8561, 8562, 8563, 8564, 8565, 8566, 8567,
	8568, 8569, 8570, 8571, 8572, 8573, 8574, 8575,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 8580, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
};

static const OFUnichar lowercasePage36[0x100] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 9424, 9425,
	9426, 9427, 9428, 9429, 9430, 9431, 9432, 9433,
	9434, 9435, 9436, 9437, 9438, 9439, 9440, 9441,
	9442, 9443, 9444, 9445, 9446, 9447, 9448, 9449,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
};

static const OFUnichar lowercasePage44[0x100] = {
	11312, 11313, 11314, 11315, 11316, 11317, 11318, 11319,
	11320, 11321, 11322, 11323, 11324, 11325, 11326, 11327,
	11328, 11329, 11330, 11331, 11332, 11333, 11334, 11335,
	11336, 11337, 11338, 11339, 11340, 11341, 11342, 11343,
	11344, 11345, 11346, 11347, 11348, 11349, 11350, 11351,
	11352, 11353, 11354, 11355, 11356, 11357, 11358, 11359,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	11361, 0, 619, 7549, 637, 0, 0, 11368,
	0, 11370, 0, 11372, 0, 593, 625, 592,
	594, 0, 11379, 0, 0, 11382, 0, 0,
	0, 0, 0, 0, 0, 0, 575, 576,
	11393, 0, 11395, 0, 11397, 0, 11399, 0,
	11401, 0, 11403, 0, 11405, 0, 11407, 0,
	11409, 0, 11411, 0, 11413, 0, 11415, 0,
	11417, 0, 11419, 0, 11421, 0, 11423, 0,
	11425, 0, 11427, 0, 11429, 0, 11431, 0,
	11433, 0, 11435, 0, 11437, 0, 11439, 0,
	11441, 0, 11443, 0, 11445, 0, 11447, 0,
	11449, 0, 11451, 0, 11453, 0, 11455, 0,
	11457, 0, 11459, 0, 11461, 0, 11463, 0,
	11465, 0, 11467, 0, 11469, 0, 11471, 0,
	11473, 0, 11475, 0, 11477, 0, 11479, 0,
	11481, 0, 11483, 0, 11485, 0, 11487, 0,
	11489, 0, 11491, 0, 0, 0, 0, 0,
	0, 0, 0, 11500, 0, 11502, 0, 0,
	0, 0, 11507, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
};

static const OFUnichar lowercasePage166[0x100] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	42561, 0, 42563, 0, 42565, 0, 42567, 0,
	42569, 0, 42571, 0, 42573, 0, 42575, 0,
	42577, 0, 42579, 0, 42581, 0, 42583, 0,
	42585, 0, 42587, 0, 42589, 0, 42591, 0,
	42593, 0, 42595, 0, 42597, 0, 42599, 0,
	42601, 0, 42603, 0, 42605, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	42625, 0, 42627, 0, 42629, 0, 42631, 0,
	42633, 0, 42635, 0, 42637, 0, 42639, 0,
	42641, 0, 42643, 0, 42645, 0, 42647, 0,
	42649, 0, 42651, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
};

static const OFUnichar lowercasePage167[0x100] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 42787, 0, 42789, 0, 42791, 0,
	42793, 0, 42795, 0, 42797, 0, 42799, 0,
	0, 0, 42803, 0, 42805, 0, 42807, 0,
	42809, 0, 42811, 0, 42813, 0, 42815, 0,
	42817, 0, 42819, 0, 42821, 0, 42823, 0,
	42825, 0, 42827, 0, 42829, 0, 42831, 0,
	42833, 0, 42835, 0, 42837, 0, 42839, 0,
	42841, 0, 42843, 0, 42845, 0, 42847, 0,
	42849, 0, 42851, 0, 42853, 0, 42855, 0,
	42857, 0, 42859, 0, 42861, 0, 42863, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 42874, 0, 42876, 0, 7545, 42879, 0,
	42881, 0, 42883, 0, 42885, 0, 42887, 0,
	0, 0, 0, 42892, 0, 613, 0, 0,
	42897, 0, 42899, 0, 0, 0, 42903, 0,
	42905, 0, 42907, 0, 42909, 0, 42911, 0,
	42913, 0, 42915, 0, 42917, 0, 42919, 0,
	42921, 0, 614, 604, 609, 620, 618, 0,
	670, 647, 669, 43859, 42933, 0, 42935, 0,
	42937, 0, 42939, 0, 42941, 0, 42943, 0,
	42945, 0, 42947, 0, 42900, 642, 7566, 42952,
	0, 42954, 0, 612, 42957, 0, 42959, 0,
	42961, 0, 42963, 0, 42965, 0, 42967, 0,
	42969, 0, 42971, 0, 411, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 42998, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
};

static const OFUnichar lowercasePage255[0x100] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 65345, 65346, 65347, 65348, 65349, 65350, 65351,
	65352, 65353, 65354, 65355, 65356, 65357, 65358, 65359,
	65360, 65361, 65362, 65363, 65364, 65365, 65366, 65367,
	65368, 65369, 65370, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
};

static const OFUnichar lowercasePage260[0x100] = {
	66600, 66601, 66602, 66603, 66604, 66605, 66606, 66607,
	66608, 66609, 66610, 66611, 66612, 66613, 66614, 66615,
	66616, 66617, 66618, 66619, 66620, 66621, 66622, 66623,
	66624, 66625, 66626, 66627, 66628, 66629, 66630, 66631,
	66632, 66633, 66634, 66635, 66636, 66637, 66638, 66639,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	66776, 66777, 66778, 66779, 66780, 66781, 66782, 66783,
	66784, 66785, 66786, 66787, 66788, 66789, 66790, 66791,
	66792, 66793, 66794, 66795, 66796, 66797, 66798, 66799,
	66800, 66801, 66802, 66803, 66804, 66805, 66806, 66807,
	66808, 66809, 66810, 66811, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
};

static const OFUnichar lowercasePage261[0x100] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	66967, 66968, 66969, 66970, 66971, 66972, 66973, 66974,
	66975, 66976, 66977, 0, 66979, 66980, 66981, 66982,
	66983, 66984, 66985, 66986, 66987, 66988, 66989, 66990,
	66991, 66992, 66993, 0, 66995, 66996, 66997, 66998,
	66999, 67000, 67001, 0, 67003, 67004, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
};

static const OFUnichar lowercasePage268[0x100] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	68800, 68801, 68802, 68803, 68804, 68805, 68806, 68807,
	68808, 68809, 68810, 68811, 68812, 68813, 68814, 68815,
	68816, 68817, 68818, 68819, 68820, 68821, 68822, 68823,
	68824, 68825, 68826, 68827, 68828, 68829, 68830, 68831,
	68832, 68833, 68834, 68835, 68836, 68837, 68838, 68839,
	68840, 68841, 68842, 68843, 68844, 68845, 68846, 68847,
	68848, 68849, 68850, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
};

static const OFUnichar lowercasePage269[0x100] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	68976, 68977, 68978, 68979, 68980, 68981, 68982, 68983,
	68984, 68985, 68986, 68987, 68988, 68989, 68990, 68991,
	68992, 68993, 68994, 68995, 68996, 68997, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
};

static const OFUnichar lowercasePage280[0x100] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	71872, 71873, 71874, 71875, 71876, 71877, 71878, 71879,
	71880, 71881, 71882, 71883, 71884, 71885, 71886, 71887,
	71888, 71889, 71890, 71891, 71892, 71893, 71894, 71895,
	71896, 71897, 71898, 71899, 71900, 71901, 71902, 71903,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
};

static const OFUnichar lowercasePage366[0x100] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	93792, 93793, 93794, 93795, 93796, 93797, 93798, 93799,
	93800, 93801, 93802, 93803, 93804, 93805, 93806, 93807,
	93808, 93809, 93810, 93811, 93812, 93813, 93814, 93815,
	93816, 93817, 93818, 93819, 93820, 93821, 93822, 93823,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	93883, 93884, 93885, 93886, 93887, 93888, 93889, 93890,
	93891, 93892, 93893, 93894, 93895, 93896, 93897, 93898,
	93899, 93900, 93901, 93902, 93903, 93904, 93905, 93906,
	93907, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
};

static const OFUnichar lowercasePage489[0x100] = {
	125218, 125219, 125220, 125221, 125222, 125223, 125224, 125225,
	125226, 125227, 125228, 125229, 125230, 125231, 125232, 125233,
	125234, 125235, 125236, 125237, 125238, 125239, 125240, 125241,
	125242, 125243, 125244, 125245, 125246, 125247, 125248, 125249,
	125250, 125251, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
};

static const OFUnichar titlecasePage1[0x100] = {
	0, 256, 0, 258, 0, 260, 0, 262,
	0, 264, 0, 266, 0, 268, 0, 270,
	0, 272, 0, 274, 0, 276, 0, 278,
	0, 280, 0, 282, 0, 284, 0, 286,
	0, 288, 0, 290, 0, 292, 0, 294,
	0, 296, 0, 298, 0, 300, 0, 302,
	0, 73, 0, 306, 0, 308, 0, 310,
	0, 0, 313, 0, 315, 0, 317, 0,
	319, 0, 321, 0, 323, 0, 325, 0,
	327, 0, 0, 330, 0, 332, 0, 334,
	0, 336, 0, 338, 0, 340, 0, 342,
	0, 344, 0, 346, 0, 348, 0, 350,
	0, 352, 0, 354, 0, 356, 0, 358,
	0, 360, 0, 362, 0, 364, 0, 366,
	0, 368, 0, 370, 0, 372, 0, 374,
	0, 0, 377, 0, 379, 0, 381, 83,
	579, 0, 0, 386, 0, 388, 0, 0,
	391, 0, 0, 0, 395, 0, 0, 0,
	0, 0, 401, 0, 0, 502, 0, 0,
	0, 408, 573, 42972, 0, 0, 544, 0,
	0, 416, 0, 418, 0, 420, 0, 0,
	423, 0, 0, 0, 0, 428, 0, 0,
	431, 0, 0, 0, 435, 0, 437, 0,
	0, 440, 0, 0, 0, 444, 0, 503,
	0, 0, 0, 0, 453, 453, 453, 456,
	456, 456, 459, 459, 459, 0, 461, 0,
	463, 0, 465, 0, 467, 0, 469, 0,
	471, 0, 473, 0, 475, 398, 0, 478,
	0, 480, 0, 482, 0, 484, 0, 486,
	0, 488, 0, 490, 0, 492, 0, 494,
	0, 498, 498, 498, 0, 500, 0, 0,
	0, 504, 0, 506, 0, 508, 0, 510,
};

static const OFUnichar titlecasePage16[0x100] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	4304, 4305, 4306, 4307, 4308, 4309, 4310, 4311,
	4312, 4313, 4314, 4315, 4316, 4317, 4318, 4319,
	4320, 4321, 4322, 4323, 4324, 4325, 4326, 4327,
	4328, 4329, 4330, 4331, 4332, 4333, 4334, 4335,
	4336, 4337, 4338, 4339, 4340, 4341, 4342, 4343,
	4344, 4345, 4346, 0, 0, 4349, 4350, 4351,
};

static const OFUnichar caseFoldingPage0[0x100] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 97, 98, 99, 100, 101, 102, 103,
	104, 105, 106, 107, 108, 109, 110, 111,
	112, 113, 114, 115, 116, 117, 118, 119,
	120, 121, 122, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 956, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	224, 225, 226, 227, 228, 229, 230, 231,
	232, 233, 234, 235, 236, 237, 238, 239,
	240, 241, 242, 243, 244, 245, 246, 0,
	248, 249, 250, 251, 252, 253, 254, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
};

static const OFUnichar caseFoldingPage1[0x100] = {
	257, 0, 259, 0, 261, 0, 263, 0,
	265, 0, 267, 0, 269, 0, 271, 0,
	273, 0, 275, 0, 277, 0, 279, 0,
	281, 0, 283, 0, 285, 0, 287, 0,
	289, 0, 291, 0, 293, 0, 295, 0,
	297, 0, 299, 0, 301, 0, 303, 0,
	0, 0, 307, 0, 309, 0, 311, 0,
	0, 314, 0, 316, 0, 318, 0, 320,
	0, 322, 0, 324, 0, 326, 0, 328,
	0, 0, 331, 0, 333, 0, 335, 0,
	337, 0, 339, 0, 341, 0, 343, 0,
	345, 0, 347, 0, 349, 0, 351, 0,
	353, 0, 355, 0, 357, 0, 359, 0,
	361, 0, 363, 0, 365, 0, 367, 0,
	369, 0, 371, 0, 373, 0, 375, 0,
	255, 378, 0, 380, 0, 382, 0, 115,
	0, 595, 387, 0, 389, 0, 596, 392,
	0, 598, 599, 396, 0, 0, 477, 601,
	603, 402, 0, 608, 611, 0, 617, 616,
	409, 0, 0, 0, 623, 626, 0, 629,
	417, 0, 419, 0, 421, 0, 640, 424,
	0, 643, 0, 0, 429, 0, 648, 432,
	0, 650, 651, 436, 0, 438, 0, 658,
	441, 0, 0, 0, 445, 0, 0, 0,
	0, 0, 0, 0, 454, 454, 0, 457,
	457, 0, 460, 460, 0, 462, 0, 464,
	0, 466, 0, 468, 0, 470, 0, 472,
	0, 474, 0, 476, 0, 0, 479, 0,
	481, 0, 483, 0, 485, 0, 487, 0,
	489, 0, 491, 0, 493, 0, 495, 0,
	0, 499, 499, 0, 501, 0, 405, 447,
	505, 0, 507, 0, 509, 0, 511, 0,
};

static const OFUnichar caseFoldingPage3[0x100] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 953, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	881, 0, 883, 0, 0, 0, 887, 0,
	0, 0, 0, 0, 0, 0, 0, 1011,
	0, 0, 0, 0, 0, 0, 940, 0,
	941, 942, 943, 0, 972, 0, 973, 974,
	0, 945, 946, 947, 948, 949, 950, 951,
	952, 953, 954, 955, 956, 957, 958, 959,
	960, 961, 0, 963, 964, 965, 966, 967,
	968, 969, 970, 971, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 963, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 983,
	946, 952, 0, 0, 0, 966, 960, 0,
	985, 0, 987, 0, 989, 0, 991, 0,
	993, 0, 995, 0, 997, 0, 999, 0,
	1001, 0, 1003, 0, 1005, 0, 1007, 0,
	954, 961, 0, 0, 952, 949, 0, 1016,
	0, 1010, 1019, 0, 0, 891, 892, 893,
};

static const OFUnichar caseFoldingPage19[0x100] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	5104, 5105, 5106, 5107, 5108, 5109, 0, 0,
};

static const OFUnichar caseFoldingPage28[0x100] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	1074, 1076, 1086, 1089, 1090, 1090, 1098, 1123,
	42571, 7306, 0, 0, 0, 0, 0, 0,
	4304, 4305, 4306, 4307, 4308, 4309, 4310, 4311,
	4312, 4313, 4314, 4315, 4316, 4317, 4318, 4319,
	4320, 4321, 4322, 4323, 4324, 4325, 4326, 4327,
	4328, 4329, 4330, 4331, 4332, 4333, 4334, 4335,
	4336, 4337, 4338, 4339, 4340, 4341, 4342, 4343,
	4344, 4345, 4346, 0, 0, 4349, 4350, 4351,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
};

static const OFUnichar caseFoldingPage30[0x100] = {
	7681, 0, 7683, 0, 7685, 0, 7687, 0,
	7689, 0, 7691, 0, 7693, 0, 7695, 0,
	7697, 0, 7699, 0, 7701, 0, 7703, 0,
	7705, 0, 7707, 0, 7709, 0, 7711, 0,
	7713, 0, 7715, 0, 7717, 0, 7719, 0,
	7721, 0, 7723, 0, 7725, 0, 7727, 0,
	7729, 0, 7731, 0, 7733, 0, 7735, 0,
	7737, 0, 7739, 0, 7741, 0, 7743, 0,
	7745, 0, 7747, 0, 7749, 0, 7751, 0,
	7753, 0, 7755, 0, 7757, 0, 7759, 0,
	7761, 0, 7763, 0, 7765, 0, 7767, 0,
	7769, 0, 7771, 0, 7773, 0, 7775, 0,
	7777, 0, 7779, 0, 7781, 0, 7783, 0,
	7785, 0, 7787, 0, 7789, 0, 7791, 0,
	7793, 0, 7795, 0, 7797, 0, 7799, 0,
	7801, 0, 7803, 0, 7805, 0, 7807, 0,
	7809, 0, 7811, 0, 7813, 0, 7815, 0,
	7817, 0, 7819, 0, 7821, 0, 7823, 0,
	7825, 0, 7827, 0, 7829, 0, 0, 0,
	0, 0, 0, 7777, 0, 0, 223, 0,
	7841, 0, 7843, 0, 7845, 0, 7847, 0,
	7849, 0, 7851, 0, 7853, 0, 7855, 0,
	7857, 0, 7859, 0, 7861, 0, 7863, 0,
	7865, 0, 7867, 0, 7869, 0, 7871, 0,
	7873, 0, 7875, 0, 7877, 0, 7879, 0,
	7881, 0, 7883, 0, 7885, 0, 7887, 0,
	7889, 0, 7891, 0, 7893, 0, 7895, 0,
	7897, 0, 7899, 0, 7901, 0, 7903, 0,
	7905, 0, 7907, 0, 7909, 0, 7911, 0,
	7913, 0, 7915, 0, 7917, 0, 7919, 0,
	7921, 0, 7923, 0, 7925, 0, 7927, 0,
	7929, 0, 7931, 0, 7933, 0, 7935, 0,
};

static const OFUnichar caseFoldingPage31[0x100] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	7936, 7937, 7938, 7939, 7940, 7941, 7942, 7943,
	0, 0, 0, 0, 0, 0, 0, 0,
	7952, 7953, 7954, 7955, 7956, 7957, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	7968, 7969, 7970, 7971, 7972, 7973, 7974, 7975,
	0, 0, 0, 0, 0, 0, 0, 0,
	7984, 7985, 7986, 7987, 7988, 7989, 7990, 7991,
	0, 0, 0, 0, 0, 0, 0, 0,
	8000, 8001, 8002, 8003, 8004, 8005, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 8017, 0, 8019, 0, 8021, 0, 8023,
	0, 0, 0, 0, 0, 0, 0, 0,
	8032, 8033, 8034, 8035, 8036, 8037, 8038, 8039,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	8064, 8065, 8066, 8067, 8068, 8069, 8070, 8071,
	0, 0, 0, 0, 0, 0, 0, 0,
	8080, 8081, 8082, 8083, 8084, 8085, 8086, 8087,
	0, 0, 0, 0, 0, 0, 0, 0,
	8096, 8097, 8098, 8099, 8100, 8101, 8102, 8103,
	0, 0, 0, 0, 0, 0, 0, 0,
	8112, 8113, 8048, 8049, 8115, 0, 953, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	8050, 8051, 8052, 8053, 8131, 0, 0, 0,
	0, 0, 0, 912, 0, 0, 0, 0,
	8144, 8145, 8054, 8055, 0, 0, 0, 0,
	0, 0, 0, 944, 0, 0, 0, 0,
	8160, 8161, 8058, 8059, 8165, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	8056, 8057, 8060, 8061, 8179, 0, 0, 0,
};

static const OFUnichar caseFoldingPage171[0x100] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	5024, 5025, 5026, 5027, 5028, 5029, 5030, 5031,
	5032, 5033, 5034, 5035, 5036, 5037, 5038, 5039,
	5040, 5041, 5042, 5043, 5044, 5045, 5046, 5047,
	5048, 5049, 5050, 5051, 5052, 5053, 5054, 5055,
	5056, 5057, 5058, 5059, 5060, 5061, 5062, 5063,
	5064, 5065, 5066, 5067, 5068, 5069, 5070, 5071,
	5072, 5073, 5074, 5075, 5076, 5077, 5078, 5079,
	5080, 5081, 5082, 5083, 5084, 5085, 5086, 5087,
	5088, 5089, 5090, 5091, 5092, 5093, 5094, 5095,
	5096, 5097, 5098, 5099, 5100, 5101, 5102, 5103,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
};

static const OFUnichar caseFoldingPage251[0x100] = {
	0, 0, 0, 0, 0, 64262, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
};

const OFUnichar *const _OFUnicodeUppercaseTable[0x1EA] = {
	uppercasePage0, uppercasePage1, uppercasePage2, uppercasePage3,
	uppercasePage4, uppercasePage5, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	uppercasePage16, emptyPage, emptyPage, uppercasePage19,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	uppercasePage28, uppercasePage29, uppercasePage30, uppercasePage31,
	emptyPage, uppercasePage33, emptyPage, emptyPage,
	uppercasePage36, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	uppercasePage44, uppercasePage45, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, uppercasePage166, uppercasePage167,
	emptyPage, emptyPage, emptyPage, uppercasePage171,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, uppercasePage255,
	emptyPage, emptyPage, emptyPage, emptyPage,
	uppercasePage260, uppercasePage261, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	uppercasePage268, uppercasePage269, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	uppercasePage280, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, uppercasePage366, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, uppercasePage489
};

const OFUnichar *const _OFUnicodeLowercaseTable[0x1EA] = {
	lowercasePage0, lowercasePage1, lowercasePage2, lowercasePage3,
	lowercasePage4, lowercasePage5, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	lowercasePage16, emptyPage, emptyPage, lowercasePage19,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	lowercasePage28, emptyPage, lowercasePage30, lowercasePage31,
	emptyPage, lowercasePage33, emptyPage, emptyPage,
	lowercasePage36, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	lowercasePage44, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, lowercasePage166, lowercasePage167,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, lowercasePage255,
	emptyPage, emptyPage, emptyPage, emptyPage,
	lowercasePage260, lowercasePage261, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	lowercasePage268, lowercasePage269, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	lowercasePage280, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, lowercasePage366, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, lowercasePage489
};

const OFUnichar *const _OFUnicodeTitlecaseTable[0x1EA] = {
	uppercasePage0, titlecasePage1, uppercasePage2, uppercasePage3,
	uppercasePage4, uppercasePage5, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	titlecasePage16, emptyPage, emptyPage, uppercasePage19,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	uppercasePage28, uppercasePage29, uppercasePage30, uppercasePage31,
	emptyPage, uppercasePage33, emptyPage, emptyPage,
	uppercasePage36, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	uppercasePage44, uppercasePage45, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, uppercasePage166, uppercasePage167,
	emptyPage, emptyPage, emptyPage, uppercasePage171,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, uppercasePage255,
	emptyPage, emptyPage, emptyPage, emptyPage,
	uppercasePage260, uppercasePage261, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	uppercasePage268, uppercasePage269, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	uppercasePage280, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, uppercasePage366, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage, emptyPage,
	emptyPage, uppercasePage489
};

const OFUnichar *const _OFUnicodeCaseFoldingTable[0x1EA] = {
	caseFoldingPage0, caseFoldingPage1, lowercasePage2,
	caseFoldingPage3, lowercasePage4, lowercasePage5,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, lowercasePage16, emptyPage,
	emptyPage, caseFoldingPage19, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, caseFoldingPage28, emptyPage,
	caseFoldingPage30, caseFoldingPage31, emptyPage,
	lowercasePage33, emptyPage, emptyPage,
	lowercasePage36, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, lowercasePage44,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, lowercasePage166, lowercasePage167,
	emptyPage, emptyPage, emptyPage,
	caseFoldingPage171, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, caseFoldingPage251,
	emptyPage, emptyPage, emptyPage,
	lowercasePage255, emptyPage, emptyPage,
	emptyPage, emptyPage, lowercasePage260,
	lowercasePage261, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, lowercasePage268, lowercasePage269,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, lowercasePage280, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	lowercasePage366, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	emptyPage, emptyPage, emptyPage,
	lowercasePage489
};

