/*
** ###################################################################
**     Processors:          RW610ETA2I
**                          RW610HNA2I
**                          RW610UKA2I
**                          RW612ETA2I
**                          RW612HNA2I
**                          RW612UKA2I
**
**     Version:             rev. 1.0, 2021-03-16
**     Build:               b240715
**
**     Abstract:
**         CMSIS Peripheral Access Layer for OCOTP
**
**     Copyright 1997-2016 Freescale Semiconductor, Inc.
**     Copyright 2016-2024 NXP
**     SPDX-License-Identifier: BSD-3-Clause
**
**     http:                 www.nxp.com
**     mail:                 support@nxp.com
**
**     Revisions:
**     - rev. 1.0 (2021-03-16)
**         Initial version.
**
** ###################################################################
*/

/*!
 * @file OCOTP.h
 * @version 1.0
 * @date 2021-03-16
 * @brief CMSIS Peripheral Access Layer for OCOTP
 *
 * CMSIS Peripheral Access Layer for OCOTP
 */

#if !defined(OCOTP_H_)
#define OCOTP_H_                                 /**< Symbol preventing repeated inclusion */

#if (defined(CPU_RW610ETA2I) || defined(CPU_RW610HNA2I) || defined(CPU_RW610UKA2I))
#include "RW610_COMMON.h"
#elif (defined(CPU_RW612ETA2I) || defined(CPU_RW612HNA2I) || defined(CPU_RW612UKA2I))
#include "RW612_COMMON.h"
#else
  #error "No valid CPU defined!"
#endif

/* ----------------------------------------------------------------------------
   -- Device Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Peripheral_access_layer Device Peripheral Access Layer
 * @{
 */


/*
** Start of section using anonymous unions
*/

#if defined(__ARMCC_VERSION)
  #if (__ARMCC_VERSION >= 6010050)
    #pragma clang diagnostic push
  #else
    #pragma push
    #pragma anon_unions
  #endif
#elif defined(__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined(__IAR_SYSTEMS_ICC__)
  #pragma language=extended
#else
  #error Not supported compiler type
#endif

/* ----------------------------------------------------------------------------
   -- OCOTP Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup OCOTP_Peripheral_Access_Layer OCOTP Peripheral Access Layer
 * @{
 */

/** OCOTP - Size of Registers Arrays */
#define OCOTP_OTP_SHADOW_COUNT                    420u
#define OCOTP_OTP_CRC_LUT_COUNT                   8u

/** OCOTP - Register Layout Typedef */
typedef struct {
  __IO uint32_t OTP_SHADOW[OCOTP_OTP_SHADOW_COUNT]; /**< OTP shadow register N, array offset: 0x0, array step: 0x4 */
       uint8_t RESERVED_0[368];
  __IO uint32_t OTP_CTRL;                          /**< OTP Controller Control Register, offset: 0x800 */
  __IO uint32_t OTP_PDN;                           /**< OTP Controller PDN Register, offset: 0x804 */
  __IO uint32_t OTP_WRITE_DATA;                    /**< OTP Controller Write Data Register, offset: 0x808 */
  __IO uint32_t OTP_READ_CTRL;                     /**< OTP Controller Read Ctrl Register, offset: 0x80C */
  __IO uint32_t OTP_READ_DATA;                     /**< OTP Controller Read Data Register, offset: 0x810 */
  __IO uint32_t OTP_CLK_DIV;                       /**< OTP Controller Clock Divider register, offset: 0x814 */
  __IO uint32_t OTP_CRC_CTRL;                      /**< OTP Controller CRC Ctrl Register, offset: 0x818 */
  __I  uint32_t OTP_CRC_VALUE;                     /**< OTP Controller CRC Value Register, offset: 0x81C */
  __IO uint32_t OTP_STATUS;                        /**< OTP Controller Status Register, offset: 0x820 */
  __I  uint32_t OTP_STARTWORD;                     /**< OTP Controller Startword Register, offset: 0x824 */
  __I  uint32_t OTP_VERSION;                       /**< OTP Controller Version Register, offset: 0x828 */
  __IO uint32_t OTP_NONMASK_STATUS1;               /**< OTP Controller Nonmask Status1 Register, offset: 0x82C */
  __IO uint32_t OTP_MASK_CTRL1;                    /**< OTP Controller Mask Ctrl1 Register, offset: 0x830 */
  __IO uint32_t OTP_MASK_STATUS1;                  /**< OTP Controller Nonmask Status1 Register, offset: 0x834 */
  __IO uint32_t OTP_ECC_CTRL;                      /**< OTP Controller ECC Ctrl Register, offset: 0x838 */
  __IO uint32_t OTP_ECC_DATA;                      /**< OTP Controller ECC Date Register, offset: 0x83C */
  __I  uint32_t OTP_ECC_DBG1;                      /**< OTP Controller ECC DBG Register1, offset: 0x840 */
  __I  uint32_t OTP_ECC_DBG2;                      /**< OTP Controller ECC DBG Register2, offset: 0x844 */
  __IO uint32_t OTP_ECC_DBG3;                      /**< OTP Controller ECC DBG Register3, offset: 0x848 */
  __IO uint32_t OTP_PRNG_RAND_SEED;                /**< OTP Controller PRNG Random Seed Register, offset: 0x84C */
  __I  uint32_t OTP_SRAM_ENTROPY_DATA;             /**< OTP Controller SRAM Entropy Data Register, offset: 0x850 */
  __I  uint32_t OTP_PRNG_OUTPUT_DATA;              /**< OTP Controller PRNG Output Data Register, offset: 0x854 */
       uint8_t RESERVED_1[4];
  __IO uint32_t OTP_CRC_LUT[OCOTP_OTP_CRC_LUT_COUNT]; /**< OTP Controller CRC LUT Register0..OTP Controller CRC LUT Register7, array offset: 0x85C, array step: 0x4 */
  __IO uint32_t OTP_LOCK_STICKY_0;                 /**< OTP Controller Lock Sticky Register0, offset: 0x87C */
  __IO uint32_t OTP_LOCK_STICKY_1;                 /**< OTP Controller Lock Sticky Register1, offset: 0x880 */
  __IO uint32_t OTP_LOCK_STICKY_2;                 /**< OTP Controller Lock Sticky Register2, offset: 0x884 */
  __IO uint32_t OTP_LOCK_STICKY_3;                 /**< OTP Controller Lock Sticky Register3, offset: 0x888 */
  __IO uint32_t OTP_LOCK_STICKY_4;                 /**< OTP Controller Lock Sticky Register4, offset: 0x88C */
  __IO uint32_t OTP_LOCK_STICKY_5;                 /**< OTP Controller Lock Sticky Register5, offset: 0x890 */
  __IO uint32_t OTP_LOCK_STICKY_6;                 /**< OTP Controller Lock Sticky Register6, offset: 0x894 */
  __IO uint32_t OTP_LOCK_STICKY_7;                 /**< OTP Controller Lock Sticky Register7, offset: 0x898 */
  __IO uint32_t OTP_LOCK_STICKY_8;                 /**< OTP Controller Lock Sticky Register8, offset: 0x89C */
  __IO uint32_t OTP_LOCK_STICKY_9;                 /**< OTP Controller Lock Sticky Register9, offset: 0x8A0 */
  __IO uint32_t OTP_LOCK_STICKY_10;                /**< OTP Controller Lock Sticky Register10, offset: 0x8A4 */
  __IO uint32_t OTP_LOCK_STICKY_11;                /**< OTP Controller Lock Sticky Register11, offset: 0x8A8 */
} OCOTP_Type;

/* ----------------------------------------------------------------------------
   -- OCOTP Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup OCOTP_Register_Masks OCOTP Register Masks
 * @{
 */

/*! @name OTP_SHADOW - OTP shadow register N */
/*! @{ */

#define OCOTP_OTP_SHADOW_SHADOW_MASK             (0xFFFFFFFFU)
#define OCOTP_OTP_SHADOW_SHADOW_SHIFT            (0U)
/*! SHADOW - OTP shadow register */
#define OCOTP_OTP_SHADOW_SHADOW(x)               (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_SHADOW_SHADOW_SHIFT)) & OCOTP_OTP_SHADOW_SHADOW_MASK)
/*! @} */

/*! @name OTP_CTRL - OTP Controller Control Register */
/*! @{ */

#define OCOTP_OTP_CTRL_ADDR_MASK                 (0x1FFU)
#define OCOTP_OTP_CTRL_ADDR_SHIFT                (0U)
#define OCOTP_OTP_CTRL_ADDR(x)                   (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_CTRL_ADDR_SHIFT)) & OCOTP_OTP_CTRL_ADDR_MASK)

#define OCOTP_OTP_CTRL_PRNG_OUTPUT_DATA_EN_MASK  (0x200U)
#define OCOTP_OTP_CTRL_PRNG_OUTPUT_DATA_EN_SHIFT (9U)
#define OCOTP_OTP_CTRL_PRNG_OUTPUT_DATA_EN(x)    (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_CTRL_PRNG_OUTPUT_DATA_EN_SHIFT)) & OCOTP_OTP_CTRL_PRNG_OUTPUT_DATA_EN_MASK)

#define OCOTP_OTP_CTRL_SRAM_ENTROPY_DATA_EN_MASK (0x400U)
#define OCOTP_OTP_CTRL_SRAM_ENTROPY_DATA_EN_SHIFT (10U)
#define OCOTP_OTP_CTRL_SRAM_ENTROPY_DATA_EN(x)   (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_CTRL_SRAM_ENTROPY_DATA_EN_SHIFT)) & OCOTP_OTP_CTRL_SRAM_ENTROPY_DATA_EN_MASK)

#define OCOTP_OTP_CTRL_RELOAD_SHADOWS_MASK       (0x800U)
#define OCOTP_OTP_CTRL_RELOAD_SHADOWS_SHIFT      (11U)
#define OCOTP_OTP_CTRL_RELOAD_SHADOWS(x)         (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_CTRL_RELOAD_SHADOWS_SHIFT)) & OCOTP_OTP_CTRL_RELOAD_SHADOWS_MASK)

#define OCOTP_OTP_CTRL_RED_MUX_SEL_MASK          (0x3000U)
#define OCOTP_OTP_CTRL_RED_MUX_SEL_SHIFT         (12U)
#define OCOTP_OTP_CTRL_RED_MUX_SEL(x)            (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_CTRL_RED_MUX_SEL_SHIFT)) & OCOTP_OTP_CTRL_RED_MUX_SEL_MASK)

#define OCOTP_OTP_CTRL_SUPPADD_MASK              (0x4000U)
#define OCOTP_OTP_CTRL_SUPPADD_SHIFT             (14U)
#define OCOTP_OTP_CTRL_SUPPADD(x)                (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_CTRL_SUPPADD_SHIFT)) & OCOTP_OTP_CTRL_SUPPADD_MASK)

#define OCOTP_OTP_CTRL_WR_UNLOCK_MASK            (0xFFFF0000U)
#define OCOTP_OTP_CTRL_WR_UNLOCK_SHIFT           (16U)
#define OCOTP_OTP_CTRL_WR_UNLOCK(x)              (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_CTRL_WR_UNLOCK_SHIFT)) & OCOTP_OTP_CTRL_WR_UNLOCK_MASK)
/*! @} */

/*! @name OTP_PDN - OTP Controller PDN Register */
/*! @{ */

#define OCOTP_OTP_PDN_PDN_MASK                   (0x1U)
#define OCOTP_OTP_PDN_PDN_SHIFT                  (0U)
#define OCOTP_OTP_PDN_PDN(x)                     (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_PDN_PDN_SHIFT)) & OCOTP_OTP_PDN_PDN_MASK)
/*! @} */

/*! @name OTP_WRITE_DATA - OTP Controller Write Data Register */
/*! @{ */

#define OCOTP_OTP_WRITE_DATA_WRITE_DATA_MASK     (0xFFFFFFFFU)
#define OCOTP_OTP_WRITE_DATA_WRITE_DATA_SHIFT    (0U)
#define OCOTP_OTP_WRITE_DATA_WRITE_DATA(x)       (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_WRITE_DATA_WRITE_DATA_SHIFT)) & OCOTP_OTP_WRITE_DATA_WRITE_DATA_MASK)
/*! @} */

/*! @name OTP_READ_CTRL - OTP Controller Read Ctrl Register */
/*! @{ */

#define OCOTP_OTP_READ_CTRL_READ_MASK            (0x1U)
#define OCOTP_OTP_READ_CTRL_READ_SHIFT           (0U)
#define OCOTP_OTP_READ_CTRL_READ(x)              (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_READ_CTRL_READ_SHIFT)) & OCOTP_OTP_READ_CTRL_READ_MASK)
/*! @} */

/*! @name OTP_READ_DATA - OTP Controller Read Data Register */
/*! @{ */

#define OCOTP_OTP_READ_DATA_READ_DATA_MASK       (0xFFFFFFFFU)
#define OCOTP_OTP_READ_DATA_READ_DATA_SHIFT      (0U)
#define OCOTP_OTP_READ_DATA_READ_DATA(x)         (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_READ_DATA_READ_DATA_SHIFT)) & OCOTP_OTP_READ_DATA_READ_DATA_MASK)
/*! @} */

/*! @name OTP_CLK_DIV - OTP Controller Clock Divider register */
/*! @{ */

#define OCOTP_OTP_CLK_DIV_DIV_MASK               (0xFU)
#define OCOTP_OTP_CLK_DIV_DIV_SHIFT              (0U)
#define OCOTP_OTP_CLK_DIV_DIV(x)                 (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_CLK_DIV_DIV_SHIFT)) & OCOTP_OTP_CLK_DIV_DIV_MASK)

#define OCOTP_OTP_CLK_DIV_RESET_MASK             (0x20000000U)
#define OCOTP_OTP_CLK_DIV_RESET_SHIFT            (29U)
#define OCOTP_OTP_CLK_DIV_RESET(x)               (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_CLK_DIV_RESET_SHIFT)) & OCOTP_OTP_CLK_DIV_RESET_MASK)

#define OCOTP_OTP_CLK_DIV_HALT_MASK              (0x40000000U)
#define OCOTP_OTP_CLK_DIV_HALT_SHIFT             (30U)
#define OCOTP_OTP_CLK_DIV_HALT(x)                (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_CLK_DIV_HALT_SHIFT)) & OCOTP_OTP_CLK_DIV_HALT_MASK)

#define OCOTP_OTP_CLK_DIV_REQFLAG_MASK           (0x80000000U)
#define OCOTP_OTP_CLK_DIV_REQFLAG_SHIFT          (31U)
#define OCOTP_OTP_CLK_DIV_REQFLAG(x)             (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_CLK_DIV_REQFLAG_SHIFT)) & OCOTP_OTP_CLK_DIV_REQFLAG_MASK)
/*! @} */

/*! @name OTP_CRC_CTRL - OTP Controller CRC Ctrl Register */
/*! @{ */

#define OCOTP_OTP_CRC_CTRL_CRC_RUN_MASK          (0x1U)
#define OCOTP_OTP_CRC_CTRL_CRC_RUN_SHIFT         (0U)
#define OCOTP_OTP_CRC_CTRL_CRC_RUN(x)            (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_CRC_CTRL_CRC_RUN_SHIFT)) & OCOTP_OTP_CRC_CTRL_CRC_RUN_MASK)

#define OCOTP_OTP_CRC_CTRL_CRC_DONE_MASK         (0x2U)
#define OCOTP_OTP_CRC_CTRL_CRC_DONE_SHIFT        (1U)
#define OCOTP_OTP_CRC_CTRL_CRC_DONE(x)           (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_CRC_CTRL_CRC_DONE_SHIFT)) & OCOTP_OTP_CRC_CTRL_CRC_DONE_MASK)

#define OCOTP_OTP_CRC_CTRL_CRC_STATUS_MASK       (0x4U)
#define OCOTP_OTP_CRC_CTRL_CRC_STATUS_SHIFT      (2U)
#define OCOTP_OTP_CRC_CTRL_CRC_STATUS(x)         (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_CRC_CTRL_CRC_STATUS_SHIFT)) & OCOTP_OTP_CRC_CTRL_CRC_STATUS_MASK)

#define OCOTP_OTP_CRC_CTRL_CRC_RUN_LOCK_MASK     (0x8U)
#define OCOTP_OTP_CRC_CTRL_CRC_RUN_LOCK_SHIFT    (3U)
#define OCOTP_OTP_CRC_CTRL_CRC_RUN_LOCK(x)       (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_CRC_CTRL_CRC_RUN_LOCK_SHIFT)) & OCOTP_OTP_CRC_CTRL_CRC_RUN_LOCK_MASK)

#define OCOTP_OTP_CRC_CTRL_CRC_LUT_SEL_MASK      (0xF0000U)
#define OCOTP_OTP_CRC_CTRL_CRC_LUT_SEL_SHIFT     (16U)
#define OCOTP_OTP_CRC_CTRL_CRC_LUT_SEL(x)        (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_CRC_CTRL_CRC_LUT_SEL_SHIFT)) & OCOTP_OTP_CRC_CTRL_CRC_LUT_SEL_MASK)
/*! @} */

/*! @name OTP_CRC_VALUE - OTP Controller CRC Value Register */
/*! @{ */

#define OCOTP_OTP_CRC_VALUE_CRC_VALUE_MASK       (0xFFFFFFFFU)
#define OCOTP_OTP_CRC_VALUE_CRC_VALUE_SHIFT      (0U)
#define OCOTP_OTP_CRC_VALUE_CRC_VALUE(x)         (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_CRC_VALUE_CRC_VALUE_SHIFT)) & OCOTP_OTP_CRC_VALUE_CRC_VALUE_MASK)
/*! @} */

/*! @name OTP_STATUS - OTP Controller Status Register */
/*! @{ */

#define OCOTP_OTP_STATUS_LOAD_COUNTER_MASK       (0x1FFU)
#define OCOTP_OTP_STATUS_LOAD_COUNTER_SHIFT      (0U)
#define OCOTP_OTP_STATUS_LOAD_COUNTER(x)         (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_STATUS_LOAD_COUNTER_SHIFT)) & OCOTP_OTP_STATUS_LOAD_COUNTER_MASK)

#define OCOTP_OTP_STATUS_LC_NOT_BLANK_STICKY_MASK (0x200U)
#define OCOTP_OTP_STATUS_LC_NOT_BLANK_STICKY_SHIFT (9U)
#define OCOTP_OTP_STATUS_LC_NOT_BLANK_STICKY(x)  (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_STATUS_LC_NOT_BLANK_STICKY_SHIFT)) & OCOTP_OTP_STATUS_LC_NOT_BLANK_STICKY_MASK)

#define OCOTP_OTP_STATUS_LOCKED_MASK             (0x800U)
#define OCOTP_OTP_STATUS_LOCKED_SHIFT            (11U)
#define OCOTP_OTP_STATUS_LOCKED(x)               (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_STATUS_LOCKED_SHIFT)) & OCOTP_OTP_STATUS_LOCKED_MASK)

#define OCOTP_OTP_STATUS_PROGFAIL_MASK           (0x1000U)
#define OCOTP_OTP_STATUS_PROGFAIL_SHIFT          (12U)
#define OCOTP_OTP_STATUS_PROGFAIL(x)             (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_STATUS_PROGFAIL_SHIFT)) & OCOTP_OTP_STATUS_PROGFAIL_MASK)

#define OCOTP_OTP_STATUS_ACK_MASK                (0x2000U)
#define OCOTP_OTP_STATUS_ACK_SHIFT               (13U)
#define OCOTP_OTP_STATUS_ACK(x)                  (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_STATUS_ACK_SHIFT)) & OCOTP_OTP_STATUS_ACK_MASK)

#define OCOTP_OTP_STATUS_PWOK_MASK               (0x4000U)
#define OCOTP_OTP_STATUS_PWOK_SHIFT              (14U)
#define OCOTP_OTP_STATUS_PWOK(x)                 (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_STATUS_PWOK_SHIFT)) & OCOTP_OTP_STATUS_PWOK_MASK)

#define OCOTP_OTP_STATUS_FLAGSTATE_MASK          (0xF0000U)
#define OCOTP_OTP_STATUS_FLAGSTATE_SHIFT         (16U)
#define OCOTP_OTP_STATUS_FLAGSTATE(x)            (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_STATUS_FLAGSTATE_SHIFT)) & OCOTP_OTP_STATUS_FLAGSTATE_MASK)

#define OCOTP_OTP_STATUS_BUSY_MASK               (0x400000U)
#define OCOTP_OTP_STATUS_BUSY_SHIFT              (22U)
#define OCOTP_OTP_STATUS_BUSY(x)                 (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_STATUS_BUSY_SHIFT)) & OCOTP_OTP_STATUS_BUSY_MASK)

#define OCOTP_OTP_STATUS_FUSE_LATCHED_MASK       (0x2000000U)
#define OCOTP_OTP_STATUS_FUSE_LATCHED_SHIFT      (25U)
#define OCOTP_OTP_STATUS_FUSE_LATCHED(x)         (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_STATUS_FUSE_LATCHED_SHIFT)) & OCOTP_OTP_STATUS_FUSE_LATCHED_MASK)

#define OCOTP_OTP_STATUS_CALIBRATED_MASK         (0x4000000U)
#define OCOTP_OTP_STATUS_CALIBRATED_SHIFT        (26U)
#define OCOTP_OTP_STATUS_CALIBRATED(x)           (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_STATUS_CALIBRATED_SHIFT)) & OCOTP_OTP_STATUS_CALIBRATED_MASK)
/*! @} */

/*! @name OTP_STARTWORD - OTP Controller Startword Register */
/*! @{ */

#define OCOTP_OTP_STARTWORD_STARTWORD_MASK       (0xFFFFU)
#define OCOTP_OTP_STARTWORD_STARTWORD_SHIFT      (0U)
#define OCOTP_OTP_STARTWORD_STARTWORD(x)         (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_STARTWORD_STARTWORD_SHIFT)) & OCOTP_OTP_STARTWORD_STARTWORD_MASK)
/*! @} */

/*! @name OTP_VERSION - OTP Controller Version Register */
/*! @{ */

#define OCOTP_OTP_VERSION_STEP_VER_MASK          (0xFFFFU)
#define OCOTP_OTP_VERSION_STEP_VER_SHIFT         (0U)
#define OCOTP_OTP_VERSION_STEP_VER(x)            (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_VERSION_STEP_VER_SHIFT)) & OCOTP_OTP_VERSION_STEP_VER_MASK)

#define OCOTP_OTP_VERSION_MINOR_VER_MASK         (0xFF0000U)
#define OCOTP_OTP_VERSION_MINOR_VER_SHIFT        (16U)
#define OCOTP_OTP_VERSION_MINOR_VER(x)           (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_VERSION_MINOR_VER_SHIFT)) & OCOTP_OTP_VERSION_MINOR_VER_MASK)

#define OCOTP_OTP_VERSION_MAJOR_VER_MASK         (0xFF000000U)
#define OCOTP_OTP_VERSION_MAJOR_VER_SHIFT        (24U)
#define OCOTP_OTP_VERSION_MAJOR_VER(x)           (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_VERSION_MAJOR_VER_SHIFT)) & OCOTP_OTP_VERSION_MAJOR_VER_MASK)
/*! @} */

/*! @name OTP_NONMASK_STATUS1 - OTP Controller Nonmask Status1 Register */
/*! @{ */

#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_PBRICK_ERR_MASK (0x20U)
#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_PBRICK_ERR_SHIFT (5U)
#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_PBRICK_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_NONMASK_STATUS1_NONMASK_PBRICK_ERR_SHIFT)) & OCOTP_OTP_NONMASK_STATUS1_NONMASK_PBRICK_ERR_MASK)

#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_OTP_STATE_ERR_MASK (0x40U)
#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_OTP_STATE_ERR_SHIFT (6U)
#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_OTP_STATE_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_NONMASK_STATUS1_NONMASK_OTP_STATE_ERR_SHIFT)) & OCOTP_OTP_NONMASK_STATUS1_NONMASK_OTP_STATE_ERR_MASK)

#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_DED_RELOAD_MASK (0x80U)
#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_DED_RELOAD_SHIFT (7U)
#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_DED_RELOAD(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_NONMASK_STATUS1_NONMASK_DED_RELOAD_SHIFT)) & OCOTP_OTP_NONMASK_STATUS1_NONMASK_DED_RELOAD_MASK)

#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_DED_MASK (0x100U)
#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_DED_SHIFT (8U)
#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_DED(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_NONMASK_STATUS1_NONMASK_DED_SHIFT)) & OCOTP_OTP_NONMASK_STATUS1_NONMASK_DED_MASK)

#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_SEC_RELOAD_MASK (0x200U)
#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_SEC_RELOAD_SHIFT (9U)
#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_SEC_RELOAD(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_NONMASK_STATUS1_NONMASK_SEC_RELOAD_SHIFT)) & OCOTP_OTP_NONMASK_STATUS1_NONMASK_SEC_RELOAD_MASK)

#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_SEC_MASK (0x400U)
#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_SEC_SHIFT (10U)
#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_SEC(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_NONMASK_STATUS1_NONMASK_SEC_SHIFT)) & OCOTP_OTP_NONMASK_STATUS1_NONMASK_SEC_MASK)

#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_CRC_DONE_MASK (0x800U)
#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_CRC_DONE_SHIFT (11U)
#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_CRC_DONE(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_NONMASK_STATUS1_NONMASK_CRC_DONE_SHIFT)) & OCOTP_OTP_NONMASK_STATUS1_NONMASK_CRC_DONE_MASK)

#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_CRC_LUT_SEL_ERR_MASK (0x1000U)
#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_CRC_LUT_SEL_ERR_SHIFT (12U)
#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_CRC_LUT_SEL_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_NONMASK_STATUS1_NONMASK_CRC_LUT_SEL_ERR_SHIFT)) & OCOTP_OTP_NONMASK_STATUS1_NONMASK_CRC_LUT_SEL_ERR_MASK)

#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_CRC_ADDRESS_RANGE_ERR_MASK (0x2000U)
#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_CRC_ADDRESS_RANGE_ERR_SHIFT (13U)
#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_CRC_ADDRESS_RANGE_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_NONMASK_STATUS1_NONMASK_CRC_ADDRESS_RANGE_ERR_SHIFT)) & OCOTP_OTP_NONMASK_STATUS1_NONMASK_CRC_ADDRESS_RANGE_ERR_MASK)

#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_CRC_WRITE_PROTECT_ERR_MASK (0x4000U)
#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_CRC_WRITE_PROTECT_ERR_SHIFT (14U)
#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_CRC_WRITE_PROTECT_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_NONMASK_STATUS1_NONMASK_CRC_WRITE_PROTECT_ERR_SHIFT)) & OCOTP_OTP_NONMASK_STATUS1_NONMASK_CRC_WRITE_PROTECT_ERR_MASK)

#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_CRC_SECURTY_PROTECT_ERR_MASK (0x8000U)
#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_CRC_SECURTY_PROTECT_ERR_SHIFT (15U)
#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_CRC_SECURTY_PROTECT_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_NONMASK_STATUS1_NONMASK_CRC_SECURTY_PROTECT_ERR_SHIFT)) & OCOTP_OTP_NONMASK_STATUS1_NONMASK_CRC_SECURTY_PROTECT_ERR_MASK)

#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_WRITE_ERR_MASK (0x10000U)
#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_WRITE_ERR_SHIFT (16U)
#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_WRITE_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_NONMASK_STATUS1_NONMASK_WRITE_ERR_SHIFT)) & OCOTP_OTP_NONMASK_STATUS1_NONMASK_WRITE_ERR_MASK)

#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_LOAD_ERR_MASK (0x20000U)
#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_LOAD_ERR_SHIFT (17U)
#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_LOAD_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_NONMASK_STATUS1_NONMASK_LOAD_ERR_SHIFT)) & OCOTP_OTP_NONMASK_STATUS1_NONMASK_LOAD_ERR_MASK)

#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_COUNTER_ERR_MASK (0x40000U)
#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_COUNTER_ERR_SHIFT (18U)
#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_COUNTER_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_NONMASK_STATUS1_NONMASK_COUNTER_ERR_SHIFT)) & OCOTP_OTP_NONMASK_STATUS1_NONMASK_COUNTER_ERR_MASK)

#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_BITPROTECT_ERR_MASK (0x80000U)
#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_BITPROTECT_ERR_SHIFT (19U)
#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_BITPROTECT_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_NONMASK_STATUS1_NONMASK_BITPROTECT_ERR_SHIFT)) & OCOTP_OTP_NONMASK_STATUS1_NONMASK_BITPROTECT_ERR_MASK)

#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_PRNG_O_FAULT_MASK (0x100000U)
#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_PRNG_O_FAULT_SHIFT (20U)
#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_PRNG_O_FAULT(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_NONMASK_STATUS1_NONMASK_PRNG_O_FAULT_SHIFT)) & OCOTP_OTP_NONMASK_STATUS1_NONMASK_PRNG_O_FAULT_MASK)

#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_ECC_ZEROIZED_ERR_MASK (0x200000U)
#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_ECC_ZEROIZED_ERR_SHIFT (21U)
#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_ECC_ZEROIZED_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_NONMASK_STATUS1_NONMASK_ECC_ZEROIZED_ERR_SHIFT)) & OCOTP_OTP_NONMASK_STATUS1_NONMASK_ECC_ZEROIZED_ERR_MASK)

#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_FUSE_ACCESS_ERR_MASK (0x400000U)
#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_FUSE_ACCESS_ERR_SHIFT (22U)
#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_FUSE_ACCESS_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_NONMASK_STATUS1_NONMASK_FUSE_ACCESS_ERR_SHIFT)) & OCOTP_OTP_NONMASK_STATUS1_NONMASK_FUSE_ACCESS_ERR_MASK)

#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_RELOAD_REQ_ERR_MASK (0x800000U)
#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_RELOAD_REQ_ERR_SHIFT (23U)
#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_RELOAD_REQ_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_NONMASK_STATUS1_NONMASK_RELOAD_REQ_ERR_SHIFT)) & OCOTP_OTP_NONMASK_STATUS1_NONMASK_RELOAD_REQ_ERR_MASK)

#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_WRITE_DURING_RELOAD_ERR_MASK (0x1000000U)
#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_WRITE_DURING_RELOAD_ERR_SHIFT (24U)
#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_WRITE_DURING_RELOAD_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_NONMASK_STATUS1_NONMASK_WRITE_DURING_RELOAD_ERR_SHIFT)) & OCOTP_OTP_NONMASK_STATUS1_NONMASK_WRITE_DURING_RELOAD_ERR_MASK)

#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_SHADOW_HVF_READ_ERR_MASK (0x2000000U)
#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_SHADOW_HVF_READ_ERR_SHIFT (25U)
#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_SHADOW_HVF_READ_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_NONMASK_STATUS1_NONMASK_SHADOW_HVF_READ_ERR_SHIFT)) & OCOTP_OTP_NONMASK_STATUS1_NONMASK_SHADOW_HVF_READ_ERR_MASK)

#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_SHADOW_HVF_WRITE_ERR_MASK (0x4000000U)
#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_SHADOW_HVF_WRITE_ERR_SHIFT (26U)
#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_SHADOW_HVF_WRITE_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_NONMASK_STATUS1_NONMASK_SHADOW_HVF_WRITE_ERR_SHIFT)) & OCOTP_OTP_NONMASK_STATUS1_NONMASK_SHADOW_HVF_WRITE_ERR_MASK)

#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_SHADOW_SRAM_READ_ERR_MASK (0x8000000U)
#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_SHADOW_SRAM_READ_ERR_SHIFT (27U)
#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_SHADOW_SRAM_READ_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_NONMASK_STATUS1_NONMASK_SHADOW_SRAM_READ_ERR_SHIFT)) & OCOTP_OTP_NONMASK_STATUS1_NONMASK_SHADOW_SRAM_READ_ERR_MASK)

#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_SHADOW_SRAM_WRITE_ERR_MASK (0x10000000U)
#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_SHADOW_SRAM_WRITE_ERR_SHIFT (28U)
#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_SHADOW_SRAM_WRITE_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_NONMASK_STATUS1_NONMASK_SHADOW_SRAM_WRITE_ERR_SHIFT)) & OCOTP_OTP_NONMASK_STATUS1_NONMASK_SHADOW_SRAM_WRITE_ERR_MASK)

#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_FUSE_READ_ERR_MASK (0x20000000U)
#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_FUSE_READ_ERR_SHIFT (29U)
#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_FUSE_READ_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_NONMASK_STATUS1_NONMASK_FUSE_READ_ERR_SHIFT)) & OCOTP_OTP_NONMASK_STATUS1_NONMASK_FUSE_READ_ERR_MASK)

#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_FUSE_PROG_ERR_MASK (0x40000000U)
#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_FUSE_PROG_ERR_SHIFT (30U)
#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_FUSE_PROG_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_NONMASK_STATUS1_NONMASK_FUSE_PROG_ERR_SHIFT)) & OCOTP_OTP_NONMASK_STATUS1_NONMASK_FUSE_PROG_ERR_MASK)

#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_SHADOW_NO_ACCESS_MASK (0x80000000U)
#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_SHADOW_NO_ACCESS_SHIFT (31U)
#define OCOTP_OTP_NONMASK_STATUS1_NONMASK_SHADOW_NO_ACCESS(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_NONMASK_STATUS1_NONMASK_SHADOW_NO_ACCESS_SHIFT)) & OCOTP_OTP_NONMASK_STATUS1_NONMASK_SHADOW_NO_ACCESS_MASK)
/*! @} */

/*! @name OTP_MASK_CTRL1 - OTP Controller Mask Ctrl1 Register */
/*! @{ */

#define OCOTP_OTP_MASK_CTRL1_TIMEOUT_COUNTER_MASK (0x7U)
#define OCOTP_OTP_MASK_CTRL1_TIMEOUT_COUNTER_SHIFT (0U)
#define OCOTP_OTP_MASK_CTRL1_TIMEOUT_COUNTER(x)  (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_CTRL1_TIMEOUT_COUNTER_SHIFT)) & OCOTP_OTP_MASK_CTRL1_TIMEOUT_COUNTER_MASK)

#define OCOTP_OTP_MASK_CTRL1_TMEOUT_COUNTER_EN_MASK (0x8U)
#define OCOTP_OTP_MASK_CTRL1_TMEOUT_COUNTER_EN_SHIFT (3U)
#define OCOTP_OTP_MASK_CTRL1_TMEOUT_COUNTER_EN(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_CTRL1_TMEOUT_COUNTER_EN_SHIFT)) & OCOTP_OTP_MASK_CTRL1_TMEOUT_COUNTER_EN_MASK)

#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_PBRICK_ERR_MASK (0x20U)
#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_PBRICK_ERR_SHIFT (5U)
#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_PBRICK_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_CTRL1_CTRL_MASK_PBRICK_ERR_SHIFT)) & OCOTP_OTP_MASK_CTRL1_CTRL_MASK_PBRICK_ERR_MASK)

#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_OTP_STATE_ERR_MASK (0x40U)
#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_OTP_STATE_ERR_SHIFT (6U)
#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_OTP_STATE_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_CTRL1_CTRL_MASK_OTP_STATE_ERR_SHIFT)) & OCOTP_OTP_MASK_CTRL1_CTRL_MASK_OTP_STATE_ERR_MASK)

#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_DED_RELOAD_MASK (0x80U)
#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_DED_RELOAD_SHIFT (7U)
#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_DED_RELOAD(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_CTRL1_CTRL_MASK_DED_RELOAD_SHIFT)) & OCOTP_OTP_MASK_CTRL1_CTRL_MASK_DED_RELOAD_MASK)

#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_DED_MASK  (0x100U)
#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_DED_SHIFT (8U)
#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_DED(x)    (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_CTRL1_CTRL_MASK_DED_SHIFT)) & OCOTP_OTP_MASK_CTRL1_CTRL_MASK_DED_MASK)

#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_SEC_RELOAD_MASK (0x200U)
#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_SEC_RELOAD_SHIFT (9U)
#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_SEC_RELOAD(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_CTRL1_CTRL_MASK_SEC_RELOAD_SHIFT)) & OCOTP_OTP_MASK_CTRL1_CTRL_MASK_SEC_RELOAD_MASK)

#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_SEC_MASK  (0x400U)
#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_SEC_SHIFT (10U)
#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_SEC(x)    (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_CTRL1_CTRL_MASK_SEC_SHIFT)) & OCOTP_OTP_MASK_CTRL1_CTRL_MASK_SEC_MASK)

#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_CRC_DONE_MASK (0x800U)
#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_CRC_DONE_SHIFT (11U)
#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_CRC_DONE(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_CTRL1_CTRL_MASK_CRC_DONE_SHIFT)) & OCOTP_OTP_MASK_CTRL1_CTRL_MASK_CRC_DONE_MASK)

#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_CRC_LUT_SEL_ERR_MASK (0x1000U)
#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_CRC_LUT_SEL_ERR_SHIFT (12U)
#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_CRC_LUT_SEL_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_CTRL1_CTRL_MASK_CRC_LUT_SEL_ERR_SHIFT)) & OCOTP_OTP_MASK_CTRL1_CTRL_MASK_CRC_LUT_SEL_ERR_MASK)

#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_CRC_ADDRESS_RANGE_ERR_MASK (0x2000U)
#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_CRC_ADDRESS_RANGE_ERR_SHIFT (13U)
#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_CRC_ADDRESS_RANGE_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_CTRL1_CTRL_MASK_CRC_ADDRESS_RANGE_ERR_SHIFT)) & OCOTP_OTP_MASK_CTRL1_CTRL_MASK_CRC_ADDRESS_RANGE_ERR_MASK)

#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_CRC_WRITE_PROTECT_ERR_MASK (0x4000U)
#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_CRC_WRITE_PROTECT_ERR_SHIFT (14U)
#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_CRC_WRITE_PROTECT_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_CTRL1_CTRL_MASK_CRC_WRITE_PROTECT_ERR_SHIFT)) & OCOTP_OTP_MASK_CTRL1_CTRL_MASK_CRC_WRITE_PROTECT_ERR_MASK)

#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_CRC_SECURTY_PROTECT_ERR_MASK (0x8000U)
#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_CRC_SECURTY_PROTECT_ERR_SHIFT (15U)
#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_CRC_SECURTY_PROTECT_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_CTRL1_CTRL_MASK_CRC_SECURTY_PROTECT_ERR_SHIFT)) & OCOTP_OTP_MASK_CTRL1_CTRL_MASK_CRC_SECURTY_PROTECT_ERR_MASK)

#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_WRITE_ERR_MASK (0x10000U)
#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_WRITE_ERR_SHIFT (16U)
#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_WRITE_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_CTRL1_CTRL_MASK_WRITE_ERR_SHIFT)) & OCOTP_OTP_MASK_CTRL1_CTRL_MASK_WRITE_ERR_MASK)

#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_LOAD_ERR_MASK (0x20000U)
#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_LOAD_ERR_SHIFT (17U)
#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_LOAD_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_CTRL1_CTRL_MASK_LOAD_ERR_SHIFT)) & OCOTP_OTP_MASK_CTRL1_CTRL_MASK_LOAD_ERR_MASK)

#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_COUNTER_ERR_MASK (0x40000U)
#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_COUNTER_ERR_SHIFT (18U)
#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_COUNTER_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_CTRL1_CTRL_MASK_COUNTER_ERR_SHIFT)) & OCOTP_OTP_MASK_CTRL1_CTRL_MASK_COUNTER_ERR_MASK)

#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_BITPROTECT_ERR_MASK (0x80000U)
#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_BITPROTECT_ERR_SHIFT (19U)
#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_BITPROTECT_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_CTRL1_CTRL_MASK_BITPROTECT_ERR_SHIFT)) & OCOTP_OTP_MASK_CTRL1_CTRL_MASK_BITPROTECT_ERR_MASK)

#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_PRNG_O_FAULT_MASK (0x100000U)
#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_PRNG_O_FAULT_SHIFT (20U)
#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_PRNG_O_FAULT(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_CTRL1_CTRL_MASK_PRNG_O_FAULT_SHIFT)) & OCOTP_OTP_MASK_CTRL1_CTRL_MASK_PRNG_O_FAULT_MASK)

#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_ECC_ZEROIZED_ERR_MASK (0x200000U)
#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_ECC_ZEROIZED_ERR_SHIFT (21U)
#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_ECC_ZEROIZED_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_CTRL1_CTRL_MASK_ECC_ZEROIZED_ERR_SHIFT)) & OCOTP_OTP_MASK_CTRL1_CTRL_MASK_ECC_ZEROIZED_ERR_MASK)

#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_FUSE_ACCESS_ERR_MASK (0x400000U)
#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_FUSE_ACCESS_ERR_SHIFT (22U)
#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_FUSE_ACCESS_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_CTRL1_CTRL_MASK_FUSE_ACCESS_ERR_SHIFT)) & OCOTP_OTP_MASK_CTRL1_CTRL_MASK_FUSE_ACCESS_ERR_MASK)

#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_RELOAD_REQ_ERR_MASK (0x800000U)
#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_RELOAD_REQ_ERR_SHIFT (23U)
#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_RELOAD_REQ_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_CTRL1_CTRL_MASK_RELOAD_REQ_ERR_SHIFT)) & OCOTP_OTP_MASK_CTRL1_CTRL_MASK_RELOAD_REQ_ERR_MASK)

#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_WRITE_DURING_RELOAD_ERR_MASK (0x1000000U)
#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_WRITE_DURING_RELOAD_ERR_SHIFT (24U)
#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_WRITE_DURING_RELOAD_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_CTRL1_CTRL_MASK_WRITE_DURING_RELOAD_ERR_SHIFT)) & OCOTP_OTP_MASK_CTRL1_CTRL_MASK_WRITE_DURING_RELOAD_ERR_MASK)

#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_SHADOW_HVF_READ_ERR_MASK (0x2000000U)
#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_SHADOW_HVF_READ_ERR_SHIFT (25U)
#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_SHADOW_HVF_READ_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_CTRL1_CTRL_MASK_SHADOW_HVF_READ_ERR_SHIFT)) & OCOTP_OTP_MASK_CTRL1_CTRL_MASK_SHADOW_HVF_READ_ERR_MASK)

#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_SHADOW_HVF_WRITE_ERR_MASK (0x4000000U)
#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_SHADOW_HVF_WRITE_ERR_SHIFT (26U)
#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_SHADOW_HVF_WRITE_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_CTRL1_CTRL_MASK_SHADOW_HVF_WRITE_ERR_SHIFT)) & OCOTP_OTP_MASK_CTRL1_CTRL_MASK_SHADOW_HVF_WRITE_ERR_MASK)

#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_SHADOW_SRAM_READ_ERR_MASK (0x8000000U)
#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_SHADOW_SRAM_READ_ERR_SHIFT (27U)
#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_SHADOW_SRAM_READ_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_CTRL1_CTRL_MASK_SHADOW_SRAM_READ_ERR_SHIFT)) & OCOTP_OTP_MASK_CTRL1_CTRL_MASK_SHADOW_SRAM_READ_ERR_MASK)

#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_SHADOW_SRAM_WRITE_ERR_MASK (0x10000000U)
#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_SHADOW_SRAM_WRITE_ERR_SHIFT (28U)
#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_SHADOW_SRAM_WRITE_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_CTRL1_CTRL_MASK_SHADOW_SRAM_WRITE_ERR_SHIFT)) & OCOTP_OTP_MASK_CTRL1_CTRL_MASK_SHADOW_SRAM_WRITE_ERR_MASK)

#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_FUSE_READ_ERR_MASK (0x20000000U)
#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_FUSE_READ_ERR_SHIFT (29U)
#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_FUSE_READ_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_CTRL1_CTRL_MASK_FUSE_READ_ERR_SHIFT)) & OCOTP_OTP_MASK_CTRL1_CTRL_MASK_FUSE_READ_ERR_MASK)

#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_FUSE_PROG_ERR_MASK (0x40000000U)
#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_FUSE_PROG_ERR_SHIFT (30U)
#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_FUSE_PROG_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_CTRL1_CTRL_MASK_FUSE_PROG_ERR_SHIFT)) & OCOTP_OTP_MASK_CTRL1_CTRL_MASK_FUSE_PROG_ERR_MASK)

#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_SHADOW_NO_ACCESS_MASK (0x80000000U)
#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_SHADOW_NO_ACCESS_SHIFT (31U)
#define OCOTP_OTP_MASK_CTRL1_CTRL_MASK_SHADOW_NO_ACCESS(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_CTRL1_CTRL_MASK_SHADOW_NO_ACCESS_SHIFT)) & OCOTP_OTP_MASK_CTRL1_CTRL_MASK_SHADOW_NO_ACCESS_MASK)
/*! @} */

/*! @name OTP_MASK_STATUS1 - OTP Controller Nonmask Status1 Register */
/*! @{ */

#define OCOTP_OTP_MASK_STATUS1_MASK_PBRICK_ERR_MASK (0x20U)
#define OCOTP_OTP_MASK_STATUS1_MASK_PBRICK_ERR_SHIFT (5U)
#define OCOTP_OTP_MASK_STATUS1_MASK_PBRICK_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_STATUS1_MASK_PBRICK_ERR_SHIFT)) & OCOTP_OTP_MASK_STATUS1_MASK_PBRICK_ERR_MASK)

#define OCOTP_OTP_MASK_STATUS1_MASK_OTP_STATE_ERR_MASK (0x40U)
#define OCOTP_OTP_MASK_STATUS1_MASK_OTP_STATE_ERR_SHIFT (6U)
#define OCOTP_OTP_MASK_STATUS1_MASK_OTP_STATE_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_STATUS1_MASK_OTP_STATE_ERR_SHIFT)) & OCOTP_OTP_MASK_STATUS1_MASK_OTP_STATE_ERR_MASK)

#define OCOTP_OTP_MASK_STATUS1_DED_RELOAD_MASK   (0x80U)
#define OCOTP_OTP_MASK_STATUS1_DED_RELOAD_SHIFT  (7U)
#define OCOTP_OTP_MASK_STATUS1_DED_RELOAD(x)     (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_STATUS1_DED_RELOAD_SHIFT)) & OCOTP_OTP_MASK_STATUS1_DED_RELOAD_MASK)

#define OCOTP_OTP_MASK_STATUS1_MASK_DED_MASK     (0x100U)
#define OCOTP_OTP_MASK_STATUS1_MASK_DED_SHIFT    (8U)
#define OCOTP_OTP_MASK_STATUS1_MASK_DED(x)       (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_STATUS1_MASK_DED_SHIFT)) & OCOTP_OTP_MASK_STATUS1_MASK_DED_MASK)

#define OCOTP_OTP_MASK_STATUS1_SEC_RELOAD_MASK   (0x200U)
#define OCOTP_OTP_MASK_STATUS1_SEC_RELOAD_SHIFT  (9U)
#define OCOTP_OTP_MASK_STATUS1_SEC_RELOAD(x)     (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_STATUS1_SEC_RELOAD_SHIFT)) & OCOTP_OTP_MASK_STATUS1_SEC_RELOAD_MASK)

#define OCOTP_OTP_MASK_STATUS1_MASK_SEC_MASK     (0x400U)
#define OCOTP_OTP_MASK_STATUS1_MASK_SEC_SHIFT    (10U)
#define OCOTP_OTP_MASK_STATUS1_MASK_SEC(x)       (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_STATUS1_MASK_SEC_SHIFT)) & OCOTP_OTP_MASK_STATUS1_MASK_SEC_MASK)

#define OCOTP_OTP_MASK_STATUS1_MASK_CRC_DONE_MASK (0x800U)
#define OCOTP_OTP_MASK_STATUS1_MASK_CRC_DONE_SHIFT (11U)
#define OCOTP_OTP_MASK_STATUS1_MASK_CRC_DONE(x)  (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_STATUS1_MASK_CRC_DONE_SHIFT)) & OCOTP_OTP_MASK_STATUS1_MASK_CRC_DONE_MASK)

#define OCOTP_OTP_MASK_STATUS1_MASK_CRC_LUT_SEL_ERR_MASK (0x1000U)
#define OCOTP_OTP_MASK_STATUS1_MASK_CRC_LUT_SEL_ERR_SHIFT (12U)
#define OCOTP_OTP_MASK_STATUS1_MASK_CRC_LUT_SEL_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_STATUS1_MASK_CRC_LUT_SEL_ERR_SHIFT)) & OCOTP_OTP_MASK_STATUS1_MASK_CRC_LUT_SEL_ERR_MASK)

#define OCOTP_OTP_MASK_STATUS1_MASK_CRC_ADDRESS_RANGE_ERR_MASK (0x2000U)
#define OCOTP_OTP_MASK_STATUS1_MASK_CRC_ADDRESS_RANGE_ERR_SHIFT (13U)
#define OCOTP_OTP_MASK_STATUS1_MASK_CRC_ADDRESS_RANGE_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_STATUS1_MASK_CRC_ADDRESS_RANGE_ERR_SHIFT)) & OCOTP_OTP_MASK_STATUS1_MASK_CRC_ADDRESS_RANGE_ERR_MASK)

#define OCOTP_OTP_MASK_STATUS1_MASK_CRC_WRITE_PROTECT_ERR_MASK (0x4000U)
#define OCOTP_OTP_MASK_STATUS1_MASK_CRC_WRITE_PROTECT_ERR_SHIFT (14U)
#define OCOTP_OTP_MASK_STATUS1_MASK_CRC_WRITE_PROTECT_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_STATUS1_MASK_CRC_WRITE_PROTECT_ERR_SHIFT)) & OCOTP_OTP_MASK_STATUS1_MASK_CRC_WRITE_PROTECT_ERR_MASK)

#define OCOTP_OTP_MASK_STATUS1_MASK_CRC_SECURTY_PROTECT_ERR_MASK (0x8000U)
#define OCOTP_OTP_MASK_STATUS1_MASK_CRC_SECURTY_PROTECT_ERR_SHIFT (15U)
#define OCOTP_OTP_MASK_STATUS1_MASK_CRC_SECURTY_PROTECT_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_STATUS1_MASK_CRC_SECURTY_PROTECT_ERR_SHIFT)) & OCOTP_OTP_MASK_STATUS1_MASK_CRC_SECURTY_PROTECT_ERR_MASK)

#define OCOTP_OTP_MASK_STATUS1_MASK_WRITE_ERR_MASK (0x10000U)
#define OCOTP_OTP_MASK_STATUS1_MASK_WRITE_ERR_SHIFT (16U)
#define OCOTP_OTP_MASK_STATUS1_MASK_WRITE_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_STATUS1_MASK_WRITE_ERR_SHIFT)) & OCOTP_OTP_MASK_STATUS1_MASK_WRITE_ERR_MASK)

#define OCOTP_OTP_MASK_STATUS1_MASK_LOAD_ERR_MASK (0x20000U)
#define OCOTP_OTP_MASK_STATUS1_MASK_LOAD_ERR_SHIFT (17U)
#define OCOTP_OTP_MASK_STATUS1_MASK_LOAD_ERR(x)  (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_STATUS1_MASK_LOAD_ERR_SHIFT)) & OCOTP_OTP_MASK_STATUS1_MASK_LOAD_ERR_MASK)

#define OCOTP_OTP_MASK_STATUS1_MASK_COUNTER_ERR_MASK (0x40000U)
#define OCOTP_OTP_MASK_STATUS1_MASK_COUNTER_ERR_SHIFT (18U)
#define OCOTP_OTP_MASK_STATUS1_MASK_COUNTER_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_STATUS1_MASK_COUNTER_ERR_SHIFT)) & OCOTP_OTP_MASK_STATUS1_MASK_COUNTER_ERR_MASK)

#define OCOTP_OTP_MASK_STATUS1_MASK_BITPROTECT_ERR_MASK (0x80000U)
#define OCOTP_OTP_MASK_STATUS1_MASK_BITPROTECT_ERR_SHIFT (19U)
#define OCOTP_OTP_MASK_STATUS1_MASK_BITPROTECT_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_STATUS1_MASK_BITPROTECT_ERR_SHIFT)) & OCOTP_OTP_MASK_STATUS1_MASK_BITPROTECT_ERR_MASK)

#define OCOTP_OTP_MASK_STATUS1_MASK_PRNG_O_FAULT_MASK (0x100000U)
#define OCOTP_OTP_MASK_STATUS1_MASK_PRNG_O_FAULT_SHIFT (20U)
#define OCOTP_OTP_MASK_STATUS1_MASK_PRNG_O_FAULT(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_STATUS1_MASK_PRNG_O_FAULT_SHIFT)) & OCOTP_OTP_MASK_STATUS1_MASK_PRNG_O_FAULT_MASK)

#define OCOTP_OTP_MASK_STATUS1_MASK_ECC_ZEROIZED_ERR_MASK (0x200000U)
#define OCOTP_OTP_MASK_STATUS1_MASK_ECC_ZEROIZED_ERR_SHIFT (21U)
#define OCOTP_OTP_MASK_STATUS1_MASK_ECC_ZEROIZED_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_STATUS1_MASK_ECC_ZEROIZED_ERR_SHIFT)) & OCOTP_OTP_MASK_STATUS1_MASK_ECC_ZEROIZED_ERR_MASK)

#define OCOTP_OTP_MASK_STATUS1_MASK_FUSE_ACCESS_ERR_MASK (0x400000U)
#define OCOTP_OTP_MASK_STATUS1_MASK_FUSE_ACCESS_ERR_SHIFT (22U)
#define OCOTP_OTP_MASK_STATUS1_MASK_FUSE_ACCESS_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_STATUS1_MASK_FUSE_ACCESS_ERR_SHIFT)) & OCOTP_OTP_MASK_STATUS1_MASK_FUSE_ACCESS_ERR_MASK)

#define OCOTP_OTP_MASK_STATUS1_MASK_RELOAD_REQ_ERR_MASK (0x800000U)
#define OCOTP_OTP_MASK_STATUS1_MASK_RELOAD_REQ_ERR_SHIFT (23U)
#define OCOTP_OTP_MASK_STATUS1_MASK_RELOAD_REQ_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_STATUS1_MASK_RELOAD_REQ_ERR_SHIFT)) & OCOTP_OTP_MASK_STATUS1_MASK_RELOAD_REQ_ERR_MASK)

#define OCOTP_OTP_MASK_STATUS1_MASK_WRITE_DURING_RELOAD_ERR_MASK (0x1000000U)
#define OCOTP_OTP_MASK_STATUS1_MASK_WRITE_DURING_RELOAD_ERR_SHIFT (24U)
#define OCOTP_OTP_MASK_STATUS1_MASK_WRITE_DURING_RELOAD_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_STATUS1_MASK_WRITE_DURING_RELOAD_ERR_SHIFT)) & OCOTP_OTP_MASK_STATUS1_MASK_WRITE_DURING_RELOAD_ERR_MASK)

#define OCOTP_OTP_MASK_STATUS1_MASK_SHADOW_HVF_READ_ERR_MASK (0x2000000U)
#define OCOTP_OTP_MASK_STATUS1_MASK_SHADOW_HVF_READ_ERR_SHIFT (25U)
#define OCOTP_OTP_MASK_STATUS1_MASK_SHADOW_HVF_READ_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_STATUS1_MASK_SHADOW_HVF_READ_ERR_SHIFT)) & OCOTP_OTP_MASK_STATUS1_MASK_SHADOW_HVF_READ_ERR_MASK)

#define OCOTP_OTP_MASK_STATUS1_MASK_SHADOW_HVF_WRITE_ERR_MASK (0x4000000U)
#define OCOTP_OTP_MASK_STATUS1_MASK_SHADOW_HVF_WRITE_ERR_SHIFT (26U)
#define OCOTP_OTP_MASK_STATUS1_MASK_SHADOW_HVF_WRITE_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_STATUS1_MASK_SHADOW_HVF_WRITE_ERR_SHIFT)) & OCOTP_OTP_MASK_STATUS1_MASK_SHADOW_HVF_WRITE_ERR_MASK)

#define OCOTP_OTP_MASK_STATUS1_MASK_SHADOW_SRAM_READ_ERR_MASK (0x8000000U)
#define OCOTP_OTP_MASK_STATUS1_MASK_SHADOW_SRAM_READ_ERR_SHIFT (27U)
#define OCOTP_OTP_MASK_STATUS1_MASK_SHADOW_SRAM_READ_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_STATUS1_MASK_SHADOW_SRAM_READ_ERR_SHIFT)) & OCOTP_OTP_MASK_STATUS1_MASK_SHADOW_SRAM_READ_ERR_MASK)

#define OCOTP_OTP_MASK_STATUS1_MASK_SHADOW_SRAM_WRITE_ERR_MASK (0x10000000U)
#define OCOTP_OTP_MASK_STATUS1_MASK_SHADOW_SRAM_WRITE_ERR_SHIFT (28U)
#define OCOTP_OTP_MASK_STATUS1_MASK_SHADOW_SRAM_WRITE_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_STATUS1_MASK_SHADOW_SRAM_WRITE_ERR_SHIFT)) & OCOTP_OTP_MASK_STATUS1_MASK_SHADOW_SRAM_WRITE_ERR_MASK)

#define OCOTP_OTP_MASK_STATUS1_MASK_FUSE_READ_ERR_MASK (0x20000000U)
#define OCOTP_OTP_MASK_STATUS1_MASK_FUSE_READ_ERR_SHIFT (29U)
#define OCOTP_OTP_MASK_STATUS1_MASK_FUSE_READ_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_STATUS1_MASK_FUSE_READ_ERR_SHIFT)) & OCOTP_OTP_MASK_STATUS1_MASK_FUSE_READ_ERR_MASK)

#define OCOTP_OTP_MASK_STATUS1_MASK_FUSE_PROG_ERR_MASK (0x40000000U)
#define OCOTP_OTP_MASK_STATUS1_MASK_FUSE_PROG_ERR_SHIFT (30U)
#define OCOTP_OTP_MASK_STATUS1_MASK_FUSE_PROG_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_STATUS1_MASK_FUSE_PROG_ERR_SHIFT)) & OCOTP_OTP_MASK_STATUS1_MASK_FUSE_PROG_ERR_MASK)

#define OCOTP_OTP_MASK_STATUS1_MASK_SHADOW_NO_ACCESS_MASK (0x80000000U)
#define OCOTP_OTP_MASK_STATUS1_MASK_SHADOW_NO_ACCESS_SHIFT (31U)
#define OCOTP_OTP_MASK_STATUS1_MASK_SHADOW_NO_ACCESS(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_MASK_STATUS1_MASK_SHADOW_NO_ACCESS_SHIFT)) & OCOTP_OTP_MASK_STATUS1_MASK_SHADOW_NO_ACCESS_MASK)
/*! @} */

/*! @name OTP_ECC_CTRL - OTP Controller ECC Ctrl Register */
/*! @{ */

#define OCOTP_OTP_ECC_CTRL_CTRL_ECC_GEN_ADDR_MASK (0x1FFU)
#define OCOTP_OTP_ECC_CTRL_CTRL_ECC_GEN_ADDR_SHIFT (0U)
#define OCOTP_OTP_ECC_CTRL_CTRL_ECC_GEN_ADDR(x)  (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_ECC_CTRL_CTRL_ECC_GEN_ADDR_SHIFT)) & OCOTP_OTP_ECC_CTRL_CTRL_ECC_GEN_ADDR_MASK)

#define OCOTP_OTP_ECC_CTRL_CTRL_ECC_GEN_DATA_MASK (0x7F0000U)
#define OCOTP_OTP_ECC_CTRL_CTRL_ECC_GEN_DATA_SHIFT (16U)
#define OCOTP_OTP_ECC_CTRL_CTRL_ECC_GEN_DATA(x)  (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_ECC_CTRL_CTRL_ECC_GEN_DATA_SHIFT)) & OCOTP_OTP_ECC_CTRL_CTRL_ECC_GEN_DATA_MASK)

#define OCOTP_OTP_ECC_CTRL_CTRL_ECC_GEN_RD_DATA_SEL_MASK (0x2000000U)
#define OCOTP_OTP_ECC_CTRL_CTRL_ECC_GEN_RD_DATA_SEL_SHIFT (25U)
#define OCOTP_OTP_ECC_CTRL_CTRL_ECC_GEN_RD_DATA_SEL(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_ECC_CTRL_CTRL_ECC_GEN_RD_DATA_SEL_SHIFT)) & OCOTP_OTP_ECC_CTRL_CTRL_ECC_GEN_RD_DATA_SEL_MASK)

#define OCOTP_OTP_ECC_CTRL_CTRL_ECC_SEC_DISABLE_MASK (0x4000000U)
#define OCOTP_OTP_ECC_CTRL_CTRL_ECC_SEC_DISABLE_SHIFT (26U)
#define OCOTP_OTP_ECC_CTRL_CTRL_ECC_SEC_DISABLE(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_ECC_CTRL_CTRL_ECC_SEC_DISABLE_SHIFT)) & OCOTP_OTP_ECC_CTRL_CTRL_ECC_SEC_DISABLE_MASK)

#define OCOTP_OTP_ECC_CTRL_CTRL_ECC_GEN_EN_MASK  (0x8000000U)
#define OCOTP_OTP_ECC_CTRL_CTRL_ECC_GEN_EN_SHIFT (27U)
#define OCOTP_OTP_ECC_CTRL_CTRL_ECC_GEN_EN(x)    (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_ECC_CTRL_CTRL_ECC_GEN_EN_SHIFT)) & OCOTP_OTP_ECC_CTRL_CTRL_ECC_GEN_EN_MASK)

#define OCOTP_OTP_ECC_CTRL_CTRL_ECC_GEN_DATA_SEL_MASK (0x10000000U)
#define OCOTP_OTP_ECC_CTRL_CTRL_ECC_GEN_DATA_SEL_SHIFT (28U)
#define OCOTP_OTP_ECC_CTRL_CTRL_ECC_GEN_DATA_SEL(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_ECC_CTRL_CTRL_ECC_GEN_DATA_SEL_SHIFT)) & OCOTP_OTP_ECC_CTRL_CTRL_ECC_GEN_DATA_SEL_MASK)

#define OCOTP_OTP_ECC_CTRL_CTRL_ECC_BLOCK_DISABLE_MASK (0x20000000U)
#define OCOTP_OTP_ECC_CTRL_CTRL_ECC_BLOCK_DISABLE_SHIFT (29U)
#define OCOTP_OTP_ECC_CTRL_CTRL_ECC_BLOCK_DISABLE(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_ECC_CTRL_CTRL_ECC_BLOCK_DISABLE_SHIFT)) & OCOTP_OTP_ECC_CTRL_CTRL_ECC_BLOCK_DISABLE_MASK)

#define OCOTP_OTP_ECC_CTRL_CTRL_ECC_BLOCK_MASK   (0x40000000U)
#define OCOTP_OTP_ECC_CTRL_CTRL_ECC_BLOCK_SHIFT  (30U)
#define OCOTP_OTP_ECC_CTRL_CTRL_ECC_BLOCK(x)     (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_ECC_CTRL_CTRL_ECC_BLOCK_SHIFT)) & OCOTP_OTP_ECC_CTRL_CTRL_ECC_BLOCK_MASK)

#define OCOTP_OTP_ECC_CTRL_CTRL_ECC_ZERO_MASK    (0x80000000U)
#define OCOTP_OTP_ECC_CTRL_CTRL_ECC_ZERO_SHIFT   (31U)
#define OCOTP_OTP_ECC_CTRL_CTRL_ECC_ZERO(x)      (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_ECC_CTRL_CTRL_ECC_ZERO_SHIFT)) & OCOTP_OTP_ECC_CTRL_CTRL_ECC_ZERO_MASK)
/*! @} */

/*! @name OTP_ECC_DATA - OTP Controller ECC Date Register */
/*! @{ */

#define OCOTP_OTP_ECC_DATA_DATA_MASK             (0xFFFFFFFFU)
#define OCOTP_OTP_ECC_DATA_DATA_SHIFT            (0U)
#define OCOTP_OTP_ECC_DATA_DATA(x)               (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_ECC_DATA_DATA_SHIFT)) & OCOTP_OTP_ECC_DATA_DATA_MASK)
/*! @} */

/*! @name OTP_ECC_DBG1 - OTP Controller ECC DBG Register1 */
/*! @{ */

#define OCOTP_OTP_ECC_DBG1_SEC_ADDR_MASK         (0x1FFU)
#define OCOTP_OTP_ECC_DBG1_SEC_ADDR_SHIFT        (0U)
#define OCOTP_OTP_ECC_DBG1_SEC_ADDR(x)           (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_ECC_DBG1_SEC_ADDR_SHIFT)) & OCOTP_OTP_ECC_DBG1_SEC_ADDR_MASK)

#define OCOTP_OTP_ECC_DBG1_DED_ADDR_MASK         (0x1FF0000U)
#define OCOTP_OTP_ECC_DBG1_DED_ADDR_SHIFT        (16U)
#define OCOTP_OTP_ECC_DBG1_DED_ADDR(x)           (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_ECC_DBG1_DED_ADDR_SHIFT)) & OCOTP_OTP_ECC_DBG1_DED_ADDR_MASK)
/*! @} */

/*! @name OTP_ECC_DBG2 - OTP Controller ECC DBG Register2 */
/*! @{ */

#define OCOTP_OTP_ECC_DBG2_WRITE_ECC_PARITY_MASK (0x7FU)
#define OCOTP_OTP_ECC_DBG2_WRITE_ECC_PARITY_SHIFT (0U)
#define OCOTP_OTP_ECC_DBG2_WRITE_ECC_PARITY(x)   (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_ECC_DBG2_WRITE_ECC_PARITY_SHIFT)) & OCOTP_OTP_ECC_DBG2_WRITE_ECC_PARITY_MASK)

#define OCOTP_OTP_ECC_DBG2_READ_ECC_PARITY_MASK  (0x7F00U)
#define OCOTP_OTP_ECC_DBG2_READ_ECC_PARITY_SHIFT (8U)
#define OCOTP_OTP_ECC_DBG2_READ_ECC_PARITY(x)    (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_ECC_DBG2_READ_ECC_PARITY_SHIFT)) & OCOTP_OTP_ECC_DBG2_READ_ECC_PARITY_MASK)

#define OCOTP_OTP_ECC_DBG2_ECC_SYNDROME_MASK     (0x7F0000U)
#define OCOTP_OTP_ECC_DBG2_ECC_SYNDROME_SHIFT    (16U)
#define OCOTP_OTP_ECC_DBG2_ECC_SYNDROME(x)       (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_ECC_DBG2_ECC_SYNDROME_SHIFT)) & OCOTP_OTP_ECC_DBG2_ECC_SYNDROME_MASK)

#define OCOTP_OTP_ECC_DBG2_ECC_CORRECTION_DETECTION_PARITYBITS_MASK (0x7F000000U)
#define OCOTP_OTP_ECC_DBG2_ECC_CORRECTION_DETECTION_PARITYBITS_SHIFT (24U)
#define OCOTP_OTP_ECC_DBG2_ECC_CORRECTION_DETECTION_PARITYBITS(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_ECC_DBG2_ECC_CORRECTION_DETECTION_PARITYBITS_SHIFT)) & OCOTP_OTP_ECC_DBG2_ECC_CORRECTION_DETECTION_PARITYBITS_MASK)
/*! @} */

/*! @name OTP_ECC_DBG3 - OTP Controller ECC DBG Register3 */
/*! @{ */

#define OCOTP_OTP_ECC_DBG3_BITS_MASK             (0xFFFFFFFFU)
#define OCOTP_OTP_ECC_DBG3_BITS_SHIFT            (0U)
#define OCOTP_OTP_ECC_DBG3_BITS(x)               (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_ECC_DBG3_BITS_SHIFT)) & OCOTP_OTP_ECC_DBG3_BITS_MASK)
/*! @} */

/*! @name OTP_PRNG_RAND_SEED - OTP Controller PRNG Random Seed Register */
/*! @{ */

#define OCOTP_OTP_PRNG_RAND_SEED_PRNG_RAND_SEED_MASK (0xFFFFFFFFU)
#define OCOTP_OTP_PRNG_RAND_SEED_PRNG_RAND_SEED_SHIFT (0U)
#define OCOTP_OTP_PRNG_RAND_SEED_PRNG_RAND_SEED(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_PRNG_RAND_SEED_PRNG_RAND_SEED_SHIFT)) & OCOTP_OTP_PRNG_RAND_SEED_PRNG_RAND_SEED_MASK)
/*! @} */

/*! @name OTP_SRAM_ENTROPY_DATA - OTP Controller SRAM Entropy Data Register */
/*! @{ */

#define OCOTP_OTP_SRAM_ENTROPY_DATA_SRAM_ENTROPY_DATA_MASK (0xFFFFFFFFU)
#define OCOTP_OTP_SRAM_ENTROPY_DATA_SRAM_ENTROPY_DATA_SHIFT (0U)
#define OCOTP_OTP_SRAM_ENTROPY_DATA_SRAM_ENTROPY_DATA(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_SRAM_ENTROPY_DATA_SRAM_ENTROPY_DATA_SHIFT)) & OCOTP_OTP_SRAM_ENTROPY_DATA_SRAM_ENTROPY_DATA_MASK)
/*! @} */

/*! @name OTP_PRNG_OUTPUT_DATA - OTP Controller PRNG Output Data Register */
/*! @{ */

#define OCOTP_OTP_PRNG_OUTPUT_DATA_PRNG_OUTPUT_DATA_MASK (0x3FFFFU)
#define OCOTP_OTP_PRNG_OUTPUT_DATA_PRNG_OUTPUT_DATA_SHIFT (0U)
#define OCOTP_OTP_PRNG_OUTPUT_DATA_PRNG_OUTPUT_DATA(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_PRNG_OUTPUT_DATA_PRNG_OUTPUT_DATA_SHIFT)) & OCOTP_OTP_PRNG_OUTPUT_DATA_PRNG_OUTPUT_DATA_MASK)
/*! @} */

/*! @name OTP_CRC_LUT - OTP Controller CRC LUT Register0..OTP Controller CRC LUT Register7 */
/*! @{ */

#define OCOTP_OTP_CRC_LUT_CRC_FUSE_START_ADDR_MASK (0x7FU)
#define OCOTP_OTP_CRC_LUT_CRC_FUSE_START_ADDR_SHIFT (0U)
#define OCOTP_OTP_CRC_LUT_CRC_FUSE_START_ADDR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_CRC_LUT_CRC_FUSE_START_ADDR_SHIFT)) & OCOTP_OTP_CRC_LUT_CRC_FUSE_START_ADDR_MASK)

#define OCOTP_OTP_CRC_LUT_CRC_EXP_VAL_FUSE_ADDR_MASK (0x700U)
#define OCOTP_OTP_CRC_LUT_CRC_EXP_VAL_FUSE_ADDR_SHIFT (8U)
#define OCOTP_OTP_CRC_LUT_CRC_EXP_VAL_FUSE_ADDR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_CRC_LUT_CRC_EXP_VAL_FUSE_ADDR_SHIFT)) & OCOTP_OTP_CRC_LUT_CRC_EXP_VAL_FUSE_ADDR_MASK)

#define OCOTP_OTP_CRC_LUT_CRC_FUSE_END_ADDR_MASK (0x7F0000U)
#define OCOTP_OTP_CRC_LUT_CRC_FUSE_END_ADDR_SHIFT (16U)
#define OCOTP_OTP_CRC_LUT_CRC_FUSE_END_ADDR(x)   (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_CRC_LUT_CRC_FUSE_END_ADDR_SHIFT)) & OCOTP_OTP_CRC_LUT_CRC_FUSE_END_ADDR_MASK)

#define OCOTP_OTP_CRC_LUT_READ_PROTECTION_MASK   (0x20000000U)
#define OCOTP_OTP_CRC_LUT_READ_PROTECTION_SHIFT  (29U)
#define OCOTP_OTP_CRC_LUT_READ_PROTECTION(x)     (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_CRC_LUT_READ_PROTECTION_SHIFT)) & OCOTP_OTP_CRC_LUT_READ_PROTECTION_MASK)

#define OCOTP_OTP_CRC_LUT_SECURITY_PROTECTION_MASK (0x40000000U)
#define OCOTP_OTP_CRC_LUT_SECURITY_PROTECTION_SHIFT (30U)
#define OCOTP_OTP_CRC_LUT_SECURITY_PROTECTION(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_CRC_LUT_SECURITY_PROTECTION_SHIFT)) & OCOTP_OTP_CRC_LUT_SECURITY_PROTECTION_MASK)

#define OCOTP_OTP_CRC_LUT_WRITE_PROTECTION_MASK  (0x80000000U)
#define OCOTP_OTP_CRC_LUT_WRITE_PROTECTION_SHIFT (31U)
#define OCOTP_OTP_CRC_LUT_WRITE_PROTECTION(x)    (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_CRC_LUT_WRITE_PROTECTION_SHIFT)) & OCOTP_OTP_CRC_LUT_WRITE_PROTECTION_MASK)
/*! @} */

/*! @name OTP_LOCK_STICKY_0 - OTP Controller Lock Sticky Register0 */
/*! @{ */

#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT0_MASK (0x1U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT0_SHIFT (0U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT0(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT0_SHIFT)) & OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT0_MASK)

#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT1_MASK (0x2U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT1_SHIFT (1U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT1(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT1_SHIFT)) & OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT1_MASK)

#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT2_MASK (0x4U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT2_SHIFT (2U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT2(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT2_SHIFT)) & OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT2_MASK)

#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT3_MASK (0x8U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT3_SHIFT (3U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT3(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT3_SHIFT)) & OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT3_MASK)

#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT4_MASK (0x10U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT4_SHIFT (4U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT4(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT4_SHIFT)) & OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT4_MASK)

#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT5_MASK (0x20U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT5_SHIFT (5U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT5(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT5_SHIFT)) & OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT5_MASK)

#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT6_MASK (0x40U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT6_SHIFT (6U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT6(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT6_SHIFT)) & OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT6_MASK)

#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT7_MASK (0x80U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT7_SHIFT (7U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT7(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT7_SHIFT)) & OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT7_MASK)

#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT8_MASK (0x100U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT8_SHIFT (8U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT8(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT8_SHIFT)) & OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT8_MASK)

#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT9_MASK (0x200U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT9_SHIFT (9U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT9(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT9_SHIFT)) & OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT9_MASK)

#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT10_MASK (0x400U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT10_SHIFT (10U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT10(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT10_SHIFT)) & OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT10_MASK)

#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT11_MASK (0x800U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT11_SHIFT (11U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT11(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT11_SHIFT)) & OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT11_MASK)

#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT12_MASK (0x1000U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT12_SHIFT (12U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT12(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT12_SHIFT)) & OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT12_MASK)

#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT13_MASK (0x2000U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT13_SHIFT (13U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT13(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT13_SHIFT)) & OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT13_MASK)

#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT14_MASK (0x4000U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT14_SHIFT (14U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT14(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT14_SHIFT)) & OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT14_MASK)

#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT15_MASK (0x8000U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT15_SHIFT (15U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT15(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT15_SHIFT)) & OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT15_MASK)

#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT16_MASK (0x10000U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT16_SHIFT (16U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT16(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT16_SHIFT)) & OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT16_MASK)

#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT17_MASK (0x20000U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT17_SHIFT (17U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT17(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT17_SHIFT)) & OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT17_MASK)

#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT18_MASK (0x40000U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT18_SHIFT (18U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT18(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT18_SHIFT)) & OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT18_MASK)

#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT19_MASK (0x80000U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT19_SHIFT (19U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT19(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT19_SHIFT)) & OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT19_MASK)

#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT20_MASK (0x100000U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT20_SHIFT (20U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT20(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT20_SHIFT)) & OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT20_MASK)

#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT21_MASK (0x200000U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT21_SHIFT (21U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT21(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT21_SHIFT)) & OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT21_MASK)

#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT22_MASK (0x400000U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT22_SHIFT (22U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT22(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT22_SHIFT)) & OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT22_MASK)

#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT23_MASK (0x800000U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT23_SHIFT (23U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT23(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT23_SHIFT)) & OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT23_MASK)

#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT24_MASK (0x1000000U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT24_SHIFT (24U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT24(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT24_SHIFT)) & OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT24_MASK)

#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT25_MASK (0x2000000U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT25_SHIFT (25U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT25(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT25_SHIFT)) & OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT25_MASK)

#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT26_MASK (0x4000000U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT26_SHIFT (26U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT26(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT26_SHIFT)) & OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT26_MASK)

#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT27_MASK (0x8000000U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT27_SHIFT (27U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT27(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT27_SHIFT)) & OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT27_MASK)

#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT28_MASK (0x10000000U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT28_SHIFT (28U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT28(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT28_SHIFT)) & OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT28_MASK)

#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT29_MASK (0x20000000U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT29_SHIFT (29U)
#define OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT29(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT29_SHIFT)) & OCOTP_OTP_LOCK_STICKY_0_LOCK_STICKY_BIT29_MASK)
/*! @} */

/*! @name OTP_LOCK_STICKY_1 - OTP Controller Lock Sticky Register1 */
/*! @{ */

#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT30_MASK (0x1U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT30_SHIFT (0U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT30(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT30_SHIFT)) & OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT30_MASK)

#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT31_MASK (0x2U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT31_SHIFT (1U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT31(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT31_SHIFT)) & OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT31_MASK)

#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT32_MASK (0x4U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT32_SHIFT (2U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT32(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT32_SHIFT)) & OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT32_MASK)

#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT33_MASK (0x8U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT33_SHIFT (3U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT33(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT33_SHIFT)) & OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT33_MASK)

#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT34_MASK (0x10U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT34_SHIFT (4U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT34(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT34_SHIFT)) & OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT34_MASK)

#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT35_MASK (0x20U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT35_SHIFT (5U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT35(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT35_SHIFT)) & OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT35_MASK)

#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT36_MASK (0x40U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT36_SHIFT (6U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT36(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT36_SHIFT)) & OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT36_MASK)

#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT37_MASK (0x80U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT37_SHIFT (7U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT37(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT37_SHIFT)) & OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT37_MASK)

#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT38_MASK (0x100U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT38_SHIFT (8U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT38(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT38_SHIFT)) & OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT38_MASK)

#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT39_MASK (0x200U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT39_SHIFT (9U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT39(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT39_SHIFT)) & OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT39_MASK)

#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT40_MASK (0x400U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT40_SHIFT (10U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT40(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT40_SHIFT)) & OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT40_MASK)

#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT41_MASK (0x800U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT41_SHIFT (11U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT41(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT41_SHIFT)) & OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT41_MASK)

#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT42_MASK (0x1000U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT42_SHIFT (12U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT42(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT42_SHIFT)) & OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT42_MASK)

#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT43_MASK (0x2000U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT43_SHIFT (13U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT43(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT43_SHIFT)) & OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT43_MASK)

#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT44_MASK (0x4000U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT44_SHIFT (14U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT44(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT44_SHIFT)) & OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT44_MASK)

#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT45_MASK (0x8000U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT45_SHIFT (15U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT45(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT45_SHIFT)) & OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT45_MASK)

#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT46_MASK (0x10000U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT46_SHIFT (16U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT46(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT46_SHIFT)) & OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT46_MASK)

#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT47_MASK (0x20000U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT47_SHIFT (17U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT47(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT47_SHIFT)) & OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT47_MASK)

#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT48_MASK (0x40000U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT48_SHIFT (18U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT48(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT48_SHIFT)) & OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT48_MASK)

#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT49_MASK (0x80000U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT49_SHIFT (19U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT49(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT49_SHIFT)) & OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT49_MASK)

#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT50_MASK (0x100000U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT50_SHIFT (20U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT50(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT50_SHIFT)) & OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT50_MASK)

#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT51_MASK (0x200000U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT51_SHIFT (21U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT51(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT51_SHIFT)) & OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT51_MASK)

#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT52_MASK (0x400000U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT52_SHIFT (22U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT52(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT52_SHIFT)) & OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT52_MASK)

#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT53_MASK (0x800000U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT53_SHIFT (23U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT53(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT53_SHIFT)) & OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT53_MASK)

#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT54_MASK (0x1000000U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT54_SHIFT (24U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT54(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT54_SHIFT)) & OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT54_MASK)

#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT55_MASK (0x2000000U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT55_SHIFT (25U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT55(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT55_SHIFT)) & OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT55_MASK)

#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT56_MASK (0x4000000U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT56_SHIFT (26U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT56(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT56_SHIFT)) & OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT56_MASK)

#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT57_MASK (0x8000000U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT57_SHIFT (27U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT57(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT57_SHIFT)) & OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT57_MASK)

#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT58_MASK (0x10000000U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT58_SHIFT (28U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT58(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT58_SHIFT)) & OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT58_MASK)

#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT59_MASK (0x20000000U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT59_SHIFT (29U)
#define OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT59(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT59_SHIFT)) & OCOTP_OTP_LOCK_STICKY_1_LOCK_STICKY_BIT59_MASK)
/*! @} */

/*! @name OTP_LOCK_STICKY_2 - OTP Controller Lock Sticky Register2 */
/*! @{ */

#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT60_MASK (0x1U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT60_SHIFT (0U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT60(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT60_SHIFT)) & OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT60_MASK)

#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT61_MASK (0x2U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT61_SHIFT (1U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT61(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT61_SHIFT)) & OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT61_MASK)

#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT62_MASK (0x4U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT62_SHIFT (2U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT62(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT62_SHIFT)) & OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT62_MASK)

#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT63_MASK (0x8U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT63_SHIFT (3U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT63(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT63_SHIFT)) & OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT63_MASK)

#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT64_MASK (0x10U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT64_SHIFT (4U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT64(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT64_SHIFT)) & OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT64_MASK)

#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT65_MASK (0x20U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT65_SHIFT (5U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT65(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT65_SHIFT)) & OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT65_MASK)

#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT66_MASK (0x40U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT66_SHIFT (6U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT66(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT66_SHIFT)) & OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT66_MASK)

#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT67_MASK (0x80U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT67_SHIFT (7U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT67(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT67_SHIFT)) & OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT67_MASK)

#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT68_MASK (0x100U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT68_SHIFT (8U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT68(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT68_SHIFT)) & OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT68_MASK)

#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT69_MASK (0x200U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT69_SHIFT (9U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT69(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT69_SHIFT)) & OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT69_MASK)

#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT70_MASK (0x400U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT70_SHIFT (10U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT70(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT70_SHIFT)) & OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT70_MASK)

#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT71_MASK (0x800U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT71_SHIFT (11U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT71(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT71_SHIFT)) & OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT71_MASK)

#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT72_MASK (0x1000U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT72_SHIFT (12U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT72(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT72_SHIFT)) & OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT72_MASK)

#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT73_MASK (0x2000U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT73_SHIFT (13U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT73(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT73_SHIFT)) & OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT73_MASK)

#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT74_MASK (0x4000U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT74_SHIFT (14U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT74(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT74_SHIFT)) & OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT74_MASK)

#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT75_MASK (0x8000U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT75_SHIFT (15U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT75(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT75_SHIFT)) & OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT75_MASK)

#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT76_MASK (0x10000U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT76_SHIFT (16U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT76(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT76_SHIFT)) & OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT76_MASK)

#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT77_MASK (0x20000U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT77_SHIFT (17U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT77(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT77_SHIFT)) & OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT77_MASK)

#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT78_MASK (0x40000U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT78_SHIFT (18U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT78(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT78_SHIFT)) & OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT78_MASK)

#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT79_MASK (0x80000U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT79_SHIFT (19U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT79(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT79_SHIFT)) & OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT79_MASK)

#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT80_MASK (0x100000U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT80_SHIFT (20U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT80(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT80_SHIFT)) & OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT80_MASK)

#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT81_MASK (0x200000U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT81_SHIFT (21U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT81(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT81_SHIFT)) & OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT81_MASK)

#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT82_MASK (0x400000U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT82_SHIFT (22U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT82(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT82_SHIFT)) & OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT82_MASK)

#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT83_MASK (0x800000U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT83_SHIFT (23U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT83(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT83_SHIFT)) & OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT83_MASK)

#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT84_MASK (0x1000000U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT84_SHIFT (24U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT84(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT84_SHIFT)) & OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT84_MASK)

#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT85_MASK (0x2000000U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT85_SHIFT (25U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT85(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT85_SHIFT)) & OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT85_MASK)

#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT86_MASK (0x4000000U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT86_SHIFT (26U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT86(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT86_SHIFT)) & OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT86_MASK)

#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT87_MASK (0x8000000U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT87_SHIFT (27U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT87(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT87_SHIFT)) & OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT87_MASK)

#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT88_MASK (0x10000000U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT88_SHIFT (28U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT88(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT88_SHIFT)) & OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT88_MASK)

#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT89_MASK (0x20000000U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT89_SHIFT (29U)
#define OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT89(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT89_SHIFT)) & OCOTP_OTP_LOCK_STICKY_2_LOCK_STICKY_BIT89_MASK)
/*! @} */

/*! @name OTP_LOCK_STICKY_3 - OTP Controller Lock Sticky Register3 */
/*! @{ */

#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT90_MASK (0x1U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT90_SHIFT (0U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT90(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT90_SHIFT)) & OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT90_MASK)

#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT91_MASK (0x2U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT91_SHIFT (1U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT91(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT91_SHIFT)) & OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT91_MASK)

#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT92_MASK (0x4U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT92_SHIFT (2U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT92(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT92_SHIFT)) & OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT92_MASK)

#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT93_MASK (0x8U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT93_SHIFT (3U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT93(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT93_SHIFT)) & OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT93_MASK)

#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT94_MASK (0x10U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT94_SHIFT (4U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT94(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT94_SHIFT)) & OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT94_MASK)

#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT95_MASK (0x20U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT95_SHIFT (5U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT95(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT95_SHIFT)) & OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT95_MASK)

#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT96_MASK (0x40U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT96_SHIFT (6U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT96(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT96_SHIFT)) & OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT96_MASK)

#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT97_MASK (0x80U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT97_SHIFT (7U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT97(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT97_SHIFT)) & OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT97_MASK)

#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT98_MASK (0x100U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT98_SHIFT (8U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT98(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT98_SHIFT)) & OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT98_MASK)

#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT99_MASK (0x200U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT99_SHIFT (9U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT99(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT99_SHIFT)) & OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT99_MASK)

#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT100_MASK (0x400U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT100_SHIFT (10U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT100(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT100_SHIFT)) & OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT100_MASK)

#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT101_MASK (0x800U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT101_SHIFT (11U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT101(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT101_SHIFT)) & OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT101_MASK)

#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT102_MASK (0x1000U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT102_SHIFT (12U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT102(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT102_SHIFT)) & OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT102_MASK)

#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT103_MASK (0x2000U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT103_SHIFT (13U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT103(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT103_SHIFT)) & OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT103_MASK)

#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT104_MASK (0x4000U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT104_SHIFT (14U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT104(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT104_SHIFT)) & OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT104_MASK)

#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT105_MASK (0x8000U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT105_SHIFT (15U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT105(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT105_SHIFT)) & OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT105_MASK)

#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT106_MASK (0x10000U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT106_SHIFT (16U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT106(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT106_SHIFT)) & OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT106_MASK)

#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT107_MASK (0x20000U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT107_SHIFT (17U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT107(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT107_SHIFT)) & OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT107_MASK)

#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT108_MASK (0x40000U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT108_SHIFT (18U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT108(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT108_SHIFT)) & OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT108_MASK)

#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT109_MASK (0x80000U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT109_SHIFT (19U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT109(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT109_SHIFT)) & OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT109_MASK)

#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT110_MASK (0x100000U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT110_SHIFT (20U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT110(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT110_SHIFT)) & OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT110_MASK)

#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT111_MASK (0x200000U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT111_SHIFT (21U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT111(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT111_SHIFT)) & OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT111_MASK)

#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT112_MASK (0x400000U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT112_SHIFT (22U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT112(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT112_SHIFT)) & OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT112_MASK)

#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT113_MASK (0x800000U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT113_SHIFT (23U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT113(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT113_SHIFT)) & OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT113_MASK)

#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT114_MASK (0x1000000U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT114_SHIFT (24U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT114(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT114_SHIFT)) & OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT114_MASK)

#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT115_MASK (0x2000000U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT115_SHIFT (25U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT115(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT115_SHIFT)) & OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT115_MASK)

#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT116_MASK (0x4000000U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT116_SHIFT (26U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT116(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT116_SHIFT)) & OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT116_MASK)

#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT117_MASK (0x8000000U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT117_SHIFT (27U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT117(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT117_SHIFT)) & OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT117_MASK)

#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT118_MASK (0x10000000U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT118_SHIFT (28U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT118(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT118_SHIFT)) & OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT118_MASK)

#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT119_MASK (0x20000000U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT119_SHIFT (29U)
#define OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT119(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT119_SHIFT)) & OCOTP_OTP_LOCK_STICKY_3_LOCK_STICKY_BIT119_MASK)
/*! @} */

/*! @name OTP_LOCK_STICKY_4 - OTP Controller Lock Sticky Register4 */
/*! @{ */

#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT120_MASK (0x1U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT120_SHIFT (0U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT120(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT120_SHIFT)) & OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT120_MASK)

#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT121_MASK (0x2U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT121_SHIFT (1U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT121(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT121_SHIFT)) & OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT121_MASK)

#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT122_MASK (0x4U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT122_SHIFT (2U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT122(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT122_SHIFT)) & OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT122_MASK)

#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT123_MASK (0x8U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT123_SHIFT (3U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT123(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT123_SHIFT)) & OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT123_MASK)

#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT124_MASK (0x10U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT124_SHIFT (4U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT124(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT124_SHIFT)) & OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT124_MASK)

#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT125_MASK (0x20U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT125_SHIFT (5U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT125(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT125_SHIFT)) & OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT125_MASK)

#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT126_MASK (0x40U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT126_SHIFT (6U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT126(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT126_SHIFT)) & OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT126_MASK)

#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT127_MASK (0x80U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT127_SHIFT (7U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT127(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT127_SHIFT)) & OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT127_MASK)

#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT128_MASK (0x100U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT128_SHIFT (8U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT128(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT128_SHIFT)) & OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT128_MASK)

#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT129_MASK (0x200U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT129_SHIFT (9U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT129(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT129_SHIFT)) & OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT129_MASK)

#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT130_MASK (0x400U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT130_SHIFT (10U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT130(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT130_SHIFT)) & OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT130_MASK)

#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT131_MASK (0x800U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT131_SHIFT (11U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT131(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT131_SHIFT)) & OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT131_MASK)

#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT132_MASK (0x1000U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT132_SHIFT (12U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT132(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT132_SHIFT)) & OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT132_MASK)

#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT133_MASK (0x2000U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT133_SHIFT (13U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT133(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT133_SHIFT)) & OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT133_MASK)

#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT134_MASK (0x4000U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT134_SHIFT (14U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT134(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT134_SHIFT)) & OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT134_MASK)

#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT135_MASK (0x8000U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT135_SHIFT (15U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT135(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT135_SHIFT)) & OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT135_MASK)

#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT136_MASK (0x10000U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT136_SHIFT (16U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT136(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT136_SHIFT)) & OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT136_MASK)

#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT137_MASK (0x20000U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT137_SHIFT (17U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT137(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT137_SHIFT)) & OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT137_MASK)

#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT138_MASK (0x40000U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT138_SHIFT (18U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT138(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT138_SHIFT)) & OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT138_MASK)

#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT139_MASK (0x80000U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT139_SHIFT (19U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT139(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT139_SHIFT)) & OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT139_MASK)

#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT140_MASK (0x100000U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT140_SHIFT (20U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT140(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT140_SHIFT)) & OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT140_MASK)

#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT141_MASK (0x200000U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT141_SHIFT (21U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT141(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT141_SHIFT)) & OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT141_MASK)

#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT142_MASK (0x400000U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT142_SHIFT (22U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT142(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT142_SHIFT)) & OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT142_MASK)

#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT143_MASK (0x800000U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT143_SHIFT (23U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT143(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT143_SHIFT)) & OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT143_MASK)

#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT144_MASK (0x1000000U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT144_SHIFT (24U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT144(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT144_SHIFT)) & OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT144_MASK)

#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT145_MASK (0x2000000U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT145_SHIFT (25U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT145(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT145_SHIFT)) & OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT145_MASK)

#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT146_MASK (0x4000000U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT146_SHIFT (26U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT146(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT146_SHIFT)) & OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT146_MASK)

#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT147_MASK (0x8000000U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT147_SHIFT (27U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT147(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT147_SHIFT)) & OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT147_MASK)

#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT148_MASK (0x10000000U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT148_SHIFT (28U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT148(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT148_SHIFT)) & OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT148_MASK)

#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT149_MASK (0x20000000U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT149_SHIFT (29U)
#define OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT149(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT149_SHIFT)) & OCOTP_OTP_LOCK_STICKY_4_LOCK_STICKY_BIT149_MASK)
/*! @} */

/*! @name OTP_LOCK_STICKY_5 - OTP Controller Lock Sticky Register5 */
/*! @{ */

#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT150_MASK (0x1U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT150_SHIFT (0U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT150(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT150_SHIFT)) & OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT150_MASK)

#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT151_MASK (0x2U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT151_SHIFT (1U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT151(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT151_SHIFT)) & OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT151_MASK)

#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT152_MASK (0x4U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT152_SHIFT (2U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT152(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT152_SHIFT)) & OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT152_MASK)

#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT153_MASK (0x8U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT153_SHIFT (3U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT153(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT153_SHIFT)) & OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT153_MASK)

#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT154_MASK (0x10U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT154_SHIFT (4U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT154(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT154_SHIFT)) & OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT154_MASK)

#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT155_MASK (0x20U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT155_SHIFT (5U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT155(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT155_SHIFT)) & OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT155_MASK)

#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT156_MASK (0x40U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT156_SHIFT (6U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT156(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT156_SHIFT)) & OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT156_MASK)

#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT157_MASK (0x80U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT157_SHIFT (7U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT157(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT157_SHIFT)) & OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT157_MASK)

#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT158_MASK (0x100U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT158_SHIFT (8U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT158(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT158_SHIFT)) & OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT158_MASK)

#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT159_MASK (0x200U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT159_SHIFT (9U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT159(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT159_SHIFT)) & OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT159_MASK)

#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT160_MASK (0x400U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT160_SHIFT (10U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT160(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT160_SHIFT)) & OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT160_MASK)

#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT161_MASK (0x800U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT161_SHIFT (11U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT161(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT161_SHIFT)) & OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT161_MASK)

#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT162_MASK (0x1000U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT162_SHIFT (12U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT162(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT162_SHIFT)) & OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT162_MASK)

#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT163_MASK (0x2000U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT163_SHIFT (13U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT163(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT163_SHIFT)) & OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT163_MASK)

#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT164_MASK (0x4000U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT164_SHIFT (14U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT164(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT164_SHIFT)) & OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT164_MASK)

#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT165_MASK (0x8000U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT165_SHIFT (15U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT165(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT165_SHIFT)) & OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT165_MASK)

#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT166_MASK (0x10000U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT166_SHIFT (16U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT166(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT166_SHIFT)) & OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT166_MASK)

#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT167_MASK (0x20000U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT167_SHIFT (17U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT167(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT167_SHIFT)) & OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT167_MASK)

#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT168_MASK (0x40000U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT168_SHIFT (18U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT168(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT168_SHIFT)) & OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT168_MASK)

#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT169_MASK (0x80000U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT169_SHIFT (19U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT169(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT169_SHIFT)) & OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT169_MASK)

#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT170_MASK (0x100000U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT170_SHIFT (20U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT170(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT170_SHIFT)) & OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT170_MASK)

#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT171_MASK (0x200000U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT171_SHIFT (21U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT171(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT171_SHIFT)) & OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT171_MASK)

#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT172_MASK (0x400000U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT172_SHIFT (22U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT172(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT172_SHIFT)) & OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT172_MASK)

#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT173_MASK (0x800000U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT173_SHIFT (23U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT173(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT173_SHIFT)) & OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT173_MASK)

#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT174_MASK (0x1000000U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT174_SHIFT (24U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT174(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT174_SHIFT)) & OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT174_MASK)

#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT175_MASK (0x2000000U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT175_SHIFT (25U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT175(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT175_SHIFT)) & OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT175_MASK)

#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT176_MASK (0x4000000U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT176_SHIFT (26U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT176(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT176_SHIFT)) & OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT176_MASK)

#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT177_MASK (0x8000000U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT177_SHIFT (27U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT177(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT177_SHIFT)) & OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT177_MASK)

#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT178_MASK (0x10000000U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT178_SHIFT (28U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT178(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT178_SHIFT)) & OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT178_MASK)

#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT179_MASK (0x20000000U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT179_SHIFT (29U)
#define OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT179(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT179_SHIFT)) & OCOTP_OTP_LOCK_STICKY_5_LOCK_STICKY_BIT179_MASK)
/*! @} */

/*! @name OTP_LOCK_STICKY_6 - OTP Controller Lock Sticky Register6 */
/*! @{ */

#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT180_MASK (0x1U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT180_SHIFT (0U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT180(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT180_SHIFT)) & OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT180_MASK)

#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT181_MASK (0x2U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT181_SHIFT (1U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT181(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT181_SHIFT)) & OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT181_MASK)

#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT182_MASK (0x4U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT182_SHIFT (2U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT182(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT182_SHIFT)) & OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT182_MASK)

#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT183_MASK (0x8U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT183_SHIFT (3U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT183(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT183_SHIFT)) & OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT183_MASK)

#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT184_MASK (0x10U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT184_SHIFT (4U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT184(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT184_SHIFT)) & OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT184_MASK)

#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT185_MASK (0x20U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT185_SHIFT (5U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT185(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT185_SHIFT)) & OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT185_MASK)

#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT186_MASK (0x40U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT186_SHIFT (6U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT186(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT186_SHIFT)) & OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT186_MASK)

#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT187_MASK (0x80U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT187_SHIFT (7U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT187(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT187_SHIFT)) & OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT187_MASK)

#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT188_MASK (0x100U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT188_SHIFT (8U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT188(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT188_SHIFT)) & OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT188_MASK)

#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT189_MASK (0x200U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT189_SHIFT (9U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT189(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT189_SHIFT)) & OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT189_MASK)

#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT190_MASK (0x400U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT190_SHIFT (10U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT190(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT190_SHIFT)) & OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT190_MASK)

#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT191_MASK (0x800U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT191_SHIFT (11U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT191(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT191_SHIFT)) & OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT191_MASK)

#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT192_MASK (0x1000U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT192_SHIFT (12U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT192(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT192_SHIFT)) & OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT192_MASK)

#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT193_MASK (0x2000U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT193_SHIFT (13U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT193(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT193_SHIFT)) & OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT193_MASK)

#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT194_MASK (0x4000U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT194_SHIFT (14U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT194(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT194_SHIFT)) & OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT194_MASK)

#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT195_MASK (0x8000U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT195_SHIFT (15U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT195(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT195_SHIFT)) & OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT195_MASK)

#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT196_MASK (0x10000U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT196_SHIFT (16U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT196(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT196_SHIFT)) & OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT196_MASK)

#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT197_MASK (0x20000U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT197_SHIFT (17U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT197(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT197_SHIFT)) & OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT197_MASK)

#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT198_MASK (0x40000U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT198_SHIFT (18U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT198(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT198_SHIFT)) & OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT198_MASK)

#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT199_MASK (0x80000U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT199_SHIFT (19U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT199(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT199_SHIFT)) & OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT199_MASK)

#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT200_MASK (0x100000U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT200_SHIFT (20U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT200(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT200_SHIFT)) & OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT200_MASK)

#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT201_MASK (0x200000U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT201_SHIFT (21U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT201(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT201_SHIFT)) & OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT201_MASK)

#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT202_MASK (0x400000U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT202_SHIFT (22U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT202(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT202_SHIFT)) & OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT202_MASK)

#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT203_MASK (0x800000U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT203_SHIFT (23U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT203(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT203_SHIFT)) & OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT203_MASK)

#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT204_MASK (0x1000000U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT204_SHIFT (24U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT204(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT204_SHIFT)) & OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT204_MASK)

#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT205_MASK (0x2000000U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT205_SHIFT (25U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT205(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT205_SHIFT)) & OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT205_MASK)

#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT206_MASK (0x4000000U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT206_SHIFT (26U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT206(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT206_SHIFT)) & OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT206_MASK)

#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT207_MASK (0x8000000U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT207_SHIFT (27U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT207(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT207_SHIFT)) & OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT207_MASK)

#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT208_MASK (0x10000000U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT208_SHIFT (28U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT208(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT208_SHIFT)) & OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT208_MASK)

#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT209_MASK (0x20000000U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT209_SHIFT (29U)
#define OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT209(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT209_SHIFT)) & OCOTP_OTP_LOCK_STICKY_6_LOCK_STICKY_BIT209_MASK)
/*! @} */

/*! @name OTP_LOCK_STICKY_7 - OTP Controller Lock Sticky Register7 */
/*! @{ */

#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT210_MASK (0x1U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT210_SHIFT (0U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT210(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT210_SHIFT)) & OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT210_MASK)

#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT211_MASK (0x2U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT211_SHIFT (1U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT211(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT211_SHIFT)) & OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT211_MASK)

#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT212_MASK (0x4U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT212_SHIFT (2U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT212(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT212_SHIFT)) & OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT212_MASK)

#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT213_MASK (0x8U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT213_SHIFT (3U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT213(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT213_SHIFT)) & OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT213_MASK)

#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT214_MASK (0x10U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT214_SHIFT (4U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT214(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT214_SHIFT)) & OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT214_MASK)

#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT215_MASK (0x20U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT215_SHIFT (5U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT215(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT215_SHIFT)) & OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT215_MASK)

#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT216_MASK (0x40U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT216_SHIFT (6U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT216(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT216_SHIFT)) & OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT216_MASK)

#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT217_MASK (0x80U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT217_SHIFT (7U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT217(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT217_SHIFT)) & OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT217_MASK)

#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT218_MASK (0x100U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT218_SHIFT (8U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT218(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT218_SHIFT)) & OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT218_MASK)

#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT219_MASK (0x200U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT219_SHIFT (9U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT219(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT219_SHIFT)) & OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT219_MASK)

#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT220_MASK (0x400U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT220_SHIFT (10U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT220(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT220_SHIFT)) & OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT220_MASK)

#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT221_MASK (0x800U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT221_SHIFT (11U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT221(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT221_SHIFT)) & OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT221_MASK)

#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT222_MASK (0x1000U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT222_SHIFT (12U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT222(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT222_SHIFT)) & OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT222_MASK)

#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT223_MASK (0x2000U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT223_SHIFT (13U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT223(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT223_SHIFT)) & OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT223_MASK)

#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT224_MASK (0x4000U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT224_SHIFT (14U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT224(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT224_SHIFT)) & OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT224_MASK)

#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT225_MASK (0x8000U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT225_SHIFT (15U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT225(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT225_SHIFT)) & OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT225_MASK)

#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT226_MASK (0x10000U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT226_SHIFT (16U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT226(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT226_SHIFT)) & OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT226_MASK)

#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT227_MASK (0x20000U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT227_SHIFT (17U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT227(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT227_SHIFT)) & OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT227_MASK)

#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT228_MASK (0x40000U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT228_SHIFT (18U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT228(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT228_SHIFT)) & OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT228_MASK)

#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT229_MASK (0x80000U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT229_SHIFT (19U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT229(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT229_SHIFT)) & OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT229_MASK)

#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT230_MASK (0x100000U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT230_SHIFT (20U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT230(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT230_SHIFT)) & OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT230_MASK)

#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT231_MASK (0x200000U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT231_SHIFT (21U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT231(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT231_SHIFT)) & OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT231_MASK)

#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT232_MASK (0x400000U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT232_SHIFT (22U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT232(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT232_SHIFT)) & OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT232_MASK)

#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT233_MASK (0x800000U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT233_SHIFT (23U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT233(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT233_SHIFT)) & OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT233_MASK)

#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT234_MASK (0x1000000U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT234_SHIFT (24U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT234(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT234_SHIFT)) & OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT234_MASK)

#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT235_MASK (0x2000000U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT235_SHIFT (25U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT235(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT235_SHIFT)) & OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT235_MASK)

#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT236_MASK (0x4000000U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT236_SHIFT (26U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT236(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT236_SHIFT)) & OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT236_MASK)

#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT237_MASK (0x8000000U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT237_SHIFT (27U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT237(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT237_SHIFT)) & OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT237_MASK)

#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT238_MASK (0x10000000U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT238_SHIFT (28U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT238(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT238_SHIFT)) & OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT238_MASK)

#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT239_MASK (0x20000000U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT239_SHIFT (29U)
#define OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT239(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT239_SHIFT)) & OCOTP_OTP_LOCK_STICKY_7_LOCK_STICKY_BIT239_MASK)
/*! @} */

/*! @name OTP_LOCK_STICKY_8 - OTP Controller Lock Sticky Register8 */
/*! @{ */

#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT240_MASK (0x1U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT240_SHIFT (0U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT240(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT240_SHIFT)) & OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT240_MASK)

#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT241_MASK (0x2U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT241_SHIFT (1U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT241(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT241_SHIFT)) & OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT241_MASK)

#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT242_MASK (0x4U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT242_SHIFT (2U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT242(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT242_SHIFT)) & OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT242_MASK)

#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT243_MASK (0x8U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT243_SHIFT (3U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT243(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT243_SHIFT)) & OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT243_MASK)

#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT244_MASK (0x10U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT244_SHIFT (4U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT244(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT244_SHIFT)) & OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT244_MASK)

#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT245_MASK (0x20U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT245_SHIFT (5U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT245(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT245_SHIFT)) & OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT245_MASK)

#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT246_MASK (0x40U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT246_SHIFT (6U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT246(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT246_SHIFT)) & OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT246_MASK)

#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT247_MASK (0x80U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT247_SHIFT (7U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT247(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT247_SHIFT)) & OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT247_MASK)

#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT248_MASK (0x100U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT248_SHIFT (8U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT248(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT248_SHIFT)) & OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT248_MASK)

#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT249_MASK (0x200U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT249_SHIFT (9U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT249(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT249_SHIFT)) & OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT249_MASK)

#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT250_MASK (0x400U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT250_SHIFT (10U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT250(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT250_SHIFT)) & OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT250_MASK)

#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT251_MASK (0x800U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT251_SHIFT (11U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT251(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT251_SHIFT)) & OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT251_MASK)

#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT252_MASK (0x1000U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT252_SHIFT (12U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT252(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT252_SHIFT)) & OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT252_MASK)

#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT253_MASK (0x2000U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT253_SHIFT (13U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT253(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT253_SHIFT)) & OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT253_MASK)

#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT254_MASK (0x4000U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT254_SHIFT (14U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT254(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT254_SHIFT)) & OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT254_MASK)

#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT255_MASK (0x8000U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT255_SHIFT (15U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT255(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT255_SHIFT)) & OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT255_MASK)

#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT256_MASK (0x10000U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT256_SHIFT (16U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT256(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT256_SHIFT)) & OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT256_MASK)

#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT257_MASK (0x20000U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT257_SHIFT (17U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT257(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT257_SHIFT)) & OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT257_MASK)

#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT258_MASK (0x40000U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT258_SHIFT (18U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT258(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT258_SHIFT)) & OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT258_MASK)

#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT259_MASK (0x80000U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT259_SHIFT (19U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT259(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT259_SHIFT)) & OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT259_MASK)

#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT260_MASK (0x100000U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT260_SHIFT (20U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT260(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT260_SHIFT)) & OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT260_MASK)

#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT261_MASK (0x200000U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT261_SHIFT (21U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT261(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT261_SHIFT)) & OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT261_MASK)

#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT262_MASK (0x400000U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT262_SHIFT (22U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT262(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT262_SHIFT)) & OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT262_MASK)

#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT263_MASK (0x800000U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT263_SHIFT (23U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT263(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT263_SHIFT)) & OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT263_MASK)

#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT264_MASK (0x1000000U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT264_SHIFT (24U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT264(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT264_SHIFT)) & OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT264_MASK)

#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT265_MASK (0x2000000U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT265_SHIFT (25U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT265(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT265_SHIFT)) & OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT265_MASK)

#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT266_MASK (0x4000000U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT266_SHIFT (26U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT266(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT266_SHIFT)) & OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT266_MASK)

#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT267_MASK (0x8000000U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT267_SHIFT (27U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT267(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT267_SHIFT)) & OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT267_MASK)

#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT268_MASK (0x10000000U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT268_SHIFT (28U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT268(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT268_SHIFT)) & OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT268_MASK)

#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT269_MASK (0x20000000U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT269_SHIFT (29U)
#define OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT269(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT269_SHIFT)) & OCOTP_OTP_LOCK_STICKY_8_LOCK_STICKY_BIT269_MASK)
/*! @} */

/*! @name OTP_LOCK_STICKY_9 - OTP Controller Lock Sticky Register9 */
/*! @{ */

#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT270_MASK (0x1U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT270_SHIFT (0U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT270(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT270_SHIFT)) & OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT270_MASK)

#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT271_MASK (0x2U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT271_SHIFT (1U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT271(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT271_SHIFT)) & OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT271_MASK)

#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT272_MASK (0x4U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT272_SHIFT (2U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT272(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT272_SHIFT)) & OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT272_MASK)

#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT273_MASK (0x8U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT273_SHIFT (3U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT273(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT273_SHIFT)) & OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT273_MASK)

#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT274_MASK (0x10U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT274_SHIFT (4U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT274(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT274_SHIFT)) & OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT274_MASK)

#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT275_MASK (0x20U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT275_SHIFT (5U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT275(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT275_SHIFT)) & OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT275_MASK)

#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT276_MASK (0x40U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT276_SHIFT (6U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT276(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT276_SHIFT)) & OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT276_MASK)

#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT277_MASK (0x80U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT277_SHIFT (7U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT277(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT277_SHIFT)) & OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT277_MASK)

#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT278_MASK (0x100U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT278_SHIFT (8U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT278(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT278_SHIFT)) & OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT278_MASK)

#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT279_MASK (0x200U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT279_SHIFT (9U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT279(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT279_SHIFT)) & OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT279_MASK)

#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT280_MASK (0x400U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT280_SHIFT (10U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT280(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT280_SHIFT)) & OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT280_MASK)

#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT281_MASK (0x800U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT281_SHIFT (11U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT281(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT281_SHIFT)) & OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT281_MASK)

#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT282_MASK (0x1000U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT282_SHIFT (12U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT282(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT282_SHIFT)) & OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT282_MASK)

#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT283_MASK (0x2000U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT283_SHIFT (13U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT283(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT283_SHIFT)) & OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT283_MASK)

#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT284_MASK (0x4000U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT284_SHIFT (14U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT284(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT284_SHIFT)) & OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT284_MASK)

#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT285_MASK (0x8000U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT285_SHIFT (15U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT285(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT285_SHIFT)) & OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT285_MASK)

#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT286_MASK (0x10000U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT286_SHIFT (16U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT286(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT286_SHIFT)) & OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT286_MASK)

#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT287_MASK (0x20000U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT287_SHIFT (17U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT287(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT287_SHIFT)) & OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT287_MASK)

#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT288_MASK (0x40000U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT288_SHIFT (18U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT288(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT288_SHIFT)) & OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT288_MASK)

#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT289_MASK (0x80000U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT289_SHIFT (19U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT289(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT289_SHIFT)) & OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT289_MASK)

#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT290_MASK (0x100000U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT290_SHIFT (20U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT290(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT290_SHIFT)) & OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT290_MASK)

#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT291_MASK (0x200000U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT291_SHIFT (21U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT291(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT291_SHIFT)) & OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT291_MASK)

#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT292_MASK (0x400000U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT292_SHIFT (22U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT292(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT292_SHIFT)) & OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT292_MASK)

#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT293_MASK (0x800000U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT293_SHIFT (23U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT293(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT293_SHIFT)) & OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT293_MASK)

#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT294_MASK (0x1000000U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT294_SHIFT (24U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT294(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT294_SHIFT)) & OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT294_MASK)

#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT295_MASK (0x2000000U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT295_SHIFT (25U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT295(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT295_SHIFT)) & OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT295_MASK)

#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT296_MASK (0x4000000U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT296_SHIFT (26U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT296(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT296_SHIFT)) & OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT296_MASK)

#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT297_MASK (0x8000000U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT297_SHIFT (27U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT297(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT297_SHIFT)) & OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT297_MASK)

#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT298_MASK (0x10000000U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT298_SHIFT (28U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT298(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT298_SHIFT)) & OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT298_MASK)

#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT299_MASK (0x20000000U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT299_SHIFT (29U)
#define OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT299(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT299_SHIFT)) & OCOTP_OTP_LOCK_STICKY_9_LOCK_STICKY_BIT299_MASK)
/*! @} */

/*! @name OTP_LOCK_STICKY_10 - OTP Controller Lock Sticky Register10 */
/*! @{ */

#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT300_MASK (0x1U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT300_SHIFT (0U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT300(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT300_SHIFT)) & OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT300_MASK)

#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT301_MASK (0x2U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT301_SHIFT (1U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT301(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT301_SHIFT)) & OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT301_MASK)

#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT302_MASK (0x4U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT302_SHIFT (2U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT302(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT302_SHIFT)) & OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT302_MASK)

#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT303_MASK (0x8U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT303_SHIFT (3U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT303(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT303_SHIFT)) & OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT303_MASK)

#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT304_MASK (0x10U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT304_SHIFT (4U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT304(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT304_SHIFT)) & OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT304_MASK)

#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT305_MASK (0x20U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT305_SHIFT (5U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT305(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT305_SHIFT)) & OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT305_MASK)

#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT306_MASK (0x40U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT306_SHIFT (6U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT306(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT306_SHIFT)) & OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT306_MASK)

#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT307_MASK (0x80U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT307_SHIFT (7U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT307(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT307_SHIFT)) & OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT307_MASK)

#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT308_MASK (0x100U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT308_SHIFT (8U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT308(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT308_SHIFT)) & OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT308_MASK)

#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT309_MASK (0x200U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT309_SHIFT (9U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT309(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT309_SHIFT)) & OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT309_MASK)

#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT310_MASK (0x400U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT310_SHIFT (10U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT310(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT310_SHIFT)) & OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT310_MASK)

#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT311_MASK (0x800U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT311_SHIFT (11U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT311(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT311_SHIFT)) & OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT311_MASK)

#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT312_MASK (0x1000U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT312_SHIFT (12U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT312(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT312_SHIFT)) & OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT312_MASK)

#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT313_MASK (0x2000U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT313_SHIFT (13U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT313(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT313_SHIFT)) & OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT313_MASK)

#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT314_MASK (0x4000U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT314_SHIFT (14U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT314(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT314_SHIFT)) & OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT314_MASK)

#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT315_MASK (0x8000U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT315_SHIFT (15U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT315(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT315_SHIFT)) & OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT315_MASK)

#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT316_MASK (0x10000U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT316_SHIFT (16U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT316(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT316_SHIFT)) & OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT316_MASK)

#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT317_MASK (0x20000U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT317_SHIFT (17U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT317(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT317_SHIFT)) & OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT317_MASK)

#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT318_MASK (0x40000U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT318_SHIFT (18U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT318(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT318_SHIFT)) & OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT318_MASK)

#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT319_MASK (0x80000U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT319_SHIFT (19U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT319(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT319_SHIFT)) & OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT319_MASK)

#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT320_MASK (0x100000U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT320_SHIFT (20U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT320(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT320_SHIFT)) & OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT320_MASK)

#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT321_MASK (0x200000U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT321_SHIFT (21U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT321(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT321_SHIFT)) & OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT321_MASK)

#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT322_MASK (0x400000U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT322_SHIFT (22U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT322(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT322_SHIFT)) & OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT322_MASK)

#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT323_MASK (0x800000U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT323_SHIFT (23U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT323(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT323_SHIFT)) & OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT323_MASK)

#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT324_MASK (0x1000000U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT324_SHIFT (24U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT324(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT324_SHIFT)) & OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT324_MASK)

#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT325_MASK (0x2000000U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT325_SHIFT (25U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT325(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT325_SHIFT)) & OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT325_MASK)

#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT326_MASK (0x4000000U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT326_SHIFT (26U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT326(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT326_SHIFT)) & OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT326_MASK)

#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT327_MASK (0x8000000U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT327_SHIFT (27U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT327(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT327_SHIFT)) & OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT327_MASK)

#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT328_MASK (0x10000000U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT328_SHIFT (28U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT328(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT328_SHIFT)) & OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT328_MASK)

#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT329_MASK (0x20000000U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT329_SHIFT (29U)
#define OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT329(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT329_SHIFT)) & OCOTP_OTP_LOCK_STICKY_10_LOCK_STICKY_BIT329_MASK)
/*! @} */

/*! @name OTP_LOCK_STICKY_11 - OTP Controller Lock Sticky Register11 */
/*! @{ */

#define OCOTP_OTP_LOCK_STICKY_11_LOCK_STICKY_BIT330_MASK (0x1U)
#define OCOTP_OTP_LOCK_STICKY_11_LOCK_STICKY_BIT330_SHIFT (0U)
#define OCOTP_OTP_LOCK_STICKY_11_LOCK_STICKY_BIT330(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_11_LOCK_STICKY_BIT330_SHIFT)) & OCOTP_OTP_LOCK_STICKY_11_LOCK_STICKY_BIT330_MASK)

#define OCOTP_OTP_LOCK_STICKY_11_LOCK_STICKY_BIT331_MASK (0x2U)
#define OCOTP_OTP_LOCK_STICKY_11_LOCK_STICKY_BIT331_SHIFT (1U)
#define OCOTP_OTP_LOCK_STICKY_11_LOCK_STICKY_BIT331(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_11_LOCK_STICKY_BIT331_SHIFT)) & OCOTP_OTP_LOCK_STICKY_11_LOCK_STICKY_BIT331_MASK)

#define OCOTP_OTP_LOCK_STICKY_11_LOCK_STICKY_BIT332_MASK (0x4U)
#define OCOTP_OTP_LOCK_STICKY_11_LOCK_STICKY_BIT332_SHIFT (2U)
#define OCOTP_OTP_LOCK_STICKY_11_LOCK_STICKY_BIT332(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_11_LOCK_STICKY_BIT332_SHIFT)) & OCOTP_OTP_LOCK_STICKY_11_LOCK_STICKY_BIT332_MASK)

#define OCOTP_OTP_LOCK_STICKY_11_LOCK_STICKY_BIT333_MASK (0x8U)
#define OCOTP_OTP_LOCK_STICKY_11_LOCK_STICKY_BIT333_SHIFT (3U)
#define OCOTP_OTP_LOCK_STICKY_11_LOCK_STICKY_BIT333(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_11_LOCK_STICKY_BIT333_SHIFT)) & OCOTP_OTP_LOCK_STICKY_11_LOCK_STICKY_BIT333_MASK)

#define OCOTP_OTP_LOCK_STICKY_11_LOCK_STICKY_BIT334_MASK (0x10U)
#define OCOTP_OTP_LOCK_STICKY_11_LOCK_STICKY_BIT334_SHIFT (4U)
#define OCOTP_OTP_LOCK_STICKY_11_LOCK_STICKY_BIT334(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_LOCK_STICKY_11_LOCK_STICKY_BIT334_SHIFT)) & OCOTP_OTP_LOCK_STICKY_11_LOCK_STICKY_BIT334_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group OCOTP_Register_Masks */


/*!
 * @}
 */ /* end of group OCOTP_Peripheral_Access_Layer */


/*
** End of section using anonymous unions
*/

#if defined(__ARMCC_VERSION)
  #if (__ARMCC_VERSION >= 6010050)
    #pragma clang diagnostic pop
  #else
    #pragma pop
  #endif
#elif defined(__GNUC__)
  /* leave anonymous unions enabled */
#elif defined(__IAR_SYSTEMS_ICC__)
  #pragma language=default
#else
  #error Not supported compiler type
#endif

/*!
 * @}
 */ /* end of group Peripheral_access_layer */


#endif  /* OCOTP_H_ */

