/*
 * Copyright 2024 NXP
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

/***********************************************************************************************************************
 * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file
 * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.
 **********************************************************************************************************************/
/*
 * How to set up clock using clock driver functions:
 *
 * 1. Setup clock sources.
 *
 * 2. Set up all selectors to provide selected clocks.
 *
 * 3. Set up all dividers.
 */

/* clang-format off */
/* TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
!!GlobalInfo
product: Clocks v13.0
processor: RW612
package_id: RW612ETA2I
mcu_data: ksdk2_0
processor_version: 15.0.0
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS **********/
/* clang-format on */

#include "fsl_power.h"
#include "fsl_clock.h"
#include "clock_config.h"

/*******************************************************************************
 * Definitions
 ******************************************************************************/

/*******************************************************************************
 * Variables
 ******************************************************************************/

/*******************************************************************************
 ************************ BOARD_InitBootClocks function ************************
 ******************************************************************************/
void BOARD_InitBootClocks(void)
{
    BOARD_BootClockRUN();
}

/*******************************************************************************
 ********************** Configuration BOARD_BootClockRUN ***********************
 ******************************************************************************/
/* clang-format off */
/* TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
!!Configuration
name: BOARD_BootClockRUN
called_from_default_init: true
outputs:
- {id: audio_pll_clk.outFreq, value: 4246732800/345600007 MHz}
- {id: aux0_pll_clk.outFreq, value: 260 MHz}
- {id: avpll_ch1_clkout.outFreq, value: 4246732800/345600007 MHz}
- {id: avpll_ch2_clkout.outFreq, value: 1415577600/22118401 MHz}
- {id: cau_slp_clk.outFreq, value: 4 MHz}
- {id: clk_32k.outFreq, value: 32 kHz}
- {id: clk_pmu_sys.outFreq, value: 52 MHz}
- {id: els_128m_clk.outFreq, value: 128 MHz}
- {id: els_256m_clk.outFreq, value: 256 MHz}
- {id: els_64m_clk.outFreq, value: 64 MHz}
- {id: ffro_clk_div4.outFreq, value: 640/53 MHz}
- {id: hclk.outFreq, value: 260 MHz}
- {id: lposc_clk_i.outFreq, value: 1 MHz}
- {id: main_clk.outFreq, value: 260 MHz}
- {id: main_pll_clk.outFreq, value: 260 MHz}
- {id: otp_fuse_32m_clk.outFreq, value: 32 MHz}
- {id: refclk_phy.outFreq, value: 40 MHz}
- {id: sfro_clk_i.outFreq, value: 16 MHz}
- {id: systick_fclk.outFreq, value: 260 MHz}
- {id: t3pll_mci_256m.outFreq, value: 256 MHz}
- {id: t3pll_mci_48_60m_irc.outFreq, value: 2560/53 MHz}
- {id: tcpu_mci_clk.outFreq, value: 260 MHz}
- {id: tddr_mci_flexspi_clk.outFreq, value: 320 MHz}
settings:
- {id: CLKCTL0.MAINCLKSELB.sel, value: CLKCTL0.MAINPLLCLKDIV}
- {id: CLKCTL0.MAINPLLCLKDIV.scale, value: '1', locked: true}
- {id: CLKCTL0.PMUFCLKDIV.scale, value: '5', locked: true}
- {id: CLKCTL0.SYSCPUAHBCLKDIV.scale, value: '1', locked: true}
- {id: CLKCTL0.SYSTICKFCLKSEL.sel, value: CLKCTL0.SYSTICKFCLKDIV}
- {id: CLKCTL0.WDT0FCLKSEL.sel, value: NO_CLOCK}
- {id: CLKCTL1.FRGPLLCLKDIV.scale, value: '13', locked: true}
- {id: CLKCTL1.OSEVENTFCLKSEL.sel, value: NO_CLOCK}
- {id: REFCLK_SYS_Config, value: Disabled}
- {id: SYSCTL2.CH1_M.scale, value: '2621440', locked: true}
- {id: SYSCTL2.CH1_OFFSET_DIV.scale, value: '345600007', locked: true}
- {id: SYSCTL2.CH2_M.scale, value: '2621440', locked: true}
- {id: SYSCTL2.CH2_OFFSET_DIV.scale, value: '66355203', locked: true}
- {id: SYSCTL2.T3_FBDIV.scale, value: '64', locked: true}
- {id: SYSCTL2.T3_REFDIV.scale, value: '1', locked: true}
- {id: T3PLL_MCI_213P3M_Config, value: Disabled}
- {id: T3PLL_MCI_FLEXSPI_Config, value: Disabled}
- {id: TCPU_MCI_FLEXSPI_CLK_Config, value: Disabled}
- {id: TDDR_MCI_ENET_CLK_Config, value: Disabled}
sources:
- {id: CAU.XTAL_OSC.outFreq, value: 40 MHz, enabled: true}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS **********/
/* clang-format on */

/*******************************************************************************
 * Variables for BOARD_BootClockRUN configuration
 ******************************************************************************/
const clock_avpll_config_t avpllConfig_BOARD_BootClockRUN =
    {
        .ch1Freq = kCLOCK_AvPllChFreq12p288m,     /* AVPLL channel frequency 12.288 MHz */
        .ch2Freq = kCLOCK_AvPllChFreq64m,         /* AVPLL channel frequency 64 MHz */
        .enableCali = true,                       /* AVPLL calibration is enabled */
    };
/*******************************************************************************
 * Code for BOARD_BootClockRUN configuration
 ******************************************************************************/
void BOARD_BootClockRUN(void)
{
    /* Disable GDET and VSensors */
    POWER_DisableGDetVSensors();
    /* Enable CAU sleep clock for PMU */
    if ((PMU->CAU_SLP_CTRL & PMU_CAU_SLP_CTRL_SOC_SLP_RDY_MASK) == 0U)
    {
        /* Enable the CAU sleep clock. */
        CLOCK_EnableClock(kCLOCK_RefClkCauSlp);
    }
    if ((SYSCTL2->SOURCE_CLK_GATE & SYSCTL2_SOURCE_CLK_GATE_REFCLK_SYS_CG_MASK) != 0U)
    {
        /* Enable the REFCLK_SYS clock. */
        CLOCK_EnableClock(kCLOCK_RefClkSys);
    }
    /* Initialize T3 PLL and enable outputs that are not clock gated. */
    CLOCK_InitT3RefClk(kCLOCK_T3MciIrc48m);
    /* Enable FFRO - T3 PLL 48/60 MHz IRC clock output */
    CLOCK_EnableClock(kCLOCK_T3PllMciIrcClk);
    /* Enable T3 PLL 256 MHz clock output */
    CLOCK_EnableClock(kCLOCK_T3PllMci256mClk);
    BOARD_ClockPreConfig();
    /* Set core clock to safe system oscillator clock for initialization of other sources. */
    CLOCK_AttachClk(kSYSOSC_to_MAIN_CLK);
    CLOCK_SetClkDiv(kCLOCK_DivSysCpuAhbClk, 1);
    /* Initialize TCPU PLL and enable outputs that are not clock gated. */
    CLOCK_InitTcpuRefClk(3120000000UL, kCLOCK_TcpuFlexspiDiv10);
    /* Enable TCPU PLL MCI clock output */
    CLOCK_EnableClock(kCLOCK_TcpuMciClk);
    /* Initialize TDDR PLL and enable outputs that are not clock gated. */
    CLOCK_InitTddrRefClk(kCLOCK_TddrFlexspiDiv10);
    /* Enable TDDR PLL FlexSPI clock output */
    CLOCK_EnableClock(kCLOCK_TddrMciFlexspiClk);
    /* Initialize AVPLL and enable both channels. */
    CLOCK_InitAvPll(&avpllConfig_BOARD_BootClockRUN);
    /* Set up clock selectors - Attach clocks to the peripheries */
    CLOCK_AttachClk(kRC32K_to_CLK32K);                 /* Switch CLK32K to RC32K */
    /*!< Please note SYSTICK_CLK source is used only if the SysTick SYST_CSR register CLKSOURCE bit is set to 0. */
    CLOCK_AttachClk(kSYSTICK_DIV_to_SYSTICK_CLK);                 /* Switch SYSTICK_CLK to SYSTICK_DIV */
    /* Set up dividers */
    CLOCK_SetClkDiv(kCLOCK_DivAudioPllClk, 1U);         /* Set .AUDIOPLLCLKDIV divider to value 1 */
    CLOCK_SetClkDiv(kCLOCK_DivPllFrgClk, 13U);         /* Set .FRGPLLCLKDIV divider to value 13 */
    CLOCK_SetClkDiv(kCLOCK_DivMainPllClk, 1U);         /* Set .MAINPLLCLKDIV divider to value 1 */
    CLOCK_SetClkDiv(kCLOCK_DivAux0PllClk, 1U);         /* Set .AUX0PLLCLKDIV divider to value 1 */
    CLOCK_SetClkDiv(kCLOCK_DivSystickClk, 1U);         /* Set .SYSTICKFCLKDIV divider to value 1 */
    CLOCK_SetClkDiv(kCLOCK_DivPmuFclk, 5U);         /* Set .PMUFCLKDIV divider to value 5 */
    /* Select the main clock source for the main system clock (MAINCLKSELA and MAINCLKSELB). */
    CLOCK_AttachClk(kMAIN_PLL_to_MAIN_CLK);
    BOARD_ClockPostConfig();
    /*!< Set SystemCoreClock variable. */
    SystemCoreClock = BOARD_BOOTCLOCKRUN_HCLK;
}

/*******************************************************************************
 ********************** Configuration BOARD_BootClockLPR ***********************
 ******************************************************************************/
/* clang-format off */
/* TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
!!Configuration
name: BOARD_BootClockLPR
outputs:
- {id: aux0_pll_clk.outFreq, value: 260 MHz}
- {id: clk_32k.outFreq, value: 32 kHz}
- {id: clk_pmu_sys.outFreq, value: 52 MHz}
- {id: els_128m_clk.outFreq, value: 128 MHz}
- {id: els_256m_clk.outFreq, value: 256 MHz}
- {id: els_64m_clk.outFreq, value: 64 MHz}
- {id: hclk.outFreq, value: 260 MHz}
- {id: main_clk.outFreq, value: 260 MHz}
- {id: main_pll_clk.outFreq, value: 260 MHz}
- {id: otp_fuse_32m_clk.outFreq, value: 32 MHz}
- {id: refclk_phy.outFreq, value: 40 MHz}
- {id: refclk_sys.outFreq, value: 40 MHz}
- {id: sfro_clk_i.outFreq, value: 16 MHz}
- {id: systick_fclk.outFreq, value: 260 MHz}
- {id: t3pll_mci_256m.outFreq, value: 256 MHz}
- {id: tcpu_mci_clk.outFreq, value: 260 MHz}
settings:
- {id: AVPLL_Init_Config, value: Disabled}
- {id: CAU_SLP_CLK_Config, value: Disabled}
- {id: CLKCTL0.MAINCLKSELB.sel, value: CLKCTL0.MAINPLLCLKDIV}
- {id: CLKCTL0.MAINPLLCLKDIV.scale, value: '1', locked: true}
- {id: CLKCTL0.SYSOSCBYPASS_SEL.sel, value: NO_CLOCK}
- {id: CLKCTL0.SYSTICKFCLKSEL.sel, value: CLKCTL0.SYSTICKFCLKDIV}
- {id: CLKCTL1.CLKOUTSEL1.sel, value: CLKCTL1.CLKOUTSEL0}
- {id: CLKCTL1.CLKOUTSEL2.sel, value: CLKCTL1.CLKOUTSEL1}
- {id: CLKCTL1.FRGPLLCLKDIV.scale, value: '13', locked: true}
- {id: SYSCTL2.T3_FBDIV.scale, value: '64'}
- {id: SYSCTL2.TCPU_FBDIV.scale, value: '78', locked: true}
- {id: SYSCTL2.TCPU_MCI_FLEXSPI_CLK_DIV.scale, value: '10', locked: true}
- {id: SYSCTL2.TCPU_REFDIV.scale, value: '1', locked: true}
- {id: T3PLL_MCI_213P3M_Config, value: Disabled}
- {id: T3PLL_MCI_48_60M_IRC_Config, value: Disabled}
- {id: T3PLL_MCI_FLEXSPI_Config, value: Disabled}
- {id: TCPU_MCI_FLEXSPI_CLK_Config, value: Disabled}
- {id: TDDR_MCI_ENET_CLK_Config, value: Disabled}
- {id: TDDR_MCI_FLEXSPI_CLK_Config, value: Disabled}
- {id: TDDR_PLL_Init_Config, value: Disabled}
sources:
- {id: CAU.XTAL_OSC.outFreq, value: 40 MHz, enabled: true}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS **********/
/* clang-format on */

/*******************************************************************************
 * Variables for BOARD_BootClockLPR configuration
 ******************************************************************************/
/*******************************************************************************
 * Code for BOARD_BootClockLPR configuration
 ******************************************************************************/
void BOARD_BootClockLPR(void)
{
    /* Disable GDET and VSensors */
    POWER_DisableGDetVSensors();
    /* Enable CAU sleep clock for PMU */
    if ((PMU->CAU_SLP_CTRL & PMU_CAU_SLP_CTRL_SOC_SLP_RDY_MASK) == 0U)
    {
        /* Enable the CAU sleep clock. */
        CLOCK_EnableClock(kCLOCK_RefClkCauSlp);
    }
    if ((SYSCTL2->SOURCE_CLK_GATE & SYSCTL2_SOURCE_CLK_GATE_REFCLK_SYS_CG_MASK) != 0U)
    {
        /* Enable the REFCLK_SYS clock. */
        CLOCK_EnableClock(kCLOCK_RefClkSys);
    }
    /* Initialize T3 PLL and enable outputs that are not clock gated. */
    CLOCK_InitT3RefClk(kCLOCK_T3MciIrc48m);
    /* Enable T3 PLL 256 MHz clock output */
    CLOCK_EnableClock(kCLOCK_T3PllMci256mClk);
    BOARD_ClockPreConfig();
    /* Set core clock to safe system oscillator clock for initialization of other sources. */
    CLOCK_AttachClk(kSYSOSC_to_MAIN_CLK);
    CLOCK_SetClkDiv(kCLOCK_DivSysCpuAhbClk, 1);
    /* Initialize TCPU PLL and enable outputs that are not clock gated. */
    CLOCK_InitTcpuRefClk(3120000000UL, kCLOCK_TcpuFlexspiDiv10);
    /* Enable TCPU PLL MCI clock output */
    CLOCK_EnableClock(kCLOCK_TcpuMciClk);
    /* Set up clock selectors - Attach clocks to the peripheries */
    CLOCK_AttachClk(kRC32K_to_CLK32K);                 /* Switch CLK32K to RC32K */
    /*!< Please note SYSTICK_CLK source is used only if the SysTick SYST_CSR register CLKSOURCE bit is set to 0. */
    CLOCK_AttachClk(kSYSTICK_DIV_to_SYSTICK_CLK);                 /* Switch SYSTICK_CLK to SYSTICK_DIV */
    /* Set up dividers */
    CLOCK_SetClkDiv(kCLOCK_DivPllFrgClk, 13U);         /* Set .FRGPLLCLKDIV divider to value 13 */
    CLOCK_SetClkDiv(kCLOCK_DivMainPllClk, 1U);         /* Set .MAINPLLCLKDIV divider to value 1 */
    CLOCK_SetClkDiv(kCLOCK_DivAux0PllClk, 1U);         /* Set .AUX0PLLCLKDIV divider to value 1 */
    CLOCK_SetClkDiv(kCLOCK_DivSystickClk, 1U);         /* Set .SYSTICKFCLKDIV divider to value 1 */
    CLOCK_SetClkDiv(kCLOCK_DivPmuFclk, 5U);         /* Set .PMUFCLKDIV divider to value 5 */
    /* Select the main clock source for the main system clock (MAINCLKSELA and MAINCLKSELB). */
    CLOCK_AttachClk(kMAIN_PLL_to_MAIN_CLK);
    /* Deinitialization of the AVPLL. */
    CLOCK_DeinitAvPll();
    /* Deinitialize TDDR PLL. */
    CLOCK_DeinitTddrRefClk();
    BOARD_ClockPostConfig();
    /*!< Set SystemCoreClock variable. */
    SystemCoreClock = BOARD_BOOTCLOCKLPR_HCLK;
}

