# _build_config.py.in is converted into _build_config.py during the meson build process.

from __future__ import annotations


def build_config() -> dict[str, str]:
    """
    Return a dictionary containing build configuration settings.

    All dictionary keys and values are strings, for example ``False`` is
    returned as ``"False"``.

        .. versionadded:: 1.1.0
    """
    return dict(
        # Python settings
        python_version="3.14",
        python_install_dir=r"D:/M/msys64/mingw64/lib/python3.14/site-packages/",
        python_path=r"D:/M/msys64/mingw64/bin/python.exe",

        # Package versions
        contourpy_version="1.3.3",
        meson_version="1.10.1",
        mesonpy_version="0.18.0",
        pybind11_version="3.0.1",

        # Misc meson settings
        meson_backend="ninja",
        build_dir=r"D:/W/B/src/python-build-MINGW64/.mesonpy-6uwdwepv/lib/contourpy/util",
        source_dir=r"D:/W/B/src/python-build-MINGW64/lib/contourpy/util",
        cross_build="False",

        # Build options
        build_options=r"-Dbuildtype=release -Db_ndebug=if-release -Db_vscrt=md --native-file=D:/W/B/src/python-build-MINGW64/.mesonpy-6uwdwepv/meson-python-native-file.ini",
        buildtype="release",
        cpp_std="c++17",
        debug="False",
        optimization="3",
        vsenv="False",
        b_ndebug="if-release",
        b_vscrt="from_buildtype",

        # C++ compiler
        compiler_name="gcc",
        compiler_version="15.2.0",
        linker_id="ld.bfd",
        compile_command="g++",

        # Host machine
        host_cpu="x86_64",
        host_cpu_family="x86_64",
        host_cpu_endian="little",
        host_cpu_system="windows",

        # Build machine, same as host machine if not a cross_build
        build_cpu="x86_64",
        build_cpu_family="x86_64",
        build_cpu_endian="little",
        build_cpu_system="windows",
    )
