/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.tools.internal.generator.codegen;

import com.ibm.db2.cmx.runtime.internal.qoc.QocJdtResultSetMetaDataForJavaTypeImpl;
import com.ibm.db2.cmx.runtime.internal.qoc.TypeMapper;
import com.ibm.db2.cmx.tools.internal.generator.jdt.TypeHelper;
import com.ibm.db2.cmx.tools.internal.generator.metadata.BeanInformation;
import com.ibm.db2.cmx.tools.internal.generator.metadata.BeanPropertyInformation;
import com.ibm.db2.cmx.tools.internal.generator.metadata.ClassInfo;
import com.ibm.db2.cmx.tools.internal.generator.metadata.TypeInfo;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;

public class QOCMetaDataGenerator {
    private StringBuilder stringBuffer_;
    private ClassInfo classInfo_;

    public QOCMetaDataGenerator(ClassInfo classInfo, StringBuilder stringBuilder) {
        this.stringBuffer_ = stringBuilder;
        this.classInfo_ = classInfo;
    }

    public void generate() throws SQLException {
        Map<String, TypeInfo> map = this.classInfo_.getVtiMetadataMap();
        Map<String, BeanInformation> map2 = this.classInfo_.getQocBeanInfoMap();
        Set<String> set = map.keySet();
        for (String string : set) {
            this.generateMetaData(string, map.get(string), map2.get(string));
        }
    }

    private void generateMetaData(String string, TypeInfo typeInfo, BeanInformation beanInformation) throws SQLException {
        this.generateClassHeader(string);
        this.generateFields(typeInfo, beanInformation);
        this.generateConstructor(string);
        this.generateReturnColumValueMethod(typeInfo, beanInformation);
        this.stringBuffer_.append("  }\n");
    }

    private void generateReturnColumValueMethod(TypeInfo typeInfo, BeanInformation beanInformation) {
        this.generateComments("    ");
        this.stringBuffer_.append("    public Object returnColumnValueForObject (Object object, int col) \n");
        this.stringBuffer_.append("    {\n");
        String string = TypeHelper.getTypeNameForGenerics(typeInfo);
        this.stringBuffer_.append("      " + string + " returnObject = (" + string + ") object;\n\n");
        if (beanInformation != null) {
            this.stringBuffer_.append("      if (object != null) {\n");
            this.stringBuffer_.append("        switch(col) { \n");
            this.stringBuffer_.append("        case 1 : \n          return returnObject;\n");
            Map<String, BeanPropertyInformation> map = beanInformation.getBeanPropertyMap();
            map = QocJdtResultSetMetaDataForJavaTypeImpl.getQocProperties(map);
            Set<String> set = map.keySet();
            String string2 = null;
            int n2 = 2;
            for (String string3 : set) {
                BeanPropertyInformation beanPropertyInformation = map.get(string3);
                if (beanPropertyInformation == null || beanPropertyInformation.isDerivedProperty()) continue;
                this.stringBuffer_.append("        case " + n2++ + ":\n");
                string2 = beanPropertyInformation.getReadMethod();
                if (string2 != null) {
                    this.stringBuffer_.append("          return returnObject." + string2 + " ();\n");
                    continue;
                }
                this.stringBuffer_.append("          return returnObject." + beanPropertyInformation.getField() + ";\n");
            }
            this.stringBuffer_.append("        }\n");
            this.stringBuffer_.append("      }\n");
        }
        this.stringBuffer_.append("      return returnObject;\n");
        this.stringBuffer_.append("    }\n");
    }

    private void generateConstructor(String string) {
        this.generateComments("    ");
        this.stringBuffer_.append("    public " + string + " () \n");
        this.stringBuffer_.append("    {\n");
        this.stringBuffer_.append("      super (sqlType_, columnName_);\n");
        this.stringBuffer_.append("    }\n\n");
    }

    private void generateFields(TypeInfo typeInfo, BeanInformation beanInformation) throws SQLException {
        if (typeInfo != null) {
            int n2;
            int n3 = 0;
            int[] nArray = null;
            String[] stringArray = null;
            if (beanInformation != null) {
                QocJdtResultSetMetaDataForJavaTypeImpl qocJdtResultSetMetaDataForJavaTypeImpl = new QocJdtResultSetMetaDataForJavaTypeImpl();
                qocJdtResultSetMetaDataForJavaTypeImpl.init(beanInformation);
                n3 = qocJdtResultSetMetaDataForJavaTypeImpl.getColumnCount();
                nArray = new int[n3];
                stringArray = new String[n3];
                for (int i10 = 0; i10 < n3; ++i10) {
                    stringArray[i10] = qocJdtResultSetMetaDataForJavaTypeImpl.getColumnName(i10 + 1);
                    nArray[i10] = qocJdtResultSetMetaDataForJavaTypeImpl.getColumnType(i10 + 1);
                }
            } else {
                n3 = 1;
                nArray = new int[n3];
                stringArray = new String[n3];
                int n4 = 0;
                stringArray[n4] = "THIS";
                nArray[n4] = TypeMapper.mapJavaToSqlType(typeInfo.getJavaType());
            }
            this.generateComments("    ");
            this.stringBuffer_.append("    private static int[] sqlType_ = {");
            for (n2 = 0; n2 < nArray.length; ++n2) {
                if (n2 != 0) {
                    this.stringBuffer_.append(", ");
                }
                this.stringBuffer_.append(TypeHelper.getJdbcSQLTypeString(nArray[n2]));
            }
            this.stringBuffer_.append("};\n");
            this.generateComments("    ");
            this.stringBuffer_.append("    private static String[] columnName_ = {");
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                if (n2 != 0) {
                    this.stringBuffer_.append(", ");
                }
                this.stringBuffer_.append("\"" + stringArray[n2] + "\"");
            }
            this.stringBuffer_.append("};\n");
        }
    }

    private TypeInfo getTypeInfo(Map<String, BeanPropertyInformation> map, String string) {
        BeanPropertyInformation beanPropertyInformation = map.get(string.toLowerCase());
        if (beanPropertyInformation != null) {
            return beanPropertyInformation.getPropertyTypeInfo();
        }
        return null;
    }

    private void generateClassHeader(String string) {
        this.generateComments("  ");
        this.stringBuffer_.append("  public static class " + string + " extends QOCBaseResultSetMetaData \n");
        this.stringBuffer_.append("  {\n\n");
    }

    private void generateComments(String string) {
        this.stringBuffer_.append(string + "/**\n");
        this.stringBuffer_.append(string + " * @generated\n");
        this.stringBuffer_.append(string + " */");
        this.stringBuffer_.append("\n");
    }
}

