/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.util.HashSet;
import java.util.Set;
import org.freeplane.view.swing.map.CombineOperation;
import org.freeplane.view.swing.map.StepFunction;

class CombinedFunction
implements StepFunction {
    private final StepFunction left;
    private final StepFunction right;
    private final CombineOperation op;
    private Set<Integer> samplePointsCache;
    private final int minX;
    private final int maxX;

    public CombinedFunction(StepFunction first, StepFunction second, CombineOperation op) {
        if (first == null || second == null || op == null) {
            throw new IllegalArgumentException();
        }
        this.op = op;
        if (op == CombineOperation.FALLBACK) {
            this.left = first;
            this.right = second;
        } else if (first.minX() <= second.minX()) {
            this.left = first;
            this.right = second;
        } else {
            this.left = second;
            this.right = first;
        }
        this.minX = Math.min(this.left.minX(), this.right.minX());
        this.maxX = Math.max(this.left.maxX(), this.right.maxX());
    }

    @Override
    public int evaluate(int x) {
        if (x < this.minX || x > this.maxX) {
            return Integer.MAX_VALUE;
        }
        if (this.op == CombineOperation.FALLBACK) {
            int mainVal = this.left.evaluate(x);
            if (mainVal != Integer.MAX_VALUE) {
                return mainVal;
            }
            if (x < this.right.minX()) {
                return this.right.evaluate(this.right.minX());
            }
            if (x > this.right.maxX()) {
                return this.right.evaluate(this.right.maxX());
            }
            int fbVal = this.right.evaluate(x);
            return fbVal;
        }
        if (x > this.left.maxX() && x < this.right.minX()) {
            int a = this.left.evaluate(this.left.maxX());
            int b = this.right.evaluate(this.right.minX());
            return this.op == CombineOperation.MIN ? Math.max(a, b) : Math.min(a, b);
        }
        int a = this.left.evaluate(x);
        int b = this.right.evaluate(x);
        if (a == Integer.MAX_VALUE) {
            return b;
        }
        if (b == Integer.MAX_VALUE) {
            return a;
        }
        return this.op == CombineOperation.MAX ? Math.max(a, b) : Math.min(a, b);
    }

    @Override
    public Set<Integer> samplePoints() {
        int y;
        if (this.samplePointsCache != null) {
            return this.samplePointsCache;
        }
        HashSet<Integer> pts = new HashSet<Integer>();
        for (Integer x : this.left.samplePoints()) {
            y = this.evaluate(x);
            if (y != this.left.evaluate(x) || y == this.evaluate(x - 1) && y == this.evaluate(x + 1)) continue;
            pts.add(x);
        }
        for (Integer x : this.right.samplePoints()) {
            y = this.evaluate(x);
            if (y != this.right.evaluate(x) || y == this.evaluate(x - 1) && y == this.evaluate(x + 1)) continue;
            pts.add(x);
        }
        this.samplePointsCache = pts;
        return this.samplePointsCache;
    }

    @Override
    public int minX() {
        return this.minX;
    }

    @Override
    public int maxX() {
        return this.maxX;
    }

    public String toString() {
        return this.explain();
    }
}

