// Generated by the gRPC C++ plugin.
// If you make any local change, they will be lost.
// source: tensorflow/core/protobuf/eager_service.proto
#ifndef GRPC_tensorflow_2fcore_2fprotobuf_2feager_5fservice_2eproto__INCLUDED
#define GRPC_tensorflow_2fcore_2fprotobuf_2feager_5fservice_2eproto__INCLUDED

#include "tensorflow/core/protobuf/eager_service.pb.h"

#include <functional>
#include <grpcpp/generic/async_generic_service.h>
#include <grpcpp/support/async_stream.h>
#include <grpcpp/support/async_unary_call.h>
#include <grpcpp/support/client_callback.h>
#include <grpcpp/client_context.h>
#include <grpcpp/completion_queue.h>
#include <grpcpp/support/message_allocator.h>
#include <grpcpp/support/method_handler.h>
#include <grpcpp/impl/proto_utils.h>
#include <grpcpp/impl/rpc_method.h>
#include <grpcpp/support/server_callback.h>
#include <grpcpp/impl/server_callback_handlers.h>
#include <grpcpp/server_context.h>
#include <grpcpp/impl/service_type.h>
#include <grpcpp/support/status.h>
#include <grpcpp/support/stub_options.h>
#include <grpcpp/support/sync_stream.h>

namespace tensorflow {
namespace eager {


namespace grpc {

// //////////////////////////////////////////////////////////////////////////////
//
// Eager Service defines a TensorFlow service that executes operations eagerly
// on a set of local devices, on behalf of a remote Eager executor.
//
// The service impl will keep track of the various clients and devices it has
// access to and allows the client to enqueue ops on any devices that it is able
// to access and schedule data transfers from/to any of the peers.
//
// A client can generate multiple contexts to be able to independently execute
// operations, but cannot share data between the two contexts.
//
// NOTE: Even though contexts generated by clients should be independent, the
// lower level tensorflow execution engine is not, so they might share some data
// (e.g. a Device's ResourceMgr).
//
// //////////////////////////////////////////////////////////////////////////////
class EagerService final {
 public:
  static constexpr char const* service_full_name() {
    return "tensorflow.eager.EagerService";
  }
  class StubInterface {
   public:
    virtual ~StubInterface() {}
    // This initializes the worker, informing it about the other workers in the
    // cluster and exchanging authentication tokens which will be used in all
    // other RPCs to detect whether the worker has restarted.
    virtual ::grpc::Status CreateContext(::grpc::ClientContext* context, const ::tensorflow::eager::CreateContextRequest& request, ::tensorflow::eager::CreateContextResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::tensorflow::eager::CreateContextResponse>> AsyncCreateContext(::grpc::ClientContext* context, const ::tensorflow::eager::CreateContextRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::tensorflow::eager::CreateContextResponse>>(AsyncCreateContextRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::tensorflow::eager::CreateContextResponse>> PrepareAsyncCreateContext(::grpc::ClientContext* context, const ::tensorflow::eager::CreateContextRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::tensorflow::eager::CreateContextResponse>>(PrepareAsyncCreateContextRaw(context, request, cq));
    }
    // [AUTOMATION]: Internal rpc option goes here.
    // This updates the eager context on an existing worker when updating the set
    // of servers in a distributed eager cluster.
    virtual ::grpc::Status UpdateContext(::grpc::ClientContext* context, const ::tensorflow::eager::UpdateContextRequest& request, ::tensorflow::eager::UpdateContextResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::tensorflow::eager::UpdateContextResponse>> AsyncUpdateContext(::grpc::ClientContext* context, const ::tensorflow::eager::UpdateContextRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::tensorflow::eager::UpdateContextResponse>>(AsyncUpdateContextRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::tensorflow::eager::UpdateContextResponse>> PrepareAsyncUpdateContext(::grpc::ClientContext* context, const ::tensorflow::eager::UpdateContextRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::tensorflow::eager::UpdateContextResponse>>(PrepareAsyncUpdateContextRaw(context, request, cq));
    }
    // [AUTOMATION]: Internal rpc option goes here.
    // This takes a list of Execute and DeleteTensorHandle operations and enqueues
    // (in async mode) or executes (in sync mode) them on the remote server.
    // All outputs of ops which were not explicitly deleted with
    // DeleteTensorHandle entries will be assumed to be alive and are usable by
    // future calls to Enqueue.
    virtual ::grpc::Status Enqueue(::grpc::ClientContext* context, const ::tensorflow::eager::EnqueueRequest& request, ::tensorflow::eager::EnqueueResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::tensorflow::eager::EnqueueResponse>> AsyncEnqueue(::grpc::ClientContext* context, const ::tensorflow::eager::EnqueueRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::tensorflow::eager::EnqueueResponse>>(AsyncEnqueueRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::tensorflow::eager::EnqueueResponse>> PrepareAsyncEnqueue(::grpc::ClientContext* context, const ::tensorflow::eager::EnqueueRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::tensorflow::eager::EnqueueResponse>>(PrepareAsyncEnqueueRaw(context, request, cq));
    }
    // [AUTOMATION]: Internal rpc option goes here.
    // A streaming version of Enqueue.
    // Current server implementation sends one response per received request.
    // The benefit for using a streaming version is that subsequent requests
    // can be sent without waiting for a response to the previous request. This
    // synchronization is required in the regular Enqueue call because gRPC does
    // not guarantee to preserve request order.
    std::unique_ptr< ::grpc::ClientReaderWriterInterface< ::tensorflow::eager::EnqueueRequest, ::tensorflow::eager::EnqueueResponse>> StreamingEnqueue(::grpc::ClientContext* context) {
      return std::unique_ptr< ::grpc::ClientReaderWriterInterface< ::tensorflow::eager::EnqueueRequest, ::tensorflow::eager::EnqueueResponse>>(StreamingEnqueueRaw(context));
    }
    std::unique_ptr< ::grpc::ClientAsyncReaderWriterInterface< ::tensorflow::eager::EnqueueRequest, ::tensorflow::eager::EnqueueResponse>> AsyncStreamingEnqueue(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq, void* tag) {
      return std::unique_ptr< ::grpc::ClientAsyncReaderWriterInterface< ::tensorflow::eager::EnqueueRequest, ::tensorflow::eager::EnqueueResponse>>(AsyncStreamingEnqueueRaw(context, cq, tag));
    }
    std::unique_ptr< ::grpc::ClientAsyncReaderWriterInterface< ::tensorflow::eager::EnqueueRequest, ::tensorflow::eager::EnqueueResponse>> PrepareAsyncStreamingEnqueue(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncReaderWriterInterface< ::tensorflow::eager::EnqueueRequest, ::tensorflow::eager::EnqueueResponse>>(PrepareAsyncStreamingEnqueueRaw(context, cq));
    }
    // [AUTOMATION]: Internal rpc option goes here.
    // Takes a set of op IDs and waits until those ops are done. Returns any error
    // in the stream so far.
    virtual ::grpc::Status WaitQueueDone(::grpc::ClientContext* context, const ::tensorflow::eager::WaitQueueDoneRequest& request, ::tensorflow::eager::WaitQueueDoneResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::tensorflow::eager::WaitQueueDoneResponse>> AsyncWaitQueueDone(::grpc::ClientContext* context, const ::tensorflow::eager::WaitQueueDoneRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::tensorflow::eager::WaitQueueDoneResponse>>(AsyncWaitQueueDoneRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::tensorflow::eager::WaitQueueDoneResponse>> PrepareAsyncWaitQueueDone(::grpc::ClientContext* context, const ::tensorflow::eager::WaitQueueDoneRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::tensorflow::eager::WaitQueueDoneResponse>>(PrepareAsyncWaitQueueDoneRaw(context, request, cq));
    }
    // [AUTOMATION]: Internal rpc option goes here.
    // This takes an Eager operation and executes it in async mode on the remote
    // server. Different from EnqueueRequest, ops/functions sent through this
    // type of requests are allowed to execute in parallel and no ordering is
    // preserved by RPC stream or executor.
    // This request type should only be used for executing component functions.
    // Ordering of component functions should be enforced by their corresponding
    // main functions. The runtime ensures the following invarients for component
    // functions (CFs) and their main functions (MFs):
    // (1) MF1 -> MF2 ==> CF1 -> CF2 ("->" indicates order of execution);
    // (2) MF1 || MF2 ==> CF1 || CF2 ("||" indicates possible parallel execution);
    // (3) For CF1 and CF2 that come from the same MF, CF1 || CF2
    // For executing ops/main functions, use Enqueue or StreamingEnqueue instead
    // for correct ordering.
    virtual ::grpc::Status RunComponentFunction(::grpc::ClientContext* context, const ::tensorflow::eager::RunComponentFunctionRequest& request, ::tensorflow::eager::RunComponentFunctionResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::tensorflow::eager::RunComponentFunctionResponse>> AsyncRunComponentFunction(::grpc::ClientContext* context, const ::tensorflow::eager::RunComponentFunctionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::tensorflow::eager::RunComponentFunctionResponse>>(AsyncRunComponentFunctionRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::tensorflow::eager::RunComponentFunctionResponse>> PrepareAsyncRunComponentFunction(::grpc::ClientContext* context, const ::tensorflow::eager::RunComponentFunctionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::tensorflow::eager::RunComponentFunctionResponse>>(PrepareAsyncRunComponentFunctionRaw(context, request, cq));
    }
    // [AUTOMATION]: Internal rpc option goes here.
    // Contexts are always created with a deadline and no RPCs within a deadline
    // will trigger a context garbage collection. KeepAlive calls can be used to
    // delay this. It can also be used to validate the existence of a context ID
    // on remote eager worker. If the context is on remote worker, return the same
    // ID and the current context view ID. This is useful for checking if the
    // remote worker (potentially with the same task name and hostname / port) is
    // replaced with a new process.
    virtual ::grpc::Status KeepAlive(::grpc::ClientContext* context, const ::tensorflow::eager::KeepAliveRequest& request, ::tensorflow::eager::KeepAliveResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::tensorflow::eager::KeepAliveResponse>> AsyncKeepAlive(::grpc::ClientContext* context, const ::tensorflow::eager::KeepAliveRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::tensorflow::eager::KeepAliveResponse>>(AsyncKeepAliveRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::tensorflow::eager::KeepAliveResponse>> PrepareAsyncKeepAlive(::grpc::ClientContext* context, const ::tensorflow::eager::KeepAliveRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::tensorflow::eager::KeepAliveResponse>>(PrepareAsyncKeepAliveRaw(context, request, cq));
    }
    // [AUTOMATION]: Internal rpc option goes here.
    // Closes the context. No calls to other methods using the existing context ID
    // are valid after this.
    virtual ::grpc::Status CloseContext(::grpc::ClientContext* context, const ::tensorflow::eager::CloseContextRequest& request, ::tensorflow::eager::CloseContextResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::tensorflow::eager::CloseContextResponse>> AsyncCloseContext(::grpc::ClientContext* context, const ::tensorflow::eager::CloseContextRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::tensorflow::eager::CloseContextResponse>>(AsyncCloseContextRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::tensorflow::eager::CloseContextResponse>> PrepareAsyncCloseContext(::grpc::ClientContext* context, const ::tensorflow::eager::CloseContextRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::tensorflow::eager::CloseContextResponse>>(PrepareAsyncCloseContextRaw(context, request, cq));
    }
    // [AUTOMATION]: Internal rpc option goes here.
    class async_interface {
     public:
      virtual ~async_interface() {}
      // This initializes the worker, informing it about the other workers in the
      // cluster and exchanging authentication tokens which will be used in all
      // other RPCs to detect whether the worker has restarted.
      virtual void CreateContext(::grpc::ClientContext* context, const ::tensorflow::eager::CreateContextRequest* request, ::tensorflow::eager::CreateContextResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void CreateContext(::grpc::ClientContext* context, const ::tensorflow::eager::CreateContextRequest* request, ::tensorflow::eager::CreateContextResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // [AUTOMATION]: Internal rpc option goes here.
      // This updates the eager context on an existing worker when updating the set
      // of servers in a distributed eager cluster.
      virtual void UpdateContext(::grpc::ClientContext* context, const ::tensorflow::eager::UpdateContextRequest* request, ::tensorflow::eager::UpdateContextResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void UpdateContext(::grpc::ClientContext* context, const ::tensorflow::eager::UpdateContextRequest* request, ::tensorflow::eager::UpdateContextResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // [AUTOMATION]: Internal rpc option goes here.
      // This takes a list of Execute and DeleteTensorHandle operations and enqueues
      // (in async mode) or executes (in sync mode) them on the remote server.
      // All outputs of ops which were not explicitly deleted with
      // DeleteTensorHandle entries will be assumed to be alive and are usable by
      // future calls to Enqueue.
      virtual void Enqueue(::grpc::ClientContext* context, const ::tensorflow::eager::EnqueueRequest* request, ::tensorflow::eager::EnqueueResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void Enqueue(::grpc::ClientContext* context, const ::tensorflow::eager::EnqueueRequest* request, ::tensorflow::eager::EnqueueResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // [AUTOMATION]: Internal rpc option goes here.
      // A streaming version of Enqueue.
      // Current server implementation sends one response per received request.
      // The benefit for using a streaming version is that subsequent requests
      // can be sent without waiting for a response to the previous request. This
      // synchronization is required in the regular Enqueue call because gRPC does
      // not guarantee to preserve request order.
      virtual void StreamingEnqueue(::grpc::ClientContext* context, ::grpc::ClientBidiReactor< ::tensorflow::eager::EnqueueRequest,::tensorflow::eager::EnqueueResponse>* reactor) = 0;
      // [AUTOMATION]: Internal rpc option goes here.
      // Takes a set of op IDs and waits until those ops are done. Returns any error
      // in the stream so far.
      virtual void WaitQueueDone(::grpc::ClientContext* context, const ::tensorflow::eager::WaitQueueDoneRequest* request, ::tensorflow::eager::WaitQueueDoneResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void WaitQueueDone(::grpc::ClientContext* context, const ::tensorflow::eager::WaitQueueDoneRequest* request, ::tensorflow::eager::WaitQueueDoneResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // [AUTOMATION]: Internal rpc option goes here.
      // This takes an Eager operation and executes it in async mode on the remote
      // server. Different from EnqueueRequest, ops/functions sent through this
      // type of requests are allowed to execute in parallel and no ordering is
      // preserved by RPC stream or executor.
      // This request type should only be used for executing component functions.
      // Ordering of component functions should be enforced by their corresponding
      // main functions. The runtime ensures the following invarients for component
      // functions (CFs) and their main functions (MFs):
      // (1) MF1 -> MF2 ==> CF1 -> CF2 ("->" indicates order of execution);
      // (2) MF1 || MF2 ==> CF1 || CF2 ("||" indicates possible parallel execution);
      // (3) For CF1 and CF2 that come from the same MF, CF1 || CF2
      // For executing ops/main functions, use Enqueue or StreamingEnqueue instead
      // for correct ordering.
      virtual void RunComponentFunction(::grpc::ClientContext* context, const ::tensorflow::eager::RunComponentFunctionRequest* request, ::tensorflow::eager::RunComponentFunctionResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void RunComponentFunction(::grpc::ClientContext* context, const ::tensorflow::eager::RunComponentFunctionRequest* request, ::tensorflow::eager::RunComponentFunctionResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // [AUTOMATION]: Internal rpc option goes here.
      // Contexts are always created with a deadline and no RPCs within a deadline
      // will trigger a context garbage collection. KeepAlive calls can be used to
      // delay this. It can also be used to validate the existence of a context ID
      // on remote eager worker. If the context is on remote worker, return the same
      // ID and the current context view ID. This is useful for checking if the
      // remote worker (potentially with the same task name and hostname / port) is
      // replaced with a new process.
      virtual void KeepAlive(::grpc::ClientContext* context, const ::tensorflow::eager::KeepAliveRequest* request, ::tensorflow::eager::KeepAliveResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void KeepAlive(::grpc::ClientContext* context, const ::tensorflow::eager::KeepAliveRequest* request, ::tensorflow::eager::KeepAliveResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // [AUTOMATION]: Internal rpc option goes here.
      // Closes the context. No calls to other methods using the existing context ID
      // are valid after this.
      virtual void CloseContext(::grpc::ClientContext* context, const ::tensorflow::eager::CloseContextRequest* request, ::tensorflow::eager::CloseContextResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void CloseContext(::grpc::ClientContext* context, const ::tensorflow::eager::CloseContextRequest* request, ::tensorflow::eager::CloseContextResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // [AUTOMATION]: Internal rpc option goes here.
    };
    typedef class async_interface experimental_async_interface;
    virtual class async_interface* async() { return nullptr; }
    class async_interface* experimental_async() { return async(); }
   private:
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::tensorflow::eager::CreateContextResponse>* AsyncCreateContextRaw(::grpc::ClientContext* context, const ::tensorflow::eager::CreateContextRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::tensorflow::eager::CreateContextResponse>* PrepareAsyncCreateContextRaw(::grpc::ClientContext* context, const ::tensorflow::eager::CreateContextRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::tensorflow::eager::UpdateContextResponse>* AsyncUpdateContextRaw(::grpc::ClientContext* context, const ::tensorflow::eager::UpdateContextRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::tensorflow::eager::UpdateContextResponse>* PrepareAsyncUpdateContextRaw(::grpc::ClientContext* context, const ::tensorflow::eager::UpdateContextRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::tensorflow::eager::EnqueueResponse>* AsyncEnqueueRaw(::grpc::ClientContext* context, const ::tensorflow::eager::EnqueueRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::tensorflow::eager::EnqueueResponse>* PrepareAsyncEnqueueRaw(::grpc::ClientContext* context, const ::tensorflow::eager::EnqueueRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientReaderWriterInterface< ::tensorflow::eager::EnqueueRequest, ::tensorflow::eager::EnqueueResponse>* StreamingEnqueueRaw(::grpc::ClientContext* context) = 0;
    virtual ::grpc::ClientAsyncReaderWriterInterface< ::tensorflow::eager::EnqueueRequest, ::tensorflow::eager::EnqueueResponse>* AsyncStreamingEnqueueRaw(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq, void* tag) = 0;
    virtual ::grpc::ClientAsyncReaderWriterInterface< ::tensorflow::eager::EnqueueRequest, ::tensorflow::eager::EnqueueResponse>* PrepareAsyncStreamingEnqueueRaw(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::tensorflow::eager::WaitQueueDoneResponse>* AsyncWaitQueueDoneRaw(::grpc::ClientContext* context, const ::tensorflow::eager::WaitQueueDoneRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::tensorflow::eager::WaitQueueDoneResponse>* PrepareAsyncWaitQueueDoneRaw(::grpc::ClientContext* context, const ::tensorflow::eager::WaitQueueDoneRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::tensorflow::eager::RunComponentFunctionResponse>* AsyncRunComponentFunctionRaw(::grpc::ClientContext* context, const ::tensorflow::eager::RunComponentFunctionRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::tensorflow::eager::RunComponentFunctionResponse>* PrepareAsyncRunComponentFunctionRaw(::grpc::ClientContext* context, const ::tensorflow::eager::RunComponentFunctionRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::tensorflow::eager::KeepAliveResponse>* AsyncKeepAliveRaw(::grpc::ClientContext* context, const ::tensorflow::eager::KeepAliveRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::tensorflow::eager::KeepAliveResponse>* PrepareAsyncKeepAliveRaw(::grpc::ClientContext* context, const ::tensorflow::eager::KeepAliveRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::tensorflow::eager::CloseContextResponse>* AsyncCloseContextRaw(::grpc::ClientContext* context, const ::tensorflow::eager::CloseContextRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::tensorflow::eager::CloseContextResponse>* PrepareAsyncCloseContextRaw(::grpc::ClientContext* context, const ::tensorflow::eager::CloseContextRequest& request, ::grpc::CompletionQueue* cq) = 0;
  };
  class Stub final : public StubInterface {
   public:
    Stub(const std::shared_ptr< ::grpc::ChannelInterface>& channel, const ::grpc::StubOptions& options = ::grpc::StubOptions());
    ::grpc::Status CreateContext(::grpc::ClientContext* context, const ::tensorflow::eager::CreateContextRequest& request, ::tensorflow::eager::CreateContextResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::tensorflow::eager::CreateContextResponse>> AsyncCreateContext(::grpc::ClientContext* context, const ::tensorflow::eager::CreateContextRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::tensorflow::eager::CreateContextResponse>>(AsyncCreateContextRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::tensorflow::eager::CreateContextResponse>> PrepareAsyncCreateContext(::grpc::ClientContext* context, const ::tensorflow::eager::CreateContextRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::tensorflow::eager::CreateContextResponse>>(PrepareAsyncCreateContextRaw(context, request, cq));
    }
    ::grpc::Status UpdateContext(::grpc::ClientContext* context, const ::tensorflow::eager::UpdateContextRequest& request, ::tensorflow::eager::UpdateContextResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::tensorflow::eager::UpdateContextResponse>> AsyncUpdateContext(::grpc::ClientContext* context, const ::tensorflow::eager::UpdateContextRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::tensorflow::eager::UpdateContextResponse>>(AsyncUpdateContextRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::tensorflow::eager::UpdateContextResponse>> PrepareAsyncUpdateContext(::grpc::ClientContext* context, const ::tensorflow::eager::UpdateContextRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::tensorflow::eager::UpdateContextResponse>>(PrepareAsyncUpdateContextRaw(context, request, cq));
    }
    ::grpc::Status Enqueue(::grpc::ClientContext* context, const ::tensorflow::eager::EnqueueRequest& request, ::tensorflow::eager::EnqueueResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::tensorflow::eager::EnqueueResponse>> AsyncEnqueue(::grpc::ClientContext* context, const ::tensorflow::eager::EnqueueRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::tensorflow::eager::EnqueueResponse>>(AsyncEnqueueRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::tensorflow::eager::EnqueueResponse>> PrepareAsyncEnqueue(::grpc::ClientContext* context, const ::tensorflow::eager::EnqueueRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::tensorflow::eager::EnqueueResponse>>(PrepareAsyncEnqueueRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientReaderWriter< ::tensorflow::eager::EnqueueRequest, ::tensorflow::eager::EnqueueResponse>> StreamingEnqueue(::grpc::ClientContext* context) {
      return std::unique_ptr< ::grpc::ClientReaderWriter< ::tensorflow::eager::EnqueueRequest, ::tensorflow::eager::EnqueueResponse>>(StreamingEnqueueRaw(context));
    }
    std::unique_ptr<  ::grpc::ClientAsyncReaderWriter< ::tensorflow::eager::EnqueueRequest, ::tensorflow::eager::EnqueueResponse>> AsyncStreamingEnqueue(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq, void* tag) {
      return std::unique_ptr< ::grpc::ClientAsyncReaderWriter< ::tensorflow::eager::EnqueueRequest, ::tensorflow::eager::EnqueueResponse>>(AsyncStreamingEnqueueRaw(context, cq, tag));
    }
    std::unique_ptr<  ::grpc::ClientAsyncReaderWriter< ::tensorflow::eager::EnqueueRequest, ::tensorflow::eager::EnqueueResponse>> PrepareAsyncStreamingEnqueue(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncReaderWriter< ::tensorflow::eager::EnqueueRequest, ::tensorflow::eager::EnqueueResponse>>(PrepareAsyncStreamingEnqueueRaw(context, cq));
    }
    ::grpc::Status WaitQueueDone(::grpc::ClientContext* context, const ::tensorflow::eager::WaitQueueDoneRequest& request, ::tensorflow::eager::WaitQueueDoneResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::tensorflow::eager::WaitQueueDoneResponse>> AsyncWaitQueueDone(::grpc::ClientContext* context, const ::tensorflow::eager::WaitQueueDoneRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::tensorflow::eager::WaitQueueDoneResponse>>(AsyncWaitQueueDoneRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::tensorflow::eager::WaitQueueDoneResponse>> PrepareAsyncWaitQueueDone(::grpc::ClientContext* context, const ::tensorflow::eager::WaitQueueDoneRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::tensorflow::eager::WaitQueueDoneResponse>>(PrepareAsyncWaitQueueDoneRaw(context, request, cq));
    }
    ::grpc::Status RunComponentFunction(::grpc::ClientContext* context, const ::tensorflow::eager::RunComponentFunctionRequest& request, ::tensorflow::eager::RunComponentFunctionResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::tensorflow::eager::RunComponentFunctionResponse>> AsyncRunComponentFunction(::grpc::ClientContext* context, const ::tensorflow::eager::RunComponentFunctionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::tensorflow::eager::RunComponentFunctionResponse>>(AsyncRunComponentFunctionRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::tensorflow::eager::RunComponentFunctionResponse>> PrepareAsyncRunComponentFunction(::grpc::ClientContext* context, const ::tensorflow::eager::RunComponentFunctionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::tensorflow::eager::RunComponentFunctionResponse>>(PrepareAsyncRunComponentFunctionRaw(context, request, cq));
    }
    ::grpc::Status KeepAlive(::grpc::ClientContext* context, const ::tensorflow::eager::KeepAliveRequest& request, ::tensorflow::eager::KeepAliveResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::tensorflow::eager::KeepAliveResponse>> AsyncKeepAlive(::grpc::ClientContext* context, const ::tensorflow::eager::KeepAliveRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::tensorflow::eager::KeepAliveResponse>>(AsyncKeepAliveRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::tensorflow::eager::KeepAliveResponse>> PrepareAsyncKeepAlive(::grpc::ClientContext* context, const ::tensorflow::eager::KeepAliveRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::tensorflow::eager::KeepAliveResponse>>(PrepareAsyncKeepAliveRaw(context, request, cq));
    }
    ::grpc::Status CloseContext(::grpc::ClientContext* context, const ::tensorflow::eager::CloseContextRequest& request, ::tensorflow::eager::CloseContextResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::tensorflow::eager::CloseContextResponse>> AsyncCloseContext(::grpc::ClientContext* context, const ::tensorflow::eager::CloseContextRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::tensorflow::eager::CloseContextResponse>>(AsyncCloseContextRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::tensorflow::eager::CloseContextResponse>> PrepareAsyncCloseContext(::grpc::ClientContext* context, const ::tensorflow::eager::CloseContextRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::tensorflow::eager::CloseContextResponse>>(PrepareAsyncCloseContextRaw(context, request, cq));
    }
    class async final :
      public StubInterface::async_interface {
     public:
      void CreateContext(::grpc::ClientContext* context, const ::tensorflow::eager::CreateContextRequest* request, ::tensorflow::eager::CreateContextResponse* response, std::function<void(::grpc::Status)>) override;
      void CreateContext(::grpc::ClientContext* context, const ::tensorflow::eager::CreateContextRequest* request, ::tensorflow::eager::CreateContextResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void UpdateContext(::grpc::ClientContext* context, const ::tensorflow::eager::UpdateContextRequest* request, ::tensorflow::eager::UpdateContextResponse* response, std::function<void(::grpc::Status)>) override;
      void UpdateContext(::grpc::ClientContext* context, const ::tensorflow::eager::UpdateContextRequest* request, ::tensorflow::eager::UpdateContextResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void Enqueue(::grpc::ClientContext* context, const ::tensorflow::eager::EnqueueRequest* request, ::tensorflow::eager::EnqueueResponse* response, std::function<void(::grpc::Status)>) override;
      void Enqueue(::grpc::ClientContext* context, const ::tensorflow::eager::EnqueueRequest* request, ::tensorflow::eager::EnqueueResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void StreamingEnqueue(::grpc::ClientContext* context, ::grpc::ClientBidiReactor< ::tensorflow::eager::EnqueueRequest,::tensorflow::eager::EnqueueResponse>* reactor) override;
      void WaitQueueDone(::grpc::ClientContext* context, const ::tensorflow::eager::WaitQueueDoneRequest* request, ::tensorflow::eager::WaitQueueDoneResponse* response, std::function<void(::grpc::Status)>) override;
      void WaitQueueDone(::grpc::ClientContext* context, const ::tensorflow::eager::WaitQueueDoneRequest* request, ::tensorflow::eager::WaitQueueDoneResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void RunComponentFunction(::grpc::ClientContext* context, const ::tensorflow::eager::RunComponentFunctionRequest* request, ::tensorflow::eager::RunComponentFunctionResponse* response, std::function<void(::grpc::Status)>) override;
      void RunComponentFunction(::grpc::ClientContext* context, const ::tensorflow::eager::RunComponentFunctionRequest* request, ::tensorflow::eager::RunComponentFunctionResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void KeepAlive(::grpc::ClientContext* context, const ::tensorflow::eager::KeepAliveRequest* request, ::tensorflow::eager::KeepAliveResponse* response, std::function<void(::grpc::Status)>) override;
      void KeepAlive(::grpc::ClientContext* context, const ::tensorflow::eager::KeepAliveRequest* request, ::tensorflow::eager::KeepAliveResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void CloseContext(::grpc::ClientContext* context, const ::tensorflow::eager::CloseContextRequest* request, ::tensorflow::eager::CloseContextResponse* response, std::function<void(::grpc::Status)>) override;
      void CloseContext(::grpc::ClientContext* context, const ::tensorflow::eager::CloseContextRequest* request, ::tensorflow::eager::CloseContextResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
     private:
      friend class Stub;
      explicit async(Stub* stub): stub_(stub) { }
      Stub* stub() { return stub_; }
      Stub* stub_;
    };
    class async* async() override { return &async_stub_; }

   private:
    std::shared_ptr< ::grpc::ChannelInterface> channel_;
    class async async_stub_{this};
    ::grpc::ClientAsyncResponseReader< ::tensorflow::eager::CreateContextResponse>* AsyncCreateContextRaw(::grpc::ClientContext* context, const ::tensorflow::eager::CreateContextRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::tensorflow::eager::CreateContextResponse>* PrepareAsyncCreateContextRaw(::grpc::ClientContext* context, const ::tensorflow::eager::CreateContextRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::tensorflow::eager::UpdateContextResponse>* AsyncUpdateContextRaw(::grpc::ClientContext* context, const ::tensorflow::eager::UpdateContextRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::tensorflow::eager::UpdateContextResponse>* PrepareAsyncUpdateContextRaw(::grpc::ClientContext* context, const ::tensorflow::eager::UpdateContextRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::tensorflow::eager::EnqueueResponse>* AsyncEnqueueRaw(::grpc::ClientContext* context, const ::tensorflow::eager::EnqueueRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::tensorflow::eager::EnqueueResponse>* PrepareAsyncEnqueueRaw(::grpc::ClientContext* context, const ::tensorflow::eager::EnqueueRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientReaderWriter< ::tensorflow::eager::EnqueueRequest, ::tensorflow::eager::EnqueueResponse>* StreamingEnqueueRaw(::grpc::ClientContext* context) override;
    ::grpc::ClientAsyncReaderWriter< ::tensorflow::eager::EnqueueRequest, ::tensorflow::eager::EnqueueResponse>* AsyncStreamingEnqueueRaw(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq, void* tag) override;
    ::grpc::ClientAsyncReaderWriter< ::tensorflow::eager::EnqueueRequest, ::tensorflow::eager::EnqueueResponse>* PrepareAsyncStreamingEnqueueRaw(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::tensorflow::eager::WaitQueueDoneResponse>* AsyncWaitQueueDoneRaw(::grpc::ClientContext* context, const ::tensorflow::eager::WaitQueueDoneRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::tensorflow::eager::WaitQueueDoneResponse>* PrepareAsyncWaitQueueDoneRaw(::grpc::ClientContext* context, const ::tensorflow::eager::WaitQueueDoneRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::tensorflow::eager::RunComponentFunctionResponse>* AsyncRunComponentFunctionRaw(::grpc::ClientContext* context, const ::tensorflow::eager::RunComponentFunctionRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::tensorflow::eager::RunComponentFunctionResponse>* PrepareAsyncRunComponentFunctionRaw(::grpc::ClientContext* context, const ::tensorflow::eager::RunComponentFunctionRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::tensorflow::eager::KeepAliveResponse>* AsyncKeepAliveRaw(::grpc::ClientContext* context, const ::tensorflow::eager::KeepAliveRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::tensorflow::eager::KeepAliveResponse>* PrepareAsyncKeepAliveRaw(::grpc::ClientContext* context, const ::tensorflow::eager::KeepAliveRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::tensorflow::eager::CloseContextResponse>* AsyncCloseContextRaw(::grpc::ClientContext* context, const ::tensorflow::eager::CloseContextRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::tensorflow::eager::CloseContextResponse>* PrepareAsyncCloseContextRaw(::grpc::ClientContext* context, const ::tensorflow::eager::CloseContextRequest& request, ::grpc::CompletionQueue* cq) override;
    const ::grpc::internal::RpcMethod rpcmethod_CreateContext_;
    const ::grpc::internal::RpcMethod rpcmethod_UpdateContext_;
    const ::grpc::internal::RpcMethod rpcmethod_Enqueue_;
    const ::grpc::internal::RpcMethod rpcmethod_StreamingEnqueue_;
    const ::grpc::internal::RpcMethod rpcmethod_WaitQueueDone_;
    const ::grpc::internal::RpcMethod rpcmethod_RunComponentFunction_;
    const ::grpc::internal::RpcMethod rpcmethod_KeepAlive_;
    const ::grpc::internal::RpcMethod rpcmethod_CloseContext_;
  };
  static std::unique_ptr<Stub> NewStub(const std::shared_ptr< ::grpc::ChannelInterface>& channel, const ::grpc::StubOptions& options = ::grpc::StubOptions());

  class Service : public ::grpc::Service {
   public:
    Service();
    virtual ~Service();
    // This initializes the worker, informing it about the other workers in the
    // cluster and exchanging authentication tokens which will be used in all
    // other RPCs to detect whether the worker has restarted.
    virtual ::grpc::Status CreateContext(::grpc::ServerContext* context, const ::tensorflow::eager::CreateContextRequest* request, ::tensorflow::eager::CreateContextResponse* response);
    // [AUTOMATION]: Internal rpc option goes here.
    // This updates the eager context on an existing worker when updating the set
    // of servers in a distributed eager cluster.
    virtual ::grpc::Status UpdateContext(::grpc::ServerContext* context, const ::tensorflow::eager::UpdateContextRequest* request, ::tensorflow::eager::UpdateContextResponse* response);
    // [AUTOMATION]: Internal rpc option goes here.
    // This takes a list of Execute and DeleteTensorHandle operations and enqueues
    // (in async mode) or executes (in sync mode) them on the remote server.
    // All outputs of ops which were not explicitly deleted with
    // DeleteTensorHandle entries will be assumed to be alive and are usable by
    // future calls to Enqueue.
    virtual ::grpc::Status Enqueue(::grpc::ServerContext* context, const ::tensorflow::eager::EnqueueRequest* request, ::tensorflow::eager::EnqueueResponse* response);
    // [AUTOMATION]: Internal rpc option goes here.
    // A streaming version of Enqueue.
    // Current server implementation sends one response per received request.
    // The benefit for using a streaming version is that subsequent requests
    // can be sent without waiting for a response to the previous request. This
    // synchronization is required in the regular Enqueue call because gRPC does
    // not guarantee to preserve request order.
    virtual ::grpc::Status StreamingEnqueue(::grpc::ServerContext* context, ::grpc::ServerReaderWriter< ::tensorflow::eager::EnqueueResponse, ::tensorflow::eager::EnqueueRequest>* stream);
    // [AUTOMATION]: Internal rpc option goes here.
    // Takes a set of op IDs and waits until those ops are done. Returns any error
    // in the stream so far.
    virtual ::grpc::Status WaitQueueDone(::grpc::ServerContext* context, const ::tensorflow::eager::WaitQueueDoneRequest* request, ::tensorflow::eager::WaitQueueDoneResponse* response);
    // [AUTOMATION]: Internal rpc option goes here.
    // This takes an Eager operation and executes it in async mode on the remote
    // server. Different from EnqueueRequest, ops/functions sent through this
    // type of requests are allowed to execute in parallel and no ordering is
    // preserved by RPC stream or executor.
    // This request type should only be used for executing component functions.
    // Ordering of component functions should be enforced by their corresponding
    // main functions. The runtime ensures the following invarients for component
    // functions (CFs) and their main functions (MFs):
    // (1) MF1 -> MF2 ==> CF1 -> CF2 ("->" indicates order of execution);
    // (2) MF1 || MF2 ==> CF1 || CF2 ("||" indicates possible parallel execution);
    // (3) For CF1 and CF2 that come from the same MF, CF1 || CF2
    // For executing ops/main functions, use Enqueue or StreamingEnqueue instead
    // for correct ordering.
    virtual ::grpc::Status RunComponentFunction(::grpc::ServerContext* context, const ::tensorflow::eager::RunComponentFunctionRequest* request, ::tensorflow::eager::RunComponentFunctionResponse* response);
    // [AUTOMATION]: Internal rpc option goes here.
    // Contexts are always created with a deadline and no RPCs within a deadline
    // will trigger a context garbage collection. KeepAlive calls can be used to
    // delay this. It can also be used to validate the existence of a context ID
    // on remote eager worker. If the context is on remote worker, return the same
    // ID and the current context view ID. This is useful for checking if the
    // remote worker (potentially with the same task name and hostname / port) is
    // replaced with a new process.
    virtual ::grpc::Status KeepAlive(::grpc::ServerContext* context, const ::tensorflow::eager::KeepAliveRequest* request, ::tensorflow::eager::KeepAliveResponse* response);
    // [AUTOMATION]: Internal rpc option goes here.
    // Closes the context. No calls to other methods using the existing context ID
    // are valid after this.
    virtual ::grpc::Status CloseContext(::grpc::ServerContext* context, const ::tensorflow::eager::CloseContextRequest* request, ::tensorflow::eager::CloseContextResponse* response);
    // [AUTOMATION]: Internal rpc option goes here.
  };
  template <class BaseClass>
  class WithAsyncMethod_CreateContext : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_CreateContext() {
      ::grpc::Service::MarkMethodAsync(0);
    }
    ~WithAsyncMethod_CreateContext() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateContext(::grpc::ServerContext* /*context*/, const ::tensorflow::eager::CreateContextRequest* /*request*/, ::tensorflow::eager::CreateContextResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCreateContext(::grpc::ServerContext* context, ::tensorflow::eager::CreateContextRequest* request, ::grpc::ServerAsyncResponseWriter< ::tensorflow::eager::CreateContextResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(0, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_UpdateContext : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_UpdateContext() {
      ::grpc::Service::MarkMethodAsync(1);
    }
    ~WithAsyncMethod_UpdateContext() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateContext(::grpc::ServerContext* /*context*/, const ::tensorflow::eager::UpdateContextRequest* /*request*/, ::tensorflow::eager::UpdateContextResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestUpdateContext(::grpc::ServerContext* context, ::tensorflow::eager::UpdateContextRequest* request, ::grpc::ServerAsyncResponseWriter< ::tensorflow::eager::UpdateContextResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(1, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_Enqueue : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_Enqueue() {
      ::grpc::Service::MarkMethodAsync(2);
    }
    ~WithAsyncMethod_Enqueue() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Enqueue(::grpc::ServerContext* /*context*/, const ::tensorflow::eager::EnqueueRequest* /*request*/, ::tensorflow::eager::EnqueueResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestEnqueue(::grpc::ServerContext* context, ::tensorflow::eager::EnqueueRequest* request, ::grpc::ServerAsyncResponseWriter< ::tensorflow::eager::EnqueueResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(2, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_StreamingEnqueue : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_StreamingEnqueue() {
      ::grpc::Service::MarkMethodAsync(3);
    }
    ~WithAsyncMethod_StreamingEnqueue() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status StreamingEnqueue(::grpc::ServerContext* /*context*/, ::grpc::ServerReaderWriter< ::tensorflow::eager::EnqueueResponse, ::tensorflow::eager::EnqueueRequest>* /*stream*/)  override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestStreamingEnqueue(::grpc::ServerContext* context, ::grpc::ServerAsyncReaderWriter< ::tensorflow::eager::EnqueueResponse, ::tensorflow::eager::EnqueueRequest>* stream, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncBidiStreaming(3, context, stream, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_WaitQueueDone : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_WaitQueueDone() {
      ::grpc::Service::MarkMethodAsync(4);
    }
    ~WithAsyncMethod_WaitQueueDone() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status WaitQueueDone(::grpc::ServerContext* /*context*/, const ::tensorflow::eager::WaitQueueDoneRequest* /*request*/, ::tensorflow::eager::WaitQueueDoneResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestWaitQueueDone(::grpc::ServerContext* context, ::tensorflow::eager::WaitQueueDoneRequest* request, ::grpc::ServerAsyncResponseWriter< ::tensorflow::eager::WaitQueueDoneResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(4, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_RunComponentFunction : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_RunComponentFunction() {
      ::grpc::Service::MarkMethodAsync(5);
    }
    ~WithAsyncMethod_RunComponentFunction() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status RunComponentFunction(::grpc::ServerContext* /*context*/, const ::tensorflow::eager::RunComponentFunctionRequest* /*request*/, ::tensorflow::eager::RunComponentFunctionResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestRunComponentFunction(::grpc::ServerContext* context, ::tensorflow::eager::RunComponentFunctionRequest* request, ::grpc::ServerAsyncResponseWriter< ::tensorflow::eager::RunComponentFunctionResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(5, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_KeepAlive : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_KeepAlive() {
      ::grpc::Service::MarkMethodAsync(6);
    }
    ~WithAsyncMethod_KeepAlive() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status KeepAlive(::grpc::ServerContext* /*context*/, const ::tensorflow::eager::KeepAliveRequest* /*request*/, ::tensorflow::eager::KeepAliveResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestKeepAlive(::grpc::ServerContext* context, ::tensorflow::eager::KeepAliveRequest* request, ::grpc::ServerAsyncResponseWriter< ::tensorflow::eager::KeepAliveResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(6, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_CloseContext : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_CloseContext() {
      ::grpc::Service::MarkMethodAsync(7);
    }
    ~WithAsyncMethod_CloseContext() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CloseContext(::grpc::ServerContext* /*context*/, const ::tensorflow::eager::CloseContextRequest* /*request*/, ::tensorflow::eager::CloseContextResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCloseContext(::grpc::ServerContext* context, ::tensorflow::eager::CloseContextRequest* request, ::grpc::ServerAsyncResponseWriter< ::tensorflow::eager::CloseContextResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(7, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  typedef WithAsyncMethod_CreateContext<WithAsyncMethod_UpdateContext<WithAsyncMethod_Enqueue<WithAsyncMethod_StreamingEnqueue<WithAsyncMethod_WaitQueueDone<WithAsyncMethod_RunComponentFunction<WithAsyncMethod_KeepAlive<WithAsyncMethod_CloseContext<Service > > > > > > > > AsyncService;
  template <class BaseClass>
  class WithCallbackMethod_CreateContext : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_CreateContext() {
      ::grpc::Service::MarkMethodCallback(0,
          new ::grpc::internal::CallbackUnaryHandler< ::tensorflow::eager::CreateContextRequest, ::tensorflow::eager::CreateContextResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::tensorflow::eager::CreateContextRequest* request, ::tensorflow::eager::CreateContextResponse* response) { return this->CreateContext(context, request, response); }));}
    void SetMessageAllocatorFor_CreateContext(
        ::grpc::MessageAllocator< ::tensorflow::eager::CreateContextRequest, ::tensorflow::eager::CreateContextResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(0);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::tensorflow::eager::CreateContextRequest, ::tensorflow::eager::CreateContextResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_CreateContext() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateContext(::grpc::ServerContext* /*context*/, const ::tensorflow::eager::CreateContextRequest* /*request*/, ::tensorflow::eager::CreateContextResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CreateContext(
      ::grpc::CallbackServerContext* /*context*/, const ::tensorflow::eager::CreateContextRequest* /*request*/, ::tensorflow::eager::CreateContextResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_UpdateContext : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_UpdateContext() {
      ::grpc::Service::MarkMethodCallback(1,
          new ::grpc::internal::CallbackUnaryHandler< ::tensorflow::eager::UpdateContextRequest, ::tensorflow::eager::UpdateContextResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::tensorflow::eager::UpdateContextRequest* request, ::tensorflow::eager::UpdateContextResponse* response) { return this->UpdateContext(context, request, response); }));}
    void SetMessageAllocatorFor_UpdateContext(
        ::grpc::MessageAllocator< ::tensorflow::eager::UpdateContextRequest, ::tensorflow::eager::UpdateContextResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(1);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::tensorflow::eager::UpdateContextRequest, ::tensorflow::eager::UpdateContextResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_UpdateContext() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateContext(::grpc::ServerContext* /*context*/, const ::tensorflow::eager::UpdateContextRequest* /*request*/, ::tensorflow::eager::UpdateContextResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* UpdateContext(
      ::grpc::CallbackServerContext* /*context*/, const ::tensorflow::eager::UpdateContextRequest* /*request*/, ::tensorflow::eager::UpdateContextResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_Enqueue : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_Enqueue() {
      ::grpc::Service::MarkMethodCallback(2,
          new ::grpc::internal::CallbackUnaryHandler< ::tensorflow::eager::EnqueueRequest, ::tensorflow::eager::EnqueueResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::tensorflow::eager::EnqueueRequest* request, ::tensorflow::eager::EnqueueResponse* response) { return this->Enqueue(context, request, response); }));}
    void SetMessageAllocatorFor_Enqueue(
        ::grpc::MessageAllocator< ::tensorflow::eager::EnqueueRequest, ::tensorflow::eager::EnqueueResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(2);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::tensorflow::eager::EnqueueRequest, ::tensorflow::eager::EnqueueResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_Enqueue() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Enqueue(::grpc::ServerContext* /*context*/, const ::tensorflow::eager::EnqueueRequest* /*request*/, ::tensorflow::eager::EnqueueResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* Enqueue(
      ::grpc::CallbackServerContext* /*context*/, const ::tensorflow::eager::EnqueueRequest* /*request*/, ::tensorflow::eager::EnqueueResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_StreamingEnqueue : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_StreamingEnqueue() {
      ::grpc::Service::MarkMethodCallback(3,
          new ::grpc::internal::CallbackBidiHandler< ::tensorflow::eager::EnqueueRequest, ::tensorflow::eager::EnqueueResponse>(
            [this](
                   ::grpc::CallbackServerContext* context) { return this->StreamingEnqueue(context); }));
    }
    ~WithCallbackMethod_StreamingEnqueue() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status StreamingEnqueue(::grpc::ServerContext* /*context*/, ::grpc::ServerReaderWriter< ::tensorflow::eager::EnqueueResponse, ::tensorflow::eager::EnqueueRequest>* /*stream*/)  override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerBidiReactor< ::tensorflow::eager::EnqueueRequest, ::tensorflow::eager::EnqueueResponse>* StreamingEnqueue(
      ::grpc::CallbackServerContext* /*context*/)
      { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_WaitQueueDone : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_WaitQueueDone() {
      ::grpc::Service::MarkMethodCallback(4,
          new ::grpc::internal::CallbackUnaryHandler< ::tensorflow::eager::WaitQueueDoneRequest, ::tensorflow::eager::WaitQueueDoneResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::tensorflow::eager::WaitQueueDoneRequest* request, ::tensorflow::eager::WaitQueueDoneResponse* response) { return this->WaitQueueDone(context, request, response); }));}
    void SetMessageAllocatorFor_WaitQueueDone(
        ::grpc::MessageAllocator< ::tensorflow::eager::WaitQueueDoneRequest, ::tensorflow::eager::WaitQueueDoneResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(4);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::tensorflow::eager::WaitQueueDoneRequest, ::tensorflow::eager::WaitQueueDoneResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_WaitQueueDone() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status WaitQueueDone(::grpc::ServerContext* /*context*/, const ::tensorflow::eager::WaitQueueDoneRequest* /*request*/, ::tensorflow::eager::WaitQueueDoneResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* WaitQueueDone(
      ::grpc::CallbackServerContext* /*context*/, const ::tensorflow::eager::WaitQueueDoneRequest* /*request*/, ::tensorflow::eager::WaitQueueDoneResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_RunComponentFunction : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_RunComponentFunction() {
      ::grpc::Service::MarkMethodCallback(5,
          new ::grpc::internal::CallbackUnaryHandler< ::tensorflow::eager::RunComponentFunctionRequest, ::tensorflow::eager::RunComponentFunctionResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::tensorflow::eager::RunComponentFunctionRequest* request, ::tensorflow::eager::RunComponentFunctionResponse* response) { return this->RunComponentFunction(context, request, response); }));}
    void SetMessageAllocatorFor_RunComponentFunction(
        ::grpc::MessageAllocator< ::tensorflow::eager::RunComponentFunctionRequest, ::tensorflow::eager::RunComponentFunctionResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(5);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::tensorflow::eager::RunComponentFunctionRequest, ::tensorflow::eager::RunComponentFunctionResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_RunComponentFunction() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status RunComponentFunction(::grpc::ServerContext* /*context*/, const ::tensorflow::eager::RunComponentFunctionRequest* /*request*/, ::tensorflow::eager::RunComponentFunctionResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* RunComponentFunction(
      ::grpc::CallbackServerContext* /*context*/, const ::tensorflow::eager::RunComponentFunctionRequest* /*request*/, ::tensorflow::eager::RunComponentFunctionResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_KeepAlive : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_KeepAlive() {
      ::grpc::Service::MarkMethodCallback(6,
          new ::grpc::internal::CallbackUnaryHandler< ::tensorflow::eager::KeepAliveRequest, ::tensorflow::eager::KeepAliveResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::tensorflow::eager::KeepAliveRequest* request, ::tensorflow::eager::KeepAliveResponse* response) { return this->KeepAlive(context, request, response); }));}
    void SetMessageAllocatorFor_KeepAlive(
        ::grpc::MessageAllocator< ::tensorflow::eager::KeepAliveRequest, ::tensorflow::eager::KeepAliveResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(6);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::tensorflow::eager::KeepAliveRequest, ::tensorflow::eager::KeepAliveResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_KeepAlive() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status KeepAlive(::grpc::ServerContext* /*context*/, const ::tensorflow::eager::KeepAliveRequest* /*request*/, ::tensorflow::eager::KeepAliveResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* KeepAlive(
      ::grpc::CallbackServerContext* /*context*/, const ::tensorflow::eager::KeepAliveRequest* /*request*/, ::tensorflow::eager::KeepAliveResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_CloseContext : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_CloseContext() {
      ::grpc::Service::MarkMethodCallback(7,
          new ::grpc::internal::CallbackUnaryHandler< ::tensorflow::eager::CloseContextRequest, ::tensorflow::eager::CloseContextResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::tensorflow::eager::CloseContextRequest* request, ::tensorflow::eager::CloseContextResponse* response) { return this->CloseContext(context, request, response); }));}
    void SetMessageAllocatorFor_CloseContext(
        ::grpc::MessageAllocator< ::tensorflow::eager::CloseContextRequest, ::tensorflow::eager::CloseContextResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(7);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::tensorflow::eager::CloseContextRequest, ::tensorflow::eager::CloseContextResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_CloseContext() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CloseContext(::grpc::ServerContext* /*context*/, const ::tensorflow::eager::CloseContextRequest* /*request*/, ::tensorflow::eager::CloseContextResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CloseContext(
      ::grpc::CallbackServerContext* /*context*/, const ::tensorflow::eager::CloseContextRequest* /*request*/, ::tensorflow::eager::CloseContextResponse* /*response*/)  { return nullptr; }
  };
  typedef WithCallbackMethod_CreateContext<WithCallbackMethod_UpdateContext<WithCallbackMethod_Enqueue<WithCallbackMethod_StreamingEnqueue<WithCallbackMethod_WaitQueueDone<WithCallbackMethod_RunComponentFunction<WithCallbackMethod_KeepAlive<WithCallbackMethod_CloseContext<Service > > > > > > > > CallbackService;
  typedef CallbackService ExperimentalCallbackService;
  template <class BaseClass>
  class WithGenericMethod_CreateContext : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_CreateContext() {
      ::grpc::Service::MarkMethodGeneric(0);
    }
    ~WithGenericMethod_CreateContext() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateContext(::grpc::ServerContext* /*context*/, const ::tensorflow::eager::CreateContextRequest* /*request*/, ::tensorflow::eager::CreateContextResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_UpdateContext : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_UpdateContext() {
      ::grpc::Service::MarkMethodGeneric(1);
    }
    ~WithGenericMethod_UpdateContext() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateContext(::grpc::ServerContext* /*context*/, const ::tensorflow::eager::UpdateContextRequest* /*request*/, ::tensorflow::eager::UpdateContextResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_Enqueue : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_Enqueue() {
      ::grpc::Service::MarkMethodGeneric(2);
    }
    ~WithGenericMethod_Enqueue() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Enqueue(::grpc::ServerContext* /*context*/, const ::tensorflow::eager::EnqueueRequest* /*request*/, ::tensorflow::eager::EnqueueResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_StreamingEnqueue : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_StreamingEnqueue() {
      ::grpc::Service::MarkMethodGeneric(3);
    }
    ~WithGenericMethod_StreamingEnqueue() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status StreamingEnqueue(::grpc::ServerContext* /*context*/, ::grpc::ServerReaderWriter< ::tensorflow::eager::EnqueueResponse, ::tensorflow::eager::EnqueueRequest>* /*stream*/)  override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_WaitQueueDone : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_WaitQueueDone() {
      ::grpc::Service::MarkMethodGeneric(4);
    }
    ~WithGenericMethod_WaitQueueDone() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status WaitQueueDone(::grpc::ServerContext* /*context*/, const ::tensorflow::eager::WaitQueueDoneRequest* /*request*/, ::tensorflow::eager::WaitQueueDoneResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_RunComponentFunction : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_RunComponentFunction() {
      ::grpc::Service::MarkMethodGeneric(5);
    }
    ~WithGenericMethod_RunComponentFunction() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status RunComponentFunction(::grpc::ServerContext* /*context*/, const ::tensorflow::eager::RunComponentFunctionRequest* /*request*/, ::tensorflow::eager::RunComponentFunctionResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_KeepAlive : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_KeepAlive() {
      ::grpc::Service::MarkMethodGeneric(6);
    }
    ~WithGenericMethod_KeepAlive() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status KeepAlive(::grpc::ServerContext* /*context*/, const ::tensorflow::eager::KeepAliveRequest* /*request*/, ::tensorflow::eager::KeepAliveResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_CloseContext : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_CloseContext() {
      ::grpc::Service::MarkMethodGeneric(7);
    }
    ~WithGenericMethod_CloseContext() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CloseContext(::grpc::ServerContext* /*context*/, const ::tensorflow::eager::CloseContextRequest* /*request*/, ::tensorflow::eager::CloseContextResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithRawMethod_CreateContext : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_CreateContext() {
      ::grpc::Service::MarkMethodRaw(0);
    }
    ~WithRawMethod_CreateContext() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateContext(::grpc::ServerContext* /*context*/, const ::tensorflow::eager::CreateContextRequest* /*request*/, ::tensorflow::eager::CreateContextResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCreateContext(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(0, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_UpdateContext : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_UpdateContext() {
      ::grpc::Service::MarkMethodRaw(1);
    }
    ~WithRawMethod_UpdateContext() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateContext(::grpc::ServerContext* /*context*/, const ::tensorflow::eager::UpdateContextRequest* /*request*/, ::tensorflow::eager::UpdateContextResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestUpdateContext(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(1, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_Enqueue : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_Enqueue() {
      ::grpc::Service::MarkMethodRaw(2);
    }
    ~WithRawMethod_Enqueue() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Enqueue(::grpc::ServerContext* /*context*/, const ::tensorflow::eager::EnqueueRequest* /*request*/, ::tensorflow::eager::EnqueueResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestEnqueue(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(2, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_StreamingEnqueue : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_StreamingEnqueue() {
      ::grpc::Service::MarkMethodRaw(3);
    }
    ~WithRawMethod_StreamingEnqueue() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status StreamingEnqueue(::grpc::ServerContext* /*context*/, ::grpc::ServerReaderWriter< ::tensorflow::eager::EnqueueResponse, ::tensorflow::eager::EnqueueRequest>* /*stream*/)  override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestStreamingEnqueue(::grpc::ServerContext* context, ::grpc::ServerAsyncReaderWriter< ::grpc::ByteBuffer, ::grpc::ByteBuffer>* stream, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncBidiStreaming(3, context, stream, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_WaitQueueDone : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_WaitQueueDone() {
      ::grpc::Service::MarkMethodRaw(4);
    }
    ~WithRawMethod_WaitQueueDone() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status WaitQueueDone(::grpc::ServerContext* /*context*/, const ::tensorflow::eager::WaitQueueDoneRequest* /*request*/, ::tensorflow::eager::WaitQueueDoneResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestWaitQueueDone(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(4, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_RunComponentFunction : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_RunComponentFunction() {
      ::grpc::Service::MarkMethodRaw(5);
    }
    ~WithRawMethod_RunComponentFunction() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status RunComponentFunction(::grpc::ServerContext* /*context*/, const ::tensorflow::eager::RunComponentFunctionRequest* /*request*/, ::tensorflow::eager::RunComponentFunctionResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestRunComponentFunction(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(5, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_KeepAlive : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_KeepAlive() {
      ::grpc::Service::MarkMethodRaw(6);
    }
    ~WithRawMethod_KeepAlive() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status KeepAlive(::grpc::ServerContext* /*context*/, const ::tensorflow::eager::KeepAliveRequest* /*request*/, ::tensorflow::eager::KeepAliveResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestKeepAlive(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(6, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_CloseContext : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_CloseContext() {
      ::grpc::Service::MarkMethodRaw(7);
    }
    ~WithRawMethod_CloseContext() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CloseContext(::grpc::ServerContext* /*context*/, const ::tensorflow::eager::CloseContextRequest* /*request*/, ::tensorflow::eager::CloseContextResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCloseContext(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(7, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_CreateContext : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_CreateContext() {
      ::grpc::Service::MarkMethodRawCallback(0,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->CreateContext(context, request, response); }));
    }
    ~WithRawCallbackMethod_CreateContext() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateContext(::grpc::ServerContext* /*context*/, const ::tensorflow::eager::CreateContextRequest* /*request*/, ::tensorflow::eager::CreateContextResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CreateContext(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_UpdateContext : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_UpdateContext() {
      ::grpc::Service::MarkMethodRawCallback(1,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->UpdateContext(context, request, response); }));
    }
    ~WithRawCallbackMethod_UpdateContext() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateContext(::grpc::ServerContext* /*context*/, const ::tensorflow::eager::UpdateContextRequest* /*request*/, ::tensorflow::eager::UpdateContextResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* UpdateContext(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_Enqueue : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_Enqueue() {
      ::grpc::Service::MarkMethodRawCallback(2,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->Enqueue(context, request, response); }));
    }
    ~WithRawCallbackMethod_Enqueue() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Enqueue(::grpc::ServerContext* /*context*/, const ::tensorflow::eager::EnqueueRequest* /*request*/, ::tensorflow::eager::EnqueueResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* Enqueue(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_StreamingEnqueue : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_StreamingEnqueue() {
      ::grpc::Service::MarkMethodRawCallback(3,
          new ::grpc::internal::CallbackBidiHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context) { return this->StreamingEnqueue(context); }));
    }
    ~WithRawCallbackMethod_StreamingEnqueue() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status StreamingEnqueue(::grpc::ServerContext* /*context*/, ::grpc::ServerReaderWriter< ::tensorflow::eager::EnqueueResponse, ::tensorflow::eager::EnqueueRequest>* /*stream*/)  override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerBidiReactor< ::grpc::ByteBuffer, ::grpc::ByteBuffer>* StreamingEnqueue(
      ::grpc::CallbackServerContext* /*context*/)
      { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_WaitQueueDone : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_WaitQueueDone() {
      ::grpc::Service::MarkMethodRawCallback(4,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->WaitQueueDone(context, request, response); }));
    }
    ~WithRawCallbackMethod_WaitQueueDone() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status WaitQueueDone(::grpc::ServerContext* /*context*/, const ::tensorflow::eager::WaitQueueDoneRequest* /*request*/, ::tensorflow::eager::WaitQueueDoneResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* WaitQueueDone(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_RunComponentFunction : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_RunComponentFunction() {
      ::grpc::Service::MarkMethodRawCallback(5,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->RunComponentFunction(context, request, response); }));
    }
    ~WithRawCallbackMethod_RunComponentFunction() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status RunComponentFunction(::grpc::ServerContext* /*context*/, const ::tensorflow::eager::RunComponentFunctionRequest* /*request*/, ::tensorflow::eager::RunComponentFunctionResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* RunComponentFunction(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_KeepAlive : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_KeepAlive() {
      ::grpc::Service::MarkMethodRawCallback(6,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->KeepAlive(context, request, response); }));
    }
    ~WithRawCallbackMethod_KeepAlive() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status KeepAlive(::grpc::ServerContext* /*context*/, const ::tensorflow::eager::KeepAliveRequest* /*request*/, ::tensorflow::eager::KeepAliveResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* KeepAlive(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_CloseContext : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_CloseContext() {
      ::grpc::Service::MarkMethodRawCallback(7,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->CloseContext(context, request, response); }));
    }
    ~WithRawCallbackMethod_CloseContext() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CloseContext(::grpc::ServerContext* /*context*/, const ::tensorflow::eager::CloseContextRequest* /*request*/, ::tensorflow::eager::CloseContextResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CloseContext(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_CreateContext : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_CreateContext() {
      ::grpc::Service::MarkMethodStreamed(0,
        new ::grpc::internal::StreamedUnaryHandler<
          ::tensorflow::eager::CreateContextRequest, ::tensorflow::eager::CreateContextResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::tensorflow::eager::CreateContextRequest, ::tensorflow::eager::CreateContextResponse>* streamer) {
                       return this->StreamedCreateContext(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_CreateContext() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status CreateContext(::grpc::ServerContext* /*context*/, const ::tensorflow::eager::CreateContextRequest* /*request*/, ::tensorflow::eager::CreateContextResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedCreateContext(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::tensorflow::eager::CreateContextRequest,::tensorflow::eager::CreateContextResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_UpdateContext : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_UpdateContext() {
      ::grpc::Service::MarkMethodStreamed(1,
        new ::grpc::internal::StreamedUnaryHandler<
          ::tensorflow::eager::UpdateContextRequest, ::tensorflow::eager::UpdateContextResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::tensorflow::eager::UpdateContextRequest, ::tensorflow::eager::UpdateContextResponse>* streamer) {
                       return this->StreamedUpdateContext(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_UpdateContext() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status UpdateContext(::grpc::ServerContext* /*context*/, const ::tensorflow::eager::UpdateContextRequest* /*request*/, ::tensorflow::eager::UpdateContextResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedUpdateContext(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::tensorflow::eager::UpdateContextRequest,::tensorflow::eager::UpdateContextResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_Enqueue : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_Enqueue() {
      ::grpc::Service::MarkMethodStreamed(2,
        new ::grpc::internal::StreamedUnaryHandler<
          ::tensorflow::eager::EnqueueRequest, ::tensorflow::eager::EnqueueResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::tensorflow::eager::EnqueueRequest, ::tensorflow::eager::EnqueueResponse>* streamer) {
                       return this->StreamedEnqueue(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_Enqueue() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status Enqueue(::grpc::ServerContext* /*context*/, const ::tensorflow::eager::EnqueueRequest* /*request*/, ::tensorflow::eager::EnqueueResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedEnqueue(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::tensorflow::eager::EnqueueRequest,::tensorflow::eager::EnqueueResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_WaitQueueDone : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_WaitQueueDone() {
      ::grpc::Service::MarkMethodStreamed(4,
        new ::grpc::internal::StreamedUnaryHandler<
          ::tensorflow::eager::WaitQueueDoneRequest, ::tensorflow::eager::WaitQueueDoneResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::tensorflow::eager::WaitQueueDoneRequest, ::tensorflow::eager::WaitQueueDoneResponse>* streamer) {
                       return this->StreamedWaitQueueDone(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_WaitQueueDone() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status WaitQueueDone(::grpc::ServerContext* /*context*/, const ::tensorflow::eager::WaitQueueDoneRequest* /*request*/, ::tensorflow::eager::WaitQueueDoneResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedWaitQueueDone(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::tensorflow::eager::WaitQueueDoneRequest,::tensorflow::eager::WaitQueueDoneResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_RunComponentFunction : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_RunComponentFunction() {
      ::grpc::Service::MarkMethodStreamed(5,
        new ::grpc::internal::StreamedUnaryHandler<
          ::tensorflow::eager::RunComponentFunctionRequest, ::tensorflow::eager::RunComponentFunctionResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::tensorflow::eager::RunComponentFunctionRequest, ::tensorflow::eager::RunComponentFunctionResponse>* streamer) {
                       return this->StreamedRunComponentFunction(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_RunComponentFunction() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status RunComponentFunction(::grpc::ServerContext* /*context*/, const ::tensorflow::eager::RunComponentFunctionRequest* /*request*/, ::tensorflow::eager::RunComponentFunctionResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedRunComponentFunction(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::tensorflow::eager::RunComponentFunctionRequest,::tensorflow::eager::RunComponentFunctionResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_KeepAlive : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_KeepAlive() {
      ::grpc::Service::MarkMethodStreamed(6,
        new ::grpc::internal::StreamedUnaryHandler<
          ::tensorflow::eager::KeepAliveRequest, ::tensorflow::eager::KeepAliveResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::tensorflow::eager::KeepAliveRequest, ::tensorflow::eager::KeepAliveResponse>* streamer) {
                       return this->StreamedKeepAlive(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_KeepAlive() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status KeepAlive(::grpc::ServerContext* /*context*/, const ::tensorflow::eager::KeepAliveRequest* /*request*/, ::tensorflow::eager::KeepAliveResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedKeepAlive(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::tensorflow::eager::KeepAliveRequest,::tensorflow::eager::KeepAliveResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_CloseContext : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_CloseContext() {
      ::grpc::Service::MarkMethodStreamed(7,
        new ::grpc::internal::StreamedUnaryHandler<
          ::tensorflow::eager::CloseContextRequest, ::tensorflow::eager::CloseContextResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::tensorflow::eager::CloseContextRequest, ::tensorflow::eager::CloseContextResponse>* streamer) {
                       return this->StreamedCloseContext(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_CloseContext() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status CloseContext(::grpc::ServerContext* /*context*/, const ::tensorflow::eager::CloseContextRequest* /*request*/, ::tensorflow::eager::CloseContextResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedCloseContext(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::tensorflow::eager::CloseContextRequest,::tensorflow::eager::CloseContextResponse>* server_unary_streamer) = 0;
  };
  typedef WithStreamedUnaryMethod_CreateContext<WithStreamedUnaryMethod_UpdateContext<WithStreamedUnaryMethod_Enqueue<WithStreamedUnaryMethod_WaitQueueDone<WithStreamedUnaryMethod_RunComponentFunction<WithStreamedUnaryMethod_KeepAlive<WithStreamedUnaryMethod_CloseContext<Service > > > > > > > StreamedUnaryService;
  typedef Service SplitStreamedService;
  typedef WithStreamedUnaryMethod_CreateContext<WithStreamedUnaryMethod_UpdateContext<WithStreamedUnaryMethod_Enqueue<WithStreamedUnaryMethod_WaitQueueDone<WithStreamedUnaryMethod_RunComponentFunction<WithStreamedUnaryMethod_KeepAlive<WithStreamedUnaryMethod_CloseContext<Service > > > > > > > StreamedService;
};

}  // namespace grpc

}  // namespace eager
}  // namespace tensorflow


#endif  // GRPC_tensorflow_2fcore_2fprotobuf_2feager_5fservice_2eproto__INCLUDED
