from typing import Tuple

from .. import ElementsType
from .. import Provider as CurrencyProvider


class Provider(CurrencyProvider):
    # source: https://www.laenderdaten.info/waehrungen/

    currencies: ElementsType[Tuple[str, str]] = (
        ("AED", "Arabische Dirham"),
        ("AFN", "Afghani"),
        ("ALL", "Albanische Lek"),
        ("AMD", "Armenische Dram"),
        ("ANG", "Antillen Gulden"),
        ("AOA", "Angolanische Kwanza"),
        ("ARS", "Argentinische Peso"),
        ("AUD", "Australische Dollar"),
        ("AWG", "Aruba Florin"),
        ("AZN", "Aserbaidschanische Manat"),
        ("BAM", "Konvertible Mark"),
        ("BBD", "Barbados Dollar"),
        ("BDT", "Bangladeschische Taka"),
        ("BGN", "Bulgarische Lew"),
        ("BHD", "Bahrainische Dinar"),
        ("BIF", "Burundische Franc"),
        ("BMD", "Bermudische Dollar"),
        ("BND", "Brunei Dollar"),
        ("BOB", "Boliviano"),
        ("BRL", "Brasilianische Real"),
        ("BSD", "Bahamas Dollar"),
        ("BTN", "Bhutanisches Ngultrum"),
        ("BWP", "Botswanische Pula"),
        ("BYR", "Belarussische Rubel"),
        ("BZD", "Belize Dollar"),
        ("CAD", "Kanadische Dollar"),
        ("CDF", "Kongolesische Franc"),
        ("CHF", "Schweizer Franken"),
        ("CLP", "Chilenische Peso"),
        ("CNY", "Renminbi Yuán"),
        ("COP", "Kolumbische Peso"),
        ("CRC", "Costa-Rica Colón"),
        ("CUC", "Cuba Peso Convertible"),
        ("CUP", "Kubanische Peso"),
        ("CVE", "Cap Verdische Escudo"),
        ("CZK", "Tschechische Krone"),
        ("DJF", "Dschibuti Franc"),
        ("DKK", "Dänische Krone"),
        ("DOP", "Dominikanische Peso"),
        ("DZD", "Algerische Dinar"),
        ("EGP", "Ägyptische Pfund"),
        ("ERN", "Eritreische Nakfa"),
        ("ETB", "Äthiopische Birr"),
        ("EUR", "Euro"),
        ("FJD", "Fidschi Dollar"),
        ("FKP", "Falkländische Pfund"),
        ("GBP", "Sterling Pfund"),
        ("GEL", "Georgische Lari"),
        ("GGP", "Guernsey Pfund"),
        ("GHS", "Ghanaische Cedi"),
        ("GIP", "Gibraltar Pfund"),
        ("GMD", "Gambische Dalasi"),
        ("GNF", "Guinea Franc"),
        ("GTQ", "Guatemaltekischer Quetzal"),
        ("GYD", "Guyana Dollar"),
        ("HKD", "Hongkong Dollar"),
        ("HNL", "Honduranische Lempira"),
        ("HRK", "Kroatische Kuna"),
        ("HTG", "Haitianische Gourde"),
        ("HUF", "Ungarische Forint"),
        ("IDR", "Indonesische Rupiah"),
        ("ILS", "Israelische Schekel"),
        ("NIS", "Israelische Schekel"),
        ("IMP", "Isle-of-Man Pfund"),
        ("INR", "Indische Rupie"),
        ("IQD", "Irakische Dinar"),
        ("IRR", "Iranische Rial"),
        ("ISK", "Isländische Krone"),
        ("JEP", "Jersey Pfund"),
        ("JMD", "Jamaikanische Dollar"),
        ("JOD", "Jordanische Dinar"),
        ("JPY", "Japanische Yen"),
        ("KES", "Kenianische Schilling"),
        ("KGS", "Kirgisische Som"),
        ("KHR", "Kambodschanische Riel"),
        ("KMF", "Komorische Franc"),
        ("KPW", "Nordkoreanische Won"),
        ("KRW", "Südkoreanische Won"),
        ("KWD", "Kuwaitische Dinar"),
        ("KYD", "Cayman Dollar"),
        ("KZT", "Kasachische Tenge"),
        ("LAK", "Laotische Kip"),
        ("LBP", "Libanesische Pfund"),
        ("LKR", "Sri Lanka Rupie"),
        ("LRD", "Liberianische Dollar"),
        ("LSL", "Lesothische Loti"),
        ("LYD", "Libysche Dinar"),
        ("MAD", "Marokkanische Dirham"),
        ("MDL", "Moldauische Leu"),
        ("MGA", "Madagassische Ariary"),
        ("MKD", "Mazedonische Denar"),
        ("MMK", "Burmesische Kyat"),
        ("MNT", "Mongolische Tögrög"),
        ("MOP", "Macau Pataca"),
        ("MRO", "Mauretanische Ouguiya"),
        ("MUR", "Mauritius Rupie"),
        ("MVR", "Maledivische Rufiyaa"),
        ("MWK", "Malawische Kwacha"),
        ("MXN", "Mexikanische Peso"),
        ("MYR", "Malaysische Ringgit"),
        ("MZN", "Mosambikanische Metical"),
        ("NAD", "Namibische Dollar"),
        ("NGN", "Nigerianische Naira"),
        ("NIO", "Nicaraguanische Córdoba Oro"),
        ("NOK", "Norwegische Krone"),
        ("NPR", "Nepalesische Rupie"),
        ("NZD", "Neuseeländische Dollar"),
        ("OMR", "Omanische Rial"),
        ("PAB", "Panamaische Balboa"),
        ("PEN", "Peruanische Sol"),
        ("PGK", "Papua-neuguineische Kina"),
        ("PHP", "Philippinische Peso"),
        ("PKR", "Pakistanische Rupie"),
        ("PLN", "Polnische Złoty"),
        ("PYG", "Paraguayische Guaraní"),
        ("QAR", "Qatar Riyal"),
        ("RON", "Rumänische Leu"),
        ("RSD", "Serbische Dinar"),
        ("RUB", "Russische Rubel"),
        ("RWF", "Ruandische Franc"),
        ("SAR", "Saudische Riyal"),
        ("SBD", "Salomonische Dollar"),
        ("SCR", "Seychellen Rupie"),
        ("SDG", "Sudanesische Pfund"),
        ("SEK", "Schwedische Krone"),
        ("SGD", "Singapur Dollar"),
        ("SHP", "St.-Helena Pfund"),
        ("SLL", "Sierra-leonische Leone"),
        ("SOS", "Somalische Schilling"),
        ("SPL", "Seborga Luigini"),
        ("SRD", "Surinamische Dollar"),
        ("STD", "São-toméische Dobra"),
        ("SVC", "El-Salvador-Colón"),
        ("SYP", "Syrische Pfund"),
        ("SZL", "Swazi Lilangeni"),
        ("THB", "Thailändische Baht"),
        ("TJS", "Tadschikische Somoni"),
        ("TMT", "Turkmenische Manat"),
        ("TND", "Tunesische Dinar"),
        ("TOP", "Tongaische Pa'anga"),
        ("TRY", "Türkische Lira"),
        ("TTD", "Trinidad und Tobago Dollar"),
        ("TVD", "Tuvalu Dollar"),
        ("TWD", "Neu Taiwanesische Dollar"),
        ("TZS", "Tansanische Schilling"),
        ("UAH", "Ukrainische Hrywnja"),
        ("UGX", "Ugandische Schilling"),
        ("USD", "Amerikanische Dollar"),
        ("UYU", "Uruguayische Peso"),
        ("UZS", "Uzbekische So'm"),
        ("VEF", "Venezuelanische Bolívar"),
        ("VND", "Vietnamesischer Dong"),
        ("VUV", "Vanuatuische Vatu"),
        ("WST", "Samoanische Tala"),
        ("XAF", "Zentralafrikanische CFA-Franc"),
        ("XCD", "Ostkaribische Dollar"),
        ("XDR", "Sonderziehungsrecht"),
        ("XOF", "Westafrikanische CFA-Franc"),
        ("XPF", "Pazifische Franc"),
        ("YER", "Jemenitische Rial"),
        ("ZAR", "Südafrikanische Rand"),
        ("ZMW", "Sambische Kwacha"),
        ("ZWD", "Simbabwe Dollar"),
    )
