/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.spi;

import java.io.InputStream;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import oracle.jdbc.spi.OracleConfigurationSecretProvider;

public interface OracleConfigurationParser {
    public static final Map<String, OracleConfigurationSecretProvider> secretProviders = new HashMap<String, OracleConfigurationSecretProvider>();

    public Properties parse(InputStream var1, Map<String, String> var2) throws SQLException;

    public String getType();

    public static OracleConfigurationParser find(String providerType) {
        for (OracleConfigurationParser parser : ServiceLoader.load(OracleConfigurationParser.class)) {
            if (!parser.getType().equals(providerType)) continue;
            return parser;
        }
        throw new IllegalStateException("Cannot find the parser type: " + providerType);
    }
}

