/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;

public class TimeUtils {
    private static final Logger logger = Logger.getLogger(TimeUtils.class.getName());

    public static Date createTime(String timeString) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
        return format.parse(timeString);
    }

    public static Integer mostSignificantDifference(Calendar c1, Calendar c2) {
        if (!TimeUtils.isSameYear(c1, c2)) {
            logger.info("YEAR");
            return 1;
        }
        if (!TimeUtils.isSameMonth(c1, c2)) {
            logger.info("Month");
            return 2;
        }
        if (!TimeUtils.isSameWeek(c1, c2)) {
            logger.info("WEEK_OF_YEAR");
            return 3;
        }
        if (!TimeUtils.isSameDay(c1, c2)) {
            logger.info("DAY_OF_MONTH");
            return 5;
        }
        if (!TimeUtils.isSameHour(c1, c2)) {
            logger.info("HOUR_OF_DAY");
            return 11;
        }
        if (!TimeUtils.isSameMinute(c1, c2)) {
            logger.info("MINUTE");
            return 12;
        }
        if (!TimeUtils.isSameSecond(c1, c2)) {
            logger.info("SECOND");
            return 13;
        }
        if (!TimeUtils.isSameMillis(c1, c2)) {
            logger.info("MILLISECOND");
            return 14;
        }
        return null;
    }

    public static boolean isSameYear(Calendar c1, Calendar c2) {
        return TimeUtils.isSameInField(1, c1, c2);
    }

    public static boolean isSameMonth(Calendar c1, Calendar c2) {
        return TimeUtils.isSameInField(2, c1, c2);
    }

    public static boolean isSameWeek(Calendar c1, Calendar c2) {
        return TimeUtils.isSameInField(3, c1, c2);
    }

    public static boolean isSameDay(Calendar c1, Calendar c2) {
        return TimeUtils.isSameInField(5, c1, c2);
    }

    public static boolean isSameHour(Calendar c1, Calendar c2) {
        return TimeUtils.isSameInField(11, c1, c2);
    }

    public static boolean isSameMinute(Calendar c1, Calendar c2) {
        return TimeUtils.isSameInField(12, c1, c2);
    }

    public static boolean isSameSecond(Calendar c1, Calendar c2) {
        return TimeUtils.isSameInField(13, c1, c2);
    }

    public static boolean isSameMillis(Calendar c1, Calendar c2) {
        return TimeUtils.isSameInField(14, c1, c2);
    }

    public static boolean isSameInField(int field, Calendar c1, Calendar c2) {
        int field2;
        int field1 = c1.get(field);
        return field1 == (field2 = c2.get(field));
    }

    public static double yearsDiff(Calendar c1, Calendar c2) {
        return TimeUtils.weeksDiff(c1, c2) / 52.0;
    }

    public static double weeksDiff(Calendar c1, Calendar c2) {
        return TimeUtils.daysDiff(c1, c2) / 7.0;
    }

    public static double daysDiff(Calendar c1, Calendar c2) {
        return TimeUtils.hoursDiff(c1, c2) / 24.0;
    }

    public static double hoursDiff(Calendar c1, Calendar c2) {
        return TimeUtils.minutesDiff(c1, c2) / 60.0;
    }

    public static double minutesDiff(Calendar c1, Calendar c2) {
        return TimeUtils.secondsDiff(c1, c2) / 60.0;
    }

    public static double secondsDiff(Calendar c1, Calendar c2) {
        return (double)TimeUtils.millisDiff(c1, c2) / 1000.0;
    }

    public static long millisDiff(Calendar c1, Calendar c2) {
        long time1 = c1.getTimeInMillis();
        long time2 = c2.getTimeInMillis();
        return Math.abs(time1 - time2);
    }

    public static Calendar min(Calendar c1, Calendar c2) {
        Calendar result = Calendar.getInstance();
        result.setTimeInMillis(c2.getTimeInMillis());
        if (TimeUtils.yearsDiff(c1, c2) > 1.0) {
            result.set(3, 0);
            result.set(2, 0);
            result.set(5, 0);
            result.set(11, 0);
            result.set(12, 0);
            result.set(13, 0);
            result.set(14, 0);
        } else if (TimeUtils.weeksDiff(c1, c2) > 1.0) {
            result.set(11, 0);
            result.set(12, 0);
            result.set(13, 0);
            result.set(14, 0);
        } else {
            if (TimeUtils.daysDiff(c1, c2) > 1.0) {
                result.set(11, 0);
                result.set(12, 0);
                result.set(13, 0);
                result.set(14, 0);
                return result;
            }
            if (TimeUtils.hoursDiff(c1, c2) > 1.0) {
                result.set(12, 0);
                result.set(13, 0);
                result.set(14, 0);
            } else if (TimeUtils.minutesDiff(c1, c2) > 1.0) {
                result.set(13, 0);
                result.set(14, 0);
            } else if (TimeUtils.secondsDiff(c1, c2) > 1.0) {
                result.set(14, 0);
                result.add(13, 1);
            }
        }
        return result;
    }

    public static Calendar max(Calendar c1, Calendar c2) {
        Calendar result = Calendar.getInstance();
        result.setTimeInMillis(c2.getTimeInMillis());
        if (TimeUtils.yearsDiff(c1, c2) > 1.0) {
            result.set(3, 0);
            result.set(2, 0);
            result.set(5, 0);
            result.set(11, 0);
            result.set(12, 0);
            result.set(13, 0);
            result.set(14, 0);
            result.add(1, 1);
        } else if (TimeUtils.weeksDiff(c1, c2) > 1.0) {
            result.set(11, 0);
            result.set(12, 0);
            result.set(13, 0);
            result.set(14, 0);
            result.add(5, 1);
        } else if (TimeUtils.daysDiff(c1, c2) > 1.0) {
            result.set(11, 0);
            result.set(12, 0);
            result.set(13, 0);
            result.set(14, 0);
            result.add(5, 1);
        } else if (TimeUtils.hoursDiff(c1, c2) > 1.0) {
            result.set(12, 0);
            result.set(13, 0);
            result.set(14, 0);
            result.add(11, 1);
        } else if (TimeUtils.minutesDiff(c1, c2) > 1.0) {
            result.set(13, 0);
            result.set(14, 0);
            result.add(12, 1);
        } else if (TimeUtils.secondsDiff(c1, c2) > 1.0) {
            result.set(14, 0);
            result.add(13, 1);
        }
        return result;
    }
}

