/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.inline;

import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.MutableObject;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.sqm.internal.CacheableSqmInterpretation;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.mutation.internal.Handler;
import org.hibernate.query.sqm.mutation.internal.MatchingIdSelectionHelper;
import org.hibernate.query.sqm.mutation.internal.inline.MatchingIdRestrictionProducer;
import org.hibernate.query.sqm.spi.SqmParameterMappingModelResolutionAccess;
import org.hibernate.query.sqm.tree.SqmDeleteOrUpdateStatement;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;

public abstract class AbstractInlineHandler
implements Handler {
    private final MatchingIdRestrictionProducer matchingIdsPredicateProducer;
    private final EntityPersister entityDescriptor;
    private final DomainParameterXref domainParameterXref;
    private final CacheableSqmInterpretation<SelectStatement, JdbcOperationQuerySelect> matchingIdsInterpretation;

    protected AbstractInlineHandler(MatchingIdRestrictionProducer matchingIdsPredicateProducer, SqmDeleteOrUpdateStatement<?> sqmStatement, DomainParameterXref domainParameterXref, DomainQueryExecutionContext context, MutableObject<JdbcParameterBindings> firstJdbcParameterBindingsConsumer) {
        SessionFactoryImplementor sessionFactory = context.getSession().getFactory();
        MappingMetamodelImplementor domainModel = sessionFactory.getMappingMetamodel();
        String mutatingEntityName = ((SqmRoot)sqmStatement.getTarget()).getModel().getHibernateEntityName();
        this.entityDescriptor = domainModel.getEntityDescriptor(mutatingEntityName);
        this.domainParameterXref = domainParameterXref;
        this.matchingIdsPredicateProducer = matchingIdsPredicateProducer;
        this.matchingIdsInterpretation = MatchingIdSelectionHelper.createMatchingIdsSelect(sqmStatement, domainParameterXref, context, firstJdbcParameterBindingsConsumer);
    }

    @Override
    public JdbcParameterBindings createJdbcParameterBindings(DomainQueryExecutionContext context) {
        return SqmUtil.createJdbcParameterBindings(context.getQueryParameterBindings(), this.domainParameterXref, this.matchingIdsInterpretation.jdbcParamsXref(), new SqmParameterMappingModelResolutionAccess(){

            @Override
            public <T> MappingModelExpressible<T> getResolvedMappingModelType(SqmParameter<T> parameter) {
                return AbstractInlineHandler.this.matchingIdsInterpretation.sqmParameterMappingModelTypes().get(parameter);
            }
        }, context.getSession());
    }

    @Override
    public boolean dependsOnParameterBindings() {
        return this.matchingIdsInterpretation.jdbcOperation().dependsOnParameterBindings();
    }

    @Override
    public boolean isCompatibleWith(JdbcParameterBindings jdbcParameterBindings, QueryOptions queryOptions) {
        return this.matchingIdsInterpretation.jdbcOperation().isCompatibleWith(jdbcParameterBindings, queryOptions);
    }

    public EntityPersister getEntityDescriptor() {
        return this.entityDescriptor;
    }

    protected MatchingIdRestrictionProducer getMatchingIdsPredicateProducer() {
        return this.matchingIdsPredicateProducer;
    }

    protected DomainParameterXref getDomainParameterXref() {
        return this.domainParameterXref;
    }

    protected CacheableSqmInterpretation<SelectStatement, JdbcOperationQuerySelect> getMatchingIdsInterpretation() {
        return this.matchingIdsInterpretation;
    }
}

