/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import org.jruby.RubyBasicObject;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Define;
import org.jruby.api.Error;
import org.jruby.java.proxies.ArrayJavaProxy;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyModule(name={"JavaArrayUtilities"})
public class JavaArrayUtilities {
    public static RubyModule createJavaArrayUtilitiesModule(ThreadContext context) {
        return Define.defineModule(context, "JavaArrayUtilities").defineMethods(context, JavaArrayUtilities.class);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject bytes_to_ruby_string(ThreadContext context, IRubyObject recv2, IRubyObject wrappedObject) {
        return JavaArrayUtilities.bytes_to_ruby_string(context, recv2, wrappedObject, context.nil);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject bytes_to_ruby_string(ThreadContext context, IRubyObject recv2, IRubyObject wrappedObject, IRubyObject encoding2) {
        JavaProxy proxy2;
        Object wrapped;
        byte[] bytes2 = null;
        if (wrappedObject instanceof JavaProxy && (wrapped = (proxy2 = (JavaProxy)wrappedObject).getObject()) instanceof byte[]) {
            bytes2 = (byte[])wrapped;
        }
        if (bytes2 == null) {
            throw Error.typeError(context, wrappedObject, "byte[]");
        }
        RubyString string2 = Create.newString(context, new ByteList(bytes2, true));
        if (!encoding2.isNil()) {
            string2.force_encoding(context, encoding2);
        }
        return string2;
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject ruby_string_to_bytes(IRubyObject recv2, IRubyObject string2) {
        return JavaArrayUtilities.ruby_string_to_bytes(((RubyBasicObject)recv2).getCurrentContext(), recv2, string2);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject ruby_string_to_bytes(ThreadContext context, IRubyObject recv2, IRubyObject string2) {
        return JavaUtil.convertJavaToUsableRubyObject(context.runtime, Convert.castAsString(context, string2).getBytes());
    }

    @JRubyMethod(module=true)
    public static IRubyObject java_to_ruby(ThreadContext context, IRubyObject recv2, IRubyObject ary) {
        if (!(ary instanceof ArrayJavaProxy)) {
            throw Error.typeError(context, ary, context.runtime.getJavaSupport().getArrayProxyClass());
        }
        return ((ArrayJavaProxy)ary).to_a(context);
    }
}

