/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.exception.RollbackException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;

public abstract class ProgramTask
extends Task {
    protected Program program;

    protected ProgramTask(Program program, String title, boolean canCancel, boolean hasProgress, boolean isModal) {
        super(title, canCancel, hasProgress, isModal);
        this.program = program;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run(TaskMonitor monitor) {
        int transactionID = this.program.startTransaction(this.getTaskTitle());
        boolean doCommit = false;
        try {
            this.doRun(monitor);
            doCommit = true;
        }
        catch (RollbackException e) {
            Msg.error((Object)((Object)this), (Object)("Task Failed - \"" + this.getTaskTitle() + "\""), (Throwable)e);
        }
        catch (Throwable t) {
            Msg.showError((Object)((Object)this), null, (String)("Task Failed - \"" + this.getTaskTitle() + "\""), (Object)("Task failed - \"" + this.getTaskTitle() + "\""), (Throwable)t);
        }
        finally {
            this.program.endTransaction(transactionID, doCommit);
        }
    }

    protected abstract void doRun(TaskMonitor var1);
}

