/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pef;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.app.util.bin.format.pef.AbstractSymbol;
import ghidra.app.util.bin.format.pef.ExportedSymbolKey;
import ghidra.app.util.bin.format.pef.LoaderInfoHeader;
import ghidra.app.util.bin.format.pef.SymbolClass;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ExportedSymbol
extends AbstractSymbol {
    public static final int kPEFExpSymClassShift = 24;
    public static final int kPEFAbsoluteExport = -2;
    public static final int kPEFReexportedImport = -3;
    private int classAndName;
    private int symbolValue;
    private short sectionIndex;
    private String _name;

    ExportedSymbol(BinaryReader reader, LoaderInfoHeader loader, ExportedSymbolKey key) throws IOException {
        this.classAndName = reader.readNextInt();
        this.symbolValue = reader.readNextInt();
        this.sectionIndex = reader.readNextShort();
        long offset = loader.getSection().getContainerOffset() + loader.getLoaderStringsOffset() + this.getNameOffset();
        this._name = reader.readAsciiString(offset, key.getNameLength());
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public SymbolClass getSymbolClass() {
        return SymbolClass.get(this.classAndName >> 24);
    }

    public int getNameOffset() {
        return this.classAndName & 0xFFFFFF;
    }

    public int getSymbolValue() {
        return this.symbolValue;
    }

    public short getSectionIndex() {
        return this.sectionIndex;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        return StructConverterUtil.toDataType(this.getClass());
    }
}

