/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objc2;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_State;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.TypedefDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ObjectiveC2_Cache
implements StructConverter {
    private ObjectiveC2_State _state;
    private long cache;

    public ObjectiveC2_Cache(ObjectiveC2_State state, BinaryReader reader) throws IOException {
        this._state = state;
        this.cache = state.is32bit ? (long)reader.readNextInt() & 0xFFFFFFFFL : reader.readNextLong();
    }

    public long getCache() {
        return this.cache;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        if (this._state.is32bit) {
            return new TypedefDataType("Cache", DWORD);
        }
        return new TypedefDataType("Cache", QWORD);
    }

    public void applyTo() throws Exception {
    }
}

