/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.threadcommand;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.LoadCommand;
import ghidra.app.util.bin.format.macho.threadcommand.ThreadState;
import ghidra.app.util.bin.format.macho.threadcommand.ThreadStateARM;
import ghidra.app.util.bin.format.macho.threadcommand.ThreadStateARM_64;
import ghidra.app.util.bin.format.macho.threadcommand.ThreadStateHeader;
import ghidra.app.util.bin.format.macho.threadcommand.ThreadStatePPC;
import ghidra.app.util.bin.format.macho.threadcommand.ThreadStateX86_32;
import ghidra.app.util.bin.format.macho.threadcommand.ThreadStateX86_64;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ThreadCommand
extends LoadCommand {
    private ThreadStateHeader threadStateHeader;
    private ThreadState threadState;

    public ThreadCommand(BinaryReader reader, MachHeader header) throws IOException {
        super(reader);
        this.threadStateHeader = new ThreadStateHeader(reader);
        if (header.getCpuType() == 7) {
            if (this.threadStateHeader.getFlavor() == 1) {
                this.threadState = new ThreadStateX86_32(reader);
            }
        } else if (header.getCpuType() == 0x1000007) {
            if (this.threadStateHeader.getFlavor() == 4) {
                this.threadState = new ThreadStateX86_64(reader);
            }
        } else if (header.getCpuType() == 18) {
            if (this.threadStateHeader.getFlavor() == 1) {
                this.threadState = new ThreadStatePPC(reader, header.is32bit());
            }
        } else if (header.getCpuType() == 0x1000012) {
            if (this.threadStateHeader.getFlavor() == 5) {
                this.threadState = new ThreadStatePPC(reader, header.is32bit());
            }
        } else if (header.getCpuType() == 12) {
            if (this.threadStateHeader.getFlavor() == 1) {
                this.threadState = new ThreadStateARM(reader);
            }
        } else if (header.getCpuType() == 0x100000C || header.getCpuType() == 0x200000C) {
            if (this.threadStateHeader.getFlavor() == 6) {
                this.threadState = new ThreadStateARM_64(reader);
            }
        } else {
            Msg.info((Object)"Mach-O Thread Command", (Object)("Unsupported thread command flavor: 0x" + Integer.toHexString(this.threadStateHeader.getFlavor()) + " for CPU type 0x" + Integer.toHexString(header.getCpuType())));
        }
    }

    public ThreadStateHeader getThreadStateHeader() {
        return this.threadStateHeader;
    }

    public ThreadState getThreadState() {
        return this.threadState;
    }

    public long getInitialInstructionPointer() {
        if (this.threadState != null) {
            return this.threadState.getInstructionPointer();
        }
        return -1L;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(this.getCommandName(), 0);
        struct.add(DWORD, "cmd", null);
        struct.add(DWORD, "cmdsize", null);
        struct.add(this.threadStateHeader.toDataType(), "threadStateHeader", null);
        if (this.threadState != null) {
            struct.add(this.threadState.toDataType(), "threadState", null);
        }
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }

    @Override
    public String getCommandName() {
        return "thread_command";
    }
}

