/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands.chained;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.chained.DyldChainedStartsInSegment;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DyldChainedStartsInImage
implements StructConverter {
    private int segCount;
    private int[] segInfoOffset;
    private List<DyldChainedStartsInSegment> chainedStarts;

    public DyldChainedStartsInImage(BinaryReader reader) throws IOException {
        long ptrIndex = reader.getPointerIndex();
        this.segCount = reader.readNextInt();
        this.segInfoOffset = reader.readNextIntArray(this.segCount);
        this.chainedStarts = new ArrayList<DyldChainedStartsInSegment>();
        for (int offset : this.segInfoOffset) {
            if (offset == 0) continue;
            reader.setPointerIndex(ptrIndex + (long)offset);
            this.chainedStarts.add(new DyldChainedStartsInSegment(reader));
        }
    }

    public void markup(Program program, Address address, MachHeader header, TaskMonitor monitor, MessageLog log) throws CancelledException {
        try {
            int skipCount = 0;
            for (int i = 0; i < this.segInfoOffset.length; ++i) {
                if (this.segInfoOffset[i] == 0) {
                    ++skipCount;
                    continue;
                }
                DyldChainedStartsInSegment startsInSeg = this.chainedStarts.get(i - skipCount);
                if (startsInSeg == null) continue;
                DataUtilities.createData((Program)program, (Address)address.add((long)this.segInfoOffset[i]), (DataType)startsInSeg.toDataType(), (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
            }
        }
        catch (Exception e) {
            log.appendMsg(DyldChainedStartsInImage.class.getSimpleName(), "Failed to markup dyld_chained_starts_in_image");
        }
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("dyld_chained_starts_in_image", 0);
        struct.add(DWORD, "seg_count", null);
        struct.add((DataType)new ArrayDataType(DWORD, this.segCount, 1), "seg_info_offset", "each entry is offset into this struct for that segment followed by pool of dyld_chain_starts_in_segment data");
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }

    public int getSegCount() {
        return this.segCount;
    }

    public int[] getSegInfoOffset() {
        return this.segInfoOffset;
    }

    public List<DyldChainedStartsInSegment> getChainedStarts() {
        return this.chainedStarts;
    }
}

