/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.elf.ElfDynamicType;
import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.util.StringUtilities;
import java.io.IOException;

public class ElfDynamic {
    private final ElfHeader elf;
    private final int d_tag;
    private final long d_val;

    public ElfDynamic(BinaryReader reader, ElfHeader elf) throws IOException {
        this.elf = elf;
        if (elf.is32Bit()) {
            this.d_tag = reader.readNextInt();
            this.d_val = reader.readNextUnsignedInt();
        } else {
            this.d_tag = (int)reader.readNextLong();
            this.d_val = reader.readNextLong();
        }
    }

    public ElfDynamic(int tag, long value, ElfHeader elf) {
        this.d_tag = tag;
        this.d_val = value;
        this.elf = elf;
    }

    public ElfDynamic(ElfDynamicType tag, long value, ElfHeader elf) {
        this(tag.value, value, elf);
    }

    public int getTag() {
        return this.d_tag;
    }

    public ElfDynamicType getTagType() {
        return this.elf.getDynamicType(this.d_tag);
    }

    public long getValue() {
        return this.d_val;
    }

    public String getTagAsString() {
        ElfDynamicType tagType = this.getTagType();
        if (tagType != null) {
            return tagType.name;
        }
        return "DT_0x" + StringUtilities.pad((String)Integer.toHexString(this.d_tag), (char)'0', (int)8);
    }

    public String toString() {
        return this.getTagAsString();
    }

    public int sizeof() {
        return this.elf.is32Bit() ? 8 : 16;
    }
}

