/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.widgets.OptionDialog;
import ghidra.app.cmd.function.CreateFunctionCmd;
import ghidra.app.cmd.function.CreateThunkFunctionCmd;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.core.function.FunctionPlugin;
import ghidra.app.plugin.core.function.ThunkReferenceAddressDialog;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.ExternalReference;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.awt.Component;

class CreateFunctionAction
extends ListingContextAction {
    FunctionPlugin funcPlugin;
    boolean allowExisting = false;
    boolean createThunk = false;

    CreateFunctionAction(String name, FunctionPlugin plugin) {
        this(name, plugin, false, false);
    }

    public CreateFunctionAction(String name, FunctionPlugin plugin, boolean allowExisting, boolean createThunk) {
        super(name, plugin.getName());
        this.funcPlugin = plugin;
        this.allowExisting = allowExisting;
        this.createThunk = createThunk;
        if (allowExisting) {
            this.setPopupMenuData(new MenuData(new String[]{"Function", name}, null, "Function"));
        } else {
            this.setPopupMenuData(new MenuData(new String[]{name}, null, "Function", -1, "A_Beginning"));
        }
        if (createThunk) {
            this.setHelpLocation(new HelpLocation("FunctionPlugin", "ThunkFunctions"));
        } else {
            String anchor = name.replaceAll(" ", "_");
            this.setHelpLocation(new HelpLocation("FunctionPlugin", anchor));
            if (!allowExisting) {
                this.setKeyBindingData(new KeyBindingData(70, 0));
            }
        }
        this.setEnabled(true);
    }

    @Override
    public void actionPerformed(ListingActionContext context) {
        BackgroundCommand cmd;
        Address entry = null;
        ProgramSelection body = null;
        if (context.hasSelection()) {
            body = context.getSelection();
            entry = body.getMinAddress();
        } else {
            entry = context.getAddress();
        }
        if (entry == null) {
            return;
        }
        String name = null;
        Function func = context.getProgram().getFunctionManager().getFunctionContaining(entry);
        if (func != null && func.getEntryPoint().equals((Object)entry)) {
            if (this.createThunk) {
                Msg.showError((Object)((Object)this), null, (String)"Thunk Conflict", (Object)"Thunk function conflicts with an existing function!");
                return;
            }
            this.funcPlugin.getTool().setStatusInfo("Function \"" + func.getName() + "\" at " + String.valueOf(func.getEntryPoint()) + " already exists");
            int result = OptionDialog.showOptionNoCancelDialog(null, (String)"Function Already Exists at This Location", (String)("Function \"" + func.getName() + "\" at " + String.valueOf(func.getEntryPoint()) + " already exists at this location.\nAre you sure you want to proceed?\nDoing so, will cause analysis to be re-run on this function"), (String)(this.createThunk ? "Create Thunk" : "&Re-create"), (String)"&No", (int)3);
            if (result != 1) {
                return;
            }
            this.funcPlugin.getTool().clearStatusInfo();
        }
        if (this.createThunk) {
            cmd = this.getCreateThunkFunctionCmd(context.getProgram(), entry, body);
            if (cmd == null) {
                return;
            }
        } else {
            cmd = new CreateFunctionCmd(name, entry, (AddressSetView)body, SourceType.USER_DEFINED, this.allowExisting, this.allowExisting);
        }
        this.funcPlugin.execute(context.getProgram(), (BackgroundCommand<Program>)cmd);
    }

    private CreateThunkFunctionCmd getCreateThunkFunctionCmd(Program program, Address entry, AddressSetView body) {
        Symbol refSymbol = null;
        Address refAddr = null;
        Listing listing = program.getListing();
        ReferenceManager refMgr = program.getReferenceManager();
        Instruction instr = listing.getInstructionAt(entry);
        if (instr != null && instr.getFlowType().isJump()) {
            Reference indirectRef = null;
            Reference dataRef = null;
            Reference jumpRef = null;
            for (Reference ref : instr.getReferencesFrom()) {
                RefType refType = ref.getReferenceType();
                if (refType == RefType.INDIRECTION) {
                    indirectRef = ref;
                    continue;
                }
                if (refType.isData()) {
                    dataRef = ref;
                    continue;
                }
                if (!refType.isJump()) continue;
                jumpRef = ref;
            }
            if (jumpRef != null) {
                refAddr = jumpRef.getToAddress();
            } else if (instr.getFlowType().isComputed()) {
                Reference[] refs;
                Reference ref;
                Reference reference = ref = indirectRef != null ? indirectRef : dataRef;
                if (ref != null && (refs = refMgr.getReferencesFrom(ref.getToAddress())).length != 0) {
                    if (refs[0].isExternalReference()) {
                        ExternalLocation extLoc = ((ExternalReference)refs[0]).getExternalLocation();
                        refSymbol = extLoc.getSymbol();
                        refAddr = extLoc.getAddress();
                    } else if (refs[0].isMemoryReference()) {
                        refAddr = refs[0].getToAddress();
                    }
                }
            }
        } else {
            Reference ref;
            if (body == null || body.getNumAddresses() == 0L) {
                Msg.showError((Object)((Object)this), (Component)this.funcPlugin.getTool().getActiveWindow(), (String)"Create Thunk Function Failed", (Object)"Must select thunk function body");
                return null;
            }
            CodeUnit cu = listing.getCodeUnitAt(entry);
            if (cu != null && new AddressSet(cu.getMinAddress(), cu.getMaxAddress()).equals((Object)body) && (ref = cu.getPrimaryReference(0)) != null) {
                refAddr = ref.getToAddress();
            }
        }
        if (refSymbol == null && refAddr != null) {
            refSymbol = program.getSymbolTable().getPrimarySymbol(refAddr);
        }
        ThunkReferenceAddressDialog dialog = new ThunkReferenceAddressDialog(this.funcPlugin.getTool());
        if (refSymbol != null) {
            dialog.showDialog(program, entry, refSymbol);
        } else {
            dialog.showDialog(program, entry, refAddr);
        }
        refSymbol = dialog.getSymbol();
        refAddr = dialog.getAddress();
        if (refSymbol != null) {
            return new CreateThunkFunctionCmd(entry, body, refSymbol);
        }
        if (refAddr != null) {
            return new CreateThunkFunctionCmd(entry, body, refAddr);
        }
        return null;
    }

    @Override
    protected boolean isEnabledForContext(ListingActionContext context) {
        return this.funcPlugin.isCreateFunctionAllowed(context, this.allowExisting, this.createThunk);
    }
}

