/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.wizard.project;

import docking.widgets.button.GRadioButton;
import docking.widgets.label.GDLabel;
import docking.widgets.list.GList;
import ghidra.util.layout.VerticalLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import utility.function.Callback;

public class RepositoryPanel
extends JPanel {
    private JRadioButton existingRepButton;
    private JRadioButton createRepButton;
    private ButtonGroup buttonGroup;
    private GList<String> nameList;
    private DefaultListModel<String> listModel;
    private JTextField nameField;
    private JLabel nameLabel;
    private Callback statusChangedCallback;

    public RepositoryPanel(Callback statusChangedCallback, String[] repositoryNames, boolean readOnlyServerAccess) {
        super(new BorderLayout(5, 10));
        this.statusChangedCallback = Callback.dummyIfNull((Callback)statusChangedCallback);
        this.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.buildMainPanel(repositoryNames, readOnlyServerAccess);
    }

    public boolean isCreateRepositorySelected() {
        return this.createRepButton.isSelected();
    }

    private void buildMainPanel(String[] repositoryNames, boolean readOnlyServerAccess) {
        this.buttonGroup = new ButtonGroup();
        this.add((Component)this.createListPanel(repositoryNames), "Center");
        this.add((Component)this.createNamePanel(), "South");
        this.addListeners();
        if (readOnlyServerAccess) {
            this.createRepButton.setEnabled(false);
            this.createRepButton.setSelected(false);
            this.nameField.setEnabled(false);
            this.nameLabel.setEnabled(false);
        }
    }

    private JPanel createListPanel(String[] repositoryNames) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Choose Existing Repository"));
        panel.add((Component)this.createExistingRepoButton(repositoryNames), "North");
        panel.add((Component)this.createScrollableRepoList(repositoryNames), "Center");
        return panel;
    }

    private JPanel createScrollableRepoList(String[] repositoryNames) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.listModel = new DefaultListModel();
        for (String repositoryName : repositoryNames) {
            this.listModel.addElement(repositoryName);
        }
        this.nameList = new GList(this.listModel);
        this.nameList.setEnabled(this.existingRepButton.isSelected());
        JScrollPane sp = new JScrollPane((Component)this.nameList);
        panel.add(sp);
        return panel;
    }

    private JComponent createExistingRepoButton(String[] repositoryNames) {
        this.existingRepButton = new GRadioButton("Existing Repository", repositoryNames.length > 0);
        this.existingRepButton.setEnabled(repositoryNames.length > 0);
        this.buttonGroup.add(this.existingRepButton);
        return this.existingRepButton;
    }

    private JPanel createNamePanel() {
        JPanel namePanel = new JPanel();
        namePanel.setLayout((LayoutManager)new VerticalLayout(5));
        namePanel.setBorder(BorderFactory.createTitledBorder("Create Repository"));
        this.createRepButton = new GRadioButton("Create Repository", !this.existingRepButton.isSelected());
        this.buttonGroup.add(this.createRepButton);
        this.nameLabel = new GDLabel("Repository Name:", 4);
        this.nameLabel.setEnabled(this.createRepButton.isSelected());
        this.nameField = new JTextField(20);
        DocumentListener dl = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                RepositoryPanel.this.statusChangedCallback.call();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                RepositoryPanel.this.statusChangedCallback.call();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                RepositoryPanel.this.statusChangedCallback.call();
            }
        };
        this.nameField.getDocument().addDocumentListener(dl);
        this.nameField.setEnabled(this.createRepButton.isSelected());
        JPanel innerPanel = new JPanel();
        innerPanel.add(this.nameLabel);
        innerPanel.add(this.nameField);
        namePanel.add(this.createRepButton);
        namePanel.add(innerPanel);
        return namePanel;
    }

    private void addListeners() {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean existingRepSelected = RepositoryPanel.this.existingRepButton.isSelected();
                RepositoryPanel.this.nameList.setEnabled(existingRepSelected);
                if (!existingRepSelected) {
                    RepositoryPanel.this.nameList.clearSelection();
                }
                boolean createRepSelected = RepositoryPanel.this.createRepButton.isSelected();
                RepositoryPanel.this.nameField.setEnabled(createRepSelected);
                RepositoryPanel.this.nameLabel.setEnabled(createRepSelected);
                if (!createRepSelected) {
                    RepositoryPanel.this.nameField.setText("");
                }
                RepositoryPanel.this.statusChangedCallback.call();
            }
        };
        this.existingRepButton.addActionListener(listener);
        this.createRepButton.addActionListener(listener);
        ListSelectionModel selModel = this.nameList.getSelectionModel();
        selModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                RepositoryPanel.this.statusChangedCallback.call();
            }
        });
    }

    public String getRepositoryName() {
        if (this.isCreateRepositorySelected()) {
            return this.nameField.getText().trim();
        }
        return (String)this.nameList.getSelectedValue();
    }
}

