/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.types.hfs;

import java.io.PrintStream;
import org.catacombae.csjc.PrintableStruct;
import org.catacombae.csjc.StaticStruct;
import org.catacombae.csjc.StructElements;
import org.catacombae.hfsexplorer.Util;

public abstract class CatDataRec
implements StaticStruct,
PrintableStruct,
StructElements {
    public static final byte HFS_DIRECTORY_RECORD = 1;
    public static final byte HFS_FILE_RECORD = 2;
    public static final byte HFS_DIRECTORY_THREAD_RECORD = 3;
    public static final byte HFS_FILE_THREAD_RECORD = 4;
    public static final int STRUCTSIZE = 2;
    private final byte[] cdrType = new byte[1];
    private final byte[] cdrResrv2 = new byte[1];

    protected CatDataRec(byte[] data, int offset) {
        System.arraycopy(data, offset + 0, this.cdrType, 0, 1);
        System.arraycopy(data, offset + 1, this.cdrResrv2, 0, 1);
    }

    public static int length() {
        return 2;
    }

    public byte getCdrType() {
        return Util.readByteBE(this.cdrType);
    }

    public byte getCdrResrv2() {
        return Util.readByteBE(this.cdrResrv2);
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " cdrType: " + Util.unsign(this.getCdrType()));
        ps.println(prefix + " cdrResrv2: " + Util.unsign(this.getCdrResrv2()));
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "CatDataRec:");
        this.printFields(ps, prefix);
    }

    public byte[] getBytes() {
        byte[] result = new byte[2];
        int offset = 0;
        System.arraycopy(this.cdrType, 0, result, offset, this.cdrType.length);
        System.arraycopy(this.cdrResrv2, 0, result, offset += this.cdrType.length, this.cdrResrv2.length);
        offset += this.cdrResrv2.length;
        return result;
    }

    protected void addSuperStructElements(StructElements.DictionaryBuilder db) {
        db.addUIntBE("cdrType", this.cdrType, "Record type", HEXADECIMAL);
        db.addUIntBE("cdrResrv2", this.cdrResrv2, "Reserved", HEXADECIMAL);
    }
}

