/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.data.exceptionhandling;

import ghidra.app.cmd.data.AbstractCreateDataTypeModel;
import ghidra.app.cmd.data.EHDataTypeUtilities;
import ghidra.app.util.datatype.microsoft.DataValidationOptions;
import ghidra.app.util.datatype.microsoft.MSDataTypeUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.IBO32DataType;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.TypedefDataType;
import ghidra.program.model.data.UnsignedLongDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.scalar.Scalar;

public class EHIPToStateModel
extends AbstractCreateDataTypeModel {
    public static final String DATA_TYPE_NAME = "IPToStateMapEntry";
    private static String STRUCTURE_NAME = "_s_IPToStateMapEntry";
    private static final int IP_ORDINAL = 0;
    private static final int STATE_ORDINAL = 1;
    private DataType dataType;

    public EHIPToStateModel(Program program, int ipToStateCount, Address ipToStateMapAddress, DataValidationOptions validationOptions) {
        super(program, ipToStateCount, ipToStateMapAddress, validationOptions);
    }

    @Override
    public String getName() {
        return DATA_TYPE_NAME;
    }

    @Override
    protected void validateModelSpecificInfo() throws InvalidDataTypeException {
        Program program = this.getProgram();
        int numEntries = this.getCount();
        for (int ipToStateOrdinal = 0; ipToStateOrdinal < numEntries; ++ipToStateOrdinal) {
            Address ipAddress;
            Object ip = this.getIP(ipToStateOrdinal);
            if (!(ip instanceof Address) || EHDataTypeUtilities.isValidAddress(program, ipAddress = (Address)ip)) continue;
            throw new InvalidDataTypeException(this.getName() + " data type at " + String.valueOf(this.getAddress()) + " doesn't refer to a valid location for the IP.");
        }
    }

    public static DataType getDataType(Program program) {
        IBO32DataType compDt;
        ProgramBasedDataTypeManager dataTypeManager = program.getDataTypeManager();
        boolean isRelative = EHIPToStateModel.isRelative(program);
        CategoryPath categoryPath = new CategoryPath(CATEGORY_PATH);
        StructureDataType struct = MSDataTypeUtils.getAlignedPack4Structure((DataTypeManager)dataTypeManager, (CategoryPath)categoryPath, (String)STRUCTURE_NAME);
        if (isRelative) {
            compDt = new IBO32DataType((DataTypeManager)dataTypeManager);
        } else {
            TypedefDataType dwordDt = new TypedefDataType(new CategoryPath("/WinDef.h"), "DWORD", (DataType)new UnsignedLongDataType((DataTypeManager)dataTypeManager), (DataTypeManager)dataTypeManager);
            compDt = new TypedefDataType(new CategoryPath("/wtypes.h"), "ULONG", (DataType)dwordDt, (DataTypeManager)dataTypeManager);
        }
        struct.add((DataType)compDt, "Ip", null);
        DataType ehStateDt = MSDataTypeUtils.getEHStateDataType((Program)program);
        struct.add(ehStateDt, "state", null);
        TypedefDataType typedefDt = new TypedefDataType(categoryPath, DATA_TYPE_NAME, (DataType)struct, (DataTypeManager)dataTypeManager);
        return MSDataTypeUtils.getMatchingDataType((Program)program, (DataType)typedefDt);
    }

    @Override
    public DataType getDataType() {
        if (this.dataType == null) {
            this.dataType = EHIPToStateModel.getDataType(this.getProgram());
        }
        return this.dataType;
    }

    @Override
    protected int getDataTypeLength() {
        return this.getDataType().getLength();
    }

    public Object getIP(int ipToStateEntryOrdinal) throws InvalidDataTypeException {
        this.checkValidity(ipToStateEntryOrdinal);
        DataType ipToStateDt = this.getDataType();
        MemBuffer specificMemBuffer = this.getSpecificMemBuffer(ipToStateEntryOrdinal, ipToStateDt);
        if (this.isRelative()) {
            Address refAddress = EHDataTypeUtilities.getAddress(ipToStateDt, 0, specificMemBuffer);
            return this.getAdjustedAddress(refAddress, 0);
        }
        Scalar scalarValue = EHDataTypeUtilities.getScalarValue(ipToStateDt, 0, specificMemBuffer);
        return scalarValue;
    }

    public Address getComponentAddressOfIPAddress(int ipToStateEntryOrdinal) throws InvalidDataTypeException {
        this.checkValidity(ipToStateEntryOrdinal);
        DataType dt = this.getDataType();
        MemBuffer specificMemBuffer = this.getSpecificMemBuffer(ipToStateEntryOrdinal, dt);
        return EHDataTypeUtilities.getComponentAddress(dt, 0, specificMemBuffer);
    }

    public int getState(int ipToStateEntryOrdinal) throws InvalidDataTypeException {
        this.checkValidity(ipToStateEntryOrdinal);
        DataType ipToStateDt = this.getDataType();
        MemBuffer specificMemBuffer = this.getSpecificMemBuffer(ipToStateEntryOrdinal, ipToStateDt);
        return EHDataTypeUtilities.getEHStateValue(ipToStateDt, 1, specificMemBuffer);
    }
}

