/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.provider.onetomany;

import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTAssociationManager;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.provider.onetomany.VTMatchOneToManyTableModel;
import ghidra.feature.vt.gui.util.AbstractVTMatchTableModel;
import ghidra.program.model.address.Address;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Collection;
import java.util.Comparator;

public class VTMatchDestinationTableModel
extends VTMatchOneToManyTableModel {
    private static final String TITLE = "VTMatch Destination Table Model";

    public VTMatchDestinationTableModel(VTController vtController) {
        super(TITLE, vtController);
    }

    protected TableColumnDescriptor<VTMatch> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addHiddenColumn((DynamicTableColumn)new AbstractVTMatchTableModel.SessionNumberTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new AbstractVTMatchTableModel.StatusTableColumn(), 1, true);
        descriptor.addHiddenColumn((DynamicTableColumn)new AbstractVTMatchTableModel.MatchTypeTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new AbstractVTMatchTableModel.ScoreTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new AbstractVTMatchTableModel.ConfidenceScoreTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new AbstractVTMatchTableModel.ImpliedMatchCountColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new AbstractVTMatchTableModel.RelatedMatchCountColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new AbstractVTMatchTableModel.MultipleSourceLabelsTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new AbstractVTMatchTableModel.SourceNamespaceTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new AbstractVTMatchTableModel.SourceLabelTableColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new AbstractVTMatchTableModel.SourceLabelSourceTypeTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new AbstractVTMatchTableModel.SourceAddressTableColumn(), 2, true);
        descriptor.addVisibleColumn((DynamicTableColumn)new AbstractVTMatchTableModel.SourceLengthTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new AbstractVTMatchTableModel.DestinationLengthTableColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new AbstractVTMatchTableModel.LengthDeltaTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new AbstractVTMatchTableModel.AlgorithmTableColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new AbstractVTMatchTableModel.TagTableColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new AbstractVTMatchTableModel.AppliedMarkupStatusBatteryTableColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new AbstractVTMatchTableModel.AppliedMarkupStatusTableColumn());
        return descriptor;
    }

    @Override
    public Address getAddress(int row) {
        VTMatch match = (VTMatch)this.getRowObject(row);
        VTAssociation association = match.getAssociation();
        return association.getSourceAddress();
    }

    @Override
    protected void doLoad(Accumulator<VTMatch> accumulator, TaskMonitor monitor) throws CancelledException {
        VTAssociationManager associationManager = this.session.getAssociationManager();
        if (this.address != null && associationManager != null) {
            Collection<VTAssociation> associations = associationManager.getRelatedAssociationsByDestinationAddress(this.address);
            monitor.initialize((long)associations.size());
            for (VTAssociation vtAssociation : associations) {
                accumulator.addAll(this.session.getMatches(vtAssociation));
                monitor.checkCancelled();
                monitor.incrementProgress(1L);
            }
        }
    }

    @Override
    protected Comparator<VTMatch> createSortComparator(int columnIndex) {
        int sourceColumnAddressIndex = this.getColumnIndex(AbstractVTMatchTableModel.SourceAddressTableColumn.class);
        if (sourceColumnAddressIndex == columnIndex) {
            return new AbstractVTMatchTableModel.SourceAddressComparator();
        }
        return super.createSortComparator(columnIndex);
    }
}

