/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.img2;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.program.model.data.DataType;
import ghidra.util.StringUtilities;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class Img2
implements StructConverter {
    private int signature;
    private int imageType;
    private byte[] unknown0;
    private short securityEpoch;
    private int flags1;
    private int dataLenPadded;
    private int dataLen;
    private byte[] unknown1;
    private int flags2;
    private byte[] reserved;
    private byte[] unknown2;
    private int headerChecksum;
    private int checksum2;
    private byte[] unknown3;

    public Img2(ByteProvider provider) throws IOException {
        this(new BinaryReader(provider, true));
    }

    public Img2(BinaryReader reader) throws IOException {
        this.signature = reader.readNextInt();
        this.imageType = reader.readNextInt();
        this.unknown0 = reader.readNextByteArray(2);
        this.securityEpoch = reader.readNextShort();
        this.flags1 = reader.readNextInt();
        this.dataLenPadded = reader.readNextInt();
        this.dataLen = reader.readNextInt();
        this.unknown1 = reader.readNextByteArray(4);
        this.flags2 = reader.readNextInt();
        this.reserved = reader.readNextByteArray(64);
        this.unknown2 = reader.readNextByteArray(4);
        this.headerChecksum = reader.readNextInt();
        this.checksum2 = reader.readNextInt();
        this.unknown3 = reader.readNextByteArray(916);
    }

    public boolean isValid() {
        return this.getSignature().equals("Img2");
    }

    public String getSignature() {
        return StringUtilities.toString((int)this.signature);
    }

    public String getImageType() {
        return StringUtilities.toString((int)this.imageType);
    }

    public short getSecurityEpoch() {
        return this.securityEpoch;
    }

    public int getFlags1() {
        return this.flags1;
    }

    public int getDataLenPadded() {
        return this.dataLenPadded;
    }

    public int getDataLen() {
        return this.dataLen;
    }

    public int getFlags2() {
        return this.flags2;
    }

    public byte[] getReserved() {
        return this.reserved;
    }

    public int getHeaderChecksum() {
        return this.headerChecksum;
    }

    public int getChecksum2() {
        return this.checksum2;
    }

    public byte[] getUnknown(int index) {
        switch (index) {
            case 0: {
                return this.unknown0;
            }
            case 1: {
                return this.unknown1;
            }
            case 2: {
                return this.unknown2;
            }
            case 3: {
                return this.unknown3;
            }
        }
        throw new RuntimeException("invalid unknown index");
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        return StructConverterUtil.toDataType((Object)this);
    }
}

