/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.gui.search.dialog;

import docking.DialogComponentProvider;
import docking.widgets.OptionDialog;
import docking.widgets.button.BrowseButton;
import docking.widgets.button.GRadioButton;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import docking.widgets.textfield.GFormattedTextField;
import ghidra.features.bsim.query.BSimClientFactory;
import ghidra.features.bsim.query.BSimServerInfo;
import ghidra.features.bsim.query.FunctionDatabase;
import ghidra.util.HelpLocation;
import ghidra.util.filechooser.GhidraFileChooserModel;
import ghidra.util.filechooser.GhidraFileFilter;
import ghidra.util.layout.HorizontalLayout;
import ghidra.util.layout.MiddleLayout;
import ghidra.util.layout.PairLayout;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;

public class CreateBsimServerInfoDialog
extends DialogComponentProvider {
    protected static final String FILE_DB_EXT = ".mv.db";
    private static final String POSTGRES = "Postgres";
    private static final String ELASTIC = "Elastic";
    private static final String FILE_H2 = "File";
    private static final JFormattedTextField.AbstractFormatterFactory FORMATTER_FACTORY = new DefaultFormatterFactory(new DefaultFormatter(){

        @Override
        public Object stringToValue(String text) {
            return text;
        }
    });
    private GRadioButton postgresButton;
    private GRadioButton elasticButton;
    private GRadioButton fileButton;
    private JPanel cardPanel;
    private DbPanel postgresPanel;
    private DbPanel elasticPanel;
    private FilePanel filePanel;
    private ServerPanel activePanel;
    private BSimServerInfo result;

    public CreateBsimServerInfoDialog() {
        super("Add BSim Server");
        this.addWorkPanel(this.buildMainPanel());
        this.addOKButton();
        this.addCancelButton();
        this.setOkEnabled(false);
        this.setHelpLocation(new HelpLocation("BSimSearchPlugin", "Add_Server_Definition_Dialog"));
    }

    BSimServerInfo getBsimServerInfo() {
        return this.result;
    }

    protected void okCallback() {
        BSimServerInfo serverInfo = this.activePanel.getServerInfo();
        if (this.acceptServer(serverInfo)) {
            this.result = serverInfo;
            this.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean acceptServer(BSimServerInfo serverInfo) {
        String errorMessage = null;
        try (FunctionDatabase database = BSimClientFactory.buildClient(serverInfo, true);){
            if (database.initialize()) {
                boolean bl = true;
                return bl;
            }
            errorMessage = database.getLastError().toString();
        }
        catch (Exception e) {
            errorMessage = e.getMessage();
        }
        int answer = OptionDialog.showYesNoDialog(null, (String)"Connection Test Failed!", (String)("Can't connect to server: " + errorMessage + "\nDo you want to proceed with creation anyway?"));
        if (answer != 1) return false;
        return true;
    }

    private JComponent buildMainPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(this.buildTypePanel(), "North");
        panel.add(this.buildCardPanel(), "Center");
        panel.getAccessibleContext().setAccessibleName("Create Bsim Server Info");
        return panel;
    }

    private Component buildCardPanel() {
        this.postgresPanel = new DbPanel(BSimServerInfo.DBType.postgres);
        this.postgresPanel.getAccessibleContext().setAccessibleName("Postgress");
        this.elasticPanel = new DbPanel(BSimServerInfo.DBType.elastic);
        this.elasticPanel.getAccessibleContext().setAccessibleName(ELASTIC);
        this.filePanel = new FilePanel();
        this.filePanel.getAccessibleContext().setAccessibleName(FILE_H2);
        this.cardPanel = new JPanel(new CardLayout());
        this.cardPanel.add((Component)this.postgresPanel, POSTGRES);
        this.cardPanel.add((Component)this.elasticPanel, ELASTIC);
        this.cardPanel.add((Component)this.filePanel, FILE_H2);
        this.activePanel = this.postgresPanel;
        this.cardPanel.getAccessibleContext().setAccessibleName("Cards");
        return this.cardPanel;
    }

    private Component buildTypePanel() {
        JPanel panel = new JPanel((LayoutManager)new MiddleLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(20, 10, 10, 10));
        JPanel innerPanel = new JPanel((LayoutManager)new HorizontalLayout(20));
        ButtonGroup group = new ButtonGroup();
        this.postgresButton = new GRadioButton(POSTGRES);
        this.postgresButton.getAccessibleContext().setAccessibleName("Postgress");
        this.elasticButton = new GRadioButton(ELASTIC);
        this.elasticButton.getAccessibleContext().setAccessibleName(ELASTIC);
        this.fileButton = new GRadioButton(FILE_H2);
        this.fileButton.getAccessibleContext().setAccessibleName(FILE_H2);
        this.postgresButton.setSelected(true);
        ActionListener actionListener = e -> this.radioChanged();
        this.postgresButton.addActionListener(actionListener);
        this.elasticButton.addActionListener(actionListener);
        this.fileButton.addActionListener(actionListener);
        group.add((AbstractButton)this.postgresButton);
        group.add((AbstractButton)this.elasticButton);
        group.add((AbstractButton)this.fileButton);
        innerPanel.add((Component)this.postgresButton);
        innerPanel.add((Component)this.elasticButton);
        innerPanel.add((Component)this.fileButton);
        innerPanel.getAccessibleContext().setAccessibleName("Buttons");
        panel.add(innerPanel);
        panel.getAccessibleContext().setAccessibleName("Types");
        return panel;
    }

    private void radioChanged() {
        CardLayout cardLayout = (CardLayout)this.cardPanel.getLayout();
        if (this.postgresButton.isSelected()) {
            cardLayout.show(this.cardPanel, POSTGRES);
            this.activePanel = this.postgresPanel;
        } else if (this.elasticButton.isSelected()) {
            cardLayout.show(this.cardPanel, ELASTIC);
            this.activePanel = this.elasticPanel;
        } else if (this.fileButton.isSelected()) {
            cardLayout.show(this.cardPanel, FILE_H2);
            this.activePanel = this.filePanel;
        }
        this.checkForValidDialog();
    }

    private int getPort(String portString) {
        try {
            return Integer.parseInt(portString);
        }
        catch (Throwable t) {
            return -1;
        }
    }

    private void checkForValidDialog() {
        BSimServerInfo serverInfo = this.activePanel.getServerInfo();
        this.setOkEnabled(serverInfo != null);
    }

    private abstract class ServerPanel
    extends JPanel {
        ServerPanel(LayoutManager layout) {
            super(layout);
            this.setBorder(BorderFactory.createEmptyBorder(20, 10, 10, 10));
        }

        abstract BSimServerInfo getServerInfo();
    }

    private class DbPanel
    extends ServerPanel {
        private GFormattedTextField nameField;
        private GFormattedTextField userField;
        private GFormattedTextField hostField;
        private JTextField portField;
        private BSimServerInfo.DBType type;
        private static final String HOSTNAME_IP_REGEX = "^[a-zA-Z0-9]+(\\-[a-zA-Z0-9]+)*(\\.[a-zA-Z0-9]+(\\-[a-zA-Z0-9]+)*)*$";
        private static final Pattern HOSTNAME_IP_PATTERN = Pattern.compile("^[a-zA-Z0-9]+(\\-[a-zA-Z0-9]+)*(\\.[a-zA-Z0-9]+(\\-[a-zA-Z0-9]+)*)*$");
        private static final String USERNAME_REGEX = "^[a-zA-Z_][a-zA-Z0-9_$]*$";
        private static final Pattern USERNAME_PATTERN = Pattern.compile("^[a-zA-Z_][a-zA-Z0-9_$]*$");

        private DbPanel(BSimServerInfo.DBType type) {
            super((LayoutManager)new PairLayout(10, 10));
            this.type = type;
            this.createDBNameField();
            this.createUserField();
            this.createHostField();
            int defaultPort = -1;
            if (type == BSimServerInfo.DBType.postgres) {
                defaultPort = 5432;
            } else if (type == BSimServerInfo.DBType.elastic) {
                defaultPort = 9200;
            }
            this.portField = new NotifyingTextField(Integer.toString(defaultPort));
            JLabel nameLabel = new JLabel("DB Name:", 4);
            JLabel userLabel = new JLabel("User (optional):", 4);
            JLabel hostLabel = new JLabel("Host:", 4);
            JLabel portLabel = new JLabel("Port:", 4);
            nameLabel.setLabelFor((Component)this.nameField);
            hostLabel.setLabelFor((Component)this.hostField);
            portLabel.setLabelFor(this.portField);
            this.add(nameLabel);
            this.add((Component)this.nameField);
            this.add(userLabel);
            this.add((Component)this.userField);
            this.add(hostLabel);
            this.add((Component)this.hostField);
            this.add(portLabel);
            this.add(this.portField);
        }

        private void setStatus(String msg) {
            CreateBsimServerInfoDialog.this.setStatusText(msg);
        }

        private void createDBNameField() {
            this.nameField = new GFormattedTextField(FORMATTER_FACTORY, (Object)"");
            this.nameField.setName("Name");
            this.nameField.setText("");
            this.nameField.setDefaultValue((Object)"");
            this.nameField.setIsError(true);
            this.nameField.setEditable(true);
            this.nameField.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent input) {
                    DbPanel.this.setStatus("");
                    String dbName = DbPanel.this.nameField.getText().trim();
                    if (dbName.length() == 0) {
                        DbPanel.this.setStatus("");
                        return false;
                    }
                    for (int i = 0; i < dbName.length(); ++i) {
                        char c = dbName.charAt(i);
                        if (Character.isLetter(c) || i != 0 && (Character.isDigit(c) || c == '_')) continue;
                        DbPanel.this.setStatus("Unsupported database name");
                        return false;
                    }
                    return true;
                }

                @Override
                public boolean shouldYieldFocus(JComponent source, JComponent target) {
                    return true;
                }
            });
            this.nameField.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 27) {
                        e.consume();
                        DbPanel.this.nameField.setText("");
                        DbPanel.this.nameField.setDefaultValue((Object)"");
                        DbPanel.this.nameField.setIsError(true);
                    }
                    CreateBsimServerInfoDialog.this.checkForValidDialog();
                }
            });
            this.nameField.addTextEntryStatusListener(f -> CreateBsimServerInfoDialog.this.checkForValidDialog());
        }

        private void createHostField() {
            this.hostField = new GFormattedTextField(FORMATTER_FACTORY, (Object)"");
            this.hostField.setName("Host");
            this.hostField.setText("");
            this.hostField.setDefaultValue((Object)"");
            this.hostField.setIsError(true);
            this.hostField.setEditable(true);
            this.hostField.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent input) {
                    DbPanel.this.setStatus("");
                    String hostname = DbPanel.this.hostField.getText().trim();
                    if (hostname.length() == 0) {
                        DbPanel.this.setStatus("");
                        return false;
                    }
                    Matcher hostMatch = HOSTNAME_IP_PATTERN.matcher(hostname);
                    if (!hostMatch.matches()) {
                        DbPanel.this.setStatus("Unsupported host name or IP address");
                        return false;
                    }
                    return true;
                }

                @Override
                public boolean shouldYieldFocus(JComponent source, JComponent target) {
                    return true;
                }
            });
            this.hostField.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 27) {
                        e.consume();
                        DbPanel.this.hostField.setText("");
                        DbPanel.this.hostField.setDefaultValue((Object)"");
                        DbPanel.this.hostField.setIsError(true);
                    }
                    CreateBsimServerInfoDialog.this.checkForValidDialog();
                }
            });
            this.hostField.addTextEntryStatusListener(f -> CreateBsimServerInfoDialog.this.checkForValidDialog());
        }

        private void createUserField() {
            this.userField = new GFormattedTextField(FORMATTER_FACTORY, (Object)"");
            this.userField.setName("User");
            this.userField.setText("");
            this.userField.setDefaultValue((Object)"");
            this.userField.setEditable(true);
            this.userField.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent input) {
                    DbPanel.this.setStatus("");
                    String username = DbPanel.this.userField.getText().trim();
                    if (username.length() == 0) {
                        DbPanel.this.setStatus("");
                        return true;
                    }
                    Matcher userMatch = USERNAME_PATTERN.matcher(username);
                    if (!userMatch.matches()) {
                        DbPanel.this.setStatus("Unsupported database user name");
                        return false;
                    }
                    return true;
                }

                @Override
                public boolean shouldYieldFocus(JComponent source, JComponent target) {
                    return true;
                }
            });
            this.userField.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 27) {
                        e.consume();
                        DbPanel.this.userField.setText("");
                        DbPanel.this.userField.setDefaultValue((Object)"");
                        DbPanel.this.userField.setIsError(false);
                    }
                    CreateBsimServerInfoDialog.this.checkForValidDialog();
                }
            });
            this.userField.addTextEntryStatusListener(f -> CreateBsimServerInfoDialog.this.checkForValidDialog());
        }

        @Override
        BSimServerInfo getServerInfo() {
            if (this.nameField.getTextEntryStatus() == GFormattedTextField.Status.INVALID || this.userField.getTextEntryStatus() == GFormattedTextField.Status.INVALID || this.hostField.getTextEntryStatus() == GFormattedTextField.Status.INVALID) {
                return null;
            }
            String user = this.userField.getText().trim();
            String name = this.nameField.getText().trim();
            String host = this.hostField.getText().trim();
            int port = CreateBsimServerInfoDialog.this.getPort(this.portField.getText().trim());
            if (name.isBlank() || host.isBlank() || port < 0) {
                return null;
            }
            return new BSimServerInfo(this.type, user, host, port, name);
        }
    }

    private class FilePanel
    extends ServerPanel {
        private JTextField fileField;

        FilePanel() {
            super((LayoutManager)new PairLayout());
            this.add(new JLabel("File: "));
            this.add(this.buildFileField());
        }

        private JPanel buildFileField() {
            JPanel panel = new JPanel(new BorderLayout());
            this.fileField = new NotifyingTextField();
            this.fileField.setEditable(false);
            panel.add((Component)this.fileField, "Center");
            JPanel subpanel = new JPanel((LayoutManager)new MiddleLayout());
            subpanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
            BrowseButton browseButton = new BrowseButton();
            browseButton.addActionListener(e -> this.showFileChooser());
            subpanel.add((Component)browseButton);
            panel.add((Component)subpanel, "East");
            return panel;
        }

        private void showFileChooser() {
            GhidraFileChooser chooser = new GhidraFileChooser((Component)this);
            chooser.setFileSelectionMode(GhidraFileChooserMode.FILES_ONLY);
            chooser.setFileFilter(new GhidraFileFilter(this){

                public String getDescription() {
                    return "*.mv.db";
                }

                public boolean accept(File file, GhidraFileChooserModel chooserModel) {
                    return file.isDirectory() || file.getName().endsWith(CreateBsimServerInfoDialog.FILE_DB_EXT);
                }
            });
            File selectedFile = chooser.getSelectedFile();
            if (selectedFile != null) {
                this.fileField.setText(selectedFile.getAbsolutePath());
            }
        }

        @Override
        BSimServerInfo getServerInfo() {
            String path = this.fileField.getText().trim();
            if (path.isBlank()) {
                return null;
            }
            File file = new File(path);
            if (file.isDirectory()) {
                return null;
            }
            return new BSimServerInfo(path);
        }
    }

    class MyFieldListener
    implements DocumentListener {
        MyFieldListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            CreateBsimServerInfoDialog.this.checkForValidDialog();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            CreateBsimServerInfoDialog.this.checkForValidDialog();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            CreateBsimServerInfoDialog.this.checkForValidDialog();
        }
    }

    class NotifyingTextField
    extends JTextField {
        public NotifyingTextField() {
            this("");
        }

        public NotifyingTextField(String initialText) {
            super(20);
            this.setText(initialText);
            this.getDocument().addDocumentListener(new MyFieldListener());
        }
    }
}

