/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database;

import db.util.ErrorHandler;
import ghidra.util.database.DBAnnotatedObject;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBCachedObjectStoreEntrySet;
import ghidra.util.database.DirectedIterator;
import ghidra.util.database.KeySpan;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;

public class DBCachedObjectStoreEntrySubSet<T extends DBAnnotatedObject>
extends DBCachedObjectStoreEntrySet<T> {
    protected final KeySpan keySpan;

    public DBCachedObjectStoreEntrySubSet(DBCachedObjectStore<T> store, ErrorHandler errHandler, ReadWriteLock lock, DirectedIterator.Direction direction, KeySpan keySpan) {
        super(store, errHandler, lock, direction);
        this.keySpan = keySpan;
    }

    @Override
    public Map.Entry<Long, T> first() {
        return this.store.safe(this.lock.readLock(), () -> this.store.entries.first(this.direction, this.keySpan));
    }

    @Override
    public Map.Entry<Long, T> last() {
        return this.store.safe(this.lock.readLock(), () -> this.store.entries.last(this.direction, this.keySpan));
    }

    @Override
    public int size() {
        return this.store.getKeyCount(this.keySpan);
    }

    @Override
    public boolean isEmpty() {
        return !this.store.getKeysExist(this.keySpan);
    }

    @Override
    public boolean contains(Object o) {
        return this.store.safe(this.lock.readLock(), () -> this.store.entries.contains(o, this.keySpan));
    }

    @Override
    public Object[] toArray() {
        return this.store.entries.toArray(this.direction, this.keySpan);
    }

    @Override
    public <U> U[] toArray(U[] a) {
        return this.store.entries.toArray(this.direction, this.keySpan, a, this.store.getKeyCount(this.keySpan));
    }

    @Override
    public boolean remove(Object o) {
        return this.store.safe(this.lock.writeLock(), () -> this.store.entries.remove(o, this.keySpan));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.store.safe(this.lock.readLock(), () -> this.store.entries.containsAll(c, this.keySpan));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.store.entries.retain(c, this.keySpan);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.store.safe(this.lock.writeLock(), () -> this.store.entries.removeAll(c, this.keySpan));
    }

    @Override
    public void clear() {
        this.store.deleteKeys(this.keySpan);
    }

    @Override
    public Map.Entry<Long, T> lower(Map.Entry<Long, T> e) {
        return this.store.safe(this.lock.readLock(), () -> this.store.entries.lower(this.direction, (Long)e.getKey(), this.keySpan));
    }

    @Override
    public Map.Entry<Long, T> floor(Map.Entry<Long, T> e) {
        return this.store.safe(this.lock.readLock(), () -> this.store.entries.floor(this.direction, (Long)e.getKey(), this.keySpan));
    }

    @Override
    public Map.Entry<Long, T> ceiling(Map.Entry<Long, T> e) {
        return this.store.safe(this.lock.readLock(), () -> this.store.entries.ceiling(this.direction, (Long)e.getKey(), this.keySpan));
    }

    @Override
    public Map.Entry<Long, T> higher(Map.Entry<Long, T> e) {
        return this.store.safe(this.lock.readLock(), () -> this.store.entries.higher(this.direction, (Long)e.getKey(), this.keySpan));
    }

    @Override
    public Iterator<Map.Entry<Long, T>> iterator() {
        return this.store.entries.iterator(this.direction, this.keySpan);
    }

    @Override
    public DBCachedObjectStoreEntrySubSet<T> descendingSet() {
        return new DBCachedObjectStoreEntrySubSet<T>(this.store, this.errHandler, this.lock, DirectedIterator.Direction.reverse(this.direction), this.keySpan);
    }

    @Override
    public Iterator<Map.Entry<Long, T>> descendingIterator() {
        return this.store.entries.iterator(DirectedIterator.Direction.reverse(this.direction), this.keySpan);
    }

    @Override
    public DBCachedObjectStoreEntrySubSet<T> subSet(Map.Entry<Long, T> fromElement, boolean fromInclusive, Map.Entry<Long, T> toElement, boolean toInclusive) {
        KeySpan span = KeySpan.sub(fromElement.getKey(), fromInclusive, toElement.getKey(), toInclusive, this.direction);
        return new DBCachedObjectStoreEntrySubSet<T>(this.store, this.errHandler, this.lock, this.direction, (KeySpan)this.keySpan.intersect(span));
    }

    @Override
    public DBCachedObjectStoreEntrySubSet<T> headSet(Map.Entry<Long, T> toElement, boolean inclusive) {
        KeySpan span = KeySpan.head(toElement.getKey(), inclusive, this.direction);
        return new DBCachedObjectStoreEntrySubSet<T>(this.store, this.errHandler, this.lock, this.direction, (KeySpan)this.keySpan.intersect(span));
    }

    @Override
    public DBCachedObjectStoreEntrySubSet<T> tailSet(Map.Entry<Long, T> fromElement, boolean inclusive) {
        KeySpan span = KeySpan.tail(fromElement.getKey(), inclusive, this.direction);
        return new DBCachedObjectStoreEntrySubSet<T>(this.store, this.errHandler, this.lock, this.direction, (KeySpan)this.keySpan.intersect(span));
    }
}

