/*
 * Decompiled with CFR 0.152.
 */
package generic;

import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;

public abstract class AbstractUnionedCollection<E>
extends AbstractCollection<E> {
    protected final Collection<? extends Collection<? extends E>> collections;

    public AbstractUnionedCollection(Collection<? extends Collection<? extends E>> collections) {
        this.collections = collections;
    }

    @SafeVarargs
    public AbstractUnionedCollection(Collection<? extends E> ... collections) {
        this.collections = Arrays.asList(collections);
    }

    @Override
    public int size() {
        int size = 0;
        for (Collection<E> col : this.collections) {
            size += col.size();
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        for (Collection<E> col : this.collections) {
            if (col.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(Object o) {
        for (Collection<E> col : this.collections) {
            if (!col.contains(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        for (Collection<E> col : this.collections) {
            if (!col.remove(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = false;
        for (Collection<E> col : this.collections) {
            result |= col.removeAll(c);
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean result = false;
        for (Collection<E> col : this.collections) {
            result |= col.retainAll(c);
        }
        return result;
    }

    @Override
    public void clear() {
        for (Collection<E> col : this.collections) {
            col.clear();
        }
    }
}

