/**
 * SECTION:avatar-details
 * @short_description: Avatar for a contact.
 * 
 * <para>This allows avatars to be associated with contacts. An avatar is a small image file which represents the contact, such as a photo of them.</para>
 *
 * Since: 0.6.0
 */
/**
 * folks_avatar_details_change_avatar:
 * @self: the <link linkend="FolksAvatarDetails"><type>FolksAvatarDetails</type></link> instance
 * @avatar: (in) (allow-none): &nbsp;.  <para>the new avatar (or <code>null</code> to unset the avatar) </para>
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Change the contact&apos;s avatar.
 * 
 * <para>It&apos;s preferred to call this rather than setting <link linkend="FolksAvatarDetails--avatar"><type>"avatar"</type></link> directly, as this method gives error notification and will only return once the avatar has been written to the relevant backing store (or the operation&apos;s failed).</para>
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if setting the avatar failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-avatar-details-change-avatar-finish"><function>folks_avatar_details_change_avatar_finish()</function></link>
 *
 * Since: 0.6.2
 */
/**
 * folks_avatar_details_change_avatar_finish:
 * @self: the <link linkend="FolksAvatarDetails"><type>FolksAvatarDetails</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: (error-domains FolksPropertyError): location to store the error occurring, or %NULL to ignore
 * 
 * Change the contact&apos;s avatar.
 * 
 * <para>It&apos;s preferred to call this rather than setting <link linkend="FolksAvatarDetails--avatar"><type>"avatar"</type></link> directly, as this method gives error notification and will only return once the avatar has been written to the relevant backing store (or the operation&apos;s failed).</para>
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if setting the avatar failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-avatar-details-change-avatar"><function>folks_avatar_details_change_avatar()</function></link>
 *
 * Since: 0.6.2
 */
/**
 * FolksAvatarDetails:avatar:
 * 
 * An avatar for the contact.
 * 
 * <para>The avatar may be <code>null</code> if unset. Otherwise, the image data may be asynchronously loaded using the methods of the <link linkend="GLoadableIcon"><type>GLoadableIcon</type></link> implementation.</para>
 *
 * Since: 0.6.0
 */
/**
 * folks_avatar_details_get_avatar:
 * @self: the <link linkend="FolksAvatarDetails"><type>FolksAvatarDetails</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksAvatarDetails--avatar"><type>"avatar"</type></link> property.
 * 
 * An avatar for the contact.
 * 
 * <para>The avatar may be <code>null</code> if unset. Otherwise, the image data may be asynchronously loaded using the methods of the <link linkend="GLoadableIcon"><type>GLoadableIcon</type></link> implementation.</para>
 * 
 * Returns: the value of the <link linkend="FolksAvatarDetails--avatar"><type>"avatar"</type></link> property
 *
 * Since: 0.6.0
 */
/**
 * folks_avatar_details_set_avatar:
 * @self: the <link linkend="FolksAvatarDetails"><type>FolksAvatarDetails</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksAvatarDetails--avatar"><type>"avatar"</type></link> property
 * 
 * Set the value of the <link linkend="FolksAvatarDetails--avatar"><type>"avatar"</type></link> property to @value.
 * 
 * An avatar for the contact.
 * 
 * <para>The avatar may be <code>null</code> if unset. Otherwise, the image data may be asynchronously loaded using the methods of the <link linkend="GLoadableIcon"><type>GLoadableIcon</type></link> implementation.</para>
 *
 * Since: 0.6.0
 */
/**
 * FolksAvatarDetails:
 * 
 * Avatar for a contact.
 * 
 * <para>This allows avatars to be associated with contacts. An avatar is a small image file which represents the contact, such as a photo of them.</para>
 *
 * Since: 0.6.0
 */
/**
 * FolksAvatarDetailsIface:
 * @change_avatar: virtual method called by <link linkend="folks-avatar-details-change-avatar"><function>folks_avatar_details_change_avatar()</function></link>
 * @change_avatar_finish: asynchronous finish function for <structfield>change_avatar</structfield>, called by <link linkend="folks-avatar-details-change-avatar"><function>folks_avatar_details_change_avatar()</function></link>
 * @get_avatar: getter method for the abstract property <link linkend="FolksAvatarDetails--avatar"><type>"avatar"</type></link>
 * @set_avatar: setter method for the abstract property <link linkend="FolksAvatarDetails--avatar"><type>"avatar"</type></link>
 * @parent_iface: the parent interface structure
 * 
 * Interface for creating <link linkend="FolksAvatarDetails"><type>FolksAvatarDetails</type></link> implementations.
 */
